/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.util.Iterator;

public class LongLinkedList {
    protected ListItem first = null;
    protected ListItem last = null;
    protected int count = 0;

    public void add(long l) {
        if (this.first == null) {
            this.last = this.first = this.createListItem(l);
        } else {
            ListItem next;
            this.last.next = next = this.createListItem(l);
            next.prev = this.last;
            this.last = next;
        }
        ++this.count;
    }

    public int getSize() {
        return this.count;
    }

    public ListItem getFirst() {
        return this.first;
    }

    public ListItem removeFirst() {
        ListItem temp = this.first;
        this.first = this.first.next;
        if (this.first != null) {
            this.first.prev = null;
        }
        return temp;
    }

    public long getLast() {
        if (this.last != null) {
            return this.last.l;
        }
        return -1L;
    }

    public boolean contains(long l) {
        ListItem next = this.first;
        while (next != null) {
            if (next.l == l) {
                return true;
            }
            next = next.next;
        }
        return false;
    }

    public long[] getData() {
        long[] data = new long[this.count];
        ListItem next = this.first;
        int i = 0;
        while (next != null) {
            data[i++] = next.l;
            next = next.next;
        }
        return data;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        ListItem next = this.first;
        while (next != null) {
            buf.append(next.l).append(' ');
            next = next.next;
        }
        return buf.toString();
    }

    public Iterator iterator() {
        return new LongLinkedListIterator();
    }

    protected ListItem createListItem(long l) {
        return new ListItem(l);
    }

    private final class LongLinkedListIterator
    implements Iterator {
        private ListItem next;

        private LongLinkedListIterator() {
            this.next = LongLinkedList.this.first;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            ListItem temp = this.next;
            this.next = this.next.next;
            return temp;
        }

        public void remove() {
            throw new RuntimeException("not implemented");
        }
    }

    public static class ListItem
    implements Comparable {
        public long l;
        public ListItem next = null;
        public ListItem prev = null;

        public ListItem() {
        }

        public ListItem(long l) {
            this.l = l;
        }

        public long getValue() {
            return this.l;
        }

        public ListItem getNext() {
            return this.next;
        }

        public int compareTo(Object o) {
            long ol = ((ListItem)o).l;
            if (ol == this.l) {
                return 0;
            }
            if (this.l < ol) {
                return -1;
            }
            return 1;
        }
    }
}

