/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.exist.util.ConfigurationHelper;
import org.exist.util.FastStringBuffer;
import org.exist.util.MimeType;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MimeTable {
    private static final String FILE_LOAD_FAILED_ERR = "Failed to load mime-type table from ";
    private static final String LOAD_FAILED_ERR = "Failed to load mime-type table from class loader";
    private static final String MIME_TYPES_XML = "mime-types.xml";
    private static final String MIME_TYPES_XML_DEFAULT = "org/exist/util/mime-types.xml";
    private static MimeTable instance = null;
    private String src;
    private Map mimeTypes = new TreeMap();
    private Map extensions = new TreeMap();
    private Map preferredExtension = new TreeMap();

    public static MimeTable getInstance() {
        if (instance == null) {
            instance = new MimeTable();
        }
        return instance;
    }

    public MimeTable() {
        this.load();
    }

    public String getSrc() {
        return this.src;
    }

    public MimeType getContentTypeFor(String fileName) {
        String ext = this.getExtension(fileName);
        return ext == null ? null : (MimeType)this.extensions.get(ext);
    }

    public MimeType getContentTypeFor(XmldbURI fileName) {
        return this.getContentTypeFor(fileName.toString());
    }

    public MimeType getContentType(String mimeType) {
        return (MimeType)this.mimeTypes.get(mimeType);
    }

    public Vector getAllExtensions(MimeType mimeType) {
        return this.getAllExtensions(mimeType.getName());
    }

    public Vector getAllExtensions(String mimeType) {
        Vector<String> extns = new Vector<String>();
        Iterator itExtensions = this.extensions.keySet().iterator();
        while (itExtensions.hasNext()) {
            String extKey = (String)itExtensions.next();
            MimeType mt = (MimeType)this.extensions.get(extKey);
            if (!mt.getName().equals(mimeType)) continue;
            extns.add(extKey);
        }
        String preferred = (String)this.preferredExtension.get(mimeType);
        if (preferred != null && !extns.contains(preferred)) {
            extns.add(0, preferred);
        }
        return extns;
    }

    public String getPreferredExtension(MimeType mimeType) {
        return this.getPreferredExtension(mimeType.getName());
    }

    public String getPreferredExtension(String mimeType) {
        return (String)this.preferredExtension.get(mimeType);
    }

    public boolean isXMLContent(String fileName) {
        String ext = this.getExtension(fileName);
        if (ext == null) {
            return false;
        }
        MimeType type = (MimeType)this.extensions.get(ext);
        if (type == null) {
            return false;
        }
        return type.getType() == 0;
    }

    private String getExtension(String fileName) {
        File f = new File(fileName);
        int p = (fileName = f.getName()).lastIndexOf(46);
        if (p < 0 || p + 1 == fileName.length()) {
            return null;
        }
        return fileName.substring(p).toLowerCase();
    }

    private void load() {
        boolean loaded = false;
        File f = ConfigurationHelper.lookup(MIME_TYPES_XML);
        if (f.canRead()) {
            try {
                System.out.println("Loading mime table from file " + f.getAbsolutePath());
                this.loadMimeTypes(new FileInputStream(f));
                loaded = true;
                this.src = f.toURI().toString();
            }
            catch (FileNotFoundException e) {
                System.err.println(FILE_LOAD_FAILED_ERR + f.getAbsolutePath());
            }
            catch (ParserConfigurationException e) {
                System.err.println(FILE_LOAD_FAILED_ERR + f.getAbsolutePath());
            }
            catch (SAXException e) {
                System.err.println(FILE_LOAD_FAILED_ERR + f.getAbsolutePath());
            }
            catch (IOException e) {
                System.err.println(FILE_LOAD_FAILED_ERR + f.getAbsolutePath());
            }
        }
        if (!loaded) {
            ClassLoader cl = MimeTable.class.getClassLoader();
            InputStream is = cl.getResourceAsStream(MIME_TYPES_XML_DEFAULT);
            if (is == null) {
                System.err.println(LOAD_FAILED_ERR);
            }
            try {
                this.loadMimeTypes(is);
                this.src = "resource://org/exist/util/mime-types.xml";
            }
            catch (ParserConfigurationException e) {
                System.err.println(LOAD_FAILED_ERR);
            }
            catch (SAXException e) {
                System.err.println(LOAD_FAILED_ERR);
            }
            catch (IOException e) {
                System.err.println(LOAD_FAILED_ERR);
            }
        }
    }

    private void loadMimeTypes(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        InputSource src = new InputSource(stream);
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setContentHandler(new MimeTableHandler());
        reader.parse(new InputSource(stream));
    }

    public static void main(String[] args) {
        MimeTable table = MimeTable.getInstance();
        MimeType type = table.getContentTypeFor("samples/xquery/fibo.svg");
        if (type == null) {
            System.out.println("Not found!");
        } else {
            System.out.println(type.getName());
            System.out.println(type.getDescription());
        }
    }

    private class MimeTableHandler
    extends DefaultHandler {
        private static final String EXTENSIONS = "extensions";
        private static final String DESCRIPTION = "description";
        private static final String MIME_TYPE = "mime-type";
        private MimeType mime = null;
        private FastStringBuffer charBuf = new FastStringBuffer(64);

        private MimeTableHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (MIME_TYPE.equals(qName)) {
                String name = attributes.getValue("name");
                if (name == null || name.length() == 0) {
                    System.err.println("No name specified for mime-type");
                    return;
                }
                int type = 1;
                String typeAttr = attributes.getValue("type");
                if (typeAttr != null && "xml".equals(typeAttr)) {
                    type = 0;
                }
                this.mime = new MimeType(name, type);
                MimeTable.this.mimeTypes.put(name, this.mime);
            }
            this.charBuf.setLength(0);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (MIME_TYPE.equals(qName)) {
                this.mime = null;
            } else if (DESCRIPTION.equals(qName)) {
                if (this.mime != null) {
                    String description = this.charBuf.getNormalizedString(3);
                    this.mime.setDescription(description);
                }
            } else if (EXTENSIONS.equals(qName) && this.mime != null) {
                String extList = this.charBuf.getNormalizedString(3);
                StringTokenizer tok = new StringTokenizer(extList, ", ");
                String preferred = null;
                while (tok.hasMoreTokens()) {
                    String ext = tok.nextToken().toLowerCase();
                    if (!MimeTable.this.extensions.containsKey(ext)) {
                        MimeTable.this.extensions.put(ext, this.mime);
                    }
                    if (preferred != null) continue;
                    preferred = ext;
                }
                MimeTable.this.preferredExtension.put(this.mime.getName(), preferred);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.charBuf.append(ch, start, length);
        }
    }
}

