/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.util.Iterator;
import org.apache.log4j.Logger;

public class OrderedLinkedList {
    private static final Logger LOG = Logger.getLogger((Class)OrderedLinkedList.class);
    protected Node header = null;
    protected Node last = null;
    private int size = 0;

    public Node add(Node newNode) {
        newNode.next = null;
        newNode.prev = null;
        ++this.size;
        if (this.header == null) {
            this.last = this.header = newNode;
            return this.header;
        }
        Node node = this.header;
        while (newNode.compareTo(node) > 0) {
            if (node.next == null) {
                node.next = newNode;
                newNode.prev = node;
                this.last = newNode;
                return newNode;
            }
            node = node.next;
        }
        newNode.prev = node.prev;
        if (newNode.prev != null) {
            newNode.prev.next = newNode;
        }
        node.prev = newNode;
        newNode.next = node;
        if (node == this.header) {
            this.header = newNode;
        }
        return newNode;
    }

    public void remove(Node n) {
        Node node = this.header;
        while (node != null) {
            if (node.equals(n)) {
                this.removeNode(n);
                return;
            }
            node = node.next;
        }
    }

    public void removeNode(Node node) {
        --this.size;
        if (node.prev == null) {
            if (node.next != null) {
                node.next.prev = null;
                this.header = node.next;
            } else {
                this.header = null;
            }
        } else {
            node.prev.next = node.next;
            if (node.next != null) {
                node.next.prev = node.prev;
            } else {
                this.last = node.prev;
            }
        }
    }

    public Node removeFirst() {
        Node node = this.header;
        this.header = node.next;
        if (this.header != null) {
            this.header.prev = null;
        }
        --this.size;
        return node;
    }

    public Node removeLast() {
        Node node = this.last;
        this.last = node.prev;
        this.last.next = null;
        --this.size;
        return node;
    }

    public Node getLast() {
        return this.last == null ? null : this.last;
    }

    public Node get(int pos) {
        Node node = this.header;
        int count = 0;
        while (node != null) {
            if (count++ == pos) {
                return node;
            }
            node = node.next;
        }
        return null;
    }

    public Node[] getData() {
        Node[] data = new Node[this.size];
        Node next = this.header;
        int i = 0;
        while (next != null) {
            data[i++] = next;
            next = next.next;
        }
        return data;
    }

    public Node[] toArray(Node[] data) {
        Node next = this.header;
        int i = 0;
        while (next != null) {
            data[i++] = next;
            next = next.next;
        }
        return data;
    }

    public boolean contains(Node c) {
        Node next = this.header;
        while (next != null) {
            if (next.equals(c)) {
                return true;
            }
            next = next.next;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public void reset() {
        this.header = null;
        this.last = null;
        this.size = 0;
    }

    public Iterator iterator() {
        return new OrderedListIterator(this.header);
    }

    public static void main(String[] args) {
        OrderedLinkedList list = new OrderedLinkedList();
        list.add(new SimpleNode((Comparable)((Object)"Adam")));
        list.add(new SimpleNode((Comparable)((Object)"Sabine")));
        list.add(new SimpleNode((Comparable)((Object)"Georg")));
        list.add(new SimpleNode((Comparable)((Object)"Henry")));
        list.add(new SimpleNode((Comparable)((Object)"Achim")));
        list.add(new SimpleNode((Comparable)((Object)"Franz")));
        list.add(new SimpleNode((Comparable)((Object)"Doris")));
        list.add(new SimpleNode((Comparable)((Object)"Rudi")));
        list.add(new SimpleNode((Comparable)((Object)"Hermann")));
        list.add(new SimpleNode((Comparable)((Object)"Lisa")));
        list.add(new SimpleNode((Comparable)((Object)"Xaver")));
        list.add(new SimpleNode((Comparable)((Object)"Reinhard")));
        list.add(new SimpleNode((Comparable)((Object)"Ludwig")));
        list.remove(new SimpleNode((Comparable)((Object)"Lisa")));
        list.remove(new SimpleNode((Comparable)((Object)"Henry")));
        for (int i = 0; i < list.size(); ++i) {
            System.out.println(((SimpleNode)list.get((int)i)).data);
        }
    }

    private static final class OrderedListIterator
    implements Iterator {
        private Node next;

        public OrderedListIterator(Node header) {
            this.next = header;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                return null;
            }
            Node current = this.next;
            this.next = this.next.next;
            return current;
        }

        public void remove() {
            throw new RuntimeException("not implemented");
        }
    }

    public static class SimpleNode
    extends Node {
        Comparable data;

        public SimpleNode(Comparable data) {
            this.data = data;
        }

        public int compareTo(Node other) {
            SimpleNode o = (SimpleNode)other;
            return this.data.compareTo(o.data);
        }

        public boolean equals(Node other) {
            return ((SimpleNode)other).data.equals(this.data);
        }

        public Comparable getData() {
            return this.data;
        }
    }

    public static abstract class Node {
        Node next = null;
        Node prev = null;

        public Node getNextNode() {
            return this.next;
        }

        public Node getPrevNode() {
            return this.prev;
        }

        public abstract int compareTo(Node var1);

        public abstract boolean equals(Node var1);
    }
}

