/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.exist.util.EXistInputSource;

public final class ZipEntryInputSource
extends EXistInputSource {
    private ZipEntry zipEntry = null;
    private ZipFile zipFile = null;

    public ZipEntryInputSource() {
    }

    public ZipEntryInputSource(ZipFile zipFile, ZipEntry zipEntry) {
        this();
        this.setZipEntry(zipFile, zipEntry);
    }

    public void setZipEntry(ZipFile zipFile, ZipEntry zipEntry) {
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
    }

    public InputStream getByteStream() {
        InputStream retval = null;
        if (this.zipFile != null && this.zipEntry != null) {
            try {
                retval = this.zipFile.getInputStream(this.zipEntry);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return retval;
    }

    public void setByteStream(InputStream is) {
    }

    public void setCharacterStream(Reader r) {
    }

    public long getByteStreamLength() {
        long retval = -1L;
        if (this.zipEntry != null) {
            retval = this.zipEntry.getSize();
        }
        return retval;
    }

    public String getSymbolicPath() {
        return this.zipFile.getName() + "#" + this.zipEntry.getName();
    }
}

