/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.util.Timer;
import java.util.TimerTask;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.xmldb.DatabaseInstanceManager;
import org.exist.xmldb.DatabaseStatus;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class LocalDatabaseInstanceManager
implements DatabaseInstanceManager {
    protected BrokerPool pool;
    protected User user;

    public LocalDatabaseInstanceManager(User user, BrokerPool pool) {
        this.pool = pool;
        this.user = user;
    }

    public void shutdown() throws XMLDBException {
        this.shutdown(0L);
    }

    public void shutdown(long delay) throws XMLDBException {
        if (!this.user.hasDbaRole()) {
            throw new XMLDBException(4, "only users in group dba may shut down the database");
        }
        if (delay > 0L) {
            TimerTask task = new TimerTask(){

                public void run() {
                    LocalDatabaseInstanceManager.this.pool.shutdown();
                }
            };
            Timer timer = new Timer();
            timer.schedule(task, delay);
        } else {
            this.pool.shutdown();
        }
    }

    public boolean enterServiceMode() throws XMLDBException {
        try {
            this.pool.enterServiceMode(this.user);
        }
        catch (PermissionDeniedException e) {
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public void exitServiceMode() throws XMLDBException {
        try {
            this.pool.exitServiceMode(this.user);
        }
        catch (PermissionDeniedException e) {
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
    }

    public DatabaseStatus getStatus() throws XMLDBException {
        return new DatabaseStatus(this.pool);
    }

    public String getName() throws XMLDBException {
        return "DatabaseInstanceManager";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public boolean isLocalInstance() {
        return true;
    }

    public void setCollection(Collection arg0) throws XMLDBException {
    }

    public String getProperty(String arg0) throws XMLDBException {
        return null;
    }

    public void setProperty(String arg0, String arg1) throws XMLDBException {
    }

    public boolean isXACMLEnabled() throws XMLDBException {
        return this.pool.getSecurityManager().isXACMLEnabled();
    }
}

