/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.exist.xmldb.FullXmldbURI;
import org.exist.xquery.util.URIUtils;
import org.exist.xquery.value.AnyURIValue;

public class XmldbURI
implements Comparable {
    protected static final Logger LOG = Logger.getLogger((Class)XmldbURI.class);
    public static final int NO_PORT = -1;
    public static final String XMLDB_SCHEME = "xmldb";
    public static final String XMLDB_URI_PREFIX = "xmldb:";
    public static final String DEFAULT_INSTANCE_NAME = "exist";
    public static final String EMBEDDED_SERVER_AUTHORITY = "embedded-eXist-server";
    public static final XmldbURI ROOT_COLLECTION_URI = XmldbURI.create("/db");
    public static final XmldbURI RELATIVE_ROOT_COLLECTION_URI = XmldbURI.create("db");
    public static final XmldbURI SYSTEM_COLLECTION_URI = XmldbURI.create("/db/system");
    public static final XmldbURI CONFIG_COLLECTION_URI = XmldbURI.create("/db/system/config");
    public static final XmldbURI ROOT_COLLECTION_CONFIG_URI = XmldbURI.create("/db/system/config/db");
    public static final XmldbURI METADATA_COLLECTION_URI = XmldbURI.create("/db/system/metadata");
    public static final XmldbURI TEMP_COLLECTION_URI = XmldbURI.create("/db/system/temp");
    public static final XmldbURI EMPTY_URI = XmldbURI.createInternal("");
    public static final XmldbURI EMBEDDED_SERVER_URI = XmldbURI.create("xmldb:exist://embedded-eXist-server");
    private String encodedCollectionPath;
    public static final String API_XMLRPC = "xmlrpc";
    public static final String API_WEBDAV = "webdav";
    public static final String API_REST = "rest-style";
    public static final String API_LOCAL = "local";

    public static XmldbURI xmldbUriFor(URI uri) throws URISyntaxException {
        return XmldbURI.getXmldbURI(uri);
    }

    public static XmldbURI xmldbUriFor(String xmldbURI) throws URISyntaxException {
        return XmldbURI.xmldbUriFor(xmldbURI, true);
    }

    public static XmldbURI xmldbUriFor(String xmldbURI, boolean escape) throws URISyntaxException {
        if (xmldbURI == null) {
            return null;
        }
        URI uri = new URI(escape ? AnyURIValue.escape(xmldbURI) : xmldbURI);
        return XmldbURI.getXmldbURI(uri);
    }

    public static XmldbURI xmldbUriFor(String accessURI, String collectionPath) throws URISyntaxException {
        if (collectionPath == null) {
            return null;
        }
        URI uri = new URI(accessURI + URIUtils.iriToURI(collectionPath));
        return XmldbURI.getXmldbURI(uri);
    }

    public static XmldbURI create(URI uri) {
        try {
            return XmldbURI.xmldbUriFor(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + e.getMessage());
        }
    }

    public static XmldbURI create(String uri) {
        try {
            return XmldbURI.xmldbUriFor(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + e.getMessage());
        }
    }

    public static XmldbURI create(String accessURI, String collectionPath) {
        try {
            return XmldbURI.xmldbUriFor(accessURI, collectionPath);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + e.getMessage());
        }
    }

    public static XmldbURI createInternal(String collectionPath) {
        return new XmldbURI(collectionPath);
    }

    private static XmldbURI getXmldbURI(URI uri) throws URISyntaxException {
        if (uri.getScheme() != null || uri.getFragment() != null || uri.getQuery() != null) {
            return new FullXmldbURI(uri);
        }
        return new XmldbURI(uri);
    }

    protected XmldbURI(URI xmldbURI) throws URISyntaxException {
        boolean hadXmldbPrefix = false;
        if (xmldbURI.getScheme() != null) {
            if (!XMLDB_SCHEME.equals(xmldbURI.getScheme())) {
                throw new URISyntaxException(xmldbURI.toString(), "xmldb URI scheme does not start with xmldb:");
            }
            xmldbURI = new URI(xmldbURI.toString().substring(XMLDB_URI_PREFIX.length()));
            hadXmldbPrefix = true;
        }
        this.parseURI(xmldbURI, hadXmldbPrefix);
    }

    protected XmldbURI(String collectionPath) {
        this.encodedCollectionPath = collectionPath;
    }

    protected void parseURI(URI xmldbURI, boolean hadXmldbPrefix) throws URISyntaxException {
        this.splitPath(xmldbURI.getRawPath());
    }

    protected void splitPath(String path) throws URISyntaxException {
        this.encodedCollectionPath = path;
        if (this.encodedCollectionPath != null && this.encodedCollectionPath.length() > 1 && this.encodedCollectionPath.endsWith("/")) {
            this.encodedCollectionPath = this.encodedCollectionPath.substring(0, this.encodedCollectionPath.length() - 1);
        }
    }

    protected void checkCompatibilityForContextOperation(XmldbURI uri) throws IllegalArgumentException {
        if (this.getInstanceName() != null && uri.getInstanceName() != null && !this.getInstanceName().equals(uri.getInstanceName())) {
            throw new IllegalArgumentException(this.getInstanceName() + " instance differs from " + uri.getInstanceName());
        }
        if (this.getHost() != null && uri.getHost() != null && !this.getHost().equalsIgnoreCase(uri.getHost())) {
            throw new IllegalArgumentException(this.getHost() + " host differs from " + uri.getHost());
        }
        if (this.getPort() != -1 && uri.getPort() != -1 && this.getPort() != uri.getPort()) {
            throw new IllegalArgumentException(this.getPort() + " port differs from " + uri.getPort());
        }
        if (this.getCollectionPath() != null && uri.getCollectionPath() != null && !this.getCollectionPath().equals(uri.getCollectionPath())) {
            throw new IllegalArgumentException(this.getCollectionPath() + " collection differs from " + uri.getCollectionPath());
        }
    }

    protected void checkCompatibilityForCollectionOperation(XmldbURI uri) throws IllegalArgumentException {
        if (this.getInstanceName() != null && uri.getInstanceName() != null && !this.getInstanceName().equals(uri.getInstanceName())) {
            throw new IllegalArgumentException(this.getInstanceName() + " instance differs from " + uri.getInstanceName());
        }
        if (this.getHost() != null && uri.getHost() != null && !this.getHost().equalsIgnoreCase(uri.getHost())) {
            throw new IllegalArgumentException(this.getHost() + " host differs from " + uri.getHost());
        }
        if (this.getPort() != -1 && uri.getPort() != -1 && this.getPort() != uri.getPort()) {
            throw new IllegalArgumentException(this.getPort() + " port differs from " + uri.getPort());
        }
        if (this.getContext() != null && uri.getContext() != null && !this.getContext().equals(uri.getContext())) {
            throw new IllegalArgumentException(this.getContext() + " context differs from " + uri.getContext());
        }
    }

    public URI getURI() {
        return URI.create(this.encodedCollectionPath);
    }

    public URI getXmldbURI() {
        return URI.create(this.encodedCollectionPath);
    }

    public String getInstanceName() {
        return null;
    }

    public String getRawCollectionPath() {
        return this.encodedCollectionPath;
    }

    public String getCollectionPath() {
        if (this.encodedCollectionPath == null) {
            return null;
        }
        try {
            return URLDecoder.decode(this.encodedCollectionPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(this.encodedCollectionPath + " can not be properly escaped");
        }
    }

    public XmldbURI toCollectionPathURI() {
        return this instanceof FullXmldbURI ? XmldbURI.create(this.getRawCollectionPath()) : this;
    }

    protected void recomputeURI() throws URISyntaxException {
    }

    protected void safeRecomputeURI() {
        try {
            this.recomputeURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private void setCollectionPath(String collectionPath) {
        String oldCollectionPath = this.encodedCollectionPath;
        try {
            String string = this.encodedCollectionPath = "".equals(collectionPath) ? null : collectionPath;
            if (this.encodedCollectionPath != null && this.getContext() != null & this.encodedCollectionPath.charAt(0) != '/') {
                this.encodedCollectionPath = "/" + this.encodedCollectionPath;
            }
            this.recomputeURI();
        }
        catch (URISyntaxException e) {
            this.encodedCollectionPath = oldCollectionPath;
            throw new IllegalArgumentException("Invalid URI: " + e.getMessage());
        }
    }

    public String getApiName() {
        return null;
    }

    public String getContext() {
        return null;
    }

    public int compareTo(Object ob) throws ClassCastException {
        if (!(ob instanceof XmldbURI)) {
            throw new ClassCastException("The provided Object is not an XmldbURI");
        }
        return this.getXmldbURI().compareTo(((XmldbURI)ob).getXmldbURI());
    }

    public XmldbURI lastSegment() {
        String name = this.getRawCollectionPath();
        int last = name.lastIndexOf(47);
        if (last == -1) {
            return this;
        }
        if (last == name.length() - 1) {
            name = name.substring(0, last);
            last = name.lastIndexOf(47);
        }
        return XmldbURI.create(name.substring(last + 1));
    }

    public int numSegments() {
        String name = this.getRawCollectionPath();
        if (name == null || "".equals(name)) {
            return 0;
        }
        String[] split = name.split("/");
        return split.length;
    }

    public XmldbURI[] getPathSegments() {
        String name = this.getRawCollectionPath();
        if (name == null || "".equals(name)) {
            return new XmldbURI[0];
        }
        String[] split = name.split("/");
        int fix = "".equals(split[0]) ? 1 : 0;
        XmldbURI[] segments = new XmldbURI[split.length - fix];
        for (int i = fix; i < split.length; ++i) {
            segments[i - fix] = XmldbURI.create(split[i]);
        }
        return segments;
    }

    public XmldbURI removeLastSegment() {
        String uri = this.toString();
        int last = uri.lastIndexOf(47);
        if (last == -1) {
            return EMPTY_URI;
        }
        if (last == uri.length() - 1) {
            uri = uri.substring(0, last);
            last = uri.lastIndexOf(47);
        }
        return last <= 0 ? EMPTY_URI : XmldbURI.create(uri.substring(0, last));
    }

    public XmldbURI append(String uri) {
        return this.append(XmldbURI.create(uri));
    }

    public XmldbURI append(XmldbURI uri) {
        String toAppend = uri.getRawCollectionPath();
        String prepend = this.toString();
        if ("".equals(toAppend)) {
            return this;
        }
        if ("".equals(prepend)) {
            return uri;
        }
        if (prepend.charAt(prepend.length() - 1) != '/' && toAppend.charAt(0) != '/') {
            return XmldbURI.create(prepend + "/" + toAppend);
        }
        return XmldbURI.create(prepend + toAppend);
    }

    public XmldbURI appendInternal(XmldbURI uri) {
        return XmldbURI.createInternal(this.getRawCollectionPath() + '/' + uri.getRawCollectionPath());
    }

    public static String recoverPseudoURIs(String pseudoURI) throws URISyntaxException {
        Pattern p = Pattern.compile("/");
        String[] parts = p.split(pseudoURI);
        StringBuffer newURIString = new StringBuffer(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            newURIString.append("/");
            if ("".equals(parts[i])) continue;
            try {
                new URI(newURIString + parts[i]);
                newURIString.append(parts[i]);
                continue;
            }
            catch (URISyntaxException e) {
                LOG.info((Object)("Trying to escape : ''" + parts[i] + "' in '" + pseudoURI + "' !"));
                newURIString.append(URIUtils.encodeForURI(parts[i]));
            }
        }
        return newURIString.toString();
    }

    public boolean equals(Object ob) {
        if (ob instanceof XmldbURI) {
            return this.getXmldbURI().equals(((XmldbURI)ob).getXmldbURI());
        }
        if (ob instanceof URI) {
            return this.getXmldbURI().equals(ob);
        }
        if (ob instanceof String) {
            try {
                return this.getXmldbURI().equals(new URI((String)ob));
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        return false;
    }

    public boolean equalsInternal(XmldbURI other) {
        if (this == other) {
            return true;
        }
        return this.encodedCollectionPath.equals(other.encodedCollectionPath);
    }

    public boolean isAbsolute() {
        return this.isCollectionPathAbsolute();
    }

    public boolean isContextAbsolute() {
        return false;
    }

    public XmldbURI normalizeContext() {
        return this;
    }

    public URI relativizeContext(URI uri) {
        return null;
    }

    public URI resolveContext(String str) throws NullPointerException, IllegalArgumentException {
        return null;
    }

    public URI resolveContext(URI uri) throws NullPointerException {
        return null;
    }

    public boolean isCollectionPathAbsolute() {
        return this.encodedCollectionPath != null && this.encodedCollectionPath.length() > 0 && this.encodedCollectionPath.charAt(0) == '/';
    }

    public XmldbURI normalizeCollectionPath() {
        String collectionPath = this.encodedCollectionPath;
        if (collectionPath == null) {
            return this;
        }
        URI collectionPathURI = URI.create(collectionPath).normalize();
        if (collectionPathURI.getPath().equals(collectionPath)) {
            return this;
        }
        XmldbURI uri = XmldbURI.create(this.getXmldbURI());
        uri.setCollectionPath(collectionPathURI.toString());
        return uri;
    }

    public URI relativizeCollectionPath(URI uri) {
        URI collectionPathURI;
        if (uri == null) {
            throw new NullPointerException("The provided URI is null");
        }
        String collectionPath = this.encodedCollectionPath;
        if (collectionPath == null) {
            throw new NullPointerException("The current collection path is null");
        }
        if (!collectionPath.endsWith("/")) {
            LOG.info((Object)("Added a final '/' to '" + collectionPath + "'"));
            collectionPathURI = URI.create(collectionPath + "/");
        } else {
            collectionPathURI = URI.create(collectionPath);
        }
        return collectionPathURI.relativize(uri);
    }

    public XmldbURI resolveCollectionPath(XmldbURI child) throws NullPointerException, IllegalArgumentException {
        if (child == null) {
            throw new NullPointerException("The provided child URI is null");
        }
        String collectionPath = this.toCollectionPathURI().toString();
        URI newCollectionURI = null;
        newCollectionURI = !collectionPath.endsWith("/") ? URI.create(collectionPath + "/").resolve(child.toCollectionPathURI().getURI()) : this.getURI().resolve(child.toCollectionPathURI().getURI());
        XmldbURI newURI = XmldbURI.create(this.getXmldbURI());
        String newCollectionPath = newCollectionURI.getRawPath();
        if (newCollectionPath.endsWith("/")) {
            newCollectionPath = newCollectionPath.substring(0, newCollectionPath.length() - 1);
        }
        newURI.encodedCollectionPath = newCollectionPath;
        newURI.safeRecomputeURI();
        return newURI;
    }

    public URI resolveCollectionPath(URI uri) throws NullPointerException {
        URI collectionPathURI;
        if (uri == null) {
            throw new NullPointerException("The provided URI is null");
        }
        String collectionPath = this.encodedCollectionPath;
        if (collectionPath == null) {
            throw new NullPointerException("The current collection path is null");
        }
        if (!collectionPath.endsWith("/")) {
            LOG.info((Object)("Added a final '/' to '" + collectionPath + "'"));
            collectionPathURI = URI.create(collectionPath + "/");
        } else {
            collectionPathURI = URI.create(collectionPath);
        }
        return collectionPathURI.resolve(uri);
    }

    public String toASCIIString() {
        return this.getXmldbURI().toASCIIString();
    }

    public URL toURL() throws IllegalArgumentException, MalformedURLException {
        return this.getXmldbURI().toURL();
    }

    public boolean startsWith(XmldbURI xmldbUri) {
        return xmldbUri == null ? false : this.toString().startsWith(xmldbUri.toString());
    }

    public boolean startsWith(String string) throws URISyntaxException {
        return this.startsWith(XmldbURI.xmldbUriFor(string));
    }

    public boolean endsWith(XmldbURI xmldbUri) {
        return xmldbUri == null ? false : this.toString().endsWith(xmldbUri.toString());
    }

    public boolean endsWith(String string) throws URISyntaxException {
        return this.endsWith(XmldbURI.xmldbUriFor(string));
    }

    public XmldbURI prepend(XmldbURI xmldbUri) {
        if (xmldbUri == null) {
            throw new NullPointerException(this.toString() + " cannot start with null!");
        }
        return xmldbUri.append(this);
    }

    public XmldbURI trimFromBeginning(XmldbURI xmldbUri) {
        if (xmldbUri == null) {
            throw new NullPointerException(this.toString() + " cannot start with null!");
        }
        if (!this.startsWith(xmldbUri)) {
            throw new IllegalArgumentException(this.toString() + " does not start with " + xmldbUri.toString());
        }
        return XmldbURI.create(this.toString().substring(xmldbUri.toString().length()));
    }

    public XmldbURI trimFromBeginning(String string) throws URISyntaxException {
        return this.trimFromBeginning(XmldbURI.xmldbUriFor(string));
    }

    public String toString() {
        return this.encodedCollectionPath;
    }

    public static String[] getPathComponents(String collectionPath) {
        Pattern p = Pattern.compile("/");
        String[] split = p.split(collectionPath);
        String[] result = new String[split.length - 1];
        System.arraycopy(split, 1, result, 0, split.length - 1);
        return result;
    }

    public static String checkPath(String currentPath, String parentPath) {
        if (currentPath == null) {
            return parentPath;
        }
        if ("/db".equals(currentPath)) {
            return currentPath;
        }
        if (currentPath.startsWith("/db/")) {
            return currentPath;
        }
        if (currentPath.startsWith("/")) {
            LOG.warn((Object)("Initial '/' for relative path '" + currentPath + "'"));
        }
        if (currentPath.startsWith("/")) {
            if (parentPath.endsWith("/")) {
                return parentPath + currentPath.substring(1);
            }
            return parentPath + currentPath;
        }
        if (parentPath.endsWith("/")) {
            return parentPath + currentPath;
        }
        return parentPath + "/" + currentPath;
    }

    public static String checkPath2(String fileName, String parentPath) {
        return XmldbURI.checkPath(fileName, parentPath);
    }

    public String makeAbsolute(String name) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '/' && name.length() > i + 1 && name.charAt(i + 1) == '/') {
                ++i;
                continue;
            }
            out.append(name.charAt(i));
        }
        String name2 = out.toString();
        if (name2.length() > 0 && name2.charAt(0) != '/') {
            name2 = "/" + name2;
        }
        if (!name2.startsWith("/db")) {
            name2 = "/db" + name2;
        }
        if (name2.endsWith("/") && name2.length() > 1) {
            name2 = name2.substring(0, name2.length() - 1);
        }
        return name2;
    }

    public static final String normalizeCollectionName(String name) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '/' && name.length() > i + 1 && name.charAt(i + 1) == '/') {
                ++i;
                continue;
            }
            out.append(name.charAt(i));
        }
        String name2 = out.toString();
        if (name2.length() > 0 && name2.charAt(0) != '/') {
            name2 = "/" + name2;
        }
        if (!name2.startsWith("/db")) {
            name2 = "/db" + name2;
        }
        if (name2.endsWith("/") && name2.length() > 1) {
            name2 = name2.substring(0, name2.length() - 1);
        }
        return name2;
    }

    public String getAuthority() {
        return null;
    }

    public String getFragment() {
        return null;
    }

    public int getPort() {
        return -1;
    }

    public String getQuery() {
        return null;
    }

    public String getRawAuthority() {
        return null;
    }

    public String getHost() {
        return null;
    }

    public String getUserInfo() {
        return null;
    }

    public String getRawFragment() {
        return null;
    }

    public String getRawQuery() {
        return null;
    }

    public String getRawUserInfo() {
        return null;
    }

    public int hashCode() {
        return this.getXmldbURI().hashCode();
    }
}

