/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmlrpc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.backup.Backup;
import org.exist.collections.Collection;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.CollectionConfigurationManager;
import org.exist.collections.IndexInfo;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentMetadata;
import org.exist.dom.DocumentSet;
import org.exist.dom.DocumentTypeImpl;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetIterator;
import org.exist.dom.QName;
import org.exist.dom.SortedNodeSet;
import org.exist.memtree.NodeImpl;
import org.exist.numbering.NodeId;
import org.exist.protocolhandler.embedded.EmbeddedInputStream;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.security.XMLSecurityManager;
import org.exist.security.xacml.AccessContext;
import org.exist.source.Source;
import org.exist.source.StringSource;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.DataBackup;
import org.exist.storage.XQueryPool;
import org.exist.storage.lock.LockedDocumentMap;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.Compressor;
import org.exist.util.LockException;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.util.Occurrences;
import org.exist.util.SyntaxException;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.validation.ValidationReport;
import org.exist.validation.Validator;
import org.exist.xmldb.XmldbURI;
import org.exist.xmlrpc.QueryResult;
import org.exist.xmlrpc.RpcAPI;
import org.exist.xmlrpc.XmldbRequestProcessorFactory;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.Option;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.HTTPUtils;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xupdate.Modification;
import org.exist.xupdate.XUpdateProcessor;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class RpcConnection
implements RpcAPI {
    private static final Logger LOG = Logger.getLogger((Class)RpcConnection.class);
    private static final int MAX_DOWNLOAD_CHUNK_SIZE = 262144;
    protected XmldbRequestProcessorFactory factory;
    protected User user;

    public RpcConnection(XmldbRequestProcessorFactory factory, User user) {
        this.factory = factory;
        this.user = user;
    }

    private void handleException(Exception e) throws EXistException, PermissionDeniedException {
        LOG.debug((Object)e.getMessage(), (Throwable)e);
        if (e instanceof EXistException) {
            throw (EXistException)e;
        }
        if (e instanceof PermissionDeniedException) {
            throw (PermissionDeniedException)e;
        }
        throw new EXistException(e);
    }

    public boolean createCollection(String name) throws EXistException, PermissionDeniedException {
        return this.createCollection(name, null);
    }

    public boolean createCollection(String name, Date created) throws EXistException, PermissionDeniedException {
        try {
            return this.createCollection(XmldbURI.xmldbUriFor(name), created);
        }
        catch (URISyntaxException e) {
            this.handleException(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createCollection(XmldbURI collUri, Date created) throws PermissionDeniedException, EXistException {
        DBBroker broker = null;
        TransactionManager transact = this.factory.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            Collection current = broker.getOrCreateCollection(transaction, collUri);
            if (created != null) {
                current.setCreationTime(created.getTime());
            }
            LOG.debug((Object)("creating collection " + collUri));
            broker.saveCollection(transaction, current);
            transact.commit(transaction);
            broker.flush();
            LOG.info((Object)("collection " + collUri + " has been created"));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            transact.abort(transaction);
            this.handleException(e);
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
        return false;
    }

    public boolean configureCollection(String collName, String configuration) throws EXistException, PermissionDeniedException {
        try {
            return this.configureCollection(XmldbURI.xmldbUriFor(collName), configuration);
        }
        catch (URISyntaxException e) {
            this.handleException(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean configureCollection(XmldbURI collUri, String configuration) throws EXistException {
        DBBroker broker = null;
        Collection collection = null;
        TransactionManager transact = this.factory.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            try {
                collection = broker.openCollection(collUri, 0);
                if (collection == null) {
                    transact.abort(transaction);
                    throw new EXistException("collection " + collUri + " not found!");
                }
            }
            finally {
                if (collection != null) {
                    collection.release(0);
                }
            }
            CollectionConfigurationManager mgr = this.factory.getBrokerPool().getConfigurationManager();
            mgr.addConfiguration(transaction, broker, collection, configuration);
            transact.commit(transaction);
            LOG.info((Object)("Configured '" + collection.getURI() + "'"));
        }
        catch (CollectionConfigurationException e) {
            transact.abort(transaction);
            throw new EXistException(e.getMessage());
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
        return false;
    }

    public String createId(String collName) throws EXistException, URISyntaxException {
        return this.createId(XmldbURI.xmldbUriFor(collName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createId(XmldbURI collUri) throws EXistException {
        DBBroker broker = this.factory.getBrokerPool().get(this.user);
        Collection collection = null;
        try {
            XmldbURI id;
            boolean ok;
            collection = broker.openCollection(collUri, 0);
            if (collection == null) {
                throw new EXistException("collection " + collUri + " not found!");
            }
            Random rand = new Random();
            do {
                ok = true;
                id = XmldbURI.create(Integer.toHexString(rand.nextInt()) + ".xml");
                if (collection.hasDocument(id)) {
                    ok = false;
                }
                if (!collection.hasSubcollection(id)) continue;
                ok = false;
            } while (!ok);
            String string = id.toString();
            return string;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QueryResult doQuery(DBBroker broker, String xpath, NodeSet contextSet, HashMap parameters) throws Exception {
        XQuery xquery = broker.getXQueryService();
        XQueryPool pool = xquery.getXQueryPool();
        StringSource source = new StringSource(xpath);
        CompiledXQuery compiled = this.compile(broker, source, parameters);
        this.checkPragmas(compiled.getContext(), parameters);
        LockedDocumentMap lockedDocuments = null;
        try {
            long start = System.currentTimeMillis();
            lockedDocuments = this.beginProtected(broker, parameters);
            if (lockedDocuments != null) {
                compiled.getContext().setProtectedDocs(lockedDocuments);
            }
            Sequence result = xquery.execute(compiled, contextSet);
            HTTPUtils.addLastModifiedHeader(result, compiled.getContext());
            LOG.info((Object)("query took " + (System.currentTimeMillis() - start) + "ms."));
            QueryResult queryResult = new QueryResult(compiled.getContext(), result);
            return queryResult;
        }
        catch (XPathException e) {
            QueryResult queryResult = new QueryResult(e);
            return queryResult;
        }
        finally {
            if (lockedDocuments != null) {
                lockedDocuments.unlock();
            }
            if (compiled != null) {
                pool.returnCompiledXQuery(source, compiled);
            }
        }
    }

    protected LockedDocumentMap beginProtected(DBBroker broker, HashMap parameters) throws EXistException {
        String protectColl = (String)parameters.get("protected");
        if (protectColl == null) {
            return null;
        }
        while (true) {
            DocumentSet docs = null;
            LockedDocumentMap lockedDocuments = new LockedDocumentMap();
            try {
                Collection coll = broker.getCollection(XmldbURI.createInternal(protectColl));
                docs = new DocumentSet();
                coll.allDocs(broker, docs, true, lockedDocuments, 1);
                return lockedDocuments;
            }
            catch (LockException e) {
                LOG.debug((Object)("Deadlock detected. Starting over again. Docs: " + docs.getLength() + "; locked: " + lockedDocuments.size()));
                lockedDocuments.unlock();
                continue;
            }
            break;
        }
    }

    private CompiledXQuery compile(DBBroker broker, Source source, HashMap parameters) throws XPathException, IOException {
        Object[] staticDocuments;
        HashMap variableDecls;
        HashMap namespaces;
        XQuery xquery = broker.getXQueryService();
        XQueryPool pool = xquery.getXQueryPool();
        CompiledXQuery compiled = pool.borrowCompiledXQuery(broker, source);
        XQueryContext context = compiled == null ? xquery.newContext(AccessContext.XMLRPC) : compiled.getContext();
        String base = (String)parameters.get("base-uri");
        if (base != null) {
            context.setBaseURI(new AnyURIValue(base));
        }
        if ((namespaces = (HashMap)parameters.get("namespaces")) != null && namespaces.size() > 0) {
            context.declareNamespaces(namespaces);
        }
        if ((variableDecls = (HashMap)parameters.get("variables")) != null) {
            Iterator i = variableDecls.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                LOG.debug((Object)("declaring " + entry.getKey().toString() + " = " + entry.getValue()));
                context.declareVariable((String)entry.getKey(), entry.getValue());
            }
        }
        if ((staticDocuments = (Object[])parameters.get("static-documents")) != null) {
            try {
                XmldbURI[] d = new XmldbURI[staticDocuments.length];
                for (int i = 0; i < staticDocuments.length; ++i) {
                    XmldbURI next;
                    d[i] = next = XmldbURI.xmldbUriFor((String)staticDocuments[i]);
                }
                context.setStaticallyKnownDocuments(d);
            }
            catch (URISyntaxException e) {
                throw new XPathException(e);
            }
        } else if (context.isBaseURIDeclared()) {
            context.setStaticallyKnownDocuments(new XmldbURI[]{context.getBaseURI().toXmldbURI()});
        }
        if (compiled == null) {
            compiled = xquery.compile(context, source);
        }
        return compiled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printDiagnostics(String query, HashMap parameters) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            StringSource source = new StringSource(query);
            XQuery xquery = broker.getXQueryService();
            XQueryPool pool = xquery.getXQueryPool();
            CompiledXQuery compiled = pool.borrowCompiledXQuery(broker, source);
            if (compiled == null) {
                compiled = this.compile(broker, source, parameters);
            }
            StringWriter writer = new StringWriter();
            compiled.dump(writer);
            String string = writer.toString();
            return string;
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
        return null;
    }

    protected void checkPragmas(XQueryContext context, HashMap parameters) throws XPathException {
        Option pragma = context.getOption(Option.SERIALIZE_QNAME);
        this.checkPragmas(pragma, parameters);
    }

    protected void checkPragmas(Option pragma, HashMap parameters) throws XPathException {
        if (pragma == null) {
            return;
        }
        String[] contents = pragma.tokenizeContents();
        for (int i = 0; i < contents.length; ++i) {
            String[] pair = Option.parseKeyValuePair(contents[i]);
            if (pair == null) {
                throw new XPathException("Unknown parameter found in " + pragma.getQName().getStringValue() + ": '" + contents[i] + "'");
            }
            LOG.debug((Object)("Setting serialization property from pragma: " + pair[0] + " = " + pair[1]));
            parameters.put(pair[0], pair[1]);
        }
    }

    public int executeQuery(byte[] xpath, String encoding, HashMap parameters) throws EXistException, PermissionDeniedException {
        String xpathString = null;
        if (encoding != null) {
            try {
                xpathString = new String(xpath, encoding);
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)e);
            }
        }
        if (xpathString == null) {
            xpathString = new String(xpath);
        }
        LOG.debug((Object)("query: " + xpathString));
        return this.executeQuery(xpathString, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeQuery(String xpath, HashMap parameters) throws EXistException, PermissionDeniedException {
        long startTime = System.currentTimeMillis();
        DBBroker broker = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            QueryResult result = this.doQuery(broker, xpath, null, parameters);
            if (result.hasErrors()) {
                throw result.getException();
            }
            result.queryTime = System.currentTimeMillis() - startTime;
            int n = this.factory.resultSets.add(result);
            return n;
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
        return -1;
    }

    protected String formatErrorMsg(String message) {
        return this.formatErrorMsg("error", message);
    }

    protected String formatErrorMsg(String type, String message) {
        StringBuffer buf = new StringBuffer();
        buf.append("<exist:result xmlns:exist=\"http://exist.sourceforge.net/NS/exist\" ");
        buf.append("hitCount=\"0\">");
        buf.append('<');
        buf.append(type);
        buf.append('>');
        buf.append(message);
        buf.append("</");
        buf.append(type);
        buf.append("></exist:result>");
        return buf.toString();
    }

    public HashMap getCollectionDesc(String rootCollection) throws EXistException, PermissionDeniedException {
        try {
            return this.getCollectionDesc(rootCollection == null ? XmldbURI.ROOT_COLLECTION_URI : XmldbURI.xmldbUriFor(rootCollection));
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getCollectionDesc(XmldbURI rootUri) throws Exception {
        DBBroker broker = this.factory.getBrokerPool().get(this.user);
        Collection collection = null;
        try {
            collection = broker.openCollection(rootUri, 0);
            if (collection == null) {
                throw new EXistException("collection " + rootUri + " not found!");
            }
            HashMap<String, Object> desc = new HashMap<String, Object>();
            Vector docs = new Vector();
            Vector<String> collections = new Vector<String>();
            if (collection.getPermissions().validate(this.user, 4)) {
                Iterator i = collection.iterator(broker);
                while (i.hasNext()) {
                    DocumentImpl doc = (DocumentImpl)i.next();
                    Permission perms = doc.getPermissions();
                    HashMap<String, Object> hash = new HashMap<String, Object>(4);
                    hash.put("name", doc.getFileURI().toString());
                    hash.put("owner", perms.getOwner());
                    hash.put("group", perms.getOwnerGroup());
                    hash.put("permissions", new Integer(perms.getPermissions()));
                    hash.put("type", doc.getResourceType() == 1 ? "BinaryResource" : "XMLResource");
                    docs.addElement(hash);
                }
                i = collection.collectionIterator();
                while (i.hasNext()) {
                    collections.addElement(((XmldbURI)i.next()).toString());
                }
            }
            Permission perms = collection.getPermissions();
            desc.put("collections", collections);
            desc.put("documents", docs);
            desc.put("name", collection.getURI().toString());
            desc.put("created", Long.toString(collection.getCreationTime()));
            desc.put("owner", perms.getOwner());
            desc.put("group", perms.getOwnerGroup());
            desc.put("permissions", new Integer(perms.getPermissions()));
            HashMap<String, Object> hashMap = desc;
            return hashMap;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    public HashMap describeResource(String resourceName) throws EXistException, PermissionDeniedException {
        try {
            return this.describeResource(XmldbURI.xmldbUriFor(resourceName));
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap describeResource(XmldbURI resourceUri) throws EXistException, PermissionDeniedException {
        DBBroker broker = this.factory.getBrokerPool().get(this.user);
        DocumentImpl doc = null;
        HashMap<String, Object> hash = new HashMap<String, Object>(5);
        try {
            doc = broker.getXMLResource(resourceUri, 0);
            if (doc == null) {
                LOG.debug((Object)("document " + resourceUri + " not found!"));
                HashMap<String, Object> hashMap = hash;
                return hashMap;
            }
            if (!doc.getCollection().getPermissions().validate(this.user, 4)) {
                throw new PermissionDeniedException("Not allowed to read collection");
            }
            Permission perms = doc.getPermissions();
            hash.put("name", resourceUri.toString());
            hash.put("owner", perms.getOwner());
            hash.put("group", perms.getOwnerGroup());
            hash.put("permissions", new Integer(perms.getPermissions()));
            hash.put("type", doc.getResourceType() == 1 ? "BinaryResource" : "XMLResource");
            hash.put("content-length", new Integer(doc.getContentLength()));
            hash.put("mime-type", doc.getMetadata().getMimeType());
            hash.put("created", new Date(doc.getMetadata().getCreated()));
            hash.put("modified", new Date(doc.getMetadata().getLastModified()));
            HashMap<String, Object> hashMap = hash;
            return hashMap;
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    public HashMap describeCollection(String rootCollection) throws EXistException, PermissionDeniedException {
        try {
            return this.describeCollection(rootCollection == null ? XmldbURI.ROOT_COLLECTION_URI : XmldbURI.xmldbUriFor(rootCollection));
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap describeCollection(XmldbURI collUri) throws Exception {
        DBBroker broker = this.factory.getBrokerPool().get(this.user);
        Collection collection = null;
        try {
            collection = broker.openCollection(collUri, 0);
            if (collection == null) {
                throw new EXistException("collection " + collUri + " not found!");
            }
            HashMap<String, Object> desc = new HashMap<String, Object>();
            ArrayList<String> collections = new ArrayList<String>();
            if (collection.getPermissions().validate(this.user, 4)) {
                Iterator i = collection.collectionIterator();
                while (i.hasNext()) {
                    collections.add(i.next().toString());
                }
            }
            Permission perms = collection.getPermissions();
            desc.put("collections", collections);
            desc.put("name", collection.getURI().toString());
            desc.put("created", Long.toString(collection.getCreationTime()));
            desc.put("owner", perms.getOwner());
            desc.put("group", perms.getOwnerGroup());
            desc.put("permissions", new Integer(perms.getPermissions()));
            HashMap<String, Object> hashMap = desc;
            return hashMap;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    public byte[] getDocument(String name, HashMap parametri) throws EXistException, PermissionDeniedException {
        String encoding = "UTF-8";
        String compression = "no";
        encoding = (String)parametri.get("encoding") == null ? "UTF-8" : (String)parametri.get("encoding");
        if ((String)parametri.get("compress-output") != null) {
            compression = (String)parametri.get("compress-output");
        }
        try {
            String xml = this.getDocumentAsString(name, parametri);
            if (xml == null) {
                throw new EXistException("document " + name + " not found!");
            }
            try {
                if (compression.equals("no")) {
                    return xml.getBytes(encoding);
                }
                LOG.debug((Object)"getdocument with compression");
                return Compressor.compress(xml.getBytes(encoding));
            }
            catch (UnsupportedEncodingException uee) {
                LOG.warn((Object)uee);
                if (compression.equals("no")) {
                    return xml.getBytes();
                }
                LOG.debug((Object)"getdocument with compression");
                return Compressor.compress(xml.getBytes());
            }
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public String getDocumentAsString(String docName, HashMap parametri) throws EXistException, PermissionDeniedException {
        try {
            return this.getDocumentAsString(XmldbURI.xmldbUriFor(docName), parametri);
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDocumentAsString(XmldbURI docUri, HashMap parametri) throws Exception {
        String string;
        Collection collection;
        DBBroker broker;
        block15: {
            broker = null;
            collection = null;
            DocumentImpl doc = null;
            try {
                String xml;
                broker = this.factory.getBrokerPool().get(this.user);
                collection = broker.openCollection(docUri.removeLastSegment(), 0);
                if (collection == null) {
                    LOG.debug((Object)("collection " + docUri.removeLastSegment() + " not found!"));
                    String string2 = null;
                    if (collection != null) {
                        collection.releaseDocument(doc, 0);
                    }
                    if (collection != null) {
                        collection.release(0);
                    }
                    this.factory.getBrokerPool().release(broker);
                    return string2;
                }
                if (!collection.getPermissions().validate(this.user, 4)) {
                    throw new PermissionDeniedException("Insufficient privileges to read resource");
                }
                doc = collection.getDocumentWithLock(broker, docUri.lastSegment(), 0);
                if (doc == null) {
                    LOG.debug((Object)("document " + docUri + " not found!"));
                    throw new EXistException("document not found");
                }
                if (!doc.getPermissions().validate(this.user, 4)) {
                    throw new PermissionDeniedException("Insufficient privileges to read resource " + docUri);
                }
                Serializer serializer = broker.getSerializer();
                serializer.setProperties(parametri);
                string = xml = serializer.serialize(doc);
                if (collection == null) break block15;
            }
            catch (NoSuchMethodError nsme) {
                nsme.printStackTrace();
                String string3 = null;
                return string3;
            }
            finally {
                if (collection != null) {
                    collection.releaseDocument(doc, 0);
                }
                if (collection != null) {
                    collection.release(0);
                }
                this.factory.getBrokerPool().release(broker);
            }
            collection.releaseDocument(doc, 0);
        }
        if (collection != null) {
            collection.release(0);
        }
        this.factory.getBrokerPool().release(broker);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getDocumentData(String docName, HashMap parameters) throws EXistException, PermissionDeniedException {
        HashMap<String, Object> hashMap;
        DBBroker broker;
        block18: {
            Collection collection = null;
            DocumentImpl doc = null;
            broker = null;
            try {
                broker = this.factory.getBrokerPool().get(this.user);
                XmldbURI docURI = XmldbURI.xmldbUriFor(docName);
                collection = broker.openCollection(docURI.removeLastSegment(), 0);
                if (collection == null) {
                    LOG.debug((Object)("collection " + docURI.removeLastSegment() + " not found!"));
                    throw new EXistException("Collection " + docURI.removeLastSegment() + " not found!");
                }
                if (!collection.getPermissions().validate(this.user, 4)) {
                    throw new PermissionDeniedException("Insufficient privileges to read resource");
                }
                doc = collection.getDocumentWithLock(broker, docURI.lastSegment(), 0);
                if (doc == null) {
                    LOG.debug((Object)("document " + docURI + " not found!"));
                    throw new EXistException("document not found");
                }
                if (!doc.getPermissions().validate(this.user, 4)) {
                    throw new PermissionDeniedException("Insufficient privileges to read resource " + docName);
                }
                String encoding = (String)parameters.get("encoding");
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                if (doc.getResourceType() == 0) {
                    Object xml;
                    Serializer serializer = broker.getSerializer();
                    serializer.setProperties(parameters);
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    if (doc.getContentLength() > 262144) {
                        File tempFile = File.createTempFile("eXistRPCC", ".xml");
                        tempFile.deleteOnExit();
                        LOG.debug((Object)("Writing to temporary file: " + tempFile.getName()));
                        FileOutputStream os = new FileOutputStream(tempFile);
                        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, encoding);
                        serializer.serialize(doc, writer);
                        ((Writer)writer).close();
                        byte[] firstChunk = this.getChunk(tempFile, 0);
                        result.put("data", firstChunk);
                        result.put("handle", tempFile.getAbsolutePath());
                        result.put("offset", new Integer(firstChunk.length));
                    } else {
                        xml = serializer.serialize(doc);
                        result.put("data", ((String)xml).getBytes(encoding));
                        result.put("offset", new Integer(0));
                    }
                    xml = result;
                    if (collection != null) {
                        collection.releaseDocument(doc, 0);
                        collection.getLock().release(0);
                    }
                    this.factory.getBrokerPool().release(broker);
                    return xml;
                }
                HashMap<String, Object> result = new HashMap<String, Object>();
                if (doc.getContentLength() > 262144) {
                    File tempFile = File.createTempFile("eXistRPCC", ".bin");
                    tempFile.deleteOnExit();
                    LOG.debug((Object)("Writing to temporary file: " + tempFile.getName()));
                    FileOutputStream os = new FileOutputStream(tempFile);
                    broker.readBinaryResource((BinaryDocument)doc, os);
                    ((OutputStream)os).close();
                    byte[] firstChunk = this.getChunk(tempFile, 0);
                    result.put("data", firstChunk);
                    result.put("handle", tempFile.getAbsolutePath());
                    result.put("offset", new Integer(firstChunk.length));
                } else {
                    byte[] data = broker.getBinaryResource((BinaryDocument)doc);
                    result.put("data", data);
                    result.put("offset", new Integer(0));
                }
                hashMap = result;
                if (collection == null) break block18;
            }
            catch (Exception e) {
                this.handleException(e);
                HashMap hashMap2 = null;
                return hashMap2;
            }
            finally {
                if (collection != null) {
                    collection.releaseDocument(doc, 0);
                    collection.getLock().release(0);
                }
                this.factory.getBrokerPool().release(broker);
            }
            collection.releaseDocument(doc, 0);
            collection.getLock().release(0);
        }
        this.factory.getBrokerPool().release(broker);
        return hashMap;
    }

    public HashMap getNextChunk(String handle, int offset) throws EXistException, PermissionDeniedException {
        try {
            File file = new File(handle);
            if (!file.isFile() || !file.canRead()) {
                throw new EXistException("Invalid handle specified");
            }
            if (offset <= 0 || (long)offset > file.length()) {
                throw new EXistException("No more data available");
            }
            byte[] chunk = this.getChunk(file, offset);
            int nextChunk = offset + chunk.length;
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("data", chunk);
            result.put("handle", handle);
            if ((long)nextChunk == file.length()) {
                file.delete();
                result.put("offset", new Integer(0));
            } else {
                result.put("offset", new Integer(nextChunk));
            }
            return result;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    private byte[] getChunk(File file, int offset) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        raf.seek(offset);
        int remaining = (int)(raf.length() - (long)offset);
        if (remaining > 262144) {
            remaining = 262144;
        }
        byte[] data = new byte[remaining];
        raf.readFully(data);
        raf.close();
        return data;
    }

    public byte[] getBinaryResource(String name) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.getBinaryResource(XmldbURI.xmldbUriFor(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBinaryResource(XmldbURI name) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        DocumentImpl doc = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            doc = broker.getXMLResource(name, 0);
            if (doc == null) {
                throw new EXistException("Resource " + name + " not found");
            }
            if (doc.getResourceType() != 1) {
                throw new EXistException("Document " + name + " is not a binary resource");
            }
            if (!doc.getPermissions().validate(this.user, 4)) {
                throw new PermissionDeniedException("Insufficient privileges to read resource");
            }
            byte[] byArray = broker.getBinaryResource((BinaryDocument)doc);
            return byArray;
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    public int xupdate(String collectionName, byte[] xupdate) throws PermissionDeniedException, EXistException {
        try {
            return this.xupdate(XmldbURI.xmldbUriFor(collectionName), new String(xupdate, "UTF-8"));
        }
        catch (Exception e) {
            this.handleException(e);
            return -1;
        }
    }

    private int xupdate(XmldbURI collUri, String xupdate) throws SAXException, LockException, PermissionDeniedException, EXistException, XPathException {
        TransactionManager transact = this.factory.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            Collection collection = broker.getCollection(collUri);
            if (collection == null) {
                transact.abort(transaction);
                throw new EXistException("collection " + collUri + " not found");
            }
            DocumentSet docs = collection.allDocs(broker, new DocumentSet(), true, true);
            XUpdateProcessor processor = new XUpdateProcessor(broker, docs, AccessContext.XMLRPC);
            Modification[] modifications = processor.parse(new InputSource(new StringReader(xupdate)));
            long mods = 0L;
            for (int i = 0; i < modifications.length; ++i) {
                mods += modifications[i].process(transaction);
                broker.flush();
            }
            transact.commit(transaction);
            int n = (int)mods;
            return n;
        }
        catch (ParserConfigurationException e) {
            transact.abort(transaction);
            throw new EXistException(e.getMessage());
        }
        catch (IOException e) {
            transact.abort(transaction);
            throw new EXistException(e.getMessage());
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
    }

    public int xupdateResource(String resource, byte[] xupdate, String encoding) throws PermissionDeniedException, EXistException {
        try {
            return this.xupdateResource(XmldbURI.xmldbUriFor(resource), new String(xupdate, encoding));
        }
        catch (Exception e) {
            this.handleException(e);
            return -1;
        }
    }

    private int xupdateResource(XmldbURI docUri, String xupdate) throws SAXException, LockException, PermissionDeniedException, EXistException, XPathException {
        TransactionManager transact = this.factory.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            DocumentImpl doc = (DocumentImpl)broker.getXMLResource(docUri);
            if (doc == null) {
                transact.abort(transaction);
                throw new EXistException("document " + docUri + " not found");
            }
            if (!doc.getPermissions().validate(this.user, 4)) {
                transact.abort(transaction);
                throw new PermissionDeniedException("Insufficient privileges to read resource");
            }
            DocumentSet docs = new DocumentSet();
            docs.add(doc);
            XUpdateProcessor processor = new XUpdateProcessor(broker, docs, AccessContext.XMLRPC);
            Modification[] modifications = processor.parse(new InputSource(new StringReader(xupdate)));
            long mods = 0L;
            for (int i = 0; i < modifications.length; ++i) {
                mods += modifications[i].process(transaction);
                broker.flush();
            }
            transact.commit(transaction);
            int n = (int)mods;
            return n;
        }
        catch (ParserConfigurationException e) {
            transact.abort(transaction);
            throw new EXistException(e.getMessage());
        }
        catch (IOException e) {
            transact.abort(transaction);
            throw new EXistException(e.getMessage());
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sync() {
        DBBroker broker = null;
        try {
            broker = this.factory.getBrokerPool().get(XMLSecurityManager.SYSTEM_USER);
            broker.sync(1);
        }
        catch (EXistException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
        return true;
    }

    public boolean isXACMLEnabled() {
        return this.factory.getBrokerPool().getSecurityManager().isXACMLEnabled();
    }

    public boolean dataBackup(String dest) {
        this.factory.getBrokerPool().triggerSystemTask(new DataBackup(dest));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDocumentListing() throws EXistException {
        DBBroker broker = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            DocumentSet docs = broker.getAllXMLResources(new DocumentSet());
            XmldbURI[] names = docs.getNames();
            Vector<String> vec = new Vector<String>();
            for (int i = 0; i < names.length; ++i) {
                vec.addElement(names[i].toString());
            }
            Vector<String> vector = vec;
            return vector;
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
    }

    public Vector getDocumentListing(String collName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.getDocumentListing(XmldbURI.xmldbUriFor(collName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getDocumentListing(XmldbURI collUri) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            collection = broker.openCollection(collUri, 0);
            Vector<String> vec = new Vector<String>();
            if (collection == null) {
                LOG.debug((Object)("collection " + collUri + " not found."));
                Vector<String> vector = vec;
                return vector;
            }
            Iterator i = collection.iterator(broker);
            while (i.hasNext()) {
                vec.addElement(((DocumentImpl)i.next()).getFileURI().toString());
            }
            Vector<String> vector = vec;
            return vector;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    public int getResourceCount(String collectionName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.getResourceCount(XmldbURI.xmldbUriFor(collectionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getResourceCount(XmldbURI collUri) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            collection = broker.openCollection(collUri, 0);
            int n = collection.getDocumentCount();
            return n;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    public String createResourceId(String collectionName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.createResourceId(XmldbURI.xmldbUriFor(collectionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createResourceId(XmldbURI collUri) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            XmldbURI id;
            boolean ok;
            broker = this.factory.getBrokerPool().get(this.user);
            collection = broker.openCollection(collUri, 0);
            Random rand = new Random();
            do {
                ok = true;
                id = XmldbURI.create(Integer.toHexString(rand.nextInt()) + ".xml");
                if (collection.hasDocument(id)) {
                    ok = false;
                }
                if (!collection.hasSubcollection(id)) continue;
                ok = false;
            } while (!ok);
            String string = id.toString();
            return string;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    public HashMap listDocumentPermissions(String name) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.listDocumentPermissions(XmldbURI.xmldbUriFor(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap listDocumentPermissions(XmldbURI collUri) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            collection = broker.openCollection(collUri, 0);
            if (collection == null) {
                throw new EXistException("Collection " + collUri + " not found");
            }
            if (!collection.getPermissions().validate(this.user, 4)) {
                throw new PermissionDeniedException("not allowed to read collection " + collUri);
            }
            HashMap result = new HashMap(collection.getDocumentCount());
            Iterator i = collection.iterator(broker);
            while (i.hasNext()) {
                DocumentImpl doc = (DocumentImpl)i.next();
                Permission perm = doc.getPermissions();
                ArrayList<Object> tmp = new ArrayList<Object>(3);
                tmp.add(perm.getOwner());
                tmp.add(perm.getOwnerGroup());
                tmp.add(new Integer(perm.getPermissions()));
                result.put(doc.getFileURI().toString(), tmp);
            }
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    public HashMap listCollectionPermissions(String name) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.listCollectionPermissions(XmldbURI.xmldbUriFor(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap listCollectionPermissions(XmldbURI collUri) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            collection = broker.openCollection(collUri, 0);
            if (collection == null) {
                throw new EXistException("Collection " + collUri + " not found");
            }
            if (!collection.getPermissions().validate(this.user, 4)) {
                throw new PermissionDeniedException("not allowed to read collection " + collUri);
            }
            HashMap result = new HashMap(collection.getChildCollectionCount());
            Iterator i = collection.collectionIterator();
            while (i.hasNext()) {
                XmldbURI child = (XmldbURI)i.next();
                XmldbURI path = collUri.append(child);
                Collection childColl = broker.getCollection(path);
                Permission perm = childColl.getPermissions();
                ArrayList<Object> tmp = new ArrayList<Object>(3);
                tmp.add(perm.getOwner());
                tmp.add(perm.getOwnerGroup());
                tmp.add(new Integer(perm.getPermissions()));
                result.put(child, tmp);
            }
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    public int getHits(int resultId) throws EXistException {
        QueryResult qr = this.factory.resultSets.get(resultId);
        if (qr == null) {
            throw new EXistException("result set unknown or timed out");
        }
        qr.timestamp = System.currentTimeMillis();
        if (qr.result == null) {
            return 0;
        }
        return qr.result.getItemCount();
    }

    public HashMap getPermissions(String name) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.getPermissions(XmldbURI.xmldbUriFor(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getPermissions(XmldbURI uri) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            collection = broker.openCollection(uri, 0);
            Permission perm = null;
            if (collection == null) {
                DocumentImpl doc = null;
                try {
                    doc = broker.getXMLResource(uri, 0);
                    if (doc == null) {
                        throw new EXistException("document or collection " + uri + " not found");
                    }
                    perm = doc.getPermissions();
                }
                finally {
                    if (doc != null) {
                        doc.getUpdateLock().release(0);
                    }
                }
            } else {
                perm = collection.getPermissions();
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("owner", perm.getOwner());
            result.put("group", perm.getOwnerGroup());
            result.put("permissions", new Integer(perm.getPermissions()));
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    public Date getCreationDate(String collectionPath) throws PermissionDeniedException, EXistException, URISyntaxException {
        return this.getCreationDate(XmldbURI.xmldbUriFor(collectionPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date getCreationDate(XmldbURI collUri) throws PermissionDeniedException, EXistException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            collection = broker.openCollection(collUri, 0);
            if (collection == null) {
                throw new EXistException("collection " + collUri + " not found");
            }
            Date date = new Date(collection.getCreationTime());
            return date;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    public Vector getTimestamps(String documentPath) throws PermissionDeniedException, EXistException, URISyntaxException {
        return this.getTimestamps(XmldbURI.xmldbUriFor(documentPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getTimestamps(XmldbURI docUri) throws PermissionDeniedException, EXistException {
        DBBroker broker = null;
        DocumentImpl doc = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            doc = broker.getXMLResource(docUri, 0);
            if (doc == null) {
                LOG.debug((Object)("document " + docUri + " not found!"));
                throw new EXistException("document not found");
            }
            DocumentMetadata metadata = doc.getMetadata();
            Vector<Date> vector = new Vector<Date>(2);
            vector.addElement(new Date(metadata.getCreated()));
            vector.addElement(new Date(metadata.getLastModified()));
            Vector<Date> vector2 = vector;
            return vector2;
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    public HashMap getUser(String name) throws EXistException, PermissionDeniedException {
        User u = this.factory.getBrokerPool().getSecurityManager().getUser(name);
        if (u == null) {
            throw new EXistException("user " + name + " does not exist");
        }
        HashMap<String, Object> tab = new HashMap<String, Object>();
        tab.put("name", u.getName());
        Vector<String> groups = new Vector<String>();
        String[] gl = u.getGroups();
        for (int i = 0; i < gl.length; ++i) {
            groups.addElement(gl[i]);
        }
        tab.put("groups", groups);
        if (u.getHome() != null) {
            tab.put("home", u.getHome().toString());
        }
        return tab;
    }

    public Vector getUsers() throws EXistException, PermissionDeniedException {
        User[] users = this.factory.getBrokerPool().getSecurityManager().getUsers();
        Vector r = new Vector();
        for (int i = 0; i < users.length; ++i) {
            HashMap<String, Object> tab = new HashMap<String, Object>();
            tab.put("name", users[i].getName());
            Vector<String> groups = new Vector<String>();
            String[] gl = users[i].getGroups();
            for (int j = 0; j < gl.length; ++j) {
                groups.addElement(gl[j]);
            }
            tab.put("groups", groups);
            if (users[i].getHome() != null) {
                tab.put("home", users[i].getHome().toString());
            }
            r.addElement(tab);
        }
        return r;
    }

    public Vector getGroups() throws EXistException, PermissionDeniedException {
        String[] groups = this.factory.getBrokerPool().getSecurityManager().getGroups();
        Vector<String> v = new Vector<String>(groups.length);
        for (int i = 0; i < groups.length; ++i) {
            v.addElement(groups[i]);
        }
        return v;
    }

    public boolean hasDocument(String documentPath) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.hasDocument(XmldbURI.xmldbUriFor(documentPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDocument(XmldbURI docUri) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            boolean bl = broker.getXMLResource(docUri) != null;
            return bl;
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
    }

    public boolean hasCollection(String collectionName) throws EXistException, URISyntaxException {
        return this.hasCollection(XmldbURI.xmldbUriFor(collectionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasCollection(XmldbURI collUri) throws EXistException {
        DBBroker broker = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            boolean bl = broker.getCollection(collUri) != null;
            return bl;
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
    }

    public boolean parse(byte[] xml, String documentPath, int overwrite) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.parse(xml, documentPath, overwrite, null, null);
    }

    public boolean parse(byte[] xml, String documentPath, int overwrite, Date created, Date modified) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.parse(xml, XmldbURI.xmldbUriFor(documentPath), overwrite, created, modified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parse(byte[] xml, XmldbURI docUri, int overwrite, Date created, Date modified) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        TransactionManager transact = this.factory.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            long startTime = System.currentTimeMillis();
            broker = this.factory.getBrokerPool().get(this.user);
            IndexInfo info = null;
            InputSource source = null;
            Collection collection = null;
            try {
                DocumentImpl old;
                collection = broker.openCollection(docUri.removeLastSegment(), 1);
                if (collection == null) {
                    transact.abort(transaction);
                    throw new EXistException("Collection " + docUri.removeLastSegment() + " not found");
                }
                if (overwrite == 0 && (old = collection.getDocument(broker, docUri.lastSegment())) != null) {
                    transact.abort(transaction);
                    throw new PermissionDeniedException("Document exists and overwrite is not allowed");
                }
                ByteArrayInputStream is = new ByteArrayInputStream(xml);
                source = new InputSource(is);
                info = collection.validateXMLResource(transaction, broker, docUri.lastSegment(), source);
                if (created != null) {
                    info.getDocument().getMetadata().setCreated(created.getTime());
                }
                if (modified != null) {
                    info.getDocument().getMetadata().setLastModified(modified.getTime());
                }
            }
            finally {
                if (collection != null) {
                    collection.release(1);
                }
            }
            collection.store(transaction, broker, info, source, false);
            transact.commit(transaction);
            LOG.debug((Object)("parsing " + docUri + " took " + (System.currentTimeMillis() - startTime) + "ms."));
            boolean bl = true;
            this.factory.getBrokerPool().release(broker);
            return bl;
        }
        catch (Exception e) {
            try {
                transact.abort(transaction);
                this.handleException(e);
                boolean bl = false;
                this.factory.getBrokerPool().release(broker);
                return bl;
            }
            catch (Throwable throwable) {
                this.factory.getBrokerPool().release(broker);
                throw throwable;
            }
        }
    }

    public boolean parseLocal(String localFile, String documentPath, int overwrite, String mimeType) throws Exception, URISyntaxException {
        return this.parseLocal(localFile, documentPath, overwrite, mimeType, null, null);
    }

    private boolean parseLocal(String localFile, XmldbURI docUri, int overwrite, String mimeType) throws Exception {
        return this.parseLocal(localFile, docUri, overwrite, mimeType, null, null);
    }

    public boolean parseLocal(String localFile, String documentPath, int overwrite, String mimeType, Date created, Date modified) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.parseLocal(localFile, XmldbURI.xmldbUriFor(documentPath), overwrite, mimeType, created, modified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseLocal(String localFile, XmldbURI docUri, int overwrite, String mimeType, Date created, Date modified) throws EXistException, PermissionDeniedException {
        File file = new File(localFile);
        if (!file.canRead()) {
            throw new EXistException("unable to read file " + localFile);
        }
        TransactionManager transact = this.factory.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        BinaryDocument doc = null;
        MimeType mime = MimeTable.getInstance().getContentType(mimeType);
        if (mime == null) {
            mime = MimeType.BINARY_TYPE;
        }
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            Collection collection = null;
            IndexInfo info = null;
            InputSource source = null;
            try {
                DocumentImpl old;
                collection = broker.openCollection(docUri.removeLastSegment(), 1);
                if (collection == null) {
                    transact.abort(transaction);
                    throw new EXistException("Collection " + docUri.removeLastSegment() + " not found");
                }
                if (overwrite == 0 && (old = collection.getDocument(broker, docUri.lastSegment())) != null) {
                    transact.abort(transaction);
                    throw new PermissionDeniedException("Old document exists and overwrite is not allowed");
                }
                if (mime.isXMLType()) {
                    source = new InputSource(file.toURI().toASCIIString());
                    info = collection.validateXMLResource(transaction, broker, docUri.lastSegment(), source);
                    if (created != null) {
                        info.getDocument().getMetadata().setCreated(created.getTime());
                    }
                    if (modified != null) {
                        info.getDocument().getMetadata().setLastModified(modified.getTime());
                    }
                } else {
                    FileInputStream is = new FileInputStream(file);
                    doc = collection.addBinaryResource(transaction, broker, docUri.lastSegment(), is, mime.getName(), (int)file.length());
                    is.close();
                    if (created != null) {
                        doc.getMetadata().setCreated(created.getTime());
                    }
                    if (modified != null) {
                        doc.getMetadata().setLastModified(modified.getTime());
                    }
                }
            }
            finally {
                if (collection != null) {
                    collection.release(1);
                }
            }
            if (mime.isXMLType()) {
                collection.store(transaction, broker, info, source, false);
            }
            transact.commit(transaction);
        }
        catch (Exception e) {
            transact.abort(transaction);
            this.handleException(e);
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
        file.delete();
        return true;
    }

    public boolean storeBinary(byte[] data, String documentPath, String mimeType, int overwrite) throws Exception, URISyntaxException {
        return this.storeBinary(data, documentPath, mimeType, overwrite, null, null);
    }

    private boolean storeBinary(byte[] data, XmldbURI docUri, String mimeType, int overwrite) throws Exception {
        return this.storeBinary(data, docUri, mimeType, overwrite, null, null);
    }

    public boolean storeBinary(byte[] data, String documentPath, String mimeType, int overwrite, Date created, Date modified) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.storeBinary(data, XmldbURI.xmldbUriFor(documentPath), mimeType, overwrite, created, modified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeBinary(byte[] data, XmldbURI docUri, String mimeType, int overwrite, Date created, Date modified) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        BinaryDocument doc = null;
        TransactionManager transact = this.factory.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            DocumentImpl old;
            broker = this.factory.getBrokerPool().get(this.user);
            Collection collection = broker.openCollection(docUri.removeLastSegment(), 1);
            if (collection == null) {
                transact.abort(transaction);
                throw new EXistException("Collection " + docUri.removeLastSegment() + " not found");
            }
            if (transaction != null) {
                transaction.registerLock(collection.getLock(), 1);
            }
            if (overwrite == 0 && (old = collection.getDocument(broker, docUri.lastSegment())) != null) {
                transact.abort(transaction);
                throw new PermissionDeniedException("Old document exists and overwrite is not allowed");
            }
            LOG.debug((Object)("Storing binary resource to collection " + collection.getURI()));
            doc = collection.addBinaryResource(transaction, broker, docUri.lastSegment(), data, mimeType);
            if (created != null) {
                doc.getMetadata().setCreated(created.getTime());
            }
            if (modified != null) {
                doc.getMetadata().setLastModified(modified.getTime());
            }
            transact.commit(transaction);
        }
        catch (Exception e) {
            transact.abort(transaction);
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
        return doc != null;
    }

    public String upload(byte[] chunk, int length, String fileName, boolean compressed) throws EXistException, IOException {
        File file;
        if (fileName == null || fileName.length() == 0) {
            file = File.createTempFile("rpc", ".xml");
            fileName = file.getAbsolutePath();
            LOG.debug((Object)("created temporary file " + file.getAbsolutePath()));
        } else {
            file = new File(fileName);
        }
        if (!file.canWrite()) {
            throw new EXistException("cannot write to file " + fileName);
        }
        FileOutputStream os = new FileOutputStream(file, true);
        if (compressed) {
            Compressor.uncompress(chunk, os);
        } else {
            os.write(chunk, 0, length);
        }
        os.close();
        return fileName;
    }

    protected String printAll(DBBroker broker, Sequence resultSet, int howmany, int start, HashMap properties, long queryTime) throws Exception {
        if (resultSet.isEmpty()) {
            StringBuffer buf = new StringBuffer();
            String opt = (String)properties.get("omit-xml-declaration");
            if (opt == null || opt.equalsIgnoreCase("no")) {
                buf.append("<?xml version=\"1.0\"?>\n");
            }
            buf.append("<exist:result xmlns:exist=\"").append("http://exist.sourceforge.net/NS/exist").append("\" ");
            buf.append("hitCount=\"0\"/>");
            return buf.toString();
        }
        if (howmany > resultSet.getItemCount() || howmany == 0) {
            howmany = resultSet.getItemCount();
        }
        if (start < 1 || start > resultSet.getItemCount()) {
            throw new EXistException("start parameter out of range");
        }
        StringWriter writer = new StringWriter();
        writer.write("<exist:result xmlns:exist=\"");
        writer.write("http://exist.sourceforge.net/NS/exist");
        writer.write("\" hits=\"");
        writer.write(Integer.toString(resultSet.getItemCount()));
        writer.write("\" start=\"");
        writer.write(Integer.toString(start));
        writer.write("\" count=\"");
        writer.write(Integer.toString(howmany));
        writer.write("\">\n");
        Serializer serializer = broker.getSerializer();
        serializer.reset();
        serializer.setProperties(properties);
        for (int i = --start; i < start + howmany; ++i) {
            Item item = resultSet.itemAt(i);
            if (item == null) continue;
            if (item.getType() == 1) {
                NodeValue node = (NodeValue)item;
                writer.write(serializer.serialize(node));
                continue;
            }
            writer.write("<exist:value type=\"");
            writer.write(Type.getTypeName(item.getType()));
            writer.write("\">");
            writer.write(item.getStringValue());
            writer.write("</exist:value>");
        }
        writer.write("\n</exist:result>");
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public HashMap compile(String query, HashMap parameters) throws EXistException, PermissionDeniedException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        DBBroker broker = null;
        XQueryPool pool = null;
        CompiledXQuery compiled = null;
        StringSource source = new StringSource(query);
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            XQuery xquery = broker.getXQueryService();
            pool = xquery.getXQueryPool();
            compiled = this.compile(broker, source, parameters);
            this.factory.getBrokerPool().release(broker);
            if (compiled != null && pool != null) {
                pool.returnCompiledXQuery(source, compiled);
            }
        }
        catch (XPathException e) {
            ret.put("error", e.getMessage());
            if (e.getLine() != 0) {
                ret.put("line", new Integer(e.getLine()));
                ret.put("column", new Integer(e.getColumn()));
            }
            this.factory.getBrokerPool().release(broker);
            if (compiled != null && pool != null) {
                pool.returnCompiledXQuery(source, compiled);
            }
        }
        catch (Exception e2) {
            this.handleException(e2);
            this.factory.getBrokerPool().release(broker);
            if (compiled != null && pool != null) {
                pool.returnCompiledXQuery(source, compiled);
            }
            {
                catch (Throwable throwable) {
                    this.factory.getBrokerPool().release(broker);
                    if (compiled != null && pool != null) {
                        pool.returnCompiledXQuery(source, compiled);
                    }
                    throw throwable;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String query(String xpath, int howmany, int start, HashMap parameters) throws EXistException, PermissionDeniedException {
        long startTime = System.currentTimeMillis();
        String result = null;
        DBBroker broker = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            QueryResult qr = this.doQuery(broker, xpath, null, parameters);
            if (qr.hasErrors()) {
                throw qr.getException();
            }
            if (qr == null) {
                String string = "<?xml version=\"1.0\"?>\n<exist:result xmlns:exist=\"http://exist.sourceforge.net/NS/exist\" hitCount=\"0\"/>";
                return string;
            }
            result = this.printAll(broker, qr.result, howmany, start, parameters, System.currentTimeMillis() - startTime);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
        return result;
    }

    public HashMap queryP(String xpath, String documentPath, String s_id, HashMap parameters) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.queryP(xpath, documentPath == null ? null : XmldbURI.xmldbUriFor(documentPath), s_id, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap queryP(String xpath, XmldbURI docUri, String s_id, HashMap parameters) throws EXistException, PermissionDeniedException {
        QueryResult queryResult;
        long startTime = System.currentTimeMillis();
        String sortBy = (String)parameters.get("sort-expr");
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ArrayList<Object> result = new ArrayList<Object>();
        ExtArrayNodeSet nodes = null;
        Sequence resultSeq = null;
        DBBroker broker = null;
        try {
            Object docs;
            Object doc;
            broker = this.factory.getBrokerPool().get(this.user);
            if (docUri != null && s_id != null) {
                doc = (DocumentImpl)broker.getXMLResource(docUri);
                docs = new Object[]{docUri.toString()};
                parameters.put("static-documents", docs);
                if (s_id.length() > 0) {
                    NodeId nodeId = this.factory.getBrokerPool().getNodeFactory().createFromString(s_id);
                    NodeProxy node = new NodeProxy((DocumentImpl)doc, nodeId);
                    nodes = new ExtArrayNodeSet(1);
                    nodes.add(node);
                }
            }
            if ((queryResult = this.doQuery(broker, xpath, nodes, parameters)) == null) {
                doc = ret;
                return doc;
            }
            if (queryResult.hasErrors()) {
                XPathException e = queryResult.getException();
                ret.put("error", e.getMessage());
                if (e.getLine() != 0) {
                    ret.put("line", new Integer(e.getLine()));
                    ret.put("column", new Integer(e.getColumn()));
                }
                docs = ret;
                return docs;
            }
            resultSeq = queryResult.result;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("found " + resultSeq.getItemCount()));
            }
            if (sortBy != null) {
                SortedNodeSet sorted = new SortedNodeSet(this.factory.getBrokerPool(), this.user, sortBy, AccessContext.XMLRPC);
                sorted.addAll(resultSeq);
                resultSeq = sorted;
            }
            if (resultSeq != null) {
                SequenceIterator i = resultSeq.iterate();
                if (i != null) {
                    while (i.hasNext()) {
                        Item next = i.nextItem();
                        if (Type.subTypeOf(next.getType(), -1)) {
                            Vector<String> entry = new Vector<String>();
                            if (((NodeValue)next).getImplementationType() == 1) {
                                NodeProxy p = (NodeProxy)next;
                                entry.addElement(p.getDocument().getURI().toString());
                                entry.addElement(p.getNodeId().toString());
                            } else {
                                entry.addElement("temp_xquery/" + next.hashCode());
                                entry.addElement(String.valueOf(((NodeImpl)next).getNodeNumber()));
                            }
                            result.add(entry);
                            continue;
                        }
                        result.add(next.getStringValue());
                    }
                } else {
                    LOG.debug((Object)"sequence iterator is null. Should not");
                }
            } else {
                LOG.debug((Object)"result sequence is null. Skipping it...");
            }
        }
        catch (Exception e) {
            this.handleException(e);
            HashMap hashMap = null;
            return hashMap;
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
        queryResult.result = resultSeq;
        queryResult.queryTime = System.currentTimeMillis() - startTime;
        int id = this.factory.resultSets.add(queryResult);
        ret.put("id", new Integer(id));
        ret.put("results", result);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap execute(String pathToQuery, HashMap parameters) throws EXistException, PermissionDeniedException {
        QueryResult queryResult;
        long startTime = System.currentTimeMillis();
        byte[] doc = this.getBinaryResource(XmldbURI.createInternal(pathToQuery));
        String xpath = null;
        try {
            xpath = new String(doc, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EXistException("Character encoding issue while reading stored XQuery: " + e.getMessage());
        }
        String sortBy = (String)parameters.get("sort-expr");
        HashMap<String, Object> ret = new HashMap<String, Object>();
        Vector<Object> result = new Vector<Object>();
        NodeSet nodes = null;
        Sequence resultSeq = null;
        DBBroker broker = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            queryResult = this.doQuery(broker, xpath, nodes, parameters);
            if (queryResult == null) {
                HashMap<String, Object> hashMap = ret;
                return hashMap;
            }
            if (queryResult.hasErrors()) {
                XPathException e = queryResult.getException();
                ret.put("error", e.getMessage());
                if (e.getLine() != 0) {
                    ret.put("line", new Integer(e.getLine()));
                    ret.put("column", new Integer(e.getColumn()));
                }
                HashMap<String, Object> hashMap = ret;
                return hashMap;
            }
            resultSeq = queryResult.result;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("found " + resultSeq.getItemCount()));
            }
            if (sortBy != null) {
                SortedNodeSet sorted = new SortedNodeSet(this.factory.getBrokerPool(), this.user, sortBy, AccessContext.XMLRPC);
                sorted.addAll(resultSeq);
                resultSeq = sorted;
            }
            if (resultSeq != null) {
                SequenceIterator i = resultSeq.iterate();
                if (i != null) {
                    while (i.hasNext()) {
                        Item next = i.nextItem();
                        if (Type.subTypeOf(next.getType(), -1)) {
                            Vector<String> entry = new Vector<String>();
                            if (((NodeValue)next).getImplementationType() == 1) {
                                NodeProxy p = (NodeProxy)next;
                                entry.addElement(p.getDocument().getURI().toString());
                                entry.addElement(p.getNodeId().toString());
                            } else {
                                entry.addElement("temp_xquery/" + next.hashCode());
                                entry.addElement(String.valueOf(((NodeImpl)next).getNodeNumber()));
                            }
                            result.addElement(entry);
                            continue;
                        }
                        result.addElement(next.getStringValue());
                    }
                } else {
                    LOG.debug((Object)"sequence iterator is null. Should not");
                }
            } else {
                LOG.debug((Object)"result sequence is null. Skipping it...");
            }
        }
        catch (Exception e) {
            this.handleException(e);
            HashMap hashMap = null;
            return hashMap;
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
        queryResult.result = resultSeq;
        queryResult.queryTime = System.currentTimeMillis() - startTime;
        int id = this.factory.resultSets.add(queryResult);
        ret.put("id", new Integer(id));
        ret.put("results", result);
        return ret;
    }

    public boolean releaseQueryResult(int handle) {
        this.factory.resultSets.remove(handle);
        LOG.debug((Object)("removed query result with handle " + handle));
        return true;
    }

    public boolean remove(String documentPath) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.remove(XmldbURI.xmldbUriFor(documentPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(XmldbURI docUri) throws EXistException, PermissionDeniedException {
        TransactionManager transact = this.factory.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        Collection collection = null;
        try {
            DocumentImpl doc;
            broker = this.factory.getBrokerPool().get(this.user);
            collection = broker.openCollection(docUri.removeLastSegment(), 1);
            if (collection == null) {
                transact.abort(transaction);
                throw new EXistException("Collection " + docUri.removeLastSegment() + " not found");
            }
            if (transaction != null) {
                transaction.registerLock(collection.getLock(), 1);
            }
            if ((doc = collection.getDocument(broker, docUri.lastSegment())) == null) {
                transact.abort(transaction);
                throw new EXistException("Document " + docUri + " not found");
            }
            if (doc.getResourceType() == 1) {
                collection.removeBinaryResource(transaction, broker, doc);
            } else {
                collection.removeXMLResource(transaction, broker, docUri.lastSegment());
            }
            transact.commit(transaction);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
    }

    public boolean removeCollection(String collectionName) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.removeCollection(XmldbURI.xmldbUriFor(collectionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeCollection(XmldbURI collURI) throws EXistException, PermissionDeniedException {
        TransactionManager transact = this.factory.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            collection = broker.openCollection(collURI, 1);
            if (collection == null) {
                transact.abort(transaction);
                boolean bl = false;
                return bl;
            }
            if (transaction != null) {
                transaction.registerLock(collection.getLock(), 1);
            }
            LOG.debug((Object)("removing collection " + collURI));
            boolean removed = broker.removeCollection(transaction, collection);
            transact.commit(transaction);
            boolean bl = removed;
            return bl;
        }
        catch (Exception e) {
            transact.abort(transaction);
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
    }

    public boolean removeUser(String name) throws EXistException, PermissionDeniedException {
        SecurityManager manager = this.factory.getBrokerPool().getSecurityManager();
        if (!manager.hasAdminPrivileges(this.user)) {
            throw new PermissionDeniedException("you are not allowed to remove users");
        }
        manager.deleteUser(name);
        return true;
    }

    public byte[] retrieve(String doc, String id, HashMap parameters) throws EXistException, PermissionDeniedException {
        String xml = null;
        try {
            xml = this.retrieveAsString(doc, id, parameters);
            try {
                String encoding = (String)parameters.get("encoding");
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                return xml.getBytes(encoding);
            }
            catch (UnsupportedEncodingException uee) {
                LOG.warn((Object)uee);
                return xml.getBytes();
            }
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public String retrieveAsString(String documentPath, String s_id, HashMap parameters) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.retrieve(XmldbURI.xmldbUriFor(documentPath), s_id, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieve(XmldbURI docUri, String s_id, HashMap parameters) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            NodeId nodeId = this.factory.getBrokerPool().getNodeFactory().createFromString(s_id);
            LOG.debug((Object)("loading doc " + docUri));
            DocumentImpl doc = (DocumentImpl)broker.getXMLResource(docUri);
            NodeProxy node = new NodeProxy(doc, nodeId);
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            serializer.setProperties(parameters);
            String string = serializer.serialize(node);
            return string;
        }
        catch (Exception e) {
            this.handleException(e);
            String string = null;
            return string;
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
    }

    public byte[] retrieve(int resultId, int num, HashMap parameters) throws EXistException, PermissionDeniedException {
        String compression = "no";
        if ((String)parameters.get("compress-output") != null) {
            compression = (String)parameters.get("compress-output");
        }
        try {
            String xml = this.retrieveAsString(resultId, num, parameters);
            String encoding = (String)parameters.get("encoding");
            if (encoding == null) {
                encoding = "UTF-8";
            }
            try {
                if (compression.equals("no")) {
                    return xml.getBytes(encoding);
                }
                LOG.debug((Object)"get result with compression");
                return Compressor.compress(xml.getBytes(encoding));
            }
            catch (UnsupportedEncodingException uee) {
                LOG.warn((Object)uee);
                if (compression.equals("no")) {
                    return xml.getBytes();
                }
                LOG.debug((Object)"get result with compression");
                return Compressor.compress(xml.getBytes());
            }
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveAsString(int resultId, int num, HashMap parameters) throws Exception {
        DBBroker broker = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            QueryResult qr = this.factory.resultSets.get(resultId);
            if (qr == null) {
                throw new EXistException("result set unknown or timed out");
            }
            qr.timestamp = System.currentTimeMillis();
            Item item = qr.result.itemAt(num);
            if (item == null) {
                throw new EXistException("index out of range");
            }
            if (Type.subTypeOf(item.getType(), -1)) {
                NodeValue nodeValue = (NodeValue)item;
                Serializer serializer = broker.getSerializer();
                serializer.reset();
                this.checkPragmas(qr.serialization, parameters);
                serializer.setProperties(parameters);
                String string = serializer.serialize(nodeValue);
                return string;
            }
            String string = item.getStringValue();
            return string;
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
    }

    public byte[] retrieveAll(int resultId, HashMap parameters) throws EXistException, PermissionDeniedException {
        try {
            String xml = this.retrieveAllAsString(resultId, parameters);
            String encoding = (String)parameters.get("encoding");
            if (encoding == null) {
                encoding = "UTF-8";
            }
            try {
                return xml.getBytes(encoding);
            }
            catch (UnsupportedEncodingException uee) {
                LOG.warn((Object)uee);
                return xml.getBytes();
            }
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveAllAsString(int resultId, HashMap parameters) throws Exception {
        DBBroker broker = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            QueryResult qr = this.factory.resultSets.get(resultId);
            if (qr == null) {
                throw new EXistException("result set unknown or timed out");
            }
            qr.timestamp = System.currentTimeMillis();
            this.checkPragmas(qr.serialization, parameters);
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            serializer.setProperties(parameters);
            SAXSerializer handler = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            StringWriter writer = new StringWriter();
            handler.setOutput(writer, this.getProperties(parameters));
            handler.startDocument();
            handler.startPrefixMapping("exist", "http://exist.sourceforge.net/NS/exist");
            AttributesImpl attribs = new AttributesImpl();
            attribs.addAttribute("", "hitCount", "hitCount", "CDATA", Integer.toString(qr.result.getItemCount()));
            handler.startElement("http://exist.sourceforge.net/NS/exist", "result", "exist:result", attribs);
            SequenceIterator i = qr.result.iterate();
            while (i.hasNext()) {
                Item current = i.nextItem();
                if (Type.subTypeOf(current.getType(), -1)) {
                    current.toSAX(broker, handler, null);
                    continue;
                }
                char[] value = current.toString().toCharArray();
                handler.characters(value, 0, value.length);
            }
            handler.endElement("http://exist.sourceforge.net/NS/exist", "result", "exist:result");
            handler.endPrefixMapping("exist");
            handler.endDocument();
            SerializerPool.getInstance().returnObject(handler);
            String string = writer.toString();
            return string;
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
    }

    public boolean setPermissions(String resource, String owner, String ownerGroup, String permissions) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.setPermissions(XmldbURI.xmldbUriFor(resource), owner, ownerGroup, permissions);
    }

    private boolean setPermissions(XmldbURI uri, String owner, String ownerGroup, String permissions) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        DocumentImpl doc = null;
        TransactionManager transact = this.factory.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            SecurityManager manager = this.factory.getBrokerPool().getSecurityManager();
            collection = broker.openCollection(uri, 1);
            if (collection == null) {
                doc = broker.getXMLResource(uri, 1);
                if (doc == null) {
                    transact.abort(transaction);
                    throw new EXistException("document or collection " + uri + " not found");
                }
                LOG.debug((Object)("changing permissions on document " + uri));
                Permission perm = doc.getPermissions();
                if (perm.validate(this.user, 2) || manager.hasAdminPrivileges(this.user)) {
                    if (owner != null) {
                        if (!perm.getOwner().equals(this.user.getName()) && !manager.hasAdminPrivileges(this.user)) {
                            throw new PermissionDeniedException("not allowed to change permissions");
                        }
                        perm.setOwner(owner);
                        if (!manager.hasGroup(ownerGroup)) {
                            manager.addGroup(ownerGroup);
                        }
                        perm.setGroup(ownerGroup);
                    }
                    if (permissions != null && permissions.length() > 0) {
                        perm.setPermissions(permissions);
                    }
                    broker.storeXMLResource(transaction, doc);
                    transact.commit(transaction);
                    broker.flush();
                    boolean bl = true;
                    return bl;
                }
                transact.abort(transaction);
                throw new PermissionDeniedException("not allowed to change permissions");
            }
            if (transaction != null) {
                transaction.registerLock(collection.getLock(), 1);
            }
            LOG.debug((Object)("changing permissions on collection " + uri));
            Permission perm = collection.getPermissions();
            if (perm.validate(this.user, 2) || manager.hasAdminPrivileges(this.user)) {
                if (permissions != null) {
                    perm.setPermissions(permissions);
                }
                if (owner != null) {
                    if (!perm.getOwner().equals(this.user.getName()) && !manager.hasAdminPrivileges(this.user)) {
                        throw new PermissionDeniedException("not allowed to change permissions");
                    }
                    perm.setOwner(owner);
                    if (!manager.hasGroup(ownerGroup)) {
                        manager.addGroup(ownerGroup);
                    }
                    perm.setGroup(ownerGroup);
                }
                broker.saveCollection(transaction, collection);
                transact.commit(transaction);
                broker.flush();
                boolean bl = true;
                return bl;
            }
            try {
                transact.abort(transaction);
                throw new PermissionDeniedException("not allowed to change permissions");
            }
            catch (SyntaxException e) {
                transact.abort(transaction);
                throw new EXistException(e.getMessage());
            }
            catch (PermissionDeniedException e) {
                transact.abort(transaction);
                throw new EXistException(e.getMessage());
            }
            catch (IOException e) {
                transact.abort(transaction);
                throw new EXistException(e.getMessage());
            }
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    public boolean setPermissions(String resource, String owner, String ownerGroup, int permissions) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.setPermissions(XmldbURI.xmldbUriFor(resource), owner, ownerGroup, permissions);
    }

    private boolean setPermissions(XmldbURI uri, String owner, String ownerGroup, int permissions) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        DocumentImpl doc = null;
        TransactionManager transact = this.factory.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            SecurityManager manager = this.factory.getBrokerPool().getSecurityManager();
            collection = broker.openCollection(uri, 1);
            if (collection == null) {
                doc = broker.getXMLResource(uri, 1);
                if (doc == null) {
                    transact.abort(transaction);
                    throw new EXistException("document or collection " + uri + " not found");
                }
                LOG.debug((Object)("changing permissions on document " + uri));
                Permission perm = doc.getPermissions();
                if (perm.validate(this.user, 2) || manager.hasAdminPrivileges(this.user)) {
                    if (owner != null) {
                        if (!perm.getOwner().equals(this.user.getName()) && !manager.hasAdminPrivileges(this.user)) {
                            throw new PermissionDeniedException("not allowed to change permissions");
                        }
                        perm.setOwner(owner);
                        if (!manager.hasGroup(ownerGroup)) {
                            manager.addGroup(ownerGroup);
                        }
                        perm.setGroup(ownerGroup);
                    }
                    perm.setPermissions(permissions);
                    broker.storeXMLResource(transaction, doc);
                    transact.commit(transaction);
                    broker.flush();
                    boolean bl = true;
                    return bl;
                }
                transact.abort(transaction);
                throw new PermissionDeniedException("not allowed to change permissions");
            }
            if (transaction != null) {
                transaction.registerLock(collection.getLock(), 1);
            }
            LOG.debug((Object)("changing permissions on collection " + uri));
            Permission perm = collection.getPermissions();
            if (perm.validate(this.user, 2) || manager.hasAdminPrivileges(this.user)) {
                perm.setPermissions(permissions);
                if (owner != null) {
                    if (!perm.getOwner().equals(this.user.getName()) && !manager.hasAdminPrivileges(this.user)) {
                        throw new PermissionDeniedException("not allowed to change permissions");
                    }
                    perm.setOwner(owner);
                    if (!manager.hasGroup(ownerGroup)) {
                        manager.addGroup(ownerGroup);
                    }
                    perm.setGroup(ownerGroup);
                }
                broker.saveCollection(transaction, collection);
                transact.commit(transaction);
                broker.flush();
                boolean bl = true;
                return bl;
            }
            try {
                transact.abort(transaction);
                throw new PermissionDeniedException("not allowed to change permissions");
            }
            catch (PermissionDeniedException e) {
                transact.abort(transaction);
                throw new EXistException(e.getMessage());
            }
            catch (IOException e) {
                transact.abort(transaction);
                throw new EXistException(e.getMessage());
            }
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    public boolean setUser(String name, String passwd, String passwdDigest, Vector groups, String home) throws EXistException, PermissionDeniedException {
        User u;
        SecurityManager manager;
        if (passwd.length() == 0) {
            passwd = null;
        }
        if (!(manager = this.factory.getBrokerPool().getSecurityManager()).hasUser(name)) {
            if (!manager.hasAdminPrivileges(this.user)) {
                throw new PermissionDeniedException("not allowed to create user");
            }
            u = new User(name);
            u.setEncodedPassword(passwd);
            u.setPasswordDigest(passwdDigest);
        } else {
            u = manager.getUser(name);
            if (!u.getName().equals(this.user.getName()) && !manager.hasAdminPrivileges(this.user)) {
                throw new PermissionDeniedException("you are not allowed to change this user");
            }
            u.setEncodedPassword(passwd);
            u.setPasswordDigest(passwdDigest);
        }
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            String g = (String)i.next();
            if (u.hasGroup(g)) continue;
            if (!manager.hasAdminPrivileges(this.user)) {
                throw new PermissionDeniedException("User is not allowed to add groups");
            }
            u.addGroup(g);
        }
        if (home != null) {
            try {
                u.setHome(XmldbURI.xmldbUriFor(home));
            }
            catch (URISyntaxException e) {
                throw new EXistException("Invalid home URI", e);
            }
        }
        manager.setUser(u);
        return true;
    }

    public boolean setUser(String name, Vector groups) throws EXistException, PermissionDeniedException {
        User u;
        SecurityManager manager = this.factory.getBrokerPool().getSecurityManager();
        if (!manager.hasUser(name)) {
            if (!manager.hasAdminPrivileges(this.user)) {
                throw new PermissionDeniedException("not allowed to create user");
            }
            u = new User(name);
        } else {
            u = manager.getUser(name);
            if (!u.getName().equals(this.user.getName()) && !manager.hasAdminPrivileges(this.user)) {
                throw new PermissionDeniedException("you are not allowed to change this user");
            }
        }
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            String g = (String)i.next();
            if (u.hasGroup(g)) continue;
            if (!manager.hasAdminPrivileges(this.user)) {
                throw new PermissionDeniedException("User is not allowed to add groups");
            }
            u.addGroup(g);
        }
        manager.setUser(u);
        return true;
    }

    public boolean setUser(String name, Vector groups, String rgroup) throws EXistException, PermissionDeniedException {
        User u;
        SecurityManager manager = this.factory.getBrokerPool().getSecurityManager();
        if (!manager.hasUser(name)) {
            if (!manager.hasAdminPrivileges(this.user)) {
                throw new PermissionDeniedException("not allowed to create user");
            }
            u = new User(name);
        } else {
            u = manager.getUser(name);
            if (!u.getName().equals(this.user.getName()) && !manager.hasAdminPrivileges(this.user)) {
                throw new PermissionDeniedException("you are not allowed to change this user");
            }
        }
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            String g = (String)i.next();
            if (!g.equals(rgroup)) continue;
            if (!manager.hasAdminPrivileges(this.user)) {
                throw new PermissionDeniedException("User is not allowed to remove groups");
            }
            u.remGroup(g);
        }
        manager.setUser(u);
        return true;
    }

    public boolean lockResource(String documentPath, String userName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.lockResource(XmldbURI.xmldbUriFor(documentPath), userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lockResource(XmldbURI docURI, String userName) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        DocumentImpl doc = null;
        TransactionManager transact = this.factory.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            doc = broker.getXMLResource(docURI, 1);
            if (doc == null) {
                throw new EXistException("Resource " + docURI + " not found");
            }
            if (!doc.getPermissions().validate(this.user, 1)) {
                throw new PermissionDeniedException("User is not allowed to lock resource " + docURI);
            }
            SecurityManager manager = this.factory.getBrokerPool().getSecurityManager();
            if (!userName.equals(this.user.getName()) && !manager.hasAdminPrivileges(this.user)) {
                throw new PermissionDeniedException("User " + this.user.getName() + " is not allowed " + "to lock the resource for user " + userName);
            }
            User lockOwner = doc.getUserLock();
            if (lockOwner != null && !lockOwner.equals(this.user) && !manager.hasAdminPrivileges(this.user)) {
                throw new PermissionDeniedException("Resource is already locked by user " + lockOwner.getName());
            }
            doc.setUserLock(this.user);
            broker.storeXMLResource(transaction, doc);
            transact.commit(transaction);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            transact.abort(transaction);
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    public String hasUserLock(String documentPath) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.hasUserLock(XmldbURI.xmldbUriFor(documentPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String hasUserLock(XmldbURI docURI) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        DocumentImpl doc = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            doc = broker.getXMLResource(docURI, 0);
            if (!doc.getPermissions().validate(this.user, 4)) {
                throw new PermissionDeniedException("Insufficient privileges to read resource");
            }
            if (doc == null) {
                throw new EXistException("Resource " + docURI + " not found");
            }
            User u = doc.getUserLock();
            String string = u == null ? "" : u.getName();
            return string;
        }
        catch (Exception e) {
            this.handleException(e);
            String string = null;
            return string;
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    public boolean unlockResource(String documentPath) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.unlockResource(XmldbURI.xmldbUriFor(documentPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unlockResource(XmldbURI docURI) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        DocumentImpl doc = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            doc = broker.getXMLResource(docURI, 1);
            if (doc == null) {
                throw new EXistException("Resource " + docURI + " not found");
            }
            if (!doc.getPermissions().validate(this.user, 1)) {
                throw new PermissionDeniedException("User is not allowed to lock resource " + docURI);
            }
            SecurityManager manager = this.factory.getBrokerPool().getSecurityManager();
            User lockOwner = doc.getUserLock();
            if (lockOwner != null && !lockOwner.equals(this.user) && !manager.hasAdminPrivileges(this.user)) {
                throw new PermissionDeniedException("Resource is already locked by user " + lockOwner.getName());
            }
            TransactionManager transact = this.factory.getBrokerPool().getTransactionManager();
            Txn transaction = transact.beginTransaction();
            doc.setUserLock(null);
            broker.storeXMLResource(transaction, doc);
            transact.commit(transaction);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap summary(String xpath) throws EXistException, PermissionDeniedException {
        long startTime = System.currentTimeMillis();
        DBBroker broker = null;
        try {
            NodeCount counter;
            broker = this.factory.getBrokerPool().get(this.user);
            QueryResult qr = this.doQuery(broker, xpath, null, null);
            if (qr == null) {
                HashMap hashMap = new HashMap();
                return hashMap;
            }
            if (qr.hasErrors()) {
                throw qr.getException();
            }
            NodeList resultSet = (NodeList)((Object)qr.result);
            HashMap<String, NodeCount> map = new HashMap<String, NodeCount>();
            HashMap<String, DoctypeCount> doctypes = new HashMap<String, DoctypeCount>();
            NodeSetIterator i = ((NodeSet)resultSet).iterator();
            while (i.hasNext()) {
                DoctypeCount doctypeCounter;
                NodeProxy p = (NodeProxy)i.next();
                String docName = p.getDocument().getURI().toString();
                DocumentType doctype = p.getDocument().getDoctype();
                if (map.containsKey(docName)) {
                    counter = (NodeCount)map.get(docName);
                    counter.inc();
                } else {
                    counter = new NodeCount(p.getDocument());
                    map.put(docName, counter);
                }
                if (doctype == null) continue;
                if (doctypes.containsKey(doctype.getName())) {
                    doctypeCounter = (DoctypeCount)doctypes.get(doctype.getName());
                    doctypeCounter.inc();
                    continue;
                }
                doctypeCounter = new DoctypeCount(doctype);
                doctypes.put(doctype.getName(), doctypeCounter);
            }
            HashMap<String, Serializable> result = new HashMap<String, Serializable>();
            result.put("queryTime", new Integer((int)(System.currentTimeMillis() - startTime)));
            result.put("hits", new Integer(resultSet.getLength()));
            Vector documents = new Vector();
            Iterator i2 = map.values().iterator();
            while (i2.hasNext()) {
                counter = (NodeCount)i2.next();
                Vector<Object> hitsByDoc = new Vector<Object>();
                hitsByDoc.addElement(counter.doc.getFileURI().toString());
                hitsByDoc.addElement(new Integer(counter.doc.getDocId()));
                hitsByDoc.addElement(new Integer(counter.count));
                documents.addElement(hitsByDoc);
            }
            result.put("documents", documents);
            Vector dtypes = new Vector();
            Iterator i3 = doctypes.values().iterator();
            while (i3.hasNext()) {
                DoctypeCount docTemp = (DoctypeCount)i3.next();
                Vector<Object> hitsByType = new Vector<Object>();
                hitsByType.addElement(docTemp.doctype.getName());
                hitsByType.addElement(new Integer(docTemp.count));
                dtypes.addElement(hitsByType);
            }
            result.put("doctypes", dtypes);
            HashMap<String, Serializable> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            this.handleException(e);
            HashMap hashMap = null;
            return hashMap;
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap summary(int resultId) throws EXistException, XPathException {
        QueryResult qr = this.factory.resultSets.get(resultId);
        if (qr == null) {
            throw new EXistException("result set unknown or timed out");
        }
        qr.timestamp = System.currentTimeMillis();
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("queryTime", new Integer((int)qr.queryTime));
        if (qr.result == null) {
            result.put("hits", new Integer(0));
            return result;
        }
        DBBroker broker = this.factory.getBrokerPool().get(this.user);
        try {
            NodeCount counter;
            NodeSet resultSet = qr.result.toNodeSet();
            HashMap<String, NodeCount> map = new HashMap<String, NodeCount>();
            HashMap<String, DoctypeCount> doctypes = new HashMap<String, DoctypeCount>();
            NodeSetIterator i = resultSet.iterator();
            while (i.hasNext()) {
                DoctypeCount doctypeCounter;
                NodeProxy p = (NodeProxy)i.next();
                String docName = p.getDocument().getURI().toString();
                DocumentType doctype = p.getDocument().getDoctype();
                if (map.containsKey(docName)) {
                    counter = (NodeCount)map.get(docName);
                    counter.inc();
                } else {
                    counter = new NodeCount(p.getDocument());
                    map.put(docName, counter);
                }
                if (doctype == null) continue;
                if (doctypes.containsKey(doctype.getName())) {
                    doctypeCounter = (DoctypeCount)doctypes.get(doctype.getName());
                    doctypeCounter.inc();
                    continue;
                }
                doctypeCounter = new DoctypeCount(doctype);
                doctypes.put(doctype.getName(), doctypeCounter);
            }
            result.put("hits", new Integer(resultSet.getLength()));
            Vector documents = new Vector();
            Iterator i2 = map.values().iterator();
            while (i2.hasNext()) {
                counter = (NodeCount)i2.next();
                Vector<Object> hitsByDoc = new Vector<Object>();
                hitsByDoc.addElement(counter.doc.getFileURI().toString());
                hitsByDoc.addElement(new Integer(counter.doc.getDocId()));
                hitsByDoc.addElement(new Integer(counter.count));
                documents.addElement(hitsByDoc);
            }
            result.put("documents", documents);
            Vector dtypes = new Vector();
            Iterator i3 = doctypes.values().iterator();
            while (i3.hasNext()) {
                DoctypeCount docTemp = (DoctypeCount)i3.next();
                Vector<Object> hitsByType = new Vector<Object>();
                hitsByType.addElement(docTemp.doctype.getName());
                hitsByType.addElement(new Integer(docTemp.count));
                dtypes.addElement(hitsByType);
            }
            result.put("doctypes", dtypes);
            HashMap<String, Serializable> hashMap = result;
            return hashMap;
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
    }

    public Vector getIndexedElements(String collectionName, boolean inclusive) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.getIndexedElements(XmldbURI.xmldbUriFor(collectionName), inclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getIndexedElements(XmldbURI collUri, boolean inclusive) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            collection = broker.openCollection(collUri, 0);
            if (collection == null) {
                throw new EXistException("collection " + collUri + " not found");
            }
            Occurrences[] occurrences = broker.getElementIndex().scanIndexedElements(collection, inclusive);
            Vector result = new Vector(occurrences.length);
            for (int i = 0; i < occurrences.length; ++i) {
                QName qname = (QName)occurrences[i].getTerm();
                Vector<Object> temp = new Vector<Object>(4);
                temp.addElement(qname.getLocalName());
                temp.addElement(qname.getNamespaceURI());
                temp.addElement(qname.getPrefix() == null ? "" : qname.getPrefix());
                temp.addElement(new Integer(occurrences[i].getOccurrences()));
                result.addElement(temp);
            }
            Vector vector = result;
            return vector;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    public Vector scanIndexTerms(String collectionName, String start, String end, boolean inclusive) throws PermissionDeniedException, EXistException, URISyntaxException {
        return this.scanIndexTerms(XmldbURI.xmldbUriFor(collectionName), start, end, inclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector scanIndexTerms(XmldbURI collUri, String start, String end, boolean inclusive) throws PermissionDeniedException, EXistException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            Vector result;
            broker = this.factory.getBrokerPool().get(this.user);
            collection = broker.openCollection(collUri, 0);
            if (collection == null) {
                throw new EXistException("collection " + collUri + " not found");
            }
            DocumentSet docs = new DocumentSet();
            collection.allDocs(broker, docs, inclusive, true);
            NodeSet nodes = docs.toNodeSet();
            Vector vector = result = this.scanIndexTerms(start, end, broker, docs, nodes);
            return vector;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector scanIndexTerms(String xpath, String start, String end) throws PermissionDeniedException, EXistException, XPathException {
        DBBroker broker = null;
        try {
            Vector result;
            broker = this.factory.getBrokerPool().get(this.user);
            XQuery xquery = broker.getXQueryService();
            Sequence nodes = xquery.execute(xpath, null, AccessContext.XMLRPC);
            Vector vector = result = this.scanIndexTerms(start, end, broker, nodes.getDocumentSet(), nodes.toNodeSet());
            return vector;
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
    }

    private Vector scanIndexTerms(String start, String end, DBBroker broker, DocumentSet docs, NodeSet nodes) throws PermissionDeniedException {
        Occurrences[] occurrences = broker.getTextEngine().scanIndexTerms(docs, nodes, start, end);
        Vector result = new Vector(occurrences.length);
        for (int i = 0; i < occurrences.length; ++i) {
            Vector<Object> temp = new Vector<Object>(2);
            temp.addElement(occurrences[i].getTerm().toString());
            temp.addElement(new Integer(occurrences[i].getOccurrences()));
            result.addElement(temp);
        }
        return result;
    }

    public void synchronize() {
    }

    private Properties getProperties(HashMap parameters) {
        Properties properties = new Properties();
        Iterator i = parameters.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            properties.setProperty((String)entry.getKey(), entry.getValue().toString());
        }
        return properties;
    }

    public byte[] getDocumentChunk(String name, int start, int len) throws EXistException, PermissionDeniedException, IOException {
        File file = new File(System.getProperty("java.io.tmpdir") + File.separator + name);
        if (!file.canRead()) {
            throw new EXistException("unable to read file " + name);
        }
        if (file.length() < (long)(start + len)) {
            throw new EXistException("address too big " + name);
        }
        byte[] buffer = new byte[len];
        RandomAccessFile os = new RandomAccessFile(file.getAbsolutePath(), "r");
        LOG.debug((Object)("Read from: " + start + " to: " + (start + len)));
        os.seek(start);
        os.read(buffer);
        os.close();
        return buffer;
    }

    public boolean moveOrCopyResource(String documentPath, String destinationPath, String newName, boolean move) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.moveOrCopyResource(XmldbURI.xmldbUriFor(documentPath), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName), move);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean moveOrCopyResource(XmldbURI docUri, XmldbURI destUri, XmldbURI newName, boolean move) throws EXistException, PermissionDeniedException {
        TransactionManager transact = this.factory.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        Collection collection = null;
        Collection destination = null;
        DocumentImpl doc = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            collection = broker.openCollection(docUri.removeLastSegment(), move ? 1 : 0);
            if (collection == null) {
                transact.abort(transaction);
                throw new EXistException("Collection " + docUri.removeLastSegment() + " not found");
            }
            doc = collection.getDocumentWithLock(broker, docUri.lastSegment(), 1);
            if (doc == null) {
                transact.abort(transaction);
                throw new EXistException("Document " + docUri + " not found");
            }
            destination = broker.openCollection(destUri, 1);
            if (destination == null) {
                transact.abort(transaction);
                throw new EXistException("Destination collection " + destUri + " not found");
            }
            if (move) {
                broker.moveXMLResource(transaction, doc, destination, newName);
            } else {
                broker.copyXMLResource(transaction, doc, destination, newName);
            }
            transact.commit(transaction);
            boolean bl = true;
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            if (collection != null) {
                collection.release(move ? 1 : 0);
            }
            if (destination != null) {
                destination.release(1);
            }
            this.factory.getBrokerPool().release(broker);
            return bl;
        }
        catch (LockException e) {
            try {
                transact.abort(transaction);
                throw new PermissionDeniedException("Could not acquire lock on document " + docUri);
                catch (IOException e2) {
                    transact.abort(transaction);
                    throw new EXistException("Could not acquire lock on document " + docUri);
                }
            }
            catch (Throwable throwable) {
                if (doc != null) {
                    doc.getUpdateLock().release(1);
                }
                if (collection != null) {
                    collection.release(move ? 1 : 0);
                }
                if (destination != null) {
                    destination.release(1);
                }
                this.factory.getBrokerPool().release(broker);
                throw throwable;
            }
        }
    }

    public boolean moveOrCopyCollection(String collectionName, String destinationPath, String newName, boolean move) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.moveOrCopyCollection(XmldbURI.xmldbUriFor(collectionName), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName), move);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean moveOrCopyCollection(XmldbURI collUri, XmldbURI destUri, XmldbURI newName, boolean move) throws EXistException, PermissionDeniedException {
        TransactionManager transact = this.factory.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        Collection collection = null;
        Collection destination = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            collection = broker.openCollection(collUri, move ? 1 : 0);
            if (collection == null) {
                transact.abort(transaction);
                throw new EXistException("Collection " + collUri + " not found");
            }
            destination = broker.openCollection(destUri, 1);
            if (destination == null) {
                transact.abort(transaction);
                throw new EXistException("Destination collection " + destUri + " not found");
            }
            if (move) {
                broker.moveCollection(transaction, collection, destination, newName);
            } else {
                broker.copyCollection(transaction, collection, destination, newName);
            }
            transact.commit(transaction);
            boolean bl = true;
            if (collection != null) {
                collection.release(move ? 1 : 0);
            }
            if (destination != null) {
                destination.release(1);
            }
            this.factory.getBrokerPool().release(broker);
            return bl;
        }
        catch (LockException e) {
            try {
                transact.abort(transaction);
                throw new PermissionDeniedException(e.getMessage());
                catch (IOException e2) {
                    transact.abort(transaction);
                    throw new EXistException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                if (collection != null) {
                    collection.release(move ? 1 : 0);
                }
                if (destination != null) {
                    destination.release(1);
                }
                this.factory.getBrokerPool().release(broker);
                throw throwable;
            }
        }
    }

    public boolean reindexCollection(String collectionName) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.reindexCollection(XmldbURI.xmldbUriFor(collectionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reindexCollection(XmldbURI collUri) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            broker.reindexCollection(collUri);
            LOG.debug((Object)("collection " + collUri + " and sub collection reindexed"));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.factory.getBrokerPool().release(broker);
        }
        return true;
    }

    public boolean backup(String userbackup, String password, String destcollection, String collection) throws EXistException, PermissionDeniedException {
        try {
            Backup backup = new Backup(userbackup, password, destcollection + "-backup", XmldbURI.xmldbUriFor(XmldbURI.EMBEDDED_SERVER_URI.toString() + collection));
            backup.backup(false, null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return true;
    }

    public boolean isValid(String documentPath) throws PermissionDeniedException, URISyntaxException, EXistException {
        return this.isValid(XmldbURI.xmldbUriFor(documentPath));
    }

    private boolean isValid(XmldbURI docUri) throws EXistException, PermissionDeniedException {
        boolean retVal = false;
        try {
            Validator validator = new Validator(this.factory.getBrokerPool());
            EmbeddedInputStream is = new EmbeddedInputStream(new XmldbURL(docUri));
            ValidationReport veh = validator.validate(is);
            retVal = veh.isValid();
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
        return retVal;
    }

    public Vector getDocType(String documentPath) throws PermissionDeniedException, EXistException, URISyntaxException {
        return this.getDocType(XmldbURI.xmldbUriFor(documentPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getDocType(XmldbURI docUri) throws PermissionDeniedException, EXistException {
        DBBroker broker = null;
        DocumentImpl doc = null;
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            doc = broker.getXMLResource(docUri, 0);
            if (doc == null) {
                LOG.debug((Object)("document " + docUri + " not found!"));
                throw new EXistException("document not found");
            }
            Vector<String> vector = new Vector<String>(3);
            if (doc.getDoctype() != null) {
                vector.addElement(doc.getDoctype().getName());
                if (doc.getDoctype().getPublicId() != null) {
                    vector.addElement(doc.getDoctype().getPublicId());
                } else {
                    vector.addElement("");
                }
                if (doc.getDoctype().getSystemId() != null) {
                    vector.addElement(doc.getDoctype().getSystemId());
                } else {
                    vector.addElement("");
                }
            } else {
                vector.addElement("");
                vector.addElement("");
                vector.addElement("");
            }
            Vector<String> vector2 = vector;
            return vector2;
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    public boolean setDocType(String documentPath, String doctypename, String publicid, String systemid) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.setDocType(XmldbURI.xmldbUriFor(documentPath), doctypename, publicid, systemid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setDocType(XmldbURI docUri, String doctypename, String publicid, String systemid) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        DocumentImpl doc = null;
        DocumentTypeImpl result = null;
        TransactionManager transact = this.factory.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            broker = this.factory.getBrokerPool().get(this.user);
            doc = broker.getXMLResource(docUri, 1);
            if (doc == null) {
                transact.abort(transaction);
                throw new EXistException("Resource " + docUri + " not found");
            }
            if (!doc.getPermissions().validate(this.user, 1)) {
                transact.abort(transaction);
                throw new PermissionDeniedException("User is not allowed to lock resource " + docUri);
            }
            if (!"".equals(doctypename)) {
                result = new DocumentTypeImpl(doctypename, "".equals(publicid) ? null : publicid, "".equals(systemid) ? null : systemid);
            }
            doc.setDocumentType(result);
            broker.storeXMLResource(transaction, doc);
            transact.commit(transaction);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            transact.abort(transaction);
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            this.factory.getBrokerPool().release(broker);
        }
    }

    public boolean copyResource(String docPath, String destinationPath, String newName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.moveOrCopyResource(docPath, destinationPath, newName, false);
    }

    public boolean copyCollection(String collectionPath, String destinationPath, String newName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.moveOrCopyCollection(collectionPath, destinationPath, newName, false);
    }

    public boolean moveResource(String docPath, String destinationPath, String newName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.moveOrCopyResource(docPath, destinationPath, newName, true);
    }

    public boolean moveCollection(String collectionPath, String destinationPath, String newName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.moveOrCopyCollection(collectionPath, destinationPath, newName, true);
    }

    public List getDocumentChunk(String name, HashMap parameters) throws EXistException, PermissionDeniedException, IOException {
        ArrayList<String> result = new ArrayList<String>(2);
        File file = File.createTempFile("rpc", ".xml");
        FileOutputStream os = new FileOutputStream(file.getAbsolutePath(), true);
        os.write(this.getDocument(name, parameters));
        os.close();
        result.add(file.getName());
        result.add(Long.toString(file.length()));
        file.deleteOnExit();
        return result;
    }

    public boolean copyCollection(String name, String namedest) throws PermissionDeniedException, EXistException {
        try {
            String nome;
            this.createCollection(namedest);
            HashMap<String, String> parametri = new HashMap<String, String>();
            parametri.put("indent", "no");
            parametri.put("expand-xincludes", "no");
            parametri.put("encoding", "UTF-8");
            HashMap lista = this.getCollectionDesc(name);
            Object[] collezioni = (Object[])lista.get("collections");
            Object[] documents = (Object[])lista.get("documents");
            for (int i = 0; i < collezioni.length; ++i) {
                nome = collezioni[i].toString();
                this.createCollection(namedest + "/" + nome);
                this.copyCollection(name + "/" + nome, namedest + "/" + nome);
            }
            int dsize = documents.length;
            for (int i = 0; i < dsize; ++i) {
                HashMap hash = (HashMap)documents[i];
                nome = (String)hash.get("name");
                int p = nome.lastIndexOf("/");
                if (p != -1) {
                    nome = nome.substring(p + 1);
                }
                byte[] xml = this.getDocument(name + "/" + nome, parametri);
                this.parse(xml, namedest + "/" + nome);
            }
            return true;
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
    }

    public int xupdateResource(String resource, byte[] xupdate) throws PermissionDeniedException, EXistException, SAXException {
        return this.xupdateResource(resource, xupdate, "UTF-8");
    }

    public boolean setPermissions(String resource, int permissions) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.setPermissions(resource, null, null, permissions);
    }

    public boolean setPermissions(String resource, String permissions) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.setPermissions(resource, null, null, permissions);
    }

    public boolean setUser(String name, String passwd, String digestPassword, Vector groups) throws EXistException, PermissionDeniedException {
        return this.setUser(name, passwd, digestPassword, groups, null);
    }

    public HashMap querySummary(int resultId) throws EXistException, PermissionDeniedException, XPathException {
        return this.summary(resultId);
    }

    public int executeQuery(byte[] xpath, HashMap parameters) throws EXistException, PermissionDeniedException {
        return this.executeQuery(xpath, null, parameters);
    }

    public boolean storeBinary(byte[] data, String docName, String mimeType, boolean replace, Date created, Date modified) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.storeBinary(data, docName, mimeType, replace ? 1 : 0, created, modified);
    }

    public boolean storeBinary(byte[] data, String docName, String mimeType, boolean replace) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.storeBinary(data, docName, mimeType, replace ? 1 : 0, null, null);
    }

    public boolean parseLocal(String localFile, String docName, boolean replace, String mimeType, Date created, Date modified) throws EXistException, PermissionDeniedException, SAXException, URISyntaxException {
        return this.parseLocal(localFile, docName, replace ? 1 : 0, mimeType, created, modified);
    }

    public boolean parseLocal(String localFile, String docName, boolean replace, String mimeType) throws EXistException, PermissionDeniedException, SAXException, URISyntaxException {
        return this.parseLocal(localFile, docName, replace ? 1 : 0, mimeType, null, null);
    }

    public String uploadCompressed(String file, byte[] data, int length) throws EXistException, PermissionDeniedException, IOException {
        return this.upload(data, length, file, true);
    }

    public String uploadCompressed(byte[] data, int length) throws EXistException, PermissionDeniedException, IOException {
        return this.upload(data, length, null, true);
    }

    public String upload(String file, byte[] chunk, int length) throws EXistException, PermissionDeniedException, IOException {
        return this.upload(chunk, length, file, false);
    }

    public String upload(byte[] chunk, int length) throws EXistException, PermissionDeniedException, IOException {
        return this.upload(chunk, length, null, false);
    }

    public boolean parse(String xml, String docName) throws EXistException, PermissionDeniedException, URISyntaxException {
        try {
            return this.parse(xml.getBytes("UTF-8"), docName, 0);
        }
        catch (UnsupportedEncodingException e) {
            this.handleException(e);
            return false;
        }
    }

    public boolean parse(String xml, String docName, int overwrite) throws EXistException, PermissionDeniedException, URISyntaxException {
        try {
            return this.parse(xml.getBytes("UTF-8"), docName, overwrite);
        }
        catch (UnsupportedEncodingException e) {
            this.handleException(e);
            return false;
        }
    }

    public boolean parse(byte[] xmlData, String docName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.parse(xmlData, docName, 0);
    }

    public HashMap querySummary(String xquery) throws EXistException, PermissionDeniedException {
        return this.summary(xquery);
    }

    public byte[] query(byte[] xquery, int howmany, int start, HashMap parameters) throws EXistException, PermissionDeniedException {
        try {
            String result = this.query(new String(xquery, "UTF-8"), howmany, start, parameters);
            return result.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.handleException(e);
            return null;
        }
    }

    public HashMap queryP(byte[] xpath, String docName, String s_id, HashMap parameters) throws EXistException, PermissionDeniedException, URISyntaxException {
        try {
            return this.queryP(new String(xpath, "UTF-8"), docName, s_id, parameters);
        }
        catch (UnsupportedEncodingException e) {
            this.handleException(e);
            return null;
        }
    }

    public HashMap queryP(byte[] xpath, HashMap parameters) throws EXistException, PermissionDeniedException {
        try {
            return this.queryP(new String(xpath, "UTF-8"), (XmldbURI)null, null, parameters);
        }
        catch (UnsupportedEncodingException e) {
            this.handleException(e);
            return null;
        }
    }

    public HashMap compile(byte[] xquery, HashMap parameters) throws EXistException, PermissionDeniedException {
        try {
            return this.compile(new String(xquery, "UTF-8"), parameters);
        }
        catch (UnsupportedEncodingException e) {
            this.handleException(e);
            return null;
        }
    }

    public byte[] retrieve(String doc, String id) throws EXistException, PermissionDeniedException {
        return this.retrieve(doc, id, null);
    }

    public String getDocumentAsString(String name, int prettyPrint, String stylesheet) throws EXistException, PermissionDeniedException {
        HashMap<String, String> parametri = new HashMap<String, String>();
        if (prettyPrint > 0) {
            parametri.put("indent", "yes");
        } else {
            parametri.put("indent", "no");
        }
        if (stylesheet != null) {
            parametri.put("stylesheet", stylesheet);
        }
        return this.getDocumentAsString(name, parametri);
    }

    public String getDocumentAsString(String name, int prettyPrint) throws EXistException, PermissionDeniedException {
        return this.getDocumentAsString(name, prettyPrint, null);
    }

    public byte[] getDocument(String name, String encoding, int prettyPrint, String stylesheet) throws EXistException, PermissionDeniedException {
        HashMap<String, String> parametri = new HashMap<String, String>();
        if (prettyPrint > 0) {
            parametri.put("indent", "yes");
        } else {
            parametri.put("indent", "no");
        }
        if (stylesheet != null) {
            parametri.put("stylesheet", stylesheet);
        }
        parametri.put("encoding", encoding);
        byte[] xml = this.getDocument(name, parametri);
        if (xml == null) {
            throw new EXistException("document " + name + " not found!");
        }
        return xml;
    }

    public byte[] getDocument(String name, String encoding, int prettyPrint) throws EXistException, PermissionDeniedException {
        return this.getDocument(name, encoding, prettyPrint, null);
    }

    public boolean shutdown() throws PermissionDeniedException {
        return this.shutdown(0L);
    }

    public boolean shutdown(long delay) throws PermissionDeniedException {
        if (!this.user.hasDbaRole()) {
            throw new PermissionDeniedException("not allowed to shut downthe database");
        }
        if (delay > 0L) {
            TimerTask task = new TimerTask(){

                public void run() {
                    try {
                        BrokerPool.stop();
                    }
                    catch (EXistException e) {
                        LOG.warn((Object)"shutdown failed", (Throwable)e);
                    }
                }
            };
            Timer timer = new Timer();
            timer.schedule(task, delay);
        } else {
            try {
                BrokerPool.stop();
            }
            catch (EXistException e) {
                LOG.warn((Object)"shutdown failed", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public boolean enterServiceMode() throws PermissionDeniedException, EXistException {
        BrokerPool brokerPool = this.factory.getBrokerPool();
        brokerPool.enterServiceMode(this.user);
        return true;
    }

    public void exitServiceMode() throws PermissionDeniedException, EXistException {
        BrokerPool brokerPool = this.factory.getBrokerPool();
        brokerPool.exitServiceMode(this.user);
    }

    class NodeCount {
        int count = 1;
        DocumentImpl doc;

        public NodeCount(DocumentImpl doc) {
            this.doc = doc;
        }

        public void inc() {
            ++this.count;
        }
    }

    class DoctypeCount {
        int count = 1;
        DocumentType doctype;

        public DoctypeCount(DocumentType doctype) {
            this.doctype = doctype;
        }

        public void inc() {
            ++this.count;
        }
    }

    class CachedQuery {
        PathExpr expression;
        String queryString;
        long timestamp;

        public CachedQuery(PathExpr expr, String query) {
            this.expression = expr;
            this.queryString = query;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

