/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmlrpc;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.server.AbstractReflectiveHandlerMapping;
import org.apache.xmlrpc.server.RequestProcessorFactoryFactory;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcNoSuchHandlerException;
import org.apache.xmlrpc.webserver.XmlRpcServlet;
import org.exist.EXistException;
import org.exist.http.Descriptor;
import org.exist.http.servlets.HttpServletRequestWrapper;
import org.exist.xmlrpc.RpcConnection;
import org.exist.xmlrpc.XmldbRequestProcessorFactory;

public class RpcServlet
extends XmlRpcServlet {
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Descriptor descriptor = Descriptor.getDescriptorSingleton();
        if (descriptor.allowRequestLogging()) {
            request = new HttpServletRequestWrapper(request, "utf-8");
            descriptor.doLogRequestInReplayLog(request);
        }
        super.doPost(request, response);
    }

    protected XmlRpcHandlerMapping newXmlRpcHandlerMapping() throws XmlRpcException {
        DefaultHandlerMapping mapping = new DefaultHandlerMapping();
        mapping.setVoidMethodEnabled(true);
        mapping.setRequestProcessorFactoryFactory((RequestProcessorFactoryFactory)new XmldbRequestProcessorFactoryFactory());
        mapping.loadDefault(RpcConnection.class);
        return mapping;
    }

    private static class DefaultHandlerMapping
    extends AbstractReflectiveHandlerMapping {
        private DefaultHandlerMapping() throws XmlRpcException {
        }

        public void loadDefault(Class clazz) throws XmlRpcException {
            this.registerPublicMethods("Default", clazz);
        }

        public XmlRpcHandler getHandler(String pHandlerName) throws XmlRpcNoSuchHandlerException, XmlRpcException {
            if (pHandlerName.indexOf(46) < 0) {
                pHandlerName = "Default." + pHandlerName;
            }
            return super.getHandler(pHandlerName);
        }
    }

    private static class XmldbRequestProcessorFactoryFactory
    extends RequestProcessorFactoryFactory.RequestSpecificProcessorFactoryFactory {
        RequestProcessorFactoryFactory.RequestProcessorFactory instance = null;

        private XmldbRequestProcessorFactoryFactory() {
        }

        public RequestProcessorFactoryFactory.RequestProcessorFactory getRequestProcessorFactory(Class pClass) throws XmlRpcException {
            try {
                if (this.instance == null) {
                    this.instance = new XmldbRequestProcessorFactory("exist");
                }
                return this.instance;
            }
            catch (EXistException e) {
                throw new XmlRpcException("Failed to initialize XMLRPC interface: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

