/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.memtree.MemTreeBuilder;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;

public class DynamicTextConstructor
extends NodeConstructor {
    private final Expression content;

    public DynamicTextConstructor(XQueryContext context, Expression contentExpr) {
        super(context);
        this.content = new Atomize(context, contentExpr);
    }

    public Expression getContent() {
        return this.content;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        contextInfo.setParent(this);
        this.content.analyze(contextInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.newDocumentContext) {
            this.context.pushDocumentContext();
        }
        try {
            Sequence contentSeq = this.content.eval(contextSequence, contextItem);
            if (contentSeq.isEmpty()) {
                result = Sequence.EMPTY_SEQUENCE;
            } else {
                MemTreeBuilder builder = this.context.getDocumentBuilder();
                builder.startDocument();
                this.context.proceed(this, builder);
                StringBuffer buf = new StringBuffer();
                SequenceIterator i = contentSeq.iterate();
                while (i.hasNext()) {
                    this.context.proceed(this, builder);
                    Item next = i.nextItem();
                    if (buf.length() > 0) {
                        buf.append(' ');
                    }
                    buf.append(next.toString());
                }
                if (buf.length() == 0) {
                    result = Sequence.EMPTY_SEQUENCE;
                } else {
                    int nodeNr = builder.characters(buf);
                    result = builder.getDocument().getNode(nodeNr);
                }
            }
        }
        finally {
            if (this.newDocumentContext) {
                this.context.popDocumentContext();
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("text {");
        dumper.startIndent();
        this.content.dump(dumper);
        dumper.endIndent();
        dumper.nl().display("}");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("text {");
        result.append(this.content.toString());
        result.append("}");
        return result.toString();
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.content.resetState(postOptimization);
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visitTextConstructor(this);
    }
}

