/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.DocumentSet;
import org.exist.dom.NodeProxy;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;

public class DynamicTypeCheck
extends AbstractExpression {
    private final Expression expression;
    private final int requiredType;

    public DynamicTypeCheck(XQueryContext context, int requiredType, Expression expr) {
        super(context);
        this.requiredType = requiredType;
        this.expression = expr;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq = this.expression.eval(contextSequence, contextItem);
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            int type = item.getType();
            if (type == -1 && ((NodeValue)item).getImplementationType() == 1 && (type = (int)((NodeProxy)item).getNodeType()) == -1) {
                type = ((NodeProxy)item).getNode().getNodeType();
            }
            if (type == this.requiredType || Type.subTypeOf(type, this.requiredType)) continue;
            if (type == 21) {
                try {
                    item = item.convertTo(this.requiredType);
                    continue;
                }
                catch (XPathException e) {
                    throw new XPathException(this.expression.getASTNode(), "FOCH0002: Required type is " + Type.getTypeName(this.requiredType) + " but got '" + Type.getTypeName(item.getType()) + "(" + item.getStringValue() + ")'");
                }
            }
            if (Type.subTypeOf(this.requiredType, 30) && Type.subTypeOf(type, this.requiredType)) {
                try {
                    item = item.convertTo(this.requiredType);
                    continue;
                }
                catch (XPathException e) {
                    throw new XPathException(this.expression.getASTNode(), "FOCH0002: Required type is " + Type.getTypeName(this.requiredType) + " but got '" + Type.getTypeName(item.getType()) + "(" + item.getStringValue() + ")'");
                }
            }
            if (Type.subTypeOf(this.requiredType, 53)) {
                try {
                    item = item.convertTo(this.requiredType);
                    continue;
                }
                catch (XPathException e) {
                    throw new XPathException(this.expression.getASTNode(), "FOCH0002: Required type is " + Type.getTypeName(this.requiredType) + " but got '" + Type.getTypeName(item.getType()) + "(" + item.getStringValue() + ")'");
                }
            }
            if (Type.subTypeOf(this.requiredType, 51)) {
                try {
                    item = item.convertTo(this.requiredType);
                    continue;
                }
                catch (XPathException e) {
                    throw new XPathException(this.expression.getASTNode(), "FOCH0002: Required type is " + Type.getTypeName(this.requiredType) + " but got '" + Type.getTypeName(item.getType()) + "(" + item.getStringValue() + ")'");
                }
            }
            if (type == 25 && this.requiredType == 22) {
                item = item.convertTo(22);
                type = 22;
                continue;
            }
            if (!Type.subTypeOf(type, this.requiredType)) {
                throw new XPathException(this.expression.getASTNode(), "FORG0001: " + Type.getTypeName(item.getType()) + "(" + item.getStringValue() + ") is not a sub-type of " + Type.getTypeName(this.requiredType));
            }
            throw new XPathException(this.expression.getASTNode(), "FOCH0002: Required type is " + Type.getTypeName(this.requiredType) + " but got '" + Type.getTypeName(item.getType()) + "(" + item.getStringValue() + ")'");
        }
        return seq;
    }

    public void dump(ExpressionDumper dumper) {
        if (dumper.verbosity() > 1) {
            dumper.display("dynamic-type-check");
            dumper.display("[");
            dumper.display(Type.getTypeName(this.requiredType));
            dumper.display(", ");
        }
        this.expression.dump(dumper);
        if (dumper.verbosity() > 1) {
            dumper.display("]");
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("dynamic-type-check");
        result.append("[");
        result.append(Type.getTypeName(this.requiredType));
        result.append(", ");
        result.append(this.expression.toString());
        result.append("]");
        return result.toString();
    }

    public int returnsType() {
        return this.requiredType;
    }

    public int getDependencies() {
        return this.expression.getDependencies();
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.expression.resetState(postOptimization);
    }

    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.expression.setContextDocSet(contextSet);
    }

    public XQueryAST getASTNode() {
        return this.expression.getASTNode();
    }

    public void accept(ExpressionVisitor visitor) {
        this.expression.accept(visitor);
    }
}

