/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.exist.dom.QName;
import org.exist.source.Source;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.FunctionId;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.Variable;
import org.exist.xquery.VariableDeclaration;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;

public class ExternalModuleImpl
implements ExternalModule {
    private final String mNamespaceURI;
    private final String mPrefix;
    private final TreeMap mFunctionMap = new TreeMap();
    private final TreeMap mGlobalVariables = new TreeMap();
    private final TreeMap mStaticVariables = new TreeMap();
    private Source mSource = null;
    private XQueryContext mContext = null;

    public ExternalModuleImpl(String namespaceURI, String prefix) {
        this.mNamespaceURI = namespaceURI;
        this.mPrefix = prefix;
    }

    public String getDescription() {
        return "User defined module";
    }

    public UserDefinedFunction getFunction(QName qname, int arity) {
        FunctionId id = new FunctionId(qname, arity);
        return (UserDefinedFunction)this.mFunctionMap.get(id);
    }

    public void declareFunction(UserDefinedFunction func) {
        this.mFunctionMap.put(func.getSignature().getFunctionId(), func);
    }

    public String getNamespaceURI() {
        return this.mNamespaceURI;
    }

    public String getDefaultPrefix() {
        return this.mPrefix;
    }

    public boolean isInternalModule() {
        return false;
    }

    public FunctionSignature[] listFunctions() {
        FunctionSignature[] signatures = new FunctionSignature[this.mFunctionMap.size()];
        int j = 0;
        Iterator i = this.mFunctionMap.values().iterator();
        while (i.hasNext()) {
            signatures[j] = ((UserDefinedFunction)i.next()).getSignature();
            ++j;
        }
        return signatures;
    }

    public Iterator getSignaturesForFunction(QName qname) {
        ArrayList<FunctionSignature> signatures = new ArrayList<FunctionSignature>(2);
        Iterator i = this.mFunctionMap.values().iterator();
        while (i.hasNext()) {
            UserDefinedFunction func = (UserDefinedFunction)i.next();
            if (func.getName().compareTo(qname) != 0) continue;
            signatures.add(func.getSignature());
        }
        return signatures.iterator();
    }

    public Variable declareVariable(QName qname, Object value) throws XPathException {
        Sequence val = XPathUtil.javaObjectToXPath(value, this.mContext);
        Variable var = (Variable)this.mStaticVariables.get(qname);
        if (var == null) {
            var = new Variable(qname);
            this.mStaticVariables.put(qname, var);
        }
        var.setValue(val);
        return var;
    }

    public Variable declareVariable(Variable var) {
        this.mStaticVariables.put(var.getQName(), var);
        return var;
    }

    public void declareVariable(QName qname, VariableDeclaration decl) throws XPathException {
        if (!qname.getNamespaceURI().equals(this.getNamespaceURI())) {
            throw new XPathException(decl.getASTNode(), "err:XQST0048: It is a static error if a function or variable declared in a library module is not in the target namespace of the library module.");
        }
        this.mGlobalVariables.put(qname, decl);
    }

    public boolean isVarDeclared(QName qname) {
        if (this.mGlobalVariables.get(qname) != null) {
            return true;
        }
        return this.mStaticVariables.get(qname) != null;
    }

    public Variable resolveVariable(QName qname) throws XPathException {
        VariableDeclaration decl = (VariableDeclaration)this.mGlobalVariables.get(qname);
        if (decl != null && !this.mStaticVariables.containsKey(qname)) {
            decl.eval(null);
        }
        return (Variable)this.mStaticVariables.get(qname);
    }

    public Source getSource() {
        return this.mSource;
    }

    public void setSource(Source source) {
        this.mSource = source;
    }

    public void setContext(XQueryContext context) {
        this.mContext = context;
    }

    public boolean moduleIsValid() {
        if (this.mSource.isValid(this.mContext.getBroker()) != 1) {
            return false;
        }
        return this.mContext.checkModulesValid();
    }

    public void reset(XQueryContext xqueryContext) {
        this.mContext.reset();
        this.mStaticVariables.clear();
    }
}

