/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.QName;
import org.exist.xquery.FunctionId;
import org.exist.xquery.value.SequenceType;

public class FunctionSignature {
    public static final SequenceType DEFAULT_TYPE = new SequenceType(11, 7);
    public static final SequenceType[] NO_ARGS = new SequenceType[0];
    private final QName name;
    private SequenceType[] arguments;
    private SequenceType returnType;
    private boolean isOverloaded = false;
    private String description = null;
    private String deprecated = null;

    public static final SequenceType[] singleArgument(SequenceType arg) {
        return new SequenceType[]{arg};
    }

    public FunctionSignature(QName name) {
        this(name, null, DEFAULT_TYPE, false);
    }

    public FunctionSignature(QName name, SequenceType[] arguments, SequenceType returnType) {
        this(name, null, arguments, returnType);
    }

    public FunctionSignature(QName name, SequenceType[] arguments, SequenceType returnType, boolean overloaded) {
        this(name, null, arguments, returnType, overloaded);
    }

    public FunctionSignature(QName name, String description, SequenceType[] arguments, SequenceType returnType) {
        this(name, description, arguments, returnType, false);
    }

    public FunctionSignature(QName name, String description, SequenceType[] arguments, SequenceType returnType, String deprecated) {
        this(name, description, arguments, returnType, false);
        this.setDeprecated(deprecated);
    }

    public FunctionSignature(QName name, String description, SequenceType[] arguments, SequenceType returnType, boolean overloaded, String deprecated) {
        this(name, description, arguments, returnType, overloaded);
        this.setDeprecated(deprecated);
    }

    public FunctionSignature(QName name, String description, SequenceType[] arguments, SequenceType returnType, boolean overloaded) {
        this.name = name;
        this.arguments = arguments;
        this.returnType = returnType;
        this.isOverloaded = overloaded;
        this.description = description;
    }

    public QName getName() {
        return this.name;
    }

    public int getArgumentCount() {
        if (this.isOverloaded) {
            return -1;
        }
        return this.arguments != null ? this.arguments.length : 0;
    }

    public FunctionId getFunctionId() {
        return new FunctionId(this.name, this.getArgumentCount());
    }

    public SequenceType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(SequenceType type) {
        this.returnType = type;
    }

    public SequenceType[] getArgumentTypes() {
        return this.arguments;
    }

    public void setArgumentTypes(SequenceType[] types) {
        this.arguments = types;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isOverloaded() {
        return this.isOverloaded;
    }

    public boolean isDeprecated() {
        return this.deprecated != null;
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(String message) {
        this.deprecated = message;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.name.toString());
        buf.append('(');
        if (this.arguments != null) {
            int var = 97;
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append('$');
                buf.append((char)(var + i));
                buf.append(" as ");
                buf.append(this.arguments[i].toString());
            }
            if (this.isOverloaded) {
                buf.append(", ...");
            }
        }
        buf.append(") ");
        buf.append(this.returnType.toString());
        return buf.toString();
    }

    public boolean equals(Object obj) {
        FunctionSignature other = (FunctionSignature)obj;
        if (this.name.equalsSimple(other.name)) {
            return this.getArgumentCount() == other.getArgumentCount();
        }
        return false;
    }
}

