/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.text.Collator;
import java.util.Iterator;
import java.util.List;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.ContextItem;
import org.exist.dom.DocumentSet;
import org.exist.dom.NewArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetIterator;
import org.exist.dom.QName;
import org.exist.dom.VirtualNodeSet;
import org.exist.storage.IndexSpec;
import org.exist.storage.Indexable;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BasicExpressionVisitor;
import org.exist.xquery.BinaryOp;
import org.exist.xquery.CachedResult;
import org.exist.xquery.Cardinality;
import org.exist.xquery.CastExpression;
import org.exist.xquery.Constants;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.IndexUseReporter;
import org.exist.xquery.LocationStep;
import org.exist.xquery.NodeTest;
import org.exist.xquery.Optimizable;
import org.exist.xquery.Optimize;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;

public class GeneralComparison
extends BinaryOp
implements Optimizable,
IndexUseReporter {
    protected int relation = 4;
    protected int truncation = -1;
    protected CachedResult cached = null;
    protected Expression collationArg = null;
    protected boolean inWhereClause = false;
    protected boolean invalidNodeEvaluation = false;
    protected int rightOpDeps;
    private boolean hasUsedIndex = false;
    private int actualReturnType = 11;
    private LocationStep contextStep = null;
    private QName contextQName = null;
    protected boolean optimizeSelf = false;
    private int axis = -1;
    private NodeSet preselectResult = null;
    private IndexFlags idxflags = new IndexFlags();

    public GeneralComparison(XQueryContext context, int relation) {
        this(context, relation, -1);
    }

    public GeneralComparison(XQueryContext context, int relation, int truncation) {
        super(context);
        this.relation = relation;
    }

    public GeneralComparison(XQueryContext context, Expression left, Expression right, int relation) {
        this(context, left, right, relation, -1);
    }

    public GeneralComparison(XQueryContext context, Expression left, Expression right, int relation, int truncation) {
        super(context);
        boolean didLeftSimplification = false;
        boolean didRightSimplification = false;
        this.relation = relation;
        this.truncation = truncation;
        if (left instanceof PathExpr && ((PathExpr)left).getLength() == 1) {
            left = ((PathExpr)left).getExpression(0);
            didLeftSimplification = true;
        }
        this.add(left);
        if (right instanceof PathExpr && ((PathExpr)right).getLength() == 1) {
            right = ((PathExpr)right).getExpression(0);
            didRightSimplification = true;
        }
        this.add(right);
        if (didLeftSimplification) {
            context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Marked left argument as a child expression");
        }
        if (didRightSimplification) {
            context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Marked right argument as a child expression");
        }
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.addFlag(16);
        contextInfo.setParent(this);
        super.analyze(contextInfo);
        this.inWhereClause = (contextInfo.getFlags() & 4) != 0;
        this.invalidNodeEvaluation = false;
        if (!Type.subTypeOf(contextInfo.getStaticType(), -1)) {
            this.invalidNodeEvaluation = this.getLeft() instanceof LocationStep && ((LocationStep)this.getLeft()).axis == 12;
        }
        this.rightOpDeps = this.getRight().getDependencies();
        this.getRight().accept(new BasicExpressionVisitor(){

            public void visitCastExpr(CastExpression expression) {
                if (PathExpr.LOG.isTraceEnabled()) {
                    PathExpr.LOG.debug((Object)"Right operand is a cast expression");
                }
                GeneralComparison.this.rightOpDeps = expression.getInnerExpression().getDependencies();
            }
        });
        if (contextInfo.getContextStep() != null && contextInfo.getContextStep() instanceof LocationStep) {
            ((LocationStep)contextInfo.getContextStep()).setUseDirectAttrSelect(false);
        }
        contextInfo.removeFlag(16);
        List steps = BasicExpressionVisitor.findLocationSteps(this.getLeft());
        if (!steps.isEmpty()) {
            LocationStep firstStep = (LocationStep)steps.get(0);
            LocationStep lastStep = (LocationStep)steps.get(steps.size() - 1);
            if (steps.size() == 1 && firstStep.getAxis() == 12) {
                LocationStep outerStep;
                NodeTest test;
                Expression outerExpr = contextInfo.getContextStep();
                if (outerExpr != null && outerExpr instanceof LocationStep && !(test = (outerStep = (LocationStep)outerExpr).getTest()).isWildcardTest() && test.getName() != null) {
                    this.contextQName = new QName(test.getName());
                    if (outerStep.getAxis() == 6 || outerStep.getAxis() == 13) {
                        this.contextQName.setNameType((byte)1);
                    }
                    this.contextStep = firstStep;
                    this.axis = outerStep.getAxis();
                    this.optimizeSelf = true;
                }
            } else {
                NodeTest test = lastStep.getTest();
                if (!test.isWildcardTest() && test.getName() != null) {
                    this.contextQName = new QName(test.getName());
                    if (lastStep.getAxis() == 6 || lastStep.getAxis() == 13) {
                        this.contextQName.setNameType((byte)1);
                    }
                    this.contextStep = lastStep;
                    this.axis = firstStep.getAxis();
                    if (this.axis == 12 && steps.size() > 1) {
                        this.axis = ((LocationStep)steps.get(1)).getAxis();
                    }
                }
            }
        }
    }

    public boolean canOptimize(Sequence contextSequence) {
        if (this.contextQName == null) {
            return false;
        }
        return Optimize.getQNameIndexType(this.context, contextSequence, this.contextQName) != 11;
    }

    public boolean optimizeOnSelf() {
        return this.optimizeSelf;
    }

    public int getOptimizeAxis() {
        return this.axis;
    }

    public int returnsType() {
        if (this.inPredicate && !Dependency.dependsOn(this, 2)) {
            return this.getLeft().returnsType();
        }
        return 23;
    }

    public int getDependencies() {
        if (!(!Type.subTypeOf(this.getLeft().returnsType(), -1) || Dependency.dependsOn(this.getLeft(), 2) || this.inWhereClause && Dependency.dependsOn(this.getLeft(), 8))) {
            return 1;
        }
        return 3;
    }

    public int getRelation() {
        return this.relation;
    }

    public NodeSet preSelect(Sequence contextSequence, boolean useContext) throws XPathException {
        this.preselectResult = null;
        int indexType = Optimize.getQNameIndexType(this.context, contextSequence, this.contextQName);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Using QName index on type " + Type.getTypeName(indexType)));
        }
        Sequence rightSeq = this.getRight().eval(contextSequence);
        SequenceIterator itRightSeq = rightSeq.iterate();
        while (itRightSeq.hasNext()) {
            NodeSet temp;
            NodeSet contextSet;
            AtomicValue key = itRightSeq.nextItem().atomize();
            if (this.truncation != -1) {
                if (!Type.subTypeOf(key.getType(), 22)) {
                    LOG.info((Object)("Truncated key. Converted from " + Type.getTypeName(key.getType()) + " to xs:string"));
                    key = key.convertTo(22);
                }
            } else if (key.getType() != indexType) {
                try {
                    key = key.convertTo(indexType);
                }
                catch (XPathException xpe) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Cannot convert key: " + Type.getTypeName(key.getType()) + " to required index type: " + Type.getTypeName(indexType)));
                    }
                    throw new XPathException(this.getASTNode(), "Cannot convert key to required index type");
                }
            }
            if (!(key instanceof Indexable)) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Using QName range index for key: " + key.getStringValue()));
            }
            NodeSet nodeSet = contextSet = useContext ? contextSequence.toNodeSet() : null;
            if (this.truncation == -1) {
                temp = this.context.getBroker().getValueIndex().find(this.relation, contextSequence.getDocumentSet(), contextSet, 1, this.contextQName, key);
                this.hasUsedIndex = true;
            } else {
                try {
                    temp = this.context.getBroker().getValueIndex().match(contextSequence.getDocumentSet(), contextSet, 1, ((Object)this.getRegexp(key.getStringValue())).toString(), this.contextQName, 1);
                    this.hasUsedIndex = true;
                }
                catch (EXistException e) {
                    throw new XPathException(this.getASTNode(), "Error during index lookup: " + e.getMessage(), e);
                }
            }
            if (this.preselectResult == null) {
                this.preselectResult = temp;
                continue;
            }
            LOG.debug((Object)("Union: " + this.preselectResult.getLength() + " -> " + temp.getLength()));
            this.preselectResult = this.preselectResult.union(temp);
        }
        return this.preselectResult == null ? NodeSet.EMPTY_SET : this.preselectResult;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.cached != null && this.cached.isValid(contextSequence, contextItem)) {
            LOG.debug((Object)"Using cached results");
            if (this.context.getProfiler().isEnabled()) {
                this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Returned cached result");
            }
            result = this.cached.getResult();
        } else {
            boolean canCache;
            if (this.preselectResult != null && this.preselectResult.isEmpty()) {
                result = Sequence.EMPTY_SEQUENCE;
            } else if (this.contextStep == null || this.preselectResult == null) {
                if (this.inPredicate && !this.invalidNodeEvaluation && !Dependency.dependsOn(this, 2) && Type.subTypeOf(this.getLeft().returnsType(), -1)) {
                    if (contextItem != null) {
                        contextSequence = contextItem.toSequence();
                    }
                    if (!Dependency.dependsOn(this.rightOpDeps, 2)) {
                        result = this.quickNodeSetCompare(contextSequence);
                    } else {
                        NodeSet nodes = (NodeSet)this.getLeft().eval(contextSequence);
                        result = this.nodeSetCompare(nodes, contextSequence);
                    }
                } else {
                    result = this.genericCompare(contextSequence, contextItem);
                }
            } else {
                this.contextStep.setPreloadNodeSets(true);
                this.contextStep.setPreloadedData(contextSequence.getDocumentSet(), this.preselectResult);
                result = this.getLeft().eval(contextSequence).toNodeSet();
            }
            boolean bl = canCache = contextSequence != null && contextSequence.isCacheable() && !Dependency.dependsOn(this.getLeft(), 2) && !Dependency.dependsOn(this.getRight(), 2) && !Dependency.dependsOnVar(this.getLeft()) && !Dependency.dependsOnVar(this.getRight());
            if (canCache) {
                this.cached = new CachedResult(contextSequence, contextItem, result);
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        this.actualReturnType = result.getItemType();
        return result;
    }

    protected Sequence genericCompare(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATION_FLAGS, "OPTIMIZATION CHOICE", "genericCompare");
        }
        Sequence ls = this.getLeft().eval(contextSequence, contextItem);
        Sequence rs = this.getRight().eval(contextSequence, contextItem);
        Collator collator = this.getCollator(contextSequence);
        if (ls.isEmpty() && rs.isEmpty()) {
            return BooleanValue.valueOf(this.compareAtomic(collator, AtomicValue.EMPTY_VALUE, AtomicValue.EMPTY_VALUE));
        }
        if (ls.isEmpty() && !rs.isEmpty()) {
            SequenceIterator i2 = rs.iterate();
            while (i2.hasNext()) {
                if (!this.compareAtomic(collator, AtomicValue.EMPTY_VALUE, i2.nextItem().atomize())) continue;
                return BooleanValue.TRUE;
            }
        } else if (!ls.isEmpty() && rs.isEmpty()) {
            SequenceIterator i1 = ls.iterate();
            while (i1.hasNext()) {
                AtomicValue lv = i1.nextItem().atomize();
                if (!this.compareAtomic(collator, lv, AtomicValue.EMPTY_VALUE)) continue;
                return BooleanValue.TRUE;
            }
        } else {
            if (ls.hasOne() && rs.hasOne()) {
                return BooleanValue.valueOf(this.compareAtomic(collator, ls.itemAt(0).atomize(), rs.itemAt(0).atomize()));
            }
            SequenceIterator i1 = ls.iterate();
            while (i1.hasNext()) {
                AtomicValue lv = i1.nextItem().atomize();
                if (rs.isEmpty()) {
                    if (!this.compareAtomic(collator, lv, AtomicValue.EMPTY_VALUE)) continue;
                    return BooleanValue.TRUE;
                }
                if (rs.hasOne()) {
                    if (!this.compareAtomic(collator, lv, rs.itemAt(0).atomize())) continue;
                    return BooleanValue.TRUE;
                }
                SequenceIterator i2 = rs.iterate();
                while (i2.hasNext()) {
                    if (!this.compareAtomic(collator, lv, i2.nextItem().atomize())) continue;
                    return BooleanValue.TRUE;
                }
            }
        }
        return BooleanValue.FALSE;
    }

    protected Sequence nodeSetCompare(NodeSet nodes, Sequence contextSequence) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATION_FLAGS, "OPTIMIZATION CHOICE", "nodeSetCompare");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"No index: fall back to nodeSetCompare");
        }
        NewArrayNodeSet result = new NewArrayNodeSet();
        Collator collator = this.getCollator(contextSequence);
        if (contextSequence != null && !contextSequence.isEmpty() && !contextSequence.getDocumentSet().contains(nodes.getDocumentSet())) {
            NodeSetIterator i1 = nodes.iterator();
            while (i1.hasNext()) {
                NodeProxy item = (NodeProxy)i1.next();
                ContextItem context = item.getContext();
                if (context == null) {
                    throw new XPathException(this.getASTNode(), "Internal error: context node missing");
                }
                AtomicValue lv = item.atomize();
                do {
                    Sequence rs = this.getRight().eval(context.getNode().toSequence());
                    SequenceIterator i2 = rs.iterate();
                    while (i2.hasNext()) {
                        AtomicValue rv = i2.nextItem().atomize();
                        if (!this.compareAtomic(collator, lv, rv)) continue;
                        result.add(item);
                    }
                } while ((context = context.getNextDirect()) != null);
            }
        } else {
            NodeSetIterator i1 = nodes.iterator();
            while (i1.hasNext()) {
                NodeProxy item = (NodeProxy)i1.next();
                AtomicValue lv = item.atomize();
                Sequence rs = this.getRight().eval(contextSequence);
                SequenceIterator i2 = rs.iterate();
                while (i2.hasNext()) {
                    AtomicValue rv = i2.nextItem().atomize();
                    if (!this.compareAtomic(collator, lv, rv)) continue;
                    result.add(item);
                }
            }
        }
        return result;
    }

    protected Sequence quickNodeSetCompare(Sequence contextSequence) throws XPathException {
        Sequence leftSeq;
        NodeSet nodes;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATION_FLAGS, "OPTIMIZATION CHOICE", "quickNodeSetCompare");
        }
        NodeSet nodeSet = nodes = (leftSeq = this.getLeft().eval(contextSequence)).isEmpty() ? NodeSet.EMPTY_SET : (NodeSet)leftSeq;
        if (!(nodes instanceof VirtualNodeSet) && nodes.isEmpty()) {
            this.hasUsedIndex = true;
            return Sequence.EMPTY_SEQUENCE;
        }
        Sequence rightSeq = this.getRight().eval(contextSequence);
        if (rightSeq.isEmpty()) {
            this.hasUsedIndex = true;
            return Sequence.EMPTY_SEQUENCE;
        }
        int indexType = nodes.getIndexType();
        if (indexType != 11) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("found an index of type: " + Type.getTypeName(indexType)));
            }
            boolean indexScan = false;
            if (contextSequence != null) {
                IndexFlags iflags = GeneralComparison.checkForQNameIndex(this.idxflags, this.context, contextSequence, this.contextQName);
                boolean indexFound = false;
                if (!iflags.indexOnQName) {
                    indexFound = this.contextQName != null;
                    this.contextQName = null;
                }
                if (!indexFound && this.contextQName == null && iflags.hasIndexOnQNames) {
                    indexScan = true;
                }
            } else {
                return this.nodeSetCompare(nodes, contextSequence);
            }
            DocumentSet docs = nodes.getDocumentSet();
            NodeSet result = null;
            SequenceIterator itRightSeq = rightSeq.iterate();
            while (itRightSeq.hasNext()) {
                AtomicValue key = itRightSeq.nextItem().atomize();
                if (this.truncation != -1) {
                    if (!Type.subTypeOf(key.getType(), 22)) {
                        LOG.info((Object)("Truncated key. Converted from " + Type.getTypeName(key.getType()) + " to xs:string"));
                        key = key.convertTo(22);
                    }
                } else if (key.getType() != indexType) {
                    try {
                        key = key.convertTo(indexType);
                    }
                    catch (XPathException xpe) {
                        if (this.context.getProfiler().isEnabled()) {
                            this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATION_FLAGS, "OPTIMIZATION FALLBACK", "Falling back to nodeSetCompare (" + xpe.getMessage() + ")");
                        }
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Cannot convert key: " + Type.getTypeName(key.getType()) + " to required index type: " + Type.getTypeName(indexType)));
                        }
                        return this.nodeSetCompare(nodes, contextSequence);
                    }
                }
                if (key instanceof Indexable) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Checking if range index can be used for key: " + key.getStringValue()));
                    }
                    if (Type.subTypeOf(key.getType(), indexType)) {
                        NodeSet ns;
                        if (this.truncation == -1) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace((Object)("Using range index for key: " + key.getStringValue()));
                            }
                            this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Using value index '" + this.context.getBroker().getValueIndex().toString() + "' to find key '" + Type.getTypeName(key.getType()) + "(" + key.getStringValue() + ")'");
                            ns = indexScan ? this.context.getBroker().getValueIndex().findAll(this.relation, docs, nodes, 0, key) : this.context.getBroker().getValueIndex().find(this.relation, docs, nodes, 0, this.contextQName, key);
                            this.hasUsedIndex = true;
                            if (result == null) {
                                result = ns;
                                continue;
                            }
                            result = result.union(ns);
                            continue;
                        }
                        if (LOG.isTraceEnabled()) {
                            this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Using value index '" + this.context.getBroker().getValueIndex().toString() + "' to match key '" + Type.getTypeName(key.getType()) + "(" + key.getStringValue() + ")'");
                        }
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Using range index for key: " + key.getStringValue()));
                        }
                        try {
                            ns = indexScan ? this.context.getBroker().getValueIndex().matchAll(docs, nodes, 0, ((Object)this.getRegexp(key.getStringValue())).toString(), 1, 0, true) : this.context.getBroker().getValueIndex().match(docs, nodes, 0, ((Object)this.getRegexp(key.getStringValue())).toString(), this.contextQName, 1);
                            this.hasUsedIndex = true;
                            if (result == null) {
                                result = ns;
                                continue;
                            }
                            result = result.union(ns);
                            continue;
                        }
                        catch (EXistException e) {
                            throw new XPathException(this.getASTNode(), e.getMessage(), e);
                        }
                    }
                    if (this.context.getProfiler().isEnabled()) {
                        this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATION_FLAGS, "OPTIMIZATION FALLBACK", "Falling back to nodeSetCompare (key is of type: " + Type.getTypeName(key.getType()) + ") whereas index is of type '" + Type.getTypeName(indexType) + "'");
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Cannot use range index: key is of type: " + Type.getTypeName(key.getType()) + ") whereas index is of type '" + Type.getTypeName(indexType)));
                    }
                    return this.nodeSetCompare(nodes, contextSequence);
                }
                if (this.context.getProfiler().isEnabled()) {
                    this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATION_FLAGS, "OPTIMIZATION FALLBACK", "Falling back to nodeSetCompare (key is not an indexable type: " + key.getClass().getName());
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Cannot use key which is of type '" + key.getClass().getName()));
                }
                return this.nodeSetCompare(nodes, contextSequence);
            }
            return result;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("No suitable index found for key: " + rightSeq.getStringValue()));
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATION_FLAGS, "OPTIMIZATION FALLBACK", "falling back to nodeSetCompare (no index available)");
        }
        return this.nodeSetCompare(nodes, contextSequence);
    }

    private CharSequence getRegexp(String expr) {
        switch (this.truncation) {
            case 1: {
                return new StringBuffer().append(expr).append('$');
            }
            case 0: {
                return new StringBuffer().append('^').append(expr);
            }
        }
        return expr;
    }

    private boolean compareAtomic(Collator collator, AtomicValue lv, AtomicValue rv) throws XPathException {
        try {
            int ltype = lv.getType();
            int rtype = rv.getType();
            if (ltype == 21) {
                lv = Type.subTypeOf(rtype, 30) ? lv.convertTo(34) : (rtype == 21 || rtype == 22 ? lv.convertTo(22) : lv.convertTo(rtype));
            }
            if (rtype == 21) {
                rv = Type.subTypeOf(ltype, 30) ? rv.convertTo(34) : (ltype == 21 || ltype == 22 ? rv.convertTo(22) : rv.convertTo(ltype));
            }
            if (this.truncation != -1) {
                lv = lv.convertTo(22);
            }
            switch (this.truncation) {
                case 0: {
                    return lv.startsWith(collator, rv);
                }
                case 1: {
                    return lv.endsWith(collator, rv);
                }
                case 2: {
                    return lv.contains(collator, rv);
                }
            }
            return lv.compareTo(collator, this.relation, rv);
        }
        catch (XPathException e) {
            e.setASTNode(this.getASTNode());
            throw e;
        }
    }

    private static boolean isEmptyString(AtomicValue lv) throws XPathException {
        return (Type.subTypeOf(lv.getType(), 22) || lv.getType() == 20) && lv.getStringValue().length() == 0;
    }

    public boolean hasUsedIndex() {
        return this.hasUsedIndex;
    }

    public void dump(ExpressionDumper dumper) {
        if (this.truncation == 2) {
            dumper.display("contains").display('(');
            this.getLeft().dump(dumper);
            dumper.display(", ");
            this.getRight().dump(dumper);
            dumper.display(")");
        } else {
            this.getLeft().dump(dumper);
            dumper.display(' ').display(Constants.OPS[this.relation]).display(' ');
            this.getRight().dump(dumper);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.truncation == 2) {
            result.append("contains").append('(');
            result.append(this.getLeft().toString());
            result.append(", ");
            result.append(this.getRight().toString());
            result.append(")");
        } else {
            result.append(this.getLeft().toString());
            result.append(' ').append(Constants.OPS[this.relation]).append(' ');
            result.append(this.getRight().toString());
        }
        return result.toString();
    }

    protected void switchOperands() {
        this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Switching operands");
        switch (this.relation) {
            case 1: {
                this.relation = 0;
                break;
            }
            case 0: {
                this.relation = 1;
                break;
            }
            case 3: {
                this.relation = 2;
                break;
            }
            case 2: {
                this.relation = 3;
            }
        }
        Expression right = this.getRight();
        this.setRight(this.getLeft());
        this.setLeft(right);
    }

    protected void simplify() {
        if (!Type.subTypeOf(this.getLeft().returnsType(), -1) && Type.subTypeOf(this.getRight().returnsType(), -1)) {
            this.switchOperands();
        } else if (Cardinality.checkCardinality(4, this.getLeft().getCardinality()) && !Cardinality.checkCardinality(4, this.getRight().getCardinality())) {
            this.switchOperands();
        }
    }

    protected Collator getCollator(Sequence contextSequence) throws XPathException {
        if (this.collationArg == null) {
            return this.context.getDefaultCollator();
        }
        String collationURI = this.collationArg.eval(contextSequence).getStringValue();
        return this.context.getCollator(collationURI);
    }

    public void setCollation(Expression collationArg) {
        this.collationArg = collationArg;
    }

    public static final IndexFlags checkForQNameIndex(IndexFlags idxflags, XQueryContext context, Sequence contextSequence, QName contextQName) {
        idxflags.reset(contextQName != null);
        Iterator i = contextSequence.getCollectionIterator();
        while (i.hasNext()) {
            Collection collection = (Collection)i.next();
            if (collection.getURI().equalsInternal(XmldbURI.SYSTEM_COLLECTION_URI)) continue;
            IndexSpec idxcfg = collection.getIndexConfiguration(context.getBroker());
            if (idxflags.indexOnQName && idxcfg.getIndexByQName(contextQName) == null) {
                idxflags.indexOnQName = false;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("cannot use index on QName: " + contextQName + ". Collection " + collection.getURI() + " does not define an index"));
                }
            }
            if (!idxflags.hasIndexOnQNames && idxcfg.hasIndexesByQName()) {
                idxflags.hasIndexOnQNames = true;
            }
            if (idxflags.hasIndexOnPaths || !idxcfg.hasIndexesByPath()) continue;
            idxflags.hasIndexOnPaths = true;
        }
        return idxflags;
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.getLeft().resetState(postOptimization);
        this.getRight().resetState(postOptimization);
        if (!postOptimization) {
            this.cached = null;
            this.preselectResult = null;
            this.hasUsedIndex = false;
        }
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visitGeneralComparison(this);
    }

    public static final class IndexFlags {
        public boolean indexOnQName = true;
        public boolean hasIndexOnPaths = false;
        public boolean hasIndexOnQNames = false;

        public boolean indexOnQName() {
            return this.indexOnQName;
        }

        public boolean hasIndexOnPaths() {
            return this.hasIndexOnPaths;
        }

        public boolean hasIndexOnQNames() {
            return this.hasIndexOnQNames;
        }

        public void reset(boolean indexOnQName) {
            this.indexOnQName = indexOnQName;
            this.hasIndexOnPaths = false;
            this.hasIndexOnQNames = false;
        }
    }
}

