/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import javax.xml.stream.XMLStreamReader;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.xquery.TypeTest;
import org.exist.xquery.util.ExpressionDumper;
import org.w3c.dom.Node;

public class NameTest
extends TypeTest {
    protected final QName nodeName;

    public NameTest(int type, QName name) {
        super(type);
        this.nodeName = name;
    }

    public QName getName() {
        return this.nodeName;
    }

    public boolean matches(NodeProxy proxy) {
        Node node = null;
        short type = proxy.getNodeType();
        if (proxy.getType() == 11) {
            node = proxy.getNode();
            type = node.getNodeType();
        }
        if (!this.isOfType(type)) {
            return false;
        }
        if (node == null) {
            node = proxy.getNode();
        }
        return this.matchesName(node);
    }

    public boolean matches(Node other) {
        if (!this.isOfType(other.getNodeType())) {
            return false;
        }
        return this.matchesName(other);
    }

    public boolean matchesName(Node other) {
        if (this.nodeName.getNamespaceURI() != null && !this.nodeName.getNamespaceURI().equals(other.getNamespaceURI())) {
            return false;
        }
        if (this.nodeName.getLocalName() != null) {
            return this.nodeName.getLocalName().equals(other.getLocalName());
        }
        return true;
    }

    public boolean matches(XMLStreamReader reader) {
        int ev = reader.getEventType();
        if (!this.isOfEventType(ev)) {
            return false;
        }
        switch (ev) {
            case 1: {
                if (this.nodeName.getNamespaceURI() != null && !this.nodeName.getNamespaceURI().equals(reader.getNamespaceURI())) {
                    return false;
                }
                if (this.nodeName.getLocalName() == null) break;
                return this.nodeName.getLocalName().equals(reader.getLocalName());
            }
            case 3: {
                if (this.nodeName.getLocalName() == null) break;
                return this.nodeName.getLocalName().equals(reader.getPITarget());
            }
        }
        return true;
    }

    public boolean isWildcardTest() {
        return this.nodeName.getLocalName() == null || this.nodeName.getNamespaceURI() == null;
    }

    public void dump(ExpressionDumper dumper) {
        if (this.nodeName.getLocalName() == null) {
            dumper.display(this.nodeName.getPrefix() + ":*");
        } else {
            dumper.display(this.nodeName.getStringValue());
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.nodeName.getLocalName() == null) {
            result.append(this.nodeName.getPrefix() + ":*");
        } else {
            result.append(this.nodeName.getStringValue());
        }
        return result.toString();
    }
}

