/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.text.Collator;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;

public class OrderSpec {
    public static final int ASCENDING_ORDER = 0;
    public static final int DESCENDING_ORDER = 1;
    public static final int EMPTY_GREATEST = 0;
    public static final int EMPTY_LEAST = 4;
    private final XQueryContext context;
    private final Expression expression;
    private int modifiers = 0;
    private Collator collator = null;

    public OrderSpec(XQueryContext context, Expression sortExpr) {
        this.expression = sortExpr;
        this.context = context;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.expression.analyze(contextInfo);
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setCollation(String collationURI) throws XPathException {
        this.collator = this.context.getCollator(collationURI);
    }

    public Expression getSortExpression() {
        return this.expression;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Collator getCollator() {
        return this.collator == null ? this.context.getDefaultCollator() : this.collator;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(ExpressionDumper.dump(this.expression));
        buf.append(' ');
        buf.append((this.modifiers & 1) == 0 ? "ascending" : "descending");
        buf.append((this.modifiers & 4) == 0 ? "empty greatest" : "empty least");
        return buf.toString();
    }

    public void resetState(boolean postOptimization) {
        this.expression.resetState(postOptimization);
    }
}

