/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SimpleTimeZone;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.CollectionConfiguration;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.TriggerStatePerThread;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentSet;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.http.servlets.SessionWrapper;
import org.exist.memtree.DocumentImpl;
import org.exist.memtree.MemTreeBuilder;
import org.exist.numbering.NodeId;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.security.xacml.AccessContext;
import org.exist.security.xacml.ExistPDP;
import org.exist.security.xacml.NullAccessContextException;
import org.exist.source.DBSource;
import org.exist.source.Source;
import org.exist.source.SourceFactory;
import org.exist.storage.DBBroker;
import org.exist.storage.UpdateListener;
import org.exist.storage.lock.LockedDocumentMap;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.Collations;
import org.exist.util.Configuration;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.LockException;
import org.exist.util.hashtable.NamePool;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BatchTransactionPragma;
import org.exist.xquery.Cardinality;
import org.exist.xquery.Expression;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.ForceIndexUse;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionId;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.Module;
import org.exist.xquery.ModuleContext;
import org.exist.xquery.NoIndexPragma;
import org.exist.xquery.Optimize;
import org.exist.xquery.Option;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Pragma;
import org.exist.xquery.ProfilePragma;
import org.exist.xquery.Profiler;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.TimerPragma;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryWatchDog;
import org.exist.xquery.functions.ModuleImpl;
import org.exist.xquery.functions.session.SessionModule;
import org.exist.xquery.parser.XQueryLexer;
import org.exist.xquery.parser.XQueryParser;
import org.exist.xquery.parser.XQueryTreeParser;
import org.exist.xquery.update.Modification;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeUtils;
import org.exist.xquery.value.Type;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XQueryContext {
    public static final String CONFIGURATION_ELEMENT_NAME = "xquery";
    public static final String CONFIGURATION_MODULES_ELEMENT_NAME = "builtin-modules";
    public static final String ENABLE_QUERY_REWRITING_ATTRIBUTE = "enable-query-rewriting";
    public static final String XQUERY_BACKWARD_COMPATIBLE_ATTRIBUTE = "backwardCompatible";
    public static final String CONFIGURATION_MODULE_ELEMENT_NAME = "module";
    public static final String BUILT_IN_MODULE_URI_ATTRIBUTE = "uri";
    public static final String BUILT_IN_MODULE_CLASS_ATTRIBUTE = "class";
    public static final String PROPERTY_XQUERY_BACKWARD_COMPATIBLE = "xquery.backwardCompatible";
    public static final String PROPERTY_ENABLE_QUERY_REWRITING = "xquery.enable-query-rewriting";
    public static final String PROPERTY_BUILT_IN_MODULES = "xquery.modules";
    private static final String JAVA_URI_START = "java:";
    protected static final Logger LOG = Logger.getLogger((Class)XQueryContext.class);
    private static final String TEMP_STORE_ERROR = "Error occurred while storing temporary data";
    protected HashMap staticNamespaces = new HashMap();
    protected HashMap inScopeNamespaces = new HashMap();
    protected HashMap inheritedInScopeNamespaces = new HashMap();
    protected HashMap staticPrefixes = new HashMap();
    protected HashMap inScopePrefixes = new HashMap();
    protected HashMap inheritedInScopePrefixes = new HashMap();
    protected final Stack namespaceStack = new Stack();
    protected TreeMap declaredFunctions = new TreeMap();
    protected TreeMap globalVariables = new TreeMap();
    protected LocalVariable lastVar = null;
    protected Stack contextStack = new Stack();
    protected final Stack callStack = new Stack();
    protected int variableStackSize = 0;
    protected final Stack forwardReferences = new Stack();
    protected List options = null;
    XMLGregorianCalendar calendar = null;
    TimeZone implicitTimeZone = null;
    protected XQueryWatchDog watchdog;
    protected HashMap modules = new HashMap();
    protected XmldbURI[] staticDocumentPaths = null;
    protected DocumentSet staticDocuments = null;
    protected XmldbURI[] staticCollections = null;
    protected DocumentSet modifiedDocuments = null;
    protected DBBroker broker;
    protected Map attributes = new HashMap();
    protected AnyURIValue baseURI = AnyURIValue.EMPTY_URI;
    protected boolean baseURISetInProlog = false;
    protected String moduleLoadPath = ".";
    protected String defaultFunctionNamespace = "http://www.w3.org/2005/xpath-functions";
    protected AnyURIValue defaultElementNamespace = AnyURIValue.EMPTY_URI;
    protected AnyURIValue defaultElementNamespaceSchema = AnyURIValue.EMPTY_URI;
    private String defaultCollation = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    private Collator defaultCollator = null;
    private boolean backwardsCompatible = false;
    private boolean stripWhitespace = true;
    private boolean preserveNamespaces = true;
    private boolean inheritNamespaces = true;
    private boolean orderEmptyGreatest = true;
    private int contextPosition = 0;
    private MemTreeBuilder builder = null;
    private NamePool sharedNamePool = new NamePool();
    private Stack fragmentStack = new Stack();
    private Expression rootExpression;
    private int expressionCounter = 0;
    private LockedDocumentMap protectedDocuments = null;
    private Profiler profiler = new Profiler();
    HashMap XQueryContextVars = new HashMap();
    public static final String XQUERY_CONTEXTVAR_XQUERY_UPDATE_ERROR = "_eXist_xquery_update_error";
    public static final String HTTP_SESSIONVAR_XMLDB_USER = "_eXist_xmldb_user";
    private Txn batchTransaction = null;
    private DocumentSet batchTransactionTriggers = new DocumentSet();
    private AccessContext accessCtx;
    private ContextUpdateListener updateListener = null;
    private boolean enableOptimizer = true;
    private boolean isShared = false;
    private String sourceKey = "unknown";
    private String sourceType = "unknown";

    private XQueryContext() {
    }

    protected XQueryContext(AccessContext accessCtx) {
        if (accessCtx == null) {
            throw new NullAccessContextException();
        }
        this.accessCtx = accessCtx;
        this.builder = new MemTreeBuilder(this);
        this.builder.startDocument();
    }

    public XQueryContext(DBBroker broker, AccessContext accessCtx) {
        this(accessCtx);
        this.broker = broker;
        this.loadDefaults(broker.getConfiguration());
    }

    public XQueryContext(XQueryContext copyFrom) {
        this(copyFrom.getAccessContext());
        this.broker = copyFrom.broker;
        this.loadDefaultNS();
        Iterator prefixes = copyFrom.staticNamespaces.keySet().iterator();
        while (prefixes.hasNext()) {
            String prefix = (String)prefixes.next();
            if (prefix.equals("xml") || prefix.equals("xmlns")) continue;
            try {
                this.declareNamespace(prefix, (String)copyFrom.staticNamespaces.get(prefix));
            }
            catch (XPathException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean hasParent() {
        return false;
    }

    public XQueryContext copyContext() {
        XQueryContext ctx = new XQueryContext(this);
        this.copyFields(ctx);
        return ctx;
    }

    public void updateContext(XQueryContext from) {
        this.watchdog = from.watchdog;
        this.lastVar = from.lastVar;
        this.variableStackSize = from.getCurrentStackSize();
        this.contextStack = from.contextStack;
        this.inScopeNamespaces = from.inScopeNamespaces;
        this.inScopePrefixes = from.inScopePrefixes;
        this.inheritedInScopeNamespaces = from.inheritedInScopeNamespaces;
        this.inheritedInScopePrefixes = from.inheritedInScopePrefixes;
        this.variableStackSize = from.variableStackSize;
        this.attributes = from.attributes;
        this.updateListener = from.updateListener;
        this.modules = from.modules;
    }

    protected void copyFields(XQueryContext ctx) {
        ctx.calendar = this.calendar;
        ctx.implicitTimeZone = this.implicitTimeZone;
        ctx.baseURI = this.baseURI;
        ctx.baseURISetInProlog = this.baseURISetInProlog;
        ctx.staticDocumentPaths = this.staticDocumentPaths;
        ctx.staticDocuments = this.staticDocuments;
        ctx.moduleLoadPath = this.moduleLoadPath;
        ctx.defaultFunctionNamespace = this.defaultFunctionNamespace;
        ctx.defaultElementNamespace = this.defaultElementNamespace;
        ctx.defaultCollation = this.defaultCollation;
        ctx.defaultCollator = this.defaultCollator;
        ctx.backwardsCompatible = this.backwardsCompatible;
        ctx.enableOptimizer = this.enableOptimizer;
        ctx.stripWhitespace = this.stripWhitespace;
        ctx.preserveNamespaces = this.preserveNamespaces;
        ctx.inheritNamespaces = this.inheritNamespaces;
        ctx.orderEmptyGreatest = this.orderEmptyGreatest;
        ctx.declaredFunctions = new TreeMap(this.declaredFunctions);
        ctx.globalVariables = new TreeMap(this.globalVariables);
        ctx.modules = new HashMap();
        Iterator i = this.modules.values().iterator();
        while (i.hasNext()) {
            try {
                Module module = (Module)i.next();
                ctx.modules.put(module.getNamespaceURI(), module);
                String prefix = (String)this.staticPrefixes.get(module.getNamespaceURI());
                ctx.declareNamespace(prefix, module.getNamespaceURI());
            }
            catch (XPathException xPathException) {}
        }
        ctx.watchdog = this.watchdog;
        ctx.lastVar = this.lastVar;
        ctx.variableStackSize = this.getCurrentStackSize();
        ctx.contextStack = this.contextStack;
    }

    public void prepare() {
        User user = this.getUserFromHttpSession();
        if (user != null) {
            this.broker.setUser(user);
        }
        this.setContextPosition(0);
        try {
            if (this.calendar == null) {
                this.calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
            }
        }
        catch (DatatypeConfigurationException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (this.implicitTimeZone == null) {
            this.implicitTimeZone = TimeZone.getDefault();
            if (this.implicitTimeZone.inDaylightTime(new Date())) {
                this.implicitTimeZone.setRawOffset(this.implicitTimeZone.getRawOffset() + this.implicitTimeZone.getDSTSavings());
            }
        }
    }

    public AccessContext getAccessContext() {
        return this.accessCtx;
    }

    public boolean isProfilingEnabled() {
        return this.profiler.isEnabled();
    }

    public boolean isProfilingEnabled(int verbosity) {
        return this.profiler.isEnabled() && this.profiler.verbosity() >= verbosity;
    }

    public Profiler getProfiler() {
        return this.profiler;
    }

    public void setRootExpression(Expression expr) {
        this.rootExpression = expr;
    }

    public Expression getRootExpression() {
        return this.rootExpression;
    }

    protected int nextExpressionId() {
        return this.expressionCounter++;
    }

    public int getExpressionCount() {
        return this.expressionCounter;
    }

    public void setSourceKey(String key) {
        this.sourceKey = key;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public void setSourceType(String type) {
        this.sourceType = type;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void declareNamespace(String prefix, String uri) throws XPathException {
        if (prefix == null) {
            prefix = "";
        }
        if (uri == null) {
            uri = "";
        }
        if (prefix.equals("xml") || prefix.equals("xmlns")) {
            throw new XPathException("err:XQST0070: Namespace predefined prefix '" + prefix + "' can not be bound");
        }
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            throw new XPathException("err:XQST0070: Namespace URI '" + uri + "' must be bound to the 'xml' prefix");
        }
        String prevURI = (String)this.staticNamespaces.get(prefix);
        if (prevURI == null) {
            if (uri.length() > 0) {
                this.staticNamespaces.put(prefix, uri);
                this.staticPrefixes.put(uri, prefix);
                return;
            }
            LOG.warn((Object)("Unbinding unbound prefix '" + prefix + "'"));
        } else {
            if (uri.length() == 0) {
                this.staticPrefixes.remove(uri);
                this.staticNamespaces.remove(prefix);
                return;
            }
            if (prefix.equals("xs") && "http://www.w3.org/2001/XMLSchema".equals(prevURI) || prefix.equals("xsi") && "http://www.w3.org/2001/XMLSchema-instance".equals(prevURI) || prefix.equals("xdt") && "http://www.w3.org/2003/05/xpath-datatypes".equals(prevURI) || prefix.equals("fn") && "http://www.w3.org/2005/xpath-functions".equals(prevURI) || prefix.equals("local") && "http://www.w3.org/2005/xquery-local-functions".equals(prevURI)) {
                this.staticPrefixes.remove(prevURI);
                this.staticNamespaces.remove(prefix);
                if (uri.length() > 0) {
                    this.staticNamespaces.put(prefix, uri);
                    this.staticPrefixes.put(uri, prefix);
                    return;
                }
                LOG.warn((Object)("Unbinding unbound prefix '" + prefix + "'"));
            } else if (!uri.equals(prevURI)) {
                throw new XPathException("err:XQST0033: Namespace prefix '" + prefix + "' is already bound to a different uri '" + prevURI + "'");
            }
        }
    }

    public void declareNamespaces(Map namespaceMap) {
        Iterator i = namespaceMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String prefix = (String)entry.getKey();
            String uri = (String)entry.getValue();
            if (prefix == null) {
                prefix = "";
            }
            if (uri == null) {
                uri = "";
            }
            this.staticNamespaces.put(prefix, uri);
            this.staticPrefixes.put(uri, prefix);
        }
    }

    public void declareInScopeNamespace(String prefix, String uri) {
        if (prefix == null || uri == null) {
            throw new IllegalArgumentException("null argument passed to declareNamespace");
        }
        if (this.inheritedInScopePrefixes.get(this.getURIForPrefix(prefix)) != null) {
            this.inheritedInScopePrefixes.remove(uri);
        }
        if (this.inheritedInScopeNamespaces.get(prefix) != null) {
            this.inheritedInScopeNamespaces.remove(prefix);
        }
        if (this.inScopeNamespaces == null) {
            this.inScopeNamespaces = new HashMap();
        }
        this.inScopePrefixes.put(uri, prefix);
        this.inScopeNamespaces.put(prefix, uri);
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setDefaultFunctionNamespace(String uri) throws XPathException {
        if (this.defaultFunctionNamespace != null && !this.defaultFunctionNamespace.equals("http://www.w3.org/2005/xpath-functions") && !this.defaultFunctionNamespace.equals(uri)) {
            throw new XPathException("err:XQST0066: default function namespace is already set to: '" + this.defaultFunctionNamespace + "'");
        }
        this.defaultFunctionNamespace = uri;
    }

    public String getDefaultElementNamespaceSchema() throws XPathException {
        return this.defaultElementNamespaceSchema.getStringValue();
    }

    public void setDefaultElementNamespaceSchema(String uri) throws XPathException {
        if (!this.defaultElementNamespaceSchema.equals(AnyURIValue.EMPTY_URI)) {
            throw new XPathException("err:XQST0066: default function namespace schema is already set to: '" + this.defaultElementNamespaceSchema.getStringValue() + "'");
        }
        this.defaultElementNamespaceSchema = new AnyURIValue(uri);
    }

    public String getDefaultElementNamespace() throws XPathException {
        return this.defaultElementNamespace.getStringValue();
    }

    public void setDefaultElementNamespace(String uri, String schema) throws XPathException {
        if (!this.defaultElementNamespace.equals(AnyURIValue.EMPTY_URI)) {
            throw new XPathException("err:XQST0066: default element namespace is already set to: '" + this.defaultElementNamespace.getStringValue() + "'");
        }
        this.defaultElementNamespace = new AnyURIValue(uri);
        if (schema != null) {
            this.defaultElementNamespaceSchema = new AnyURIValue(schema);
        }
    }

    public void setDefaultCollation(String uri) throws XPathException {
        URI uriTest;
        if (uri.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint") || uri.equals("codepoint")) {
            this.defaultCollation = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
            this.defaultCollator = null;
        }
        try {
            uriTest = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new XPathException("err:XQST0038: Unknown collation : '" + uri + "'");
        }
        if (uri.startsWith("http://exist-db.org/collation") || uri.startsWith("?") || uriTest.isAbsolute()) {
            this.defaultCollator = Collations.getCollationFromURI(this, uri);
            this.defaultCollation = uri;
        } else {
            String absUri = this.getBaseURI().getStringValue() + uri;
            this.defaultCollator = Collations.getCollationFromURI(this, absUri);
            this.defaultCollation = absUri;
        }
    }

    public String getDefaultCollation() {
        return this.defaultCollation;
    }

    public Collator getCollator(String uri) throws XPathException {
        if (uri == null) {
            return this.defaultCollator;
        }
        return Collations.getCollationFromURI(this, uri);
    }

    public Collator getDefaultCollator() {
        return this.defaultCollator;
    }

    public String getURIForPrefix(String prefix) {
        String uri;
        String string = uri = this.inScopeNamespaces == null ? null : (String)this.inScopeNamespaces.get(prefix);
        if (uri != null) {
            return uri;
        }
        String string2 = uri = this.inheritedInScopeNamespaces == null ? null : (String)this.inheritedInScopeNamespaces.get(prefix);
        if (uri != null) {
            return uri;
        }
        return (String)this.staticNamespaces.get(prefix);
    }

    public String getPrefixForURI(String uri) {
        String prefix;
        String string = prefix = this.inScopePrefixes == null ? null : (String)this.inScopePrefixes.get(uri);
        if (prefix != null) {
            return prefix;
        }
        String string2 = prefix = this.inheritedInScopePrefixes == null ? null : (String)this.inheritedInScopePrefixes.get(uri);
        if (prefix != null) {
            return prefix;
        }
        return (String)this.staticPrefixes.get(uri);
    }

    public String getInScopeNamespace(String prefix) {
        return this.inScopeNamespaces == null ? null : (String)this.inScopeNamespaces.get(prefix);
    }

    public String getInScopePrefix(String uri) {
        return this.inScopePrefixes == null ? null : (String)this.inScopePrefixes.get(uri);
    }

    public String getInheritedNamespace(String prefix) {
        return this.inheritedInScopeNamespaces == null ? null : (String)this.inheritedInScopeNamespaces.get(prefix);
    }

    public String getInheritedPrefix(String uri) {
        return this.inheritedInScopePrefixes == null ? null : (String)this.inheritedInScopePrefixes.get(uri);
    }

    public void removeNamespace(String uri) {
        this.staticPrefixes.remove(uri);
        Iterator i = this.staticNamespaces.values().iterator();
        while (i.hasNext()) {
            if (!((String)i.next()).equals(uri)) continue;
            i.remove();
            return;
        }
        this.inScopePrefixes.remove(uri);
        if (this.inScopeNamespaces != null) {
            i = this.inScopeNamespaces.values().iterator();
            while (i.hasNext()) {
                if (!((String)i.next()).equals(uri)) continue;
                i.remove();
                return;
            }
        }
        this.inheritedInScopePrefixes.remove(uri);
        if (this.inheritedInScopeNamespaces != null) {
            i = this.inheritedInScopeNamespaces.values().iterator();
            while (i.hasNext()) {
                if (!((String)i.next()).equals(uri)) continue;
                i.remove();
                return;
            }
        }
    }

    public void setStaticallyKnownDocuments(XmldbURI[] docs) {
        this.staticDocumentPaths = docs;
    }

    public void setStaticallyKnownDocuments(DocumentSet set) {
        this.staticDocuments = set;
    }

    public void setCalendar(XMLGregorianCalendar newCalendar) {
        this.calendar = (XMLGregorianCalendar)newCalendar.clone();
    }

    public void setTimeZone(TimeZone newTimeZone) {
        this.implicitTimeZone = newTimeZone;
    }

    public XMLGregorianCalendar getCalendar() {
        if (this.calendar == null) {
            try {
                this.calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
            }
            catch (DatatypeConfigurationException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.calendar;
    }

    public TimeZone getImplicitTimeZone() {
        if (this.implicitTimeZone == null) {
            this.implicitTimeZone = TimeZone.getDefault();
            if (this.implicitTimeZone.inDaylightTime(new Date())) {
                this.implicitTimeZone.setRawOffset(this.implicitTimeZone.getRawOffset() + this.implicitTimeZone.getDSTSavings());
            }
        }
        return this.implicitTimeZone;
    }

    public DocumentSet getStaticallyKnownDocuments() throws XPathException {
        if (this.staticDocuments != null) {
            return this.staticDocuments;
        }
        if (this.protectedDocuments != null) {
            this.staticDocuments = this.protectedDocuments.toDocumentSet();
            return this.staticDocuments;
        }
        this.staticDocuments = new DocumentSet(1031);
        if (this.staticDocumentPaths == null) {
            this.broker.getAllXMLResources(this.staticDocuments);
        } else {
            for (int i = 0; i < this.staticDocumentPaths.length; ++i) {
                try {
                    Collection collection = this.broker.getCollection(this.staticDocumentPaths[i]);
                    if (collection != null) {
                        collection.allDocs(this.broker, this.staticDocuments, true, true);
                        continue;
                    }
                    org.exist.dom.DocumentImpl doc = this.broker.getXMLResource(this.staticDocumentPaths[i], 0);
                    if (doc == null) continue;
                    if (doc.getPermissions().validate(this.broker.getUser(), 4)) {
                        this.staticDocuments.add(doc);
                    }
                    doc.getUpdateLock().release(0);
                    continue;
                }
                catch (PermissionDeniedException e) {
                    LOG.warn((Object)("Permission denied to read resource " + this.staticDocumentPaths[i] + ". Skipping it."));
                }
            }
        }
        return this.staticDocuments;
    }

    public void setProtectedDocs(LockedDocumentMap map) {
        this.protectedDocuments = map;
    }

    public LockedDocumentMap getProtectedDocs() {
        return this.protectedDocuments;
    }

    public boolean inProtectedMode() {
        return this.protectedDocuments != null;
    }

    public boolean lockDocumentsOnLoad() {
        return false;
    }

    public void addLockedDocument(org.exist.dom.DocumentImpl doc) {
    }

    public void setShared(boolean shared) {
        this.isShared = shared;
    }

    public void addModifiedDoc(org.exist.dom.DocumentImpl document) {
        if (this.modifiedDocuments == null) {
            this.modifiedDocuments = new DocumentSet();
        }
        this.modifiedDocuments.add(document);
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean keepGlobals) {
        if (this.modifiedDocuments != null) {
            try {
                Modification.checkFragmentation(this, this.modifiedDocuments);
            }
            catch (EXistException e) {
                LOG.warn((Object)("Error while checking modified documents: " + e.getMessage()), (Throwable)e);
            }
            this.modifiedDocuments = null;
        }
        this.calendar = null;
        this.implicitTimeZone = null;
        this.builder = new MemTreeBuilder(this);
        this.builder.startDocument();
        if (!keepGlobals) {
            this.staticDocumentPaths = null;
            this.staticDocuments = null;
        }
        if (!this.isShared) {
            this.lastVar = null;
        }
        this.fragmentStack = new Stack();
        this.callStack.clear();
        this.protectedDocuments = null;
        if (!keepGlobals) {
            this.globalVariables.clear();
        }
        this.XQueryContextVars.clear();
        if (!this.isShared) {
            this.watchdog.reset();
        }
        this.profiler.reset();
        Iterator i = this.modules.values().iterator();
        while (i.hasNext()) {
            Module module = (Module)i.next();
            module.reset(this);
        }
        this.clearUpdateListeners();
    }

    public boolean stripWhitespace() {
        return this.stripWhitespace;
    }

    public void setStripWhitespace(boolean strip) {
        this.stripWhitespace = strip;
    }

    public boolean preserveNamespaces() {
        return this.preserveNamespaces;
    }

    public void setPreserveNamespaces(boolean preserve) {
        this.preserveNamespaces = preserve;
    }

    public boolean inheritNamespaces() {
        return this.inheritNamespaces;
    }

    public void setInheritNamespaces(boolean inherit) {
        this.inheritNamespaces = inherit;
    }

    public boolean orderEmptyGreatest() {
        return this.orderEmptyGreatest;
    }

    public void setOrderEmptyGreatest(boolean order) {
        this.orderEmptyGreatest = order;
    }

    public Iterator getModules() {
        return this.modules.values().iterator();
    }

    public Module getModule(String namespaceURI) {
        return (Module)this.modules.get(namespaceURI);
    }

    public boolean checkModulesValid() {
        Iterator i = this.modules.values().iterator();
        while (i.hasNext()) {
            Module module = (Module)i.next();
            if (module.isInternalModule() || ((ExternalModule)module).moduleIsValid()) continue;
            LOG.debug((Object)("Module with URI " + module.getNamespaceURI() + " has changed and needs to be reloaded"));
            return false;
        }
        return true;
    }

    public Module loadBuiltInModule(String namespaceURI, String moduleClass) {
        Module module = this.getModule(namespaceURI);
        if (module != null) {
            return module;
        }
        return this.initBuiltInModule(namespaceURI, moduleClass);
    }

    protected Module initBuiltInModule(String namespaceURI, String moduleClass) {
        Module module = null;
        try {
            Class<?> mClass = Class.forName(moduleClass);
            if (!Module.class.isAssignableFrom(mClass)) {
                LOG.info((Object)("failed to load module. " + moduleClass + " is not an instance of org.exist.xquery.Module."));
                return null;
            }
            this.instantiateModule(namespaceURI, mClass);
        }
        catch (ClassNotFoundException e) {
            LOG.warn((Object)("module class " + moduleClass + " not found. Skipping..."));
        }
        return module;
    }

    protected Module instantiateModule(String namespaceURI, Class mClass) {
        Module module = null;
        try {
            module = (Module)mClass.newInstance();
            if (!module.getNamespaceURI().equals(namespaceURI)) {
                LOG.warn((Object)("the module declares a different namespace URI. Expected: " + namespaceURI + " found: " + module.getNamespaceURI()));
                return null;
            }
            if (this.getPrefixForURI(module.getNamespaceURI()) == null && module.getDefaultPrefix().length() > 0) {
                this.declareNamespace(module.getDefaultPrefix(), module.getNamespaceURI());
            }
            this.modules.put(module.getNamespaceURI(), module);
            return module;
        }
        catch (InstantiationException e) {
            LOG.warn((Object)("error while instantiating module class " + mClass.getName()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)("error while instantiating module class " + mClass.getName()), (Throwable)e);
        }
        catch (XPathException e) {
            LOG.warn((Object)("error while instantiating module class " + mClass.getName()), (Throwable)e);
        }
        return null;
    }

    public ExistPDP getPDP() {
        return this.broker.getBrokerPool().getSecurityManager().getPDP();
    }

    public void declareFunction(UserDefinedFunction function) throws XPathException {
        if ("http://www.w3.org/XML/1998/namespace".equals(function.getSignature().getName().getNamespaceURI())) {
            throw new XPathException("XQST0045: function is in the forbidden namespace 'http://www.w3.org/XML/1998/namespace'");
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(function.getSignature().getName().getNamespaceURI())) {
            throw new XPathException("XQST0045: function is in the forbidden namespace 'http://www.w3.org/2001/XMLSchema'");
        }
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(function.getSignature().getName().getNamespaceURI())) {
            throw new XPathException("XQST0045: function is in the forbidden namespace 'http://www.w3.org/2001/XMLSchema-instance'");
        }
        if ("http://www.w3.org/2005/xpath-functions".equals(function.getSignature().getName().getNamespaceURI())) {
            throw new XPathException("XQST0045: function is in the forbidden namespace 'http://www.w3.org/2005/xpath-functions'");
        }
        this.declaredFunctions.put(function.getSignature().getFunctionId(), function);
    }

    public UserDefinedFunction resolveFunction(QName name, int argCount) throws XPathException {
        FunctionId id = new FunctionId(name, argCount);
        UserDefinedFunction func = (UserDefinedFunction)this.declaredFunctions.get(id);
        return func;
    }

    public Iterator getSignaturesForFunction(QName name) {
        ArrayList<FunctionSignature> signatures = new ArrayList<FunctionSignature>(2);
        Iterator i = this.declaredFunctions.values().iterator();
        while (i.hasNext()) {
            UserDefinedFunction func = (UserDefinedFunction)i.next();
            if (!func.getName().equals(name)) continue;
            signatures.add(func.getSignature());
        }
        return signatures.iterator();
    }

    public Iterator localFunctions() {
        return this.declaredFunctions.values().iterator();
    }

    public LocalVariable declareVariableBinding(LocalVariable var) throws XPathException {
        if (this.lastVar == null) {
            this.lastVar = var;
        } else {
            this.lastVar.addAfter(var);
            this.lastVar = var;
        }
        var.setStackPosition(this.getCurrentStackSize());
        return var;
    }

    public Variable declareGlobalVariable(Variable var) throws XPathException {
        this.globalVariables.put(var.getQName(), var);
        var.setStackPosition(this.getCurrentStackSize());
        return var;
    }

    public Variable declareVariable(String qname, Object value) throws XPathException {
        QName qn = QName.parse(this, qname, null);
        Module module = this.getModule(qn.getNamespaceURI());
        if (module != null) {
            Variable var = module.declareVariable(qn, value);
            return var;
        }
        Sequence val = XPathUtil.javaObjectToXPath(value, this);
        Variable var = (Variable)this.globalVariables.get(qn);
        if (var == null) {
            var = new Variable(qn);
            this.globalVariables.put(qn, var);
        }
        if (var.getSequenceType() != null) {
            int actualCardinality = val.isEmpty() ? 1 : (val.hasMany() ? 4 : 2);
            if (!Cardinality.checkCardinality(var.getSequenceType().getCardinality(), actualCardinality)) {
                throw new XPathException("XPTY0004: Invalid cardinality for variable $" + var.getQName() + ". Expected " + Cardinality.getDescription(var.getSequenceType().getCardinality()) + ", got " + Cardinality.getDescription(actualCardinality));
            }
            if (!Type.subTypeOf(var.getSequenceType().getPrimaryType(), -1) ? !val.isEmpty() && !Type.subTypeOf(val.getItemType(), var.getSequenceType().getPrimaryType()) : !val.isEmpty() && !Type.subTypeOf(val.getItemType(), var.getSequenceType().getPrimaryType())) {
                throw new XPathException("XPTY0004: Invalid type for variable $" + var.getQName() + ". Expected " + Type.getTypeName(var.getSequenceType().getPrimaryType()) + ", got " + Type.getTypeName(val.getItemType()));
            }
        }
        var.setValue(val);
        return var;
    }

    public Variable resolveVariable(String name) throws XPathException {
        QName qn = QName.parse(this, name, null);
        return this.resolveVariable(qn);
    }

    public Variable resolveVariable(QName qname) throws XPathException {
        Module module;
        Variable var = this.resolveLocalVariable(qname);
        if (var == null && (module = this.getModule(qname.getNamespaceURI())) != null) {
            var = module.resolveVariable(qname);
        }
        if (var == null) {
            var = (Variable)this.globalVariables.get(qname);
        }
        return var;
    }

    protected Variable resolveLocalVariable(QName qname) throws XPathException {
        LocalVariable end = this.contextStack.isEmpty() ? null : (LocalVariable)this.contextStack.peek();
        LocalVariable var = this.lastVar;
        while (var != null) {
            if (var == end) {
                return null;
            }
            if (qname.equals(var.getQName())) {
                return var;
            }
            var = var.before;
        }
        return null;
    }

    public boolean isVarDeclared(QName qname) {
        Module module = this.getModule(qname.getNamespaceURI());
        if (module != null && module.isVarDeclared(qname)) {
            return true;
        }
        return this.globalVariables.get(qname) != null;
    }

    public void setBackwardsCompatibility(boolean backwardsCompatible) {
        this.backwardsCompatible = backwardsCompatible;
    }

    public boolean isBackwardsCompatible() {
        return this.backwardsCompatible;
    }

    public DBBroker getBroker() {
        return this.broker;
    }

    public void setBroker(DBBroker broker) {
        this.broker = broker;
    }

    public User getUser() {
        return this.getBroker().getUser();
    }

    private User getUserFromHttpSession() {
        JavaObjectValue session;
        SessionModule myModule = (SessionModule)this.getModule("http://exist-db.org/xquery/session");
        if (myModule == null) {
            return null;
        }
        Variable var = null;
        try {
            var = myModule.resolveVariable(SessionModule.SESSION_VAR);
        }
        catch (XPathException xpe) {
            return null;
        }
        if (var != null && var.getValue() != null && var.getValue().getItemType() == 100 && (session = (JavaObjectValue)var.getValue().itemAt(0)).getObject() instanceof SessionWrapper) {
            try {
                return (User)((SessionWrapper)session.getObject()).getAttribute(HTTP_SESSIONVAR_XMLDB_USER);
            }
            catch (IllegalStateException e) {
                return null;
            }
        }
        return null;
    }

    public MemTreeBuilder getDocumentBuilder() {
        if (this.builder == null) {
            this.builder = new MemTreeBuilder(this);
            this.builder.startDocument();
        }
        return this.builder;
    }

    public NamePool getSharedNamePool() {
        return this.sharedNamePool;
    }

    public void proceed() throws TerminatedException {
        this.proceed(null);
    }

    public void proceed(Expression expr) throws TerminatedException {
        this.watchdog.proceed(expr);
    }

    public void proceed(Expression expr, MemTreeBuilder builder) throws TerminatedException {
        this.watchdog.proceed(expr, builder);
    }

    public void recover() {
        this.watchdog.reset();
        this.builder = null;
    }

    public XQueryWatchDog getWatchDog() {
        return this.watchdog;
    }

    protected void setWatchDog(XQueryWatchDog watchdog) {
        this.watchdog = watchdog;
    }

    public void pushDocumentContext() {
        this.fragmentStack.push(this.builder);
        this.builder = null;
    }

    public void popDocumentContext() {
        if (!this.fragmentStack.isEmpty()) {
            this.builder = (MemTreeBuilder)this.fragmentStack.pop();
        }
    }

    public void setBaseURI(AnyURIValue uri) {
        this.setBaseURI(uri, false);
    }

    public void setBaseURI(AnyURIValue uri, boolean setInProlog) {
        if (this.baseURISetInProlog) {
            return;
        }
        if (uri == null) {
            this.baseURI = AnyURIValue.EMPTY_URI;
        }
        this.baseURI = uri;
        this.baseURISetInProlog = setInProlog;
    }

    public void setModuleLoadPath(String path) {
        this.moduleLoadPath = path;
    }

    public String getModuleLoadPath() {
        return this.moduleLoadPath;
    }

    public boolean isBaseURIDeclared() {
        return this.baseURI != null && !this.baseURI.equals(AnyURIValue.EMPTY_URI);
    }

    public AnyURIValue getBaseURI() throws XPathException {
        if (this.baseURI == null || this.baseURI.equals(AnyURIValue.EMPTY_URI)) {
            // empty if block
        }
        return this.baseURI;
    }

    public void setContextPosition(int pos) {
        this.contextPosition = pos;
    }

    public int getContextPosition() {
        return this.contextPosition;
    }

    public void pushInScopeNamespaces() {
        HashMap m = (HashMap)this.inScopeNamespaces.clone();
        HashMap p = (HashMap)this.inScopePrefixes.clone();
        this.namespaceStack.push(this.inheritedInScopeNamespaces);
        this.namespaceStack.push(this.inheritedInScopePrefixes);
        this.namespaceStack.push(this.inScopeNamespaces);
        this.namespaceStack.push(this.inScopePrefixes);
        this.inheritedInScopeNamespaces = (HashMap)this.inheritedInScopeNamespaces.clone();
        this.inheritedInScopeNamespaces.putAll(m);
        this.inheritedInScopePrefixes = (HashMap)this.inheritedInScopePrefixes.clone();
        this.inheritedInScopePrefixes.putAll(p);
        this.inScopeNamespaces = new HashMap();
        this.inScopePrefixes = new HashMap();
    }

    public void popInScopeNamespaces() {
        this.inScopePrefixes = (HashMap)this.namespaceStack.pop();
        this.inScopeNamespaces = (HashMap)this.namespaceStack.pop();
        this.inheritedInScopePrefixes = (HashMap)this.namespaceStack.pop();
        this.inheritedInScopeNamespaces = (HashMap)this.namespaceStack.pop();
    }

    public void pushNamespaceContext() {
        HashMap m = (HashMap)this.staticNamespaces.clone();
        HashMap p = (HashMap)this.staticPrefixes.clone();
        this.namespaceStack.push(this.staticNamespaces);
        this.namespaceStack.push(this.staticPrefixes);
        this.staticNamespaces = m;
        this.staticPrefixes = p;
    }

    public void popNamespaceContext() {
        this.staticPrefixes = (HashMap)this.namespaceStack.pop();
        this.staticNamespaces = (HashMap)this.namespaceStack.pop();
    }

    public LocalVariable markLocalVariables(boolean newContext) {
        if (newContext) {
            this.contextStack.push(this.lastVar);
        }
        ++this.variableStackSize;
        return this.lastVar;
    }

    public void popLocalVariables(LocalVariable var) {
        if (var != null) {
            var.after = null;
            if (!this.contextStack.isEmpty() && var == this.contextStack.peek()) {
                this.contextStack.pop();
            }
        }
        this.lastVar = var;
        --this.variableStackSize;
    }

    public int getCurrentStackSize() {
        return this.variableStackSize;
    }

    public void functionStart(FunctionSignature signature) {
        this.callStack.push(signature);
    }

    public void functionEnd() {
        if (this.callStack.isEmpty()) {
            LOG.warn((Object)"Function call stack is empty, but XQueryContext.functionEnd() was called. This could indicate a concurrency issue (shared XQueryContext?)");
        } else {
            this.callStack.pop();
        }
    }

    public boolean tailRecursiveCall(FunctionSignature signature) {
        return this.callStack.contains(signature);
    }

    public void importModule(String namespaceURI, String prefix, String location) throws XPathException {
        Module module;
        block22: {
            module = this.getModule(namespaceURI);
            if (module != null) {
                LOG.debug((Object)("Module " + namespaceURI + " already present."));
            } else {
                if (location == null) {
                    location = namespaceURI;
                }
                if (location.startsWith(JAVA_URI_START)) {
                    location = location.substring(JAVA_URI_START.length());
                    module = this.loadBuiltInModule(namespaceURI, location);
                } else {
                    Source source2;
                    if (location.startsWith("xmldb:") || location.indexOf(58) < 0 && this.moduleLoadPath.startsWith("xmldb:")) {
                        try {
                            XmldbURI locationUri = XmldbURI.xmldbUriFor(location);
                            if (this.moduleLoadPath.startsWith("xmldb:")) {
                                XmldbURI moduleLoadPathUri = XmldbURI.xmldbUriFor(this.moduleLoadPath);
                                locationUri = moduleLoadPathUri.resolveCollectionPath(locationUri);
                            }
                            org.exist.dom.DocumentImpl sourceDoc = null;
                            try {
                                sourceDoc = this.broker.getXMLResource(locationUri.toCollectionPathURI(), 0);
                                if (sourceDoc == null) {
                                    throw new XPathException("source for module " + location + " not found in database");
                                }
                                if (sourceDoc.getResourceType() != 1 || !sourceDoc.getMetadata().getMimeType().equals("application/xquery")) {
                                    throw new XPathException("source for module " + location + " is not an XQuery or " + "declares a wrong mime-type");
                                }
                                DBSource source2 = new DBSource(this.broker, (BinaryDocument)sourceDoc, true);
                                module = this.compileModule(prefix, namespaceURI, location, module, source2);
                                break block22;
                            }
                            catch (PermissionDeniedException e) {
                                throw new XPathException("permission denied to read module source from " + location);
                            }
                            finally {
                                if (sourceDoc != null) {
                                    sourceDoc.getUpdateLock().release(0);
                                }
                            }
                        }
                        catch (URISyntaxException e) {
                            throw new XPathException(e.getMessage(), (Throwable)e);
                        }
                    }
                    try {
                        source2 = SourceFactory.getSource(this.broker, this.moduleLoadPath, location, true);
                    }
                    catch (MalformedURLException e) {
                        throw new XPathException("source location for module " + namespaceURI + " should be a valid URL: " + e.getMessage());
                    }
                    catch (IOException e) {
                        throw new XPathException("source for module " + namespaceURI + " not found: " + e.getMessage());
                    }
                    catch (PermissionDeniedException e) {
                        throw new XPathException("Permission denied to access module " + namespaceURI + " : " + e.getMessage());
                    }
                    module = this.compileModule(prefix, namespaceURI, location, module, source2);
                }
            }
        }
        if (prefix == null) {
            prefix = module.getDefaultPrefix();
        }
        this.declareNamespace(prefix, namespaceURI);
    }

    private Module compileModule(String prefix, String namespaceURI, String location, Module module, Source source) throws XPathException {
        Reader reader;
        LOG.debug((Object)("Loading module from " + location));
        try {
            reader = source.getReader();
        }
        catch (IOException e) {
            throw new XPathException("IO exception while loading module " + namespaceURI, (Throwable)e);
        }
        ModuleContext modContext = new ModuleContext(this, prefix, namespaceURI);
        XQueryLexer lexer = new XQueryLexer(modContext, reader);
        XQueryParser parser = new XQueryParser(lexer);
        XQueryTreeParser astParser = new XQueryTreeParser(modContext);
        try {
            parser.xpath();
            if (parser.foundErrors()) {
                LOG.debug((Object)parser.getErrorMessage());
                throw new XPathException("error found while loading module from " + location + ": " + parser.getErrorMessage());
            }
            AST ast = parser.getAST();
            PathExpr path = new PathExpr(modContext);
            astParser.xpath(ast, path);
            if (astParser.foundErrors()) {
                throw new XPathException("error found while loading module from " + location + ": " + astParser.getErrorMessage(), (Throwable)astParser.getLastException());
            }
            path.analyze(new AnalyzeContextInfo());
            ExternalModule modExternal = astParser.getModule();
            if (modExternal == null) {
                throw new XPathException("source at " + location + " is not a valid module");
            }
            if (!modExternal.getNamespaceURI().equals(namespaceURI)) {
                throw new XPathException("namespace URI declared by module (" + modExternal.getNamespaceURI() + ") does not match namespace URI in import statement, which was: " + namespaceURI);
            }
            this.modules.put(modExternal.getNamespaceURI(), modExternal);
            modExternal.setSource(source);
            modExternal.setContext(modContext);
            module = modExternal;
        }
        catch (RecognitionException e) {
            throw new XPathException("error found while loading module from " + location + ": " + e.getMessage(), e.getLine(), e.getColumn());
        }
        catch (TokenStreamException e) {
            throw new XPathException("error found while loading module from " + location + ": " + e.getMessage(), (Throwable)e);
        }
        catch (XPathException e) {
            e.prependMessage("Error while loading module " + location + ": ");
            throw e;
        }
        catch (Exception e) {
            throw new XPathException("Internal error while loading module: " + location, (Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOG.warn((Object)("Error while closing module source: " + e.getMessage()), (Throwable)e);
            }
        }
        this.declareModuleVars(module);
        return module;
    }

    private void declareModuleVars(Module module) {
        String moduleNS = module.getNamespaceURI();
        Iterator i = this.globalVariables.values().iterator();
        while (i.hasNext()) {
            Variable var = (Variable)i.next();
            if (!moduleNS.equals(var.getQName().getNamespaceURI())) continue;
            module.declareVariable(var);
            i.remove();
        }
    }

    public void addForwardReference(FunctionCall call) {
        this.forwardReferences.push(call);
    }

    public void resolveForwardReferences() throws XPathException {
        while (!this.forwardReferences.empty()) {
            FunctionCall call = (FunctionCall)this.forwardReferences.pop();
            UserDefinedFunction func = this.resolveFunction(call.getQName(), call.getArgumentCount());
            if (func == null) {
                throw new XPathException(call.getASTNode(), "Call to undeclared function: " + call.getQName().getStringValue());
            }
            call.resolveForwardReference(func);
        }
    }

    public boolean optimizationsEnabled() {
        return this.enableOptimizer;
    }

    public void addOption(String qnameString, String contents) throws XPathException {
        QName qn = QName.parse(this, qnameString, this.defaultFunctionNamespace);
        Option option = new Option(qn, contents);
        if (this.options == null) {
            this.options = new ArrayList();
        }
        boolean added = false;
        for (int i = 0; i < this.options.size(); ++i) {
            Option old = (Option)this.options.get(i);
            if (!old.equals(option)) continue;
            this.options.add(i, option);
            added = true;
            break;
        }
        if (!added) {
            this.options.add(option);
        }
        if (Option.PROFILE_QNAME.compareTo(qn) == 0) {
            this.profiler.configure(option);
        } else if (Option.TIMEOUT_QNAME.compareTo(qn) == 0) {
            this.watchdog.setTimeoutFromOption(option);
        } else if (Option.OUTPUT_SIZE_QNAME.compareTo(qn) == 0) {
            this.watchdog.setMaxNodesFromOption(option);
        } else if (Option.OPTIMIZE_QNAME.compareTo(qn) == 0) {
            String[] param;
            String[] params = option.tokenizeContents();
            if (params.length > 0 && "enable".equals((param = Option.parseKeyValuePair(params[0]))[0])) {
                this.enableOptimizer = "yes".equals(param[1]);
            }
        } else if (Option.OPTIMIZE_IMPLICIT_TIMEZONE.compareTo(qn) == 0) {
            Duration duration = TimeUtils.getInstance().newDuration(option.getContents());
            this.implicitTimeZone = new SimpleTimeZone((int)duration.getTimeInMillis(new Date()), "XQuery context");
        } else if (Option.CURRENT_DATETIME.compareTo(qn) == 0) {
            DateTimeValue dtv = new DateTimeValue(option.getContents());
            this.calendar = (XMLGregorianCalendar)dtv.calendar.clone();
        }
    }

    public Option getOption(QName qname) {
        if (this.options != null) {
            for (int i = 0; i < this.options.size(); ++i) {
                Option option = (Option)this.options.get(i);
                if (qname.compareTo(option.getQName()) != 0) continue;
                return option;
            }
        }
        return null;
    }

    public Pragma getPragma(String name, String contents) throws XPathException {
        QName qname = QName.parse(this, name);
        if ("".equals(qname.getNamespaceURI())) {
            throw new XPathException("XPST0081: pragma's ('" + name + "') namespace URI is empty");
        }
        if ("http://exist.sourceforge.net/NS/exist".equals(qname.getNamespaceURI())) {
            contents = StringValue.trimWhitespace(contents);
            if (TimerPragma.TIMER_PRAGMA.equalsSimple(qname)) {
                return new TimerPragma(qname, contents);
            }
            if (Optimize.OPTIMIZE_PRAGMA.equalsSimple(qname)) {
                return new Optimize(this, qname, contents, true);
            }
            if (BatchTransactionPragma.BATCH_TRANSACTION_PRAGMA.equalsSimple(qname)) {
                return new BatchTransactionPragma(qname, contents);
            }
            if (ForceIndexUse.EXCEPTION_IF_INDEX_NOT_USED_PRAGMA.equalsSimple(qname)) {
                return new ForceIndexUse(qname, contents);
            }
            if (ProfilePragma.PROFILIE_PRAGMA.equalsSimple(qname)) {
                return new ProfilePragma(qname, contents);
            }
            if (NoIndexPragma.NO_INDEX_PRAGMA.equalsSimple(qname)) {
                return new NoIndexPragma(qname, contents);
            }
        }
        return null;
    }

    public org.exist.dom.DocumentImpl storeTemporaryDoc(DocumentImpl doc) throws XPathException {
        try {
            org.exist.dom.DocumentImpl targetDoc = this.broker.storeTempResource(doc);
            if (targetDoc == null) {
                throw new XPathException("Internal error: failed to store temporary doc fragment");
            }
            LOG.debug((Object)("Stored: " + targetDoc.getDocId() + ": " + targetDoc.getURI()));
            return targetDoc;
        }
        catch (EXistException e) {
            throw new XPathException(TEMP_STORE_ERROR, (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            throw new XPathException(TEMP_STORE_ERROR, (Throwable)e);
        }
        catch (LockException e) {
            throw new XPathException(TEMP_STORE_ERROR, (Throwable)e);
        }
    }

    public void setAttribute(String attribute, Object value) {
        this.attributes.put(attribute, value);
    }

    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    public void setXQueryContextVar(String name, Object XQvar) {
        this.XQueryContextVars.put(name, XQvar);
    }

    public Object getXQueryContextVar(String name) {
        return this.XQueryContextVars.get(name);
    }

    public void startBatchTransaction() throws TransactionException {
        if (this.batchTransaction != null) {
            this.finishBatchTransaction();
        }
        TransactionManager txnMgr = this.getBroker().getBrokerPool().getTransactionManager();
        this.batchTransaction = txnMgr.beginTransaction();
    }

    public boolean hasBatchTransaction() {
        return this.batchTransaction != null;
    }

    public Txn getBatchTransaction() {
        return this.batchTransaction;
    }

    public void setBatchTransactionTrigger(org.exist.dom.DocumentImpl doc) {
        Iterator itTrigDoc = this.batchTransactionTriggers.iterator();
        while (itTrigDoc.hasNext()) {
            org.exist.dom.DocumentImpl trigDoc = (org.exist.dom.DocumentImpl)itTrigDoc.next();
            if (!trigDoc.getURI().equals(doc.getURI())) continue;
            itTrigDoc.remove();
            break;
        }
        this.batchTransactionTriggers.add(doc);
    }

    public void finishBatchTransaction() throws TransactionException {
        if (this.batchTransaction != null) {
            TransactionManager txnMgr = this.getBroker().getBrokerPool().getTransactionManager();
            txnMgr.commit(this.batchTransaction);
            Iterator itDoc = this.batchTransactionTriggers.iterator();
            while (itDoc.hasNext()) {
                org.exist.dom.DocumentImpl doc = (org.exist.dom.DocumentImpl)itDoc.next();
                CollectionConfiguration config = doc.getCollection().getConfiguration(this.getBroker());
                if (config == null) continue;
                DocumentTrigger trigger = null;
                try {
                    trigger = (DocumentTrigger)config.newTrigger(1, this.getBroker(), doc.getCollection());
                }
                catch (CollectionConfigurationException e) {
                    LOG.debug((Object)("An error occurred while initializing a trigger for collection " + doc.getCollection().getURI() + ": " + e.getMessage()), (Throwable)e);
                }
                if (trigger == null) continue;
                try {
                    trigger.finish(1, this.getBroker(), TriggerStatePerThread.getTransaction(), doc.getURI(), doc);
                }
                catch (Exception e) {
                    LOG.debug((Object)("Trigger event UPDATE_DOCUMENT_EVENT for collection: " + doc.getCollection().getURI() + " with: " + doc.getURI() + " " + e.getMessage()));
                }
            }
            this.batchTransactionTriggers.clear();
            this.batchTransaction = null;
        }
    }

    public void setXQuerySerializer(String name, boolean indent, boolean omitxmldeclaration) throws XPathException {
        for (int i = 0; i < this.options.size(); ++i) {
            Option option = (Option)this.options.get(i);
            if (!option.getQName().equals("exist:serialize")) continue;
            String content = option.getContents();
            content = content.indexOf("method=") != -1 ? content.replaceFirst("method=[^/ ]*", "method=" + name) : content + " method=" + name;
            content = content.indexOf("indent=") != -1 ? content.replaceFirst("indent=[^/ ]*", "indent=" + (indent ? "yes" : "no")) : content + " indent" + (indent ? "yes" : "no");
            content = content.indexOf("omit-xml-declaration") != -1 ? content.replaceFirst("omit-xml-declaration=[^/ ]*", "omit-xml-declaration=" + (omitxmldeclaration ? "yes" : "no")) : content + " omit-xml-declaration" + (omitxmldeclaration ? "yes" : "no");
            this.options.remove(i);
            this.addOption("exist:serialize", content);
            return;
        }
        this.addOption("exist:serialize", "method=" + name + " indent=" + (indent ? "yes" : "no") + " omit-xml-declaration=" + (omitxmldeclaration ? "yes" : "no"));
    }

    protected void loadDefaults(Configuration config) {
        this.watchdog = new XQueryWatchDog(this);
        this.loadDefaultNS();
        String param = (String)this.getBroker().getConfiguration().getProperty(PROPERTY_ENABLE_QUERY_REWRITING);
        this.enableOptimizer = param != null && param.equals("yes");
        param = (String)this.getBroker().getConfiguration().getProperty(PROPERTY_XQUERY_BACKWARD_COMPATIBLE);
        this.backwardsCompatible = param == null ? true : param.equals("yes");
        Map modules = (Map)config.getProperty(PROPERTY_BUILT_IN_MODULES);
        if (modules != null) {
            Iterator i = modules.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Class mClass = (Class)entry.getValue();
                String namespaceURI = (String)entry.getKey();
                Module module = this.getModule(namespaceURI);
                if (module != null) continue;
                this.instantiateModule(namespaceURI, mClass);
            }
        }
    }

    protected void loadDefaultNS() {
        try {
            this.staticNamespaces.put("xml", "http://www.w3.org/XML/1998/namespace");
            this.staticPrefixes.put("http://www.w3.org/XML/1998/namespace", "xml");
            this.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
            this.declareNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.declareNamespace("xdt", "http://www.w3.org/2003/05/xpath-datatypes");
            this.declareNamespace("fn", "http://www.w3.org/2005/xpath-functions");
            this.declareNamespace("local", "http://www.w3.org/2005/xquery-local-functions");
            this.declareNamespace("exist", "http://exist.sourceforge.net/NS/exist");
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
    }

    public void registerUpdateListener(UpdateListener listener) {
        if (this.updateListener == null) {
            this.updateListener = new ContextUpdateListener();
            this.broker.getBrokerPool().getNotificationService().subscribe(this.updateListener);
        }
        this.updateListener.addListener(listener);
    }

    protected void clearUpdateListeners() {
        if (this.updateListener != null) {
            this.broker.getBrokerPool().getNotificationService().unsubscribe(this.updateListener);
        }
        this.updateListener = null;
    }

    public void checkOptions(Properties properties) throws XPathException {
        Option pragma = this.getOption(Option.SERIALIZE_QNAME);
        if (pragma == null) {
            return;
        }
        String[] contents = pragma.tokenizeContents();
        for (int i = 0; i < contents.length; ++i) {
            String[] pair = Option.parseKeyValuePair(contents[i]);
            if (pair == null) {
                throw new XPathException("Unknown parameter found in " + pragma.getQName().getStringValue() + ": '" + contents[i] + "'");
            }
            LOG.debug((Object)("Setting serialization property from pragma: " + pair[0] + " = " + pair[1]));
            properties.setProperty(pair[0], pair[1]);
        }
    }

    public static Map loadModuleClasses(Element xquery) throws DatabaseConfigurationException {
        Element elem;
        NodeList modules;
        HashMap<String, Class> classMap = new HashMap<String, Class>();
        classMap.put("http://www.w3.org/2005/xpath-functions", ModuleImpl.class);
        NodeList builtins = xquery.getElementsByTagName(CONFIGURATION_MODULES_ELEMENT_NAME);
        if (builtins.getLength() > 0 && (modules = (elem = (Element)builtins.item(0)).getElementsByTagName(CONFIGURATION_MODULE_ELEMENT_NAME)).getLength() > 0) {
            for (int i = 0; i < modules.getLength(); ++i) {
                elem = (Element)modules.item(i);
                String uri = elem.getAttribute(BUILT_IN_MODULE_URI_ATTRIBUTE);
                String clazz = elem.getAttribute(BUILT_IN_MODULE_CLASS_ATTRIBUTE);
                if (uri == null) {
                    throw new DatabaseConfigurationException("element 'module' requires an attribute 'uri'");
                }
                if (clazz == null) {
                    throw new DatabaseConfigurationException("element 'module' requires an attribute 'class'");
                }
                Class mClass = XQueryContext.lookupModuleClass(uri, clazz);
                if (mClass != null) {
                    classMap.put(uri, mClass);
                }
                LOG.debug((Object)("Configured module '" + uri + "' implemented in '" + clazz + "'"));
            }
        }
        return classMap;
    }

    private static Class lookupModuleClass(String uri, String clazz) throws DatabaseConfigurationException {
        try {
            Class<?> mClass = Class.forName(clazz);
            if (!Module.class.isAssignableFrom(mClass)) {
                throw new DatabaseConfigurationException("Failed to load module: " + uri + ". Class " + clazz + " is not an instance of org.exist.xquery.Module.");
            }
            return mClass;
        }
        catch (ClassNotFoundException e) {
            LOG.warn((Object)("Configuration problem: failed to load class for module " + uri + "; class: " + clazz), (Throwable)e);
            return null;
        }
    }

    private class ContextUpdateListener
    implements UpdateListener {
        private List listeners = new ArrayList();

        private ContextUpdateListener() {
        }

        public void addListener(UpdateListener listener) {
            this.listeners.add(listener);
        }

        public void documentUpdated(org.exist.dom.DocumentImpl document, int event) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                UpdateListener listener = (UpdateListener)this.listeners.get(i);
                if (listener == null) continue;
                listener.documentUpdated(document, event);
            }
        }

        public void unsubscribe() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                UpdateListener listener = (UpdateListener)this.listeners.get(i);
                if (listener == null) continue;
                listener.unsubscribe();
            }
            this.listeners.clear();
        }

        public void nodeMoved(NodeId oldNodeId, StoredNode newNode) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                UpdateListener listener = (UpdateListener)this.listeners.get(i);
                if (listener == null) continue;
                listener.nodeMoved(oldNodeId, newNode);
            }
        }

        public void debug() {
            LOG.debug((Object)"XQueryContext: ");
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((UpdateListener)this.listeners.get(i)).debug();
            }
        }
    }
}

