/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class FunLang
extends Function {
    public static String queryString = "(ancestor-or-self::*/@xml:lang)[position() = last()]";
    public CompiledXQuery query;
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("lang", "http://www.w3.org/2005/xpath-functions"), "Returns true if the context items xml:lang attribute is equal to the value of $a, false otherwise.", new SequenceType[]{new SequenceType(22, 3)}, new SequenceType(23, 2)), new FunctionSignature(new QName("lang", "http://www.w3.org/2005/xpath-functions"), "Returns true if the context items xml:lang attribute is equal to the value of $a, false otherwise.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(-1, 2)}, new SequenceType(23, 2))};

    public FunLang(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        this.query = this.context.getBroker().getXQueryService().compile(this.context, queryString);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        BooleanValue result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (this.getArgumentCount() == 2) {
            contextSequence = this.getArgument(1).eval(contextSequence);
        }
        if (contextSequence == null) {
            throw new XPathException(this.getASTNode(), "XPDY0002: Undefined context item");
        }
        if (!Type.subTypeOf(contextSequence.getItemType(), -1)) {
            throw new XPathException(this.getASTNode(), "XPDY0004: Context item is not a node");
        }
        String lang = this.getArgument(0).eval(contextSequence).getStringValue();
        Sequence seq = this.query.eval(contextSequence);
        if (seq.isEmpty()) {
            result = BooleanValue.FALSE;
        } else if (seq.hasOne()) {
            int hyphen;
            String langValue = seq.getStringValue();
            boolean include = lang.equalsIgnoreCase(langValue);
            if (!include && (hyphen = langValue.indexOf(45)) != -1) {
                langValue = langValue.substring(0, hyphen);
                include = lang.equalsIgnoreCase(langValue);
            }
            result = new BooleanValue(include);
        } else {
            throw new XPathException(this.getASTNode(), "XPDY0004: Sequence returned more than one item !");
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public int getDependencies() {
        return 1;
    }
}

