/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.DocumentImpl;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class FunRoot
extends Function {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("root", "http://www.w3.org/2005/xpath-functions"), "Returns the root of the tree to which the context node belongs. This will usually, but not necessarily, be a document node.", new SequenceType[0], new SequenceType(-1, 2)), new FunctionSignature(new QName("root", "http://www.w3.org/2005/xpath-functions"), "Returns the root of the tree to which $arg belongs. This will usually, but not necessarily, be a document node.", new SequenceType[]{new SequenceType(-1, 3)}, new SequenceType(-1, 3))};

    public FunRoot(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (contextSequence == null || contextSequence.isEmpty()) {
            Sequence sequence = Sequence.EMPTY_SEQUENCE;
        }
        if ((seq = this.getSignature().getArgumentCount() > 0 ? this.getArgument(0).eval(contextSequence, contextItem) : contextSequence) == null) {
            throw new XPathException(this.getASTNode(), "XPDY0002: Undefined context item");
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet(seq.getItemCount());
        int j = 0;
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            if (!Type.subTypeOf(item.getType(), -1)) {
                throw new XPathException(this.getASTNode(), "FOTY0011: item is not a node; got '" + item + "'");
            }
            NodeProxy p = item instanceof NodeProxy ? (NodeProxy)item : item.toSequence().toNodeSet().get(0);
            DocumentImpl doc = p.getDocument();
            if (doc.getCollection().isTempCollection()) {
                StoredNode trueRoot = (StoredNode)doc.getDocumentElement().getChildNodes().item(j);
                result.add((Item)new NodeProxy(trueRoot));
            } else {
                result.add((Item)new NodeProxy(((NodeProxy)item).getDocument()));
            }
            ++j;
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

