/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class QNameFunctions
extends BasicFunction {
    public static final FunctionSignature prefixFromQName = new FunctionSignature(new QName("prefix-from-QName", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:NCName representing the prefix of $a. If $a is the empty sequence, returns the empty sequence.", new SequenceType[]{new SequenceType(24, 3)}, new SequenceType(65, 3));
    public static final FunctionSignature localNameFromQName = new FunctionSignature(new QName("local-name-from-QName", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:NCName representing the local part of $a. If $a is the empty sequence, returns the empty sequence.", new SequenceType[]{new SequenceType(24, 3)}, new SequenceType(65, 3));
    public static final FunctionSignature namespaceURIFromQName = new FunctionSignature(new QName("namespace-uri-from-QName", "http://www.w3.org/2005/xpath-functions"), "Returns the namespace URI for $a. If $a is the empty sequence, returns the empty sequence.", new SequenceType[]{new SequenceType(24, 3)}, new SequenceType(25, 3));

    public QNameFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if (args[0].isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            QNameValue value = (QNameValue)args[0].itemAt(0);
            QName qname = value.getQName();
            if (this.isCalledAs("prefix-from-QName")) {
                String prefix = qname.getPrefix();
                result = prefix == null ? Sequence.EMPTY_SEQUENCE : new StringValue(prefix, 65);
            } else if (this.isCalledAs("local-name-from-QName")) {
                result = new StringValue(qname.getLocalName(), 65);
            } else {
                String uri = qname.getNamespaceURI();
                if (uri == null) {
                    uri = "";
                }
                result = new AnyURIValue(uri);
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

