/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.text;

import org.exist.dom.Match;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class MatchCount
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("match-count", "http://exist-db.org/xquery/text", "text"), "Counts the number of fulltext matches within the nodes and subnodes in $a.", new SequenceType[]{new SequenceType(-1, 3)}, new SequenceType(31, 2));

    public MatchCount(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        IntegerValue result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if (args[0].isEmpty()) {
            result = IntegerValue.ZERO;
        } else {
            int count = 0;
            SequenceIterator i = args[0].iterate();
            while (i.hasNext()) {
                Item next = i.nextItem();
                if (!Type.subTypeOf(next.getType(), -1)) continue;
                NodeValue nv = (NodeValue)next;
                if (nv.getImplementationType() != 1) {
                    throw new XPathException(this.getASTNode(), this.getName() + " cannot be applied to in-memory nodes.");
                }
                NodeProxy np = (NodeProxy)nv;
                for (Match match = np.getMatches(); match != null; match = match.getNextMatch()) {
                    if (!match.getNodeId().isDescendantOrSelfOf(np.getNodeId())) continue;
                    count += match.getFrequency();
                }
            }
            result = new IntegerValue(count);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

