/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.io.UnsupportedEncodingException;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Base64Binary;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class BinaryToString
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("binary-to-string", "http://exist-db.org/xquery/util", "util"), "Returns the contents of a binary resource as an xs:string value. The binary data is transformed into a Java string using the encoding specified in the optional second argument or UTF-8.", new SequenceType[]{new SequenceType(26, 3)}, new SequenceType(22, 3)), new FunctionSignature(new QName("binary-to-string", "http://exist-db.org/xquery/util", "util"), "Returns the contents of a binary resource as an xs:string value. The binary data is transformed into a Java string using the encoding specified in the optional second argument or UTF-8.", new SequenceType[]{new SequenceType(26, 3), new SequenceType(22, 2)}, new SequenceType(22, 3)), new FunctionSignature(new QName("string-to-binary", "http://exist-db.org/xquery/util", "util"), "Returns the contents of a binary resource as an xs:string value. The binary data is transformed into a Java string using the encoding specified in the optional second argument or UTF-8.", new SequenceType[]{new SequenceType(22, 3)}, new SequenceType(26, 3)), new FunctionSignature(new QName("string-to-binary", "http://exist-db.org/xquery/util", "util"), "Returns the contents of a binary resource as an xs:string value. The binary data is transformed into a Java string using the encoding specified in the optional second argument or UTF-8.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(22, 2)}, new SequenceType(26, 3))};

    public BinaryToString(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String encoding = "UTF-8";
        if (args.length == 2) {
            encoding = args[1].getStringValue();
        }
        if (this.isCalledAs("binary-to-string")) {
            Base64Binary binary = (Base64Binary)args[0].itemAt(0);
            byte[] data = binary.getBinaryData();
            try {
                return new StringValue(new String(data, encoding));
            }
            catch (UnsupportedEncodingException e) {
                throw new XPathException(this.getASTNode(), "Unsupported encoding: " + encoding);
            }
        }
        String str = args[0].getStringValue();
        try {
            byte[] data = str.getBytes(encoding);
            return new Base64Binary(data);
        }
        catch (UnsupportedEncodingException e) {
            throw new XPathException(this.getASTNode(), "Unsupported encoding: " + encoding);
        }
    }
}

