/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.text.Collator;
import java.util.Locale;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class Collations
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("collations", "http://exist-db.org/xquery/util", "util"), "Returns a sequence of strings containing all collation locales that might be specified in the '?lang=' parameter of a collation URI.", FunctionSignature.NO_ARGS, new SequenceType(22, 7));

    public Collations(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        ValueSequence result = new ValueSequence();
        Locale[] locales = Collator.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            String locale = locales[i].getLanguage();
            if (locales[i].getCountry().length() > 0) {
                locale = locale + '-' + locales[i].getCountry();
            }
            result.add(new StringValue(locale));
        }
        return result;
    }
}

