/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FileRead
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("file-read", "http://exist-db.org/xquery/util", "util"), "Read content of file $a", new SequenceType[]{new SequenceType(11, 2)}, new SequenceType(22, 3)), new FunctionSignature(new QName("file-read", "http://exist-db.org/xquery/util", "util"), "Read content of file $a with the encoding specified in $b.", new SequenceType[]{new SequenceType(11, 2), new SequenceType(22, 2)}, new SequenceType(22, 3))};

    public FileRead(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        StringWriter sw;
        String arg = args[0].itemAt(0).getStringValue();
        try {
            int len;
            InputStreamReader isr;
            URL url = new URL(arg);
            if (args.length > 1) {
                arg = args[1].itemAt(0).getStringValue();
                isr = new InputStreamReader(url.openStream(), arg);
            } else {
                isr = new InputStreamReader(url.openStream());
            }
            sw = new StringWriter();
            char[] buf = new char[1024];
            while ((len = isr.read(buf)) > 0) {
                sw.write(buf, 0, len);
            }
            isr.close();
            sw.close();
        }
        catch (MalformedURLException e) {
            throw new XPathException(this.getASTNode(), e.getMessage());
        }
        catch (IOException e) {
            throw new XPathException(this.getASTNode(), e.getMessage());
        }
        return new StringValue(sw.toString());
    }
}

