/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Properties;
import org.exist.dom.QName;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Option;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.xml.sax.SAXException;

public class Serialize
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("serialize", "http://exist-db.org/xquery/util", "util"), "Writes the node set passed in parameter $a into a file on the file system. The full path to the file is specified in parameter $b. $c contains a sequence of zero or more serialization parameters specified as key=value pairs. The serialization options are the same as those recognized by \"declare option exist:serialize\". The function does NOT automatically inherit the serialization options of the XQuery it is called from. False is returned if the specified file can not be created or is not writable, true on success. The empty sequence is returned if the argument sequence is empty.", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(22, 2), new SequenceType(22, 7)}, new SequenceType(23, 3)), new FunctionSignature(new QName("serialize", "http://exist-db.org/xquery/util", "util"), "Returns the Serialized node set passed in parameter $a. $b contains a sequence of zero or more serialization parameters specified as key=value pairs. The serialization options are the same as those recognized by \"declare option exist:serialize\". The function does NOT automatically inherit the serialization options of the XQuery it is called from.", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(22, 7)}, new SequenceType(22, 3))};

    public Serialize(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Properties outputProperties = null;
        OutputStream os = null;
        if (args.length == 3) {
            String path = args[1].itemAt(0).getStringValue();
            File file = new File(path);
            if (file.isDirectory()) {
                LOG.debug((Object)("Output file is a directory: " + file.getAbsolutePath()));
                return BooleanValue.FALSE;
            }
            if (file.exists() && !file.canWrite()) {
                LOG.debug((Object)("Cannot write to file " + file.getAbsolutePath()));
                return BooleanValue.FALSE;
            }
            outputProperties = this.parseSerializationOptions(args[2].iterate());
            try {
                os = new FileOutputStream(file);
            }
            catch (IOException e) {
                throw new XPathException(this.getASTNode(), "A problem ocurred while serializing the node set: " + e.getMessage(), e);
            }
            this.serialize(args[0].iterate(), outputProperties, os);
            return BooleanValue.TRUE;
        }
        outputProperties = this.parseSerializationOptions(args[1].iterate());
        os = new ByteArrayOutputStream();
        this.serialize(args[0].iterate(), outputProperties, os);
        try {
            String encoding = outputProperties.getProperty("encoding", "UTF-8");
            return new StringValue(new String(os.toByteArray(), encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new XPathException(this.getASTNode(), "A problem ocurred while serializing the node set: " + e.getMessage(), e);
        }
    }

    private Properties parseSerializationOptions(SequenceIterator siSerializeParams) throws XPathException {
        Properties outputProperties = new Properties();
        outputProperties.setProperty("indent", "yes");
        outputProperties.setProperty("omit-xml-declaration", "yes");
        while (siSerializeParams.hasNext()) {
            String[] opt = Option.parseKeyValuePair(siSerializeParams.nextItem().getStringValue());
            outputProperties.setProperty(opt[0], opt[1]);
        }
        return outputProperties;
    }

    private void serialize(SequenceIterator siNode, Properties outputProperties, OutputStream os) throws XPathException {
        SAXSerializer sax = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
        try {
            try {
                String encoding = outputProperties.getProperty("encoding", "UTF-8");
                OutputStreamWriter writer = new OutputStreamWriter(os, encoding);
                sax.setOutput(writer, outputProperties);
                Serializer serializer = this.context.getBroker().getSerializer();
                serializer.reset();
                serializer.setProperties(outputProperties);
                serializer.setReceiver(sax);
                sax.startDocument();
                while (siNode.hasNext()) {
                    NodeValue next = (NodeValue)siNode.nextItem();
                    serializer.toSAX(next);
                }
                sax.endDocument();
                ((Writer)writer).close();
            }
            catch (SAXException e) {
                throw new XPathException(this.getASTNode(), "A problem ocurred while serializing the node set: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new XPathException(this.getASTNode(), "A problem ocurred while serializing the node set: " + e.getMessage(), e);
            }
            Object var10_11 = null;
            SerializerPool.getInstance().returnObject(sax);
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            SerializerPool.getInstance().returnObject(sax);
            throw throwable;
        }
    }
}

