/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.update;

import org.exist.EXistException;
import org.exist.dom.AttrImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.ElementImpl;
import org.exist.dom.NodeImpl;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.NotificationService;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.update.Modification;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.util.Messages;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class Rename
extends Modification {
    public Rename(XQueryContext context, Expression select, Expression value) {
        super(context, select, value);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence contentSeq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((contentSeq = this.value.eval(contextSequence)).isEmpty()) {
            throw new XPathException(this.getASTNode(), Messages.getMessage("D09"));
        }
        Sequence inSeq = this.select.eval(contextSequence);
        if (!Type.subTypeOf(inSeq.getItemType(), -1)) {
            ValueSequence prevUpdateErrors = null;
            XPathException xpe = new XPathException(this.getASTNode(), Messages.getMessage("D08"));
            Object ctxVarObj = this.context.getXQueryContextVar("_eXist_xquery_update_error");
            prevUpdateErrors = ctxVarObj == null ? new ValueSequence() : (ValueSequence)XPathUtil.javaObjectToXPath(ctxVarObj, this.context);
            prevUpdateErrors.add(new StringValue(xpe.getMessage()));
            this.context.setXQueryContextVar("_eXist_xquery_update_error", prevUpdateErrors);
            if (!inSeq.isEmpty()) {
                throw xpe;
            }
        }
        if (!inSeq.isEmpty()) {
            Item item = contentSeq.itemAt(0);
            QName newQName = item.getType() == 24 ? ((QNameValue)item).getQName() : QName.parse(this.context, item.getStringValue());
            try {
                Txn transaction = this.getTransaction();
                StoredNode[] ql = this.selectAndLock(transaction, inSeq.toNodeSet());
                Modification.IndexListener listener = new Modification.IndexListener(ql);
                NotificationService notifier = this.context.getBroker().getBrokerPool().getNotificationService();
                for (int i = 0; i < ql.length; ++i) {
                    StoredNode node = ql[i];
                    DocumentImpl doc = (DocumentImpl)node.getOwnerDocument();
                    if (!doc.getPermissions().validate(this.context.getUser(), 1)) {
                        throw new XPathException(this.getASTNode(), "permission denied to update document");
                    }
                    doc.getMetadata().setIndexListener(listener);
                    NodeImpl parent = (NodeImpl)node.getParentNode();
                    switch (node.getNodeType()) {
                        case 1: {
                            ElementImpl newElem = new ElementImpl((ElementImpl)node);
                            newElem.setNodeName(newQName);
                            parent.updateChild(transaction, node, newElem);
                            break;
                        }
                        case 2: {
                            AttrImpl newAttr = new AttrImpl((AttrImpl)node);
                            newAttr.setNodeName(newQName);
                            parent.updateChild(transaction, node, newAttr);
                            break;
                        }
                        default: {
                            throw new XPathException(this.getASTNode(), "unsupported node-type");
                        }
                    }
                    doc.getMetadata().clearIndexListener();
                    doc.getMetadata().setLastModified(System.currentTimeMillis());
                    this.modifiedDocuments.add(doc);
                    this.context.getBroker().storeXMLResource(transaction, doc);
                    notifier.notifyUpdate(doc, 1);
                }
                this.finishTriggers(transaction);
                this.commitTransaction(transaction);
            }
            catch (PermissionDeniedException e) {
                throw new XPathException(this.getASTNode(), e.getMessage(), e);
            }
            catch (EXistException e) {
                throw new XPathException(this.getASTNode(), e.getMessage(), e);
            }
            catch (LockException e) {
                throw new XPathException(this.getASTNode(), e.getMessage(), e);
            }
            finally {
                this.unlockDocuments();
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", Sequence.EMPTY_SEQUENCE);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("update rename").nl();
        dumper.startIndent();
        this.select.dump(dumper);
        dumper.endIndent();
        dumper.nl().display(" to ").nl();
        dumper.startIndent();
        this.value.dump(dumper);
        dumper.nl().endIndent();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("update rename ");
        result.append(this.select.toString());
        result.append(" as ");
        result.append(this.value.toString());
        return result.toString();
    }
}

