/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.util;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.exist.xmldb.XmldbURI;

public class URIUtils {
    public static String encodeForURI(String uriPart) {
        String result = URIUtils.urlEncodeUtf8(uriPart);
        result = result.replaceAll("\\+", "%20");
        result = result.replaceAll("%2D", "-");
        result = result.replaceAll("%5F", "_");
        result = result.replaceAll("%2E", ".");
        result = result.replaceAll("%7E", "~");
        result = result.replaceAll("\\*", "%2A");
        return result;
    }

    public static String iriToURI(String uriPart) {
        String result = URIUtils.urlEncodeUtf8(uriPart);
        result = result.replaceAll("%23", "#");
        result = result.replaceAll("%2D", "-");
        result = result.replaceAll("%5F", "_");
        result = result.replaceAll("%2E", ".");
        result = result.replaceAll("%21", "!");
        result = result.replaceAll("%7E", "~");
        result = result.replaceAll("%2A", "*");
        result = result.replaceAll("%27", "'");
        result = result.replaceAll("%28", "(");
        result = result.replaceAll("%29", ")");
        result = result.replaceAll("%3B", ";");
        result = result.replaceAll("%2F", "/");
        result = result.replaceAll("%3F", "?");
        result = result.replaceAll("%3A", ":");
        result = result.replaceAll("%40", "@");
        result = result.replaceAll("%26", "&");
        result = result.replaceAll("%3D", "=");
        result = result.replaceAll("%2B", "+");
        result = result.replaceAll("%24", "\\$");
        result = result.replaceAll("%2C", ",");
        result = result.replaceAll("%5B", "[");
        result = result.replaceAll("%5D", "]");
        result = result.replaceAll("%25", "%");
        return result;
    }

    public static String escapeHtmlURI(String uri) {
        String result = URIUtils.urlEncodeUtf8(uri);
        result = result.replaceAll("\\+", " ");
        result = result.replaceAll("%20", " ");
        result = result.replaceAll("%23", "#");
        result = result.replaceAll("%2D", "-");
        result = result.replaceAll("%5F", "_");
        result = result.replaceAll("%2E", ".");
        result = result.replaceAll("%21", "!");
        result = result.replaceAll("%7E", "~");
        result = result.replaceAll("%2A", "*");
        result = result.replaceAll("%27", "'");
        result = result.replaceAll("%28", "(");
        result = result.replaceAll("%29", ")");
        result = result.replaceAll("%3B", ";");
        result = result.replaceAll("%2F", "/");
        result = result.replaceAll("%3F", "?");
        result = result.replaceAll("%3A", ":");
        result = result.replaceAll("%40", "@");
        result = result.replaceAll("%26", "&");
        result = result.replaceAll("%3D", "=");
        result = result.replaceAll("%2B", "+");
        result = result.replaceAll("%24", "\\$");
        result = result.replaceAll("%2C", ",");
        result = result.replaceAll("%5B", "[");
        result = result.replaceAll("%5D", "]");
        result = result.replaceAll("%25", "%");
        return result;
    }

    public static String urlEncodeUtf8(String uri) {
        try {
            String almostEncoded = URLEncoder.encode(uri, "UTF-8");
            return almostEncoded.replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String urlDecodeUtf8(String uri) {
        try {
            return URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String urlDecodeUtf8(XmldbURI uri) {
        try {
            return URLDecoder.decode(uri.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String urlEncodePartsUtf8(String url) {
        String[] split = url.split("/", -1);
        StringBuffer ret = new StringBuffer(url.length());
        for (int i = 0; i < split.length; ++i) {
            ret.append(URIUtils.urlEncodeUtf8(split[i]));
            if (i >= split.length - 1) continue;
            ret.append("/");
        }
        return ret.toString();
    }

    public static String ensureUrlEncodedUtf8(String path) {
        try {
            XmldbURI uri = XmldbURI.xmldbUriFor(path);
            return uri.getRawCollectionPath();
        }
        catch (URISyntaxException e) {
            return URIUtils.urlEncodePartsUtf8(path);
        }
    }

    public static XmldbURI encodeXmldbUriFor(String path) throws URISyntaxException {
        return XmldbURI.xmldbUriFor(URIUtils.urlEncodePartsUtf8(path));
    }
}

