/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import org.exist.util.Base64Decoder;
import org.exist.util.Base64Encoder;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.HexBinary;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;

public class Base64Binary
extends BinaryValue {
    public Base64Binary(byte[] data) {
        super(data);
    }

    public Base64Binary(String str) throws XPathException {
        Base64Decoder dec = new Base64Decoder();
        try {
            dec.translate(str);
        }
        catch (IllegalArgumentException e) {
            throw new XPathException("cannot build " + Type.getTypeName(this.getType()) + " from '" + str + "'. " + e.getMessage());
        }
        this.data = dec.getByteArray();
    }

    public int getType() {
        return 26;
    }

    public String getStringValue() throws XPathException {
        Base64Encoder enc = new Base64Encoder();
        enc.translate(this.data);
        return new String(enc.getCharArray());
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        Base64Encoder enc = new Base64Encoder();
        switch (requiredType) {
            case 26: {
                return this;
            }
            case 27: {
                return new HexBinary(this.data);
            }
            case 21: {
                enc.translate(this.data);
                return new UntypedAtomicValue(new String(enc.getCharArray()).trim());
            }
            case 22: {
                enc.translate(this.data);
                return new StringValue(new String(enc.getCharArray()).trim());
            }
        }
        throw new XPathException("cannot convert " + Type.getTypeName(this.getType()) + " to " + Type.getTypeName(requiredType));
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(Base64Binary.class)) {
            return this;
        }
        if (target == [B.class) {
            return this.data;
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }

    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException("FORG0006: value of type " + Type.getTypeName(this.getType()) + " has no boolean value.");
    }
}

