/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.util.Hashtable;
import java.util.Iterator;
import org.exist.xquery.GroupSpec;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.GroupedValueSequence;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.ValueSequence;

public class GroupedValueSequenceTable
extends Hashtable {
    private GroupSpec[] groupSpecs;
    private String toGroupVarName;
    private XQueryContext context;

    public GroupedValueSequenceTable(GroupSpec[] groupSpecs, String varName, XQueryContext aContext) {
        super(11, 0.75f);
        this.groupSpecs = groupSpecs;
        this.toGroupVarName = varName;
        this.context = aContext;
    }

    public void setToGroupVarName(String varName) {
        this.toGroupVarName = varName;
    }

    public String getToGroupVarName() {
        return this.toGroupVarName;
    }

    public Iterator iterate() {
        Iterator it = this.keySet().iterator();
        return it;
    }

    public void add(Item item) throws XPathException {
        Sequence[] specEvaluation = new Sequence[this.groupSpecs.length];
        ValueSequence keySequence = new ValueSequence();
        for (int i = 0; i < this.groupSpecs.length; ++i) {
            specEvaluation[i] = this.groupSpecs[i].getGroupExpression().eval(item.toSequence());
            keySequence.add(specEvaluation[i].itemAt(0));
        }
        String hashKey = keySequence.getHashKey();
        if (this.containsKey(hashKey)) {
            GroupedValueSequence currentGroup = (GroupedValueSequence)super.get(hashKey);
            currentGroup.add(item);
        } else {
            GroupedValueSequence newGroup = new GroupedValueSequence(this.groupSpecs, 1, keySequence, this.context);
            newGroup.add(item);
            super.put(hashKey, newGroup);
        }
    }

    public void addAll(Sequence sequence) throws XPathException {
        SequenceIterator i = sequence.iterate();
        while (i.hasNext()) {
            this.add(i.nextItem());
        }
    }
}

