/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import org.exist.dom.QName;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;

public class QNameValue
extends AtomicValue {
    private XQueryContext context;
    private QName qname;
    private String stringValue;

    public QNameValue(XQueryContext context, String name) throws XPathException {
        if (name.length() == 0) {
            throw new XPathException("err:FORG0001: An empty string is not a valid lexical representation of xs:QName.");
        }
        this.context = context;
        try {
            this.qname = QName.parse(context, name, context.getURIForPrefix(""));
        }
        catch (Exception e) {
            throw new XPathException(e);
        }
        this.stringValue = this.computeStringValue();
    }

    public QNameValue(XQueryContext context, QName name) {
        this.context = context;
        this.qname = name;
        this.stringValue = this.computeStringValue();
    }

    public int getType() {
        return 24;
    }

    public QName getQName() {
        return this.qname;
    }

    public String getStringValue() throws XPathException {
        return this.stringValue;
    }

    private String computeStringValue() {
        String prefix = this.qname.getPrefix();
        if ((prefix == null || "".equals(prefix)) && this.qname.needsNamespaceDecl() && (prefix = this.context.getPrefixForURI(this.qname.getNamespaceURI())) != null) {
            this.qname.setPrefix(prefix);
        }
        if (prefix != null && prefix.length() > 0) {
            return prefix + ':' + this.qname.getLocalName();
        }
        return this.qname.getLocalName();
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 24: {
                return this;
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 21: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        throw new XPathException("A QName cannot be converted to " + Type.getTypeName(requiredType));
    }

    public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
        if (other.getType() == 24) {
            int cmp = this.qname.compareTo(((QNameValue)other).qname);
            switch (operator) {
                case 4: {
                    return cmp == 0;
                }
                case 5: {
                    return cmp != 0;
                }
            }
            throw new XPathException("XPTY0004 : cannot apply operator to QName");
        }
        throw new XPathException("Type error: cannot compare QName to " + Type.getTypeName(other.getType()));
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 24) {
            return this.qname.compareTo(((QNameValue)other).qname);
        }
        throw new XPathException("Type error: cannot compare QName to " + Type.getTypeName(other.getType()));
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Invalid argument to aggregate function: QName");
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Invalid argument to aggregate function: QName");
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(QNameValue.class)) {
            return 0;
        }
        if (javaClass == String.class) {
            return 1;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(QNameValue.class)) {
            return this;
        }
        if (target == String.class) {
            return this.getStringValue();
        }
        if (target == Object.class) {
            return this.qname;
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }

    public String toString() {
        try {
            return this.getStringValue();
        }
        catch (XPathException e) {
            return super.toString();
        }
    }

    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException("err:FORG0006: value of type " + Type.getTypeName(this.getType()) + " has no boolean value.");
    }
}

