/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.util.HashSet;
import org.exist.dom.QName;
import org.exist.util.hashtable.Int2ObjectHashMap;
import org.exist.util.hashtable.Object2IntHashMap;
import org.exist.xquery.XPathException;

public class Type {
    public static final String[] NODETYPES = new String[]{"node", "element", "attribute", "text", "processing-instruction", "comment", "document", "namespace", "cdata-section"};
    public static final int NODE = -1;
    public static final int ELEMENT = 1;
    public static final int ATTRIBUTE = 2;
    public static final int TEXT = 3;
    public static final int PROCESSING_INSTRUCTION = 4;
    public static final int COMMENT = 5;
    public static final int DOCUMENT = 6;
    public static final int NAMESPACE = 500;
    public static final int CDATA_SECTION = 501;
    public static final int EMPTY = 10;
    public static final int ITEM = 11;
    public static final int ANY_TYPE = 12;
    public static final int ANY_SIMPLE_TYPE = 13;
    public static final int UNTYPED = 14;
    public static final int ATOMIC = 20;
    public static final int UNTYPED_ATOMIC = 21;
    public static final int STRING = 22;
    public static final int BOOLEAN = 23;
    public static final int QNAME = 24;
    public static final int ANY_URI = 25;
    public static final int BASE64_BINARY = 26;
    public static final int HEX_BINARY = 27;
    public static final int NOTATION = 28;
    public static final int NUMBER = 30;
    public static final int INTEGER = 31;
    public static final int DECIMAL = 32;
    public static final int FLOAT = 33;
    public static final int DOUBLE = 34;
    public static final int NON_POSITIVE_INTEGER = 35;
    public static final int NEGATIVE_INTEGER = 36;
    public static final int LONG = 37;
    public static final int INT = 38;
    public static final int SHORT = 39;
    public static final int BYTE = 40;
    public static final int NON_NEGATIVE_INTEGER = 41;
    public static final int UNSIGNED_LONG = 42;
    public static final int UNSIGNED_INT = 43;
    public static final int UNSIGNED_SHORT = 44;
    public static final int UNSIGNED_BYTE = 45;
    public static final int POSITIVE_INTEGER = 46;
    public static final int DATE_TIME = 50;
    public static final int DATE = 51;
    public static final int TIME = 52;
    public static final int DURATION = 53;
    public static final int YEAR_MONTH_DURATION = 54;
    public static final int DAY_TIME_DURATION = 55;
    public static final int GYEAR = 56;
    public static final int GMONTH = 57;
    public static final int GDAY = 58;
    public static final int GYEARMONTH = 59;
    public static final int GMONTHDAY = 71;
    public static final int TOKEN = 60;
    public static final int NORMALIZED_STRING = 61;
    public static final int LANGUAGE = 62;
    public static final int NMTOKEN = 63;
    public static final int NAME = 64;
    public static final int NCNAME = 65;
    public static final int ID = 66;
    public static final int IDREF = 67;
    public static final int ENTITY = 68;
    public static final int JAVA_OBJECT = 100;
    public static final int FUNCTION_REFERENCE = 101;
    public static final int IDX_FULLTEXT = 200;
    private static final Int2ObjectHashMap typeHierarchy = new Int2ObjectHashMap();
    private static final Int2ObjectHashMap typeNames;
    private static final Object2IntHashMap typeCodes;

    public static final void defineBuiltInType(int type, String name) {
        typeNames.put(type, name);
        typeCodes.put(name, type);
    }

    public static final String getTypeName(int type) {
        return (String)typeNames.get(type);
    }

    public static final int getType(String name) throws XPathException {
        int code = typeCodes.get(name);
        if (code == -1) {
            throw new XPathException("Type: " + name + " is not defined");
        }
        return code;
    }

    public static final int getType(QName qname) throws XPathException {
        String uri = qname.getNamespaceURI();
        if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
            return Type.getType("xs:" + qname.getLocalName());
        }
        if (uri.equals("http://www.w3.org/2003/05/xpath-datatypes")) {
            return Type.getType("xdt:" + qname.getLocalName());
        }
        return Type.getType(qname.getLocalName());
    }

    public static final void defineSubType(int supertype, int subtype) {
        typeHierarchy.put(subtype, new Integer(supertype));
    }

    public static final boolean subTypeOf(int subtype, int supertype) {
        if (subtype == supertype) {
            return true;
        }
        if (supertype == 11 || supertype == 12) {
            return true;
        }
        if (subtype == 11 || subtype == 10 || subtype == 12) {
            return false;
        }
        if (!typeHierarchy.containsKey(subtype)) {
            throw new IllegalArgumentException("type " + subtype + " is not a valid type");
        }
        subtype = (Integer)typeHierarchy.get(subtype);
        return Type.subTypeOf(subtype, supertype);
    }

    public static final int getSuperType(int subtype) {
        if (subtype == 11) {
            return 11;
        }
        Integer i = (Integer)typeHierarchy.get(subtype);
        if (i == null) {
            System.err.println("no supertype for " + Type.getTypeName(subtype));
            return 11;
        }
        return i;
    }

    public static int getCommonSuperType(int type1, int type2) {
        if (type1 == type2) {
            return type1;
        }
        HashSet<Integer> t1 = new HashSet<Integer>();
        int t = type1;
        while (t != 11) {
            if (t == type2) {
                return t;
            }
            t1.add(new Integer(t));
            t = Type.getSuperType(t);
        }
        t = Type.getSuperType(type2);
        while (t != 11) {
            if (t1.contains(new Integer(t))) {
                return t;
            }
            t = Type.getSuperType(t);
        }
        return 11;
    }

    static {
        Type.defineSubType(12, 13);
        Type.defineSubType(12, 14);
        Type.defineSubType(13, 20);
        Type.defineSubType(11, -1);
        Type.defineSubType(-1, 1);
        Type.defineSubType(-1, 2);
        Type.defineSubType(-1, 3);
        Type.defineSubType(-1, 4);
        Type.defineSubType(-1, 5);
        Type.defineSubType(-1, 6);
        Type.defineSubType(-1, 500);
        Type.defineSubType(-1, 501);
        Type.defineSubType(11, 20);
        Type.defineSubType(20, 22);
        Type.defineSubType(20, 23);
        Type.defineSubType(20, 24);
        Type.defineSubType(20, 25);
        Type.defineSubType(20, 30);
        Type.defineSubType(20, 21);
        Type.defineSubType(20, 100);
        Type.defineSubType(20, 101);
        Type.defineSubType(20, 50);
        Type.defineSubType(20, 51);
        Type.defineSubType(20, 52);
        Type.defineSubType(20, 53);
        Type.defineSubType(20, 56);
        Type.defineSubType(20, 57);
        Type.defineSubType(20, 58);
        Type.defineSubType(20, 59);
        Type.defineSubType(20, 71);
        Type.defineSubType(20, 26);
        Type.defineSubType(20, 27);
        Type.defineSubType(20, 28);
        Type.defineSubType(53, 54);
        Type.defineSubType(53, 55);
        Type.defineSubType(30, 32);
        Type.defineSubType(30, 33);
        Type.defineSubType(30, 34);
        Type.defineSubType(32, 31);
        Type.defineSubType(31, 35);
        Type.defineSubType(35, 36);
        Type.defineSubType(31, 37);
        Type.defineSubType(37, 38);
        Type.defineSubType(38, 39);
        Type.defineSubType(39, 40);
        Type.defineSubType(31, 41);
        Type.defineSubType(41, 46);
        Type.defineSubType(41, 42);
        Type.defineSubType(42, 43);
        Type.defineSubType(43, 44);
        Type.defineSubType(44, 45);
        Type.defineSubType(22, 61);
        Type.defineSubType(61, 60);
        Type.defineSubType(60, 62);
        Type.defineSubType(60, 63);
        Type.defineSubType(60, 64);
        Type.defineSubType(64, 65);
        Type.defineSubType(65, 66);
        Type.defineSubType(65, 67);
        Type.defineSubType(65, 68);
        typeNames = new Int2ObjectHashMap(100);
        typeCodes = new Object2IntHashMap(100);
        Type.defineBuiltInType(-1, "node()");
        Type.defineBuiltInType(11, "item()");
        Type.defineBuiltInType(10, "empty()");
        Type.defineBuiltInType(1, "element()");
        Type.defineBuiltInType(6, "document()");
        Type.defineBuiltInType(2, "attribute()");
        Type.defineBuiltInType(3, "text()");
        Type.defineBuiltInType(4, "processing-instruction()");
        Type.defineBuiltInType(5, "comment()");
        Type.defineBuiltInType(500, "namespace()");
        Type.defineBuiltInType(501, "cdata-section()");
        Type.defineBuiltInType(100, "object");
        Type.defineBuiltInType(101, "function");
        Type.defineBuiltInType(30, "numeric");
        Type.defineBuiltInType(12, "xs:anyType");
        Type.defineBuiltInType(13, "xs:anySimpleType");
        Type.defineBuiltInType(14, "xs:untyped");
        Type.defineBuiltInType(20, "xs:anyAtomicType");
        Type.defineBuiltInType(20, "xdt:anyAtomicType");
        Type.defineBuiltInType(21, "xs:untypedAtomic");
        Type.defineBuiltInType(21, "xdt:untypedAtomic");
        Type.defineBuiltInType(23, "xs:boolean");
        Type.defineBuiltInType(32, "xs:decimal");
        Type.defineBuiltInType(33, "xs:float");
        Type.defineBuiltInType(34, "xs:double");
        Type.defineBuiltInType(31, "xs:integer");
        Type.defineBuiltInType(35, "xs:nonPositiveInteger");
        Type.defineBuiltInType(36, "xs:negativeInteger");
        Type.defineBuiltInType(37, "xs:long");
        Type.defineBuiltInType(38, "xs:int");
        Type.defineBuiltInType(39, "xs:short");
        Type.defineBuiltInType(40, "xs:byte");
        Type.defineBuiltInType(41, "xs:nonNegativeInteger");
        Type.defineBuiltInType(42, "xs:unsignedLong");
        Type.defineBuiltInType(43, "xs:unsignedInt");
        Type.defineBuiltInType(44, "xs:unsignedShort");
        Type.defineBuiltInType(45, "xs:unsignedByte");
        Type.defineBuiltInType(46, "xs:positiveInteger");
        Type.defineBuiltInType(22, "xs:string");
        Type.defineBuiltInType(24, "xs:QName");
        Type.defineBuiltInType(25, "xs:anyURI");
        Type.defineBuiltInType(26, "xs:base64Binary");
        Type.defineBuiltInType(27, "xs:hexBinary");
        Type.defineBuiltInType(28, "xs:NOTATION");
        Type.defineBuiltInType(50, "xs:dateTime");
        Type.defineBuiltInType(51, "xs:date");
        Type.defineBuiltInType(52, "xs:time");
        Type.defineBuiltInType(53, "xs:duration");
        Type.defineBuiltInType(56, "xs:gYear");
        Type.defineBuiltInType(57, "xs:gMonth");
        Type.defineBuiltInType(58, "xs:gDay");
        Type.defineBuiltInType(59, "xs:gYearMonth");
        Type.defineBuiltInType(71, "xs:gMonthDay");
        Type.defineBuiltInType(54, "xs:yearMonthDuration");
        Type.defineBuiltInType(54, "xdt:yearMonthDuration");
        Type.defineBuiltInType(55, "xs:dayTimeDuration");
        Type.defineBuiltInType(55, "xdt:dayTimeDuration");
        Type.defineBuiltInType(61, "xs:normalizedString");
        Type.defineBuiltInType(60, "xs:token");
        Type.defineBuiltInType(62, "xs:language");
        Type.defineBuiltInType(63, "xs:NMTOKEN");
        Type.defineBuiltInType(64, "xs:Name");
        Type.defineBuiltInType(65, "xs:NCName");
        Type.defineBuiltInType(66, "xs:ID");
        Type.defineBuiltInType(67, "xs:IDREF");
        Type.defineBuiltInType(68, "xs:ENTITY");
    }
}

