/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xupdate;

import java.util.Map;
import org.exist.EXistException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeImpl;
import org.exist.dom.StoredNode;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.NotificationService;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xquery.XPathException;
import org.exist.xupdate.Modification;
import org.w3c.dom.NodeList;

public class Insert
extends Modification {
    public static final int INSERT_BEFORE = 0;
    public static final int INSERT_AFTER = 1;
    private int mode = 0;

    public Insert(DBBroker broker, DocumentSet docs, String selectStmt, Map namespaces, Map variables) {
        super(broker, docs, selectStmt, namespaces, variables);
    }

    public Insert(DBBroker broker, DocumentSet docs, String selectStmt, int mode, Map namespaces, Map variables) {
        this(broker, docs, selectStmt, namespaces, variables);
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long process(Txn transaction) throws PermissionDeniedException, LockException, EXistException, XPathException {
        NodeList children = this.content;
        if (children.getLength() == 0) {
            return 0L;
        }
        try {
            StoredNode[] ql = this.selectAndLock(transaction);
            Modification.IndexListener listener = new Modification.IndexListener(ql);
            NotificationService notifier = this.broker.getBrokerPool().getNotificationService();
            int len = children.getLength();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("found " + len + " nodes to insert"));
            }
            for (int i = 0; i < ql.length; ++i) {
                StoredNode node = ql[i];
                DocumentImpl doc = (DocumentImpl)node.getOwnerDocument();
                doc.getMetadata().setIndexListener(listener);
                if (!doc.getPermissions().validate(this.broker.getUser(), 1)) {
                    throw new PermissionDeniedException("permission to update document denied");
                }
                NodeImpl parent = (NodeImpl)node.getParentNode();
                switch (this.mode) {
                    case 0: {
                        parent.insertBefore(transaction, children, node);
                        break;
                    }
                    case 1: {
                        parent.insertAfter(transaction, children, node);
                    }
                }
                doc.getMetadata().clearIndexListener();
                doc.getMetadata().setLastModified(System.currentTimeMillis());
                this.modifiedDocuments.add(doc);
                this.broker.storeXMLResource(transaction, doc);
                notifier.notifyUpdate(doc, 1);
            }
            this.checkFragmentation(transaction, this.modifiedDocuments);
            long l = ql.length;
            return l;
        }
        finally {
            this.unlockDocuments(transaction);
        }
    }

    public String getName() {
        return this.mode == 0 ? "insert-before" : "insert-after";
    }
}

