/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xupdate;

import java.util.Map;
import org.exist.EXistException;
import org.exist.dom.AttrImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ElementImpl;
import org.exist.dom.StoredNode;
import org.exist.dom.TextImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.NotificationService;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xquery.XPathException;
import org.exist.xupdate.Modification;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Update
extends Modification {
    public Update(DBBroker broker, DocumentSet docs, String selectStmt, Map namespaces, Map variables) {
        super(broker, docs, selectStmt, namespaces, variables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long process(Txn transaction) throws PermissionDeniedException, LockException, EXistException, XPathException {
        NodeList children = this.content;
        if (children.getLength() == 0) {
            return 0L;
        }
        int modifications = children.getLength();
        try {
            StoredNode[] ql = this.selectAndLock(transaction);
            Modification.IndexListener listener = new Modification.IndexListener(ql);
            NotificationService notifier = this.broker.getBrokerPool().getNotificationService();
            for (int i = 0; i < ql.length; ++i) {
                StoredNode node = ql[i];
                if (node == null) {
                    LOG.warn((Object)("select " + this.selectStmt + " returned empty node"));
                    continue;
                }
                DocumentImpl doc = (DocumentImpl)node.getOwnerDocument();
                doc.getMetadata().setIndexListener(listener);
                if (!doc.getPermissions().validate(this.broker.getUser(), 1)) {
                    throw new PermissionDeniedException("permission to update document denied");
                }
                switch (node.getNodeType()) {
                    case 1: {
                        if (modifications == 0) {
                            modifications = 1;
                        }
                        ((ElementImpl)node).update(transaction, children);
                        break;
                    }
                    case 3: {
                        ElementImpl parent = (ElementImpl)node.getParentNode();
                        Node temp = children.item(0);
                        TextImpl text = new TextImpl(temp.getNodeValue());
                        modifications = 1;
                        text.setOwnerDocument(doc);
                        parent.updateChild(transaction, node, text);
                        break;
                    }
                    case 2: {
                        ElementImpl parent = (ElementImpl)node.getParentNode();
                        if (parent == null) {
                            LOG.warn((Object)("parent node not found for " + node.getNodeId()));
                            break;
                        }
                        AttrImpl attr = (AttrImpl)node;
                        Node temp = children.item(0);
                        AttrImpl attribute = new AttrImpl(attr.getQName(), temp.getNodeValue());
                        attribute.setOwnerDocument(doc);
                        parent.updateChild(transaction, node, attribute);
                        break;
                    }
                    default: {
                        throw new EXistException("unsupported node-type");
                    }
                }
                doc.getMetadata().clearIndexListener();
                doc.getMetadata().setLastModified(System.currentTimeMillis());
                this.modifiedDocuments.add(doc);
                this.broker.storeXMLResource(transaction, doc);
                notifier.notifyUpdate(doc, 1);
            }
            this.checkFragmentation(transaction, this.modifiedDocuments);
        }
        finally {
            this.unlockDocuments(transaction);
        }
        return modifications;
    }

    public String getName() {
        return "update";
    }
}

