/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import net.sf.flatpack.AbstractParser;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.DefaultDataSet;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.structure.Row;
import net.sf.flatpack.util.ParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDelimiterParser
extends AbstractParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDelimiterParser.class);
    private static final String LINE_BREAK = System.lineSeparator();
    private char delimiter = '\u0000';
    private char qualifier = '\u0000';
    private boolean ignoreFirstRecord = false;
    private int lineCount = 0;

    public AbstractDelimiterParser(Reader dataSourceReader, String dataDefinition, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(dataSourceReader, dataDefinition);
        this.delimiter = delimiter;
        this.qualifier = qualifier;
        this.ignoreFirstRecord = ignoreFirstRecord;
    }

    public AbstractDelimiterParser(Reader dataSourceReader, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(dataSourceReader);
        this.delimiter = delimiter;
        this.qualifier = qualifier;
        this.ignoreFirstRecord = ignoreFirstRecord;
    }

    @Override
    protected DataSet doParse() {
        try {
            this.lineCount = 0;
            return this.doDelimitedFile(this.getDataSourceReader(), this.shouldCreateMDFromFile());
        }
        catch (IOException e) {
            LOGGER.error("error accessing/creating inputstream", (Throwable)e);
            return null;
        }
    }

    protected abstract boolean shouldCreateMDFromFile();

    protected char getDelimiter() {
        return this.delimiter;
    }

    protected void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    protected boolean isIgnoreFirstRecord() {
        return this.ignoreFirstRecord;
    }

    protected void setIgnoreFirstRecord(boolean ignoreFirstRecord) {
        this.ignoreFirstRecord = ignoreFirstRecord;
    }

    protected char getQualifier() {
        return this.qualifier;
    }

    protected void setQualifier(char qualifier) {
        this.qualifier = qualifier;
    }

    protected int getLineCount() {
        return this.lineCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataSet doDelimitedFile(Reader dataSource, boolean createMDFromFile) throws IOException {
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource is null");
        }
        DefaultDataSet ds = new DefaultDataSet(this.getPzMetaData(), this);
        try (BufferedReader br = new BufferedReader(dataSource);){
            ds.setPZConvertProps(ParserUtils.loadConvertProperties());
            boolean processedFirst = false;
            String line = null;
            int estimatedColCount = 10;
            while ((line = this.fetchNextRecord(br, this.getQualifier(), this.getDelimiter())) != null) {
                String mdkey;
                List<String> columns;
                block29: {
                    int columnCount;
                    if (!processedFirst && this.isIgnoreFirstRecord()) {
                        processedFirst = true;
                        continue;
                    }
                    if (!processedFirst && createMDFromFile) {
                        processedFirst = true;
                        this.setPzMetaData(ParserUtils.getPZMetaDataFromFile(line, this.delimiter, this.qualifier, this, this.isAddSuffixToDuplicateColumnNames()));
                        ds.setMetaData(this.getPzMetaData());
                        continue;
                    }
                    if (this.oddNumberOfQualifier(line, this.getQualifier())) {
                        this.addError(ds, "Odd number of Qualifier characters", this.lineCount, 1, this.isStoreRawDataToDataError() ? line : null);
                        continue;
                    }
                    columns = ParserUtils.splitLine(line, this.getDelimiter(), this.getQualifier(), estimatedColCount, this.isPreserveLeadingWhitespace(), this.isPreserveTrailingWhitespace());
                    mdkey = ParserUtils.getCMDKeyForDelimitedFile(this.getPzMetaData(), columns);
                    List<ColumnMetaData> metaData = ParserUtils.getColumnMetaData(mdkey, this.getPzMetaData());
                    estimatedColCount = columnCount = metaData.size();
                    if (columns.size() > columnCount) {
                        if (this.isIgnoreExtraColumns()) {
                            columns = columns.subList(0, columnCount);
                            this.addError(ds, "Flatpack truncated line to correct number of columns", this.lineCount, 1, this.isStoreRawDataToDataError() ? line : null);
                            break block29;
                        } else {
                            this.addError(ds, "Too many columns expected: " + columnCount + " Flatpack got: " + columns.size(), this.lineCount, 2, this.isStoreRawDataToDataError() ? line : null);
                            continue;
                        }
                    }
                    if (columns.size() < columnCount) {
                        if (this.isHandlingShortLines()) {
                            while (columns.size() < columnCount) {
                                columns.add("");
                            }
                            this.addError(ds, "Flatpack padded line to correct number of columns", this.lineCount, 1, this.isStoreRawDataToDataError() ? line : null);
                        } else {
                            this.addError(ds, "Too few columns expected: " + columnCount + " only got: " + columns.size(), this.lineCount, 2, this.isStoreRawDataToDataError() ? line : null);
                            continue;
                        }
                    }
                }
                Row row = new Row();
                row.setMdkey(mdkey.equals("detail") ? null : mdkey);
                row.setCols(columns);
                row.setRowNumber(this.lineCount);
                if (this.isFlagEmptyRows()) {
                    row.setEmpty(ParserUtils.isListElementsEmpty(columns));
                }
                if (this.isStoreRawDataToDataSet()) {
                    row.setRawData(line);
                }
                ds.addRow(row);
            }
            return ds;
        }
        finally {
            this.closeReaders();
        }
    }

    private boolean oddNumberOfQualifier(String line, char q) {
        if (line == null || line.isEmpty()) {
            return false;
        }
        int count = 0;
        int idx = 0;
        while ((idx = line.indexOf(q, idx)) != -1) {
            ++count;
            ++idx;
        }
        return count % 2 != 0;
    }

    protected String fetchNextRecord(BufferedReader aContentReader, char aQualifier, char aDelimiter) throws IOException {
        if (aQualifier == '\u0000') {
            return aContentReader.readLine();
        }
        StringBuilder lineData = null;
        String line = null;
        boolean multiline = false;
        while ((line = aContentReader.readLine()) != null) {
            if (lineData == null) {
                lineData = new StringBuilder(line);
            } else {
                lineData.append(LINE_BREAK).append(line);
            }
            if (multiline = this.isMultiline(line.toCharArray(), multiline, aQualifier, aDelimiter)) continue;
        }
        if (lineData != null) {
            ++this.lineCount;
            String result = lineData.toString();
            return result.endsWith(LINE_BREAK) ? result.substring(0, result.length() - LINE_BREAK.length()) : result;
        }
        return null;
    }

    protected boolean isMultiline(char[] a\u0421hrArray, boolean aMultiline, char aQualifier, char aDelimiter) {
        int position = 0;
        if (a\u0421hrArray == null || a\u0421hrArray.length == 0) {
            return aMultiline;
        }
        block0: do {
            if (!aMultiline && a\u0421hrArray[position] == aDelimiter) {
                ++position;
                continue;
            }
            if (!aMultiline && a\u0421hrArray[position] != aQualifier) {
                while (++position < a\u0421hrArray.length) {
                    if (a\u0421hrArray[position] != aDelimiter) continue;
                    ++position;
                    break;
                }
                if (position < a\u0421hrArray.length) continue;
                return false;
            }
            if (aMultiline && position == 0 && a\u0421hrArray[0] == aQualifier && a\u0421hrArray.length > 1 && a\u0421hrArray[1] == aQualifier) {
                ++position;
            } else {
                aMultiline = !aMultiline || position != 0 || a\u0421hrArray[0] != aQualifier || a\u0421hrArray.length <= 1 || a\u0421hrArray[1] == aQualifier;
            }
            if (a\u0421hrArray[position] == aQualifier) {
                ++position;
            }
            while (position < a\u0421hrArray.length) {
                if (a\u0421hrArray[position] == aQualifier) {
                    if (position == a\u0421hrArray.length - 1 || a\u0421hrArray[position + 1] != aQualifier) {
                        ++position;
                        aMultiline = false;
                        continue block0;
                    }
                    position += 2;
                    continue;
                }
                ++position;
            }
        } while (position <= a\u0421hrArray.length - 1);
        return aMultiline;
    }
}

