/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

public class BinaryConverter {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private static final char[] c_ = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final byte[] b_ = new byte[]{17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 17, 17, 17, 17, 17, 17, 10, 11, 12, 13, 14, 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 10, 11, 12, 13, 14, 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};

    private BinaryConverter() {
    }

    public static void shortToByteArray(short s, byte[] byArray, int n) {
        byArray[n] = (byte)(s >>> 8);
        byArray[n + 1] = (byte)s;
    }

    public static byte[] shortToByteArray(short s) {
        byte[] byArray = new byte[2];
        BinaryConverter.shortToByteArray(s, byArray, 0);
        return byArray;
    }

    public static short byteArrayToShort(byte[] byArray, int n) {
        return (short)(((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF));
    }

    public static void intToByteArray(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
    }

    public static byte[] intToByteArray(int n) {
        byte[] byArray = new byte[4];
        BinaryConverter.intToByteArray(n, byArray, 0);
        return byArray;
    }

    public static int byteArrayToInt(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
    }

    public static void floatToByteArray(float f, byte[] byArray, int n) {
        int n2 = Float.floatToIntBits(f);
        byArray[n] = (byte)(n2 >>> 24);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 3] = (byte)n2;
    }

    public static byte[] floatToByteArray(int n) {
        byte[] byArray = new byte[4];
        BinaryConverter.floatToByteArray(n, byArray, 0);
        return byArray;
    }

    public static byte[] floatToByteArray(float f) {
        byte[] byArray = new byte[4];
        BinaryConverter.floatToByteArray(f, byArray, 0);
        return byArray;
    }

    public static float byteArrayToFloat(byte[] byArray, int n) {
        int n2 = ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
        return Float.intBitsToFloat(n2);
    }

    public static void doubleToByteArray(double d, byte[] byArray, int n) {
        long l = Double.doubleToLongBits(d);
        int n2 = (int)(l >>> 32);
        int n3 = (int)l;
        byArray[n] = (byte)(n2 >>> 24);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 3] = (byte)n2;
        byArray[n + 4] = (byte)(n3 >>> 24);
        byArray[n + 5] = (byte)(n3 >>> 16);
        byArray[n + 6] = (byte)(n3 >>> 8);
        byArray[n + 7] = (byte)n3;
    }

    public static byte[] doubleToByteArray(double d) {
        byte[] byArray = new byte[8];
        BinaryConverter.doubleToByteArray(d, byArray, 0);
        return byArray;
    }

    public static double byteArrayToDouble(byte[] byArray, int n) {
        int n2 = ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
        int n3 = ((byArray[n + 4] & 0xFF) << 24) + ((byArray[n + 5] & 0xFF) << 16) + ((byArray[n + 6] & 0xFF) << 8) + (byArray[n + 7] & 0xFF);
        long l = ((long)n2 << 32) + ((long)n3 & 0xFFFFFFFFL);
        return Double.longBitsToDouble(l);
    }

    public static void unsignedShortToByteArray(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 8);
        byArray[n2 + 1] = (byte)n;
    }

    public static byte[] unsignedShortToByteArray(int n) {
        byte[] byArray = new byte[2];
        BinaryConverter.unsignedShortToByteArray(n, byArray, 0);
        return byArray;
    }

    public static int byteArrayToUnsignedShort(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF);
    }

    public static void unsignedIntToByteArray(long l, byte[] byArray, int n) {
        int n2 = (int)l;
        byArray[n] = (byte)(n2 >>> 24);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 3] = (byte)n2;
    }

    public static byte[] unsignedIntToByteArray(long l) {
        byte[] byArray = new byte[4];
        BinaryConverter.unsignedIntToByteArray(l, byArray, 0);
        return byArray;
    }

    public static long byteArrayToUnsignedInt(byte[] byArray, int n) {
        return (long)(((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF)) & 0xFFFFFFFFL;
    }

    public static void longToByteArray(long l, byte[] byArray, int n) {
        int n2 = (int)(l >>> 32);
        int n3 = (int)l;
        byArray[n] = (byte)(n2 >>> 24);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 3] = (byte)n2;
        byArray[n + 4] = (byte)(n3 >>> 24);
        byArray[n + 5] = (byte)(n3 >>> 16);
        byArray[n + 6] = (byte)(n3 >>> 8);
        byArray[n + 7] = (byte)n3;
    }

    public static byte[] longToByteArray(long l) {
        byte[] byArray = new byte[8];
        BinaryConverter.longToByteArray(l, byArray, 0);
        return byArray;
    }

    public static long byteArrayToLong(byte[] byArray, int n) {
        int n2 = ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
        int n3 = ((byArray[n + 4] & 0xFF) << 24) + ((byArray[n + 5] & 0xFF) << 16) + ((byArray[n + 6] & 0xFF) << 8) + (byArray[n + 7] & 0xFF);
        return ((long)n2 << 32) + ((long)n3 & 0xFFFFFFFFL);
    }

    static byte[] charArrayToByteArray(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            byArray[n2++] = (byte)(cArray[n] >> 8);
            byArray[n2++] = (byte)cArray[n++];
        }
        return byArray;
    }

    static char[] byteArrayToCharArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        char[] cArray = new char[byArray.length / 2];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            cArray[n2++] = (char)(((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF));
        }
        return cArray;
    }

    static final char hiNibbleToChar(byte by) {
        return c_[by >>> 4 & 0xF];
    }

    static final char loNibbleToChar(byte by) {
        return c_[by & 0xF];
    }

    public static final String bytesToString(byte[] byArray) {
        return BinaryConverter.bytesToString(byArray, 0, byArray.length);
    }

    public static final String bytesToString(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 * 2];
        int n3 = BinaryConverter.bytesToString(byArray, n, n2, cArray, 0);
        return new String(cArray, 0, n3);
    }

    static final int bytesToString(byte[] byArray, int n, int n2, char[] cArray, int n3) {
        for (int i = 0; i < n2; ++i) {
            int n4 = i * 2;
            byte by = (byte)(byArray[i + n] >>> 4 & 0xF);
            byte by2 = (byte)(byArray[i + n] & 0xF);
            cArray[n4 + n3] = c_[by];
            cArray[n4 + n3 + 1] = c_[by2];
        }
        return n2 * 2;
    }

    static final byte charsToByte(char c, char c2) {
        int n = 0xFFFF & c;
        int n2 = 0xFFFF & c2;
        if (n > 255 || n2 > 255) {
            throw new NumberFormatException();
        }
        byte by = b_[n];
        byte by2 = b_[n2];
        if (by == 17 || by2 == 17) {
            return 0;
        }
        return (byte)((byte)(by << 4) + by2);
    }

    public static final byte[] stringToBytes(String string) {
        int n = string.length();
        if (n > 2) {
            if (string.charAt(0) == '0' && (string.charAt(1) == 'x' || string.charAt(1) == 'X')) {
                string = string.substring(2);
            } else if ((string.charAt(0) == 'x' || string.charAt(0) == 'X') && string.charAt(1) == '\'') {
                if (string.charAt(n - 1) == '\'') {
                    string = string.substring(2, n - 1);
                } else {
                    throw new NumberFormatException();
                }
            }
        }
        if (string.length() % 2 == 1) {
            string = "0" + string;
        }
        char[] cArray = string.toCharArray();
        return BinaryConverter.stringToBytes(cArray, 0, cArray.length);
    }

    static final byte[] stringToBytes(char[] cArray, int n, int n2) {
        if (cArray.length == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[(n2 + 1) / 2];
        int n3 = BinaryConverter.stringToBytes(cArray, n, n2, byArray, 0);
        if (n3 < byArray.length) {
            byte[] byArray2 = byArray;
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
        }
        return byArray;
    }

    static final int stringToBytes(char[] cArray, int n, int n2, byte[] byArray, int n3) {
        if (cArray.length == 0) {
            return 0;
        }
        for (int i = 0; i < byArray.length; ++i) {
            int n4 = i * 2;
            int n5 = 0xFFFF & cArray[n4 + n];
            int n6 = 0xFFFF & cArray[n4 + n + 1];
            if (n5 > 255 || n6 > 255) {
                throw new NumberFormatException();
            }
            byte by = b_[n5];
            byte by2 = b_[n6];
            if (by == 17 || by2 == 17) {
                throw new NumberFormatException();
            }
            byte by3 = (byte)(by << 4);
            byArray[i + n3] = (byte)(by3 + by2);
        }
        return byArray.length;
    }
}

