/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NetServerShare;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;

public class NetServerFileShare
extends NetServerShare {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static ProgramMap setterMap_ = new ProgramMap();
    private static ProgramMap openListAttributeMap_ = new ProgramMap();
    private static final String ADFS_ = "qzlsadfs";
    private static final String CHFS_ = "qzlschfs";
    public static final String MAXIMUM_USERS = "MAXIMUM_USERS";
    public static final String PATH = "PATH";
    static final String PATH_LENGTH = "PATH_LENGTH";
    public static final String PERMISSION = "PERMISSION";
    public static final Integer PERMISSION_READ_ONLY;
    public static final Integer PERMISSION_READ_WRITE;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public NetServerFileShare() {
    }

    public NetServerFileShare(AS400 aS400, String string) {
        super(aS400, string);
    }

    public void add() throws ResourceException {
        try {
            this.freezeProperties();
            if (this.document_ == null) {
                this.document_ = (ProgramCallDocument)NetServerShare.staticDocument_.clone();
            }
            this.document_.setSystem(this.getSystem());
            this.document_.setValue("qzlsadfs.shareName", this.getName());
            this.document_.setValue("qzlschfs.shareName", this.getName());
            if (this.hasUncommittedAttributeChanges("DESCRIPTION")) {
                this.document_.setValue("qzlsadfs.description", (String)this.getAttributeValue("DESCRIPTION"));
                this.document_.setValue("qzlschfs.description", (String)this.getAttributeValue("DESCRIPTION"));
            }
            if (!this.hasUncommittedAttributeChanges(PATH)) {
                throw new ExtendedIllegalStateException("path", 4);
            }
            String string = (String)this.getAttributeValue(PATH);
            Integer n = new Integer(string.length() * 2);
            this.document_.setValue("qzlsadfs.lengthOfPathName", n);
            this.document_.setValue("qzlsadfs.pathName", string);
            this.document_.setValue("qzlschfs.lengthOfPathName", n);
            this.document_.setValue("qzlschfs.pathName", string);
            if (this.hasUncommittedAttributeChanges(PERMISSION)) {
                this.document_.setValue("qzlsadfs.permissions", (Integer)this.getAttributeValue(PERMISSION));
                this.document_.setValue("qzlschfs.permissions", (Integer)this.getAttributeValue(PERMISSION));
            }
            if (this.hasUncommittedAttributeChanges(MAXIMUM_USERS)) {
                this.document_.setValue("qzlsadfs.maximumUsers", (Integer)this.getAttributeValue(MAXIMUM_USERS));
                this.document_.setValue("qzlschfs.maximumUsers", (Integer)this.getAttributeValue(MAXIMUM_USERS));
            }
            if (!this.isConnectionEstablished()) {
                this.establishConnection(false);
            }
            if (!this.document_.callProgram(ADFS_)) {
                throw new ResourceException(this.document_.getMessageList(ADFS_));
            }
            this.fireResourceCreated();
        }
        catch (PcmlException pcmlException) {
            Trace.log(2, "PcmlException when adding a file share.", (Throwable)pcmlException);
            throw new ResourceException(pcmlException);
        }
    }

    protected void commitAttributeChanges(Object[] objectArray, Object[] objectArray2) throws ResourceException {
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            if (!string.equals(PATH)) continue;
            String string2 = (String)objectArray2[i];
            int n = string2.length() * 2;
            this.setAttributeValue(PATH_LENGTH, new Integer(n));
            int n2 = objectArray.length;
            Object[] objectArray3 = new Object[n2 + 1];
            System.arraycopy(objectArray, 0, objectArray3, 0, n2);
            objectArray3[n2] = PATH_LENGTH;
            Object[] objectArray4 = new Object[n2 + 1];
            System.arraycopy(objectArray2, 0, objectArray4, 0, n2);
            objectArray4[n2] = new Integer(n);
            objectArray = objectArray3;
            objectArray2 = objectArray4;
            break;
        }
        super.commitAttributeChanges(objectArray, objectArray2);
    }

    protected void establishConnection() throws ResourceException {
        this.establishConnection(true);
    }

    void establishConnection(boolean bl) throws ResourceException {
        Object[] objectArray = new Object[]{PATH_LENGTH};
        super.establishConnection(setterMap_, objectArray, bl);
    }

    static ResourceList list(AS400 aS400) throws ResourceException {
        return NetServerFileShare.list(aS400, "*ALL");
    }

    static ResourceList list(AS400 aS400, String string) throws ResourceException {
        return NetServerShare.list(aS400, 0, string, openListAttributeMap_);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class.forName("com.ibm.as400.access.NetServerShare");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        setterMap_.add("DESCRIPTION", CHFS_, "description");
        openListAttributeMap_.add("DESCRIPTION", "qzlsolst_zlsl0100", "receiverVariable.description");
        openListAttributeMap_.add("USER_COUNT", "qzlsolst_zlsl0100", "receiverVariable.currentUsers");
        NetServerShare.attributes_.add((Object)MAXIMUM_USERS, class$java$lang$Integer == null ? (class$java$lang$Integer = NetServerFileShare.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(-1));
        NetServerShare.getterMap_.add((Object)MAXIMUM_USERS, "qzlsolst_zlsl0100", "receiverVariable.maximumUsers", NetServerShare.INDICES_);
        setterMap_.add(MAXIMUM_USERS, CHFS_, "maximumUsers");
        openListAttributeMap_.add(MAXIMUM_USERS, "qzlsolst_zlsl0100", "receiverVariable.maximumUsers");
        NetServerShare.attributes_.add(PATH, class$java$lang$String == null ? (class$java$lang$String = NetServerFileShare.class$("java.lang.String")) : class$java$lang$String);
        NetServerShare.getterMap_.add((Object)PATH, "qzlsolst_zlsl0100", "receiverVariable.pathName", NetServerShare.INDICES_);
        setterMap_.add(PATH, CHFS_, "pathName");
        openListAttributeMap_.add(PATH, "qzlsolst_zlsl0100", "receiverVariable.pathName");
        NetServerShare.attributes_.add(PATH_LENGTH, class$java$lang$Integer == null ? (class$java$lang$Integer = NetServerFileShare.class$("java.lang.Integer")) : class$java$lang$Integer);
        NetServerShare.getterMap_.add((Object)PATH_LENGTH, "qzlsolst_zlsl0100", "receiverVariable.lengthOfPathName", NetServerShare.INDICES_);
        setterMap_.add(PATH_LENGTH, CHFS_, "lengthOfPathName");
        openListAttributeMap_.add(PATH_LENGTH, "qzlsolst_zlsl0100", "receiverVariable.lengthOfPathName");
        PERMISSION_READ_ONLY = new Integer(1);
        PERMISSION_READ_WRITE = new Integer(2);
        NetServerShare.attributes_.add(PERMISSION, class$java$lang$Integer == null ? (class$java$lang$Integer = NetServerFileShare.class$("java.lang.Integer")) : class$java$lang$Integer, false, new Object[]{PERMISSION_READ_ONLY, PERMISSION_READ_WRITE}, PERMISSION_READ_WRITE, true);
        NetServerShare.getterMap_.add((Object)PERMISSION, "qzlsolst_zlsl0100", "receiverVariable.permissions", NetServerShare.INDICES_);
        setterMap_.add(PERMISSION, CHFS_, "permissions");
        openListAttributeMap_.add(PERMISSION, "qzlsolst_zlsl0100", "receiverVariable.permissions");
    }
}

