/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;

public class AS400AuthenticationException
extends AS400SecurityException {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private AS400Message[] msgList_ = null;

    AS400AuthenticationException() {
        this(27);
    }

    AS400AuthenticationException(AS400Message[] aS400MessageArray) {
        this(AS400AuthenticationException.getReturnCode(aS400MessageArray));
        this.msgList_ = aS400MessageArray;
    }

    AS400AuthenticationException(int n) {
        super(n);
    }

    public AS400Message getAS400Message() {
        if (this.msgList_ != null && this.msgList_.length > 0) {
            return this.msgList_[0];
        }
        return null;
    }

    public AS400Message[] getAS400MessageList() {
        return this.msgList_;
    }

    static int getReturnCode(AS400Message[] aS400MessageArray) {
        for (int i = 0; i < aS400MessageArray.length; ++i) {
            String string = aS400MessageArray[i].getID().toUpperCase();
            if (string.equals("CPF22E2")) {
                return 8;
            }
            if (string.equals("CPF22E3")) {
                return 31;
            }
            if (string.equals("CPF22E4")) {
                return 7;
            }
            if (string.equals("CPF22E5")) {
                return 6;
            }
            if (string.equals("CPF22E9")) {
                return 4;
            }
            if (string.equals("CPF2204")) {
                return 32;
            }
            if (!string.equals("CPF2217")) continue;
            return 4;
        }
        return 27;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this.getReturnCode() == 27 && this.getAS400Message() != null) {
            stringBuffer.append(" >> " + this.getAS400Message().toString());
        }
        return stringBuffer.toString();
    }
}

