/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400JDBCTimestamp;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.JVMInfo;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.CharConversionException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLTimestamp
extends SQLDataBase {
    static final String copyright2 = "Copyright (C) 1997-2013 International Business Machines Corporation and others.";
    static boolean jdk14 = false;
    private int year_;
    private int month_;
    private int day_;
    private int hour_;
    private int minute_;
    private int second_;
    private long picos_;
    private int length_;

    SQLTimestamp(int n, SQLConversionSettings sQLConversionSettings) {
        super(sQLConversionSettings);
        this.length_ = n;
        this.year_ = 0;
        this.month_ = 0;
        this.day_ = 0;
        this.hour_ = 0;
        this.minute_ = 0;
        this.second_ = 0;
        this.picos_ = 0L;
    }

    public Object clone() {
        return new SQLTimestamp(this.length_, this.settings_);
    }

    public static Timestamp stringToTimestamp(String string, Calendar calendar) throws SQLException {
        try {
            Object object;
            int n = string.length();
            if (n < 10) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(null, "Invalid timestamp length " + string);
                }
                JDError.throwSQLException("07006", string);
            }
            if (string.charAt(4) != '-' || string.charAt(7) != '-') {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(null, "Timestamp missing - " + string);
                }
                JDError.throwSQLException("07006", string);
            }
            int n2 = Integer.parseInt(string.substring(0, 4));
            if (calendar == null) {
                calendar = AS400Calendar.getGregorianInstance();
                calendar.setLenient(false);
            } else {
                calendar = AS400Calendar.getConversionCalendar(calendar);
            }
            calendar.set(1, n2);
            calendar.set(2, Integer.parseInt(string.substring(5, 7)) - 1);
            calendar.set(5, Integer.parseInt(string.substring(8, 10)));
            if (n >= 13) {
                calendar.set(11, Integer.parseInt(string.substring(11, 13)));
            } else {
                calendar.set(11, 0);
            }
            if (n >= 16) {
                calendar.set(12, Integer.parseInt(string.substring(14, 16)));
            } else {
                calendar.set(12, 0);
            }
            if (n >= 19) {
                calendar.set(13, Integer.parseInt(string.substring(17, 19)));
            } else {
                calendar.set(13, 0);
            }
            long l = 0L;
            if (n > 20) {
                object = string.substring(20).trim() + "00000000000000";
                l = Long.parseLong(((String)object).substring(0, 12));
            } else {
                l = 0L;
            }
            object = null;
            try {
                long l2 = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
                if (l % 1000L == 0L) {
                    object = new Timestamp(l2);
                    ((Timestamp)object).setNanos((int)(l / 1000L));
                } else {
                    AS400JDBCTimestamp aS400JDBCTimestamp = new AS400JDBCTimestamp(l2, 32);
                    aS400JDBCTimestamp.setPicos(l);
                    object = aS400JDBCTimestamp;
                }
            }
            catch (Exception exception) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logException(null, "Error parsing timestamp " + string, exception);
                }
                JDError.throwSQLException("07006", string);
                return null;
            }
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing timestamp " + string, numberFormatException);
            }
            JDError.throwSQLException("07006", string);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing timestamp " + string, stringIndexOutOfBoundsException);
            }
            JDError.throwSQLException("07006", string);
        }
        return new Timestamp(0L);
    }

    public static String timestampToString(Timestamp timestamp, Calendar calendar, SQLConversionSettings sQLConversionSettings) {
        return SQLTimestamp.timestampToString(timestamp, calendar, -1, 26, sQLConversionSettings);
    }

    public static String timestampToStringTrimTrailingZeros(Timestamp timestamp, Calendar calendar, SQLConversionSettings sQLConversionSettings) {
        int n;
        String string = SQLTimestamp.timestampToString(timestamp, calendar, -1, 32, sQLConversionSettings);
        for (n = 32; string.charAt(n - 1) == '0' && n > 21; --n) {
        }
        if (n < 32) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String timestampToString(Timestamp timestamp, Calendar calendar, int n, SQLConversionSettings sQLConversionSettings) {
        return SQLTimestamp.timestampToString(timestamp, calendar, n, 26, sQLConversionSettings);
    }

    public static String timestampToString(Timestamp timestamp, Calendar calendar, int n, int n2, SQLConversionSettings sQLConversionSettings) {
        char c = ' ';
        char c2 = ':';
        char c3 = ':';
        if (sQLConversionSettings.getTimestampFormat() == 1) {
            c = '-';
            c2 = '.';
            c3 = '.';
        }
        StringBuffer stringBuffer = new StringBuffer();
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.setTime(timestamp);
        int n3 = calendar.get(11);
        if (n == 24 && n3 == 0) {
            calendar.add(5, -1);
        }
        stringBuffer.append(JDUtilities.padZeros(calendar.get(1), 4));
        stringBuffer.append('-');
        stringBuffer.append(JDUtilities.padZeros(calendar.get(2) + 1, 2));
        stringBuffer.append('-');
        stringBuffer.append(JDUtilities.padZeros(calendar.get(5), 2));
        stringBuffer.append(c);
        n3 = calendar.get(11);
        stringBuffer.append(JDUtilities.padZeros(n3, 2));
        stringBuffer.append(c2);
        stringBuffer.append(JDUtilities.padZeros(calendar.get(12), 2));
        stringBuffer.append(c3);
        stringBuffer.append(JDUtilities.padZeros(calendar.get(13), 2));
        if (n2 > 20) {
            stringBuffer.append('.');
            if (timestamp instanceof AS400JDBCTimestamp) {
                stringBuffer.append(JDUtilities.padZeros(((AS400JDBCTimestamp)timestamp).getPicos(), 12));
                stringBuffer.setLength(n2);
            } else {
                int n4 = timestamp.getNanos();
                stringBuffer.append(JDUtilities.padZeros(n4, 9));
                if (n2 > 29) {
                    stringBuffer.append("000");
                }
                stringBuffer.setLength(n2);
            }
        }
        if (n == 24 && n3 == 0) {
            stringBuffer.setCharAt(11, '2');
            stringBuffer.setCharAt(12, '4');
        }
        return stringBuffer.toString();
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.year_ = (byArray[n] & 0xF) * 1000 + (byArray[n + 1] & 0xF) * 100 + (byArray[n + 2] & 0xF) * 10 + (byArray[n + 3] & 0xF);
        this.month_ = (byArray[n + 5] & 0xF) * 10 + (byArray[n + 6] & 0xF) - 1;
        this.day_ = (byArray[n + 8] & 0xF) * 10 + (byArray[n + 9] & 0xF);
        this.hour_ = (byArray[n + 11] & 0xF) * 10 + (byArray[n + 12] & 0xF);
        this.minute_ = (byArray[n + 14] & 0xF) * 10 + (byArray[n + 15] & 0xF);
        this.second_ = (byArray[n + 17] & 0xF) * 10 + (byArray[n + 18] & 0xF);
        long l = 100000000000L;
        this.picos_ = 0L;
        for (int i = 20; i < this.length_; ++i) {
            this.picos_ += (long)(byArray[n + i] & 0xF) * l;
            l /= 10L;
        }
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(this.getString().replace(':', '.'));
        stringBuffer.setCharAt(10, '-');
        if (stringBuffer.length() > this.length_) {
            stringBuffer.setLength(this.length_);
        }
        try {
            convTable.stringToByteArray(stringBuffer.toString(), byArray, n);
        }
        catch (CharConversionException charConversionException) {
            JDError.throwSQLException("HY000", charConversionException);
        }
    }

    public int getSQLType() {
        return 28;
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (calendar == null) {
            calendar = AS400Calendar.getGregorianInstance();
            calendar.setLenient(false);
        } else {
            calendar = AS400Calendar.getConversionCalendar(calendar);
        }
        if (object instanceof String) {
            Timestamp timestamp = SQLTimestamp.stringToTimestamp((String)object, calendar);
            this.year_ = calendar.get(1);
            this.month_ = calendar.get(2);
            this.day_ = calendar.get(5);
            this.hour_ = calendar.get(11);
            this.minute_ = calendar.get(12);
            this.second_ = calendar.get(13);
            this.picos_ = timestamp instanceof AS400JDBCTimestamp ? ((AS400JDBCTimestamp)timestamp).getPicos() : (long)timestamp.getNanos() * 1000L;
        } else if (object instanceof Timestamp) {
            calendar.setTime((Timestamp)object);
            this.year_ = calendar.get(1);
            this.month_ = calendar.get(2);
            this.day_ = calendar.get(5);
            this.hour_ = calendar.get(11);
            this.minute_ = calendar.get(12);
            this.second_ = calendar.get(13);
            this.picos_ = object instanceof AS400JDBCTimestamp ? ((AS400JDBCTimestamp)object).getPicos() : (long)((Timestamp)object).getNanos() * 1000L;
        } else if (object instanceof java.util.Date) {
            calendar.setTime((java.util.Date)object);
            this.year_ = calendar.get(1);
            this.month_ = calendar.get(2);
            this.day_ = calendar.get(5);
            this.hour_ = calendar.get(11);
            this.minute_ = calendar.get(12);
            this.second_ = calendar.get(13);
            this.picos_ = (long)calendar.get(14) * 1000000000L;
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
    }

    public String getCreateParameters() {
        return null;
    }

    public int getDisplaySize() {
        return this.length_;
    }

    public String getJavaClassName() {
        return "java.sql.Timestamp";
    }

    public String getLiteralPrefix() {
        return "'";
    }

    public String getLiteralSuffix() {
        return "'";
    }

    public String getLocalName() {
        return "TIMESTAMP";
    }

    public int getMaximumPrecision() {
        return this.length_;
    }

    public int getMaximumScale() {
        return this.getScale();
    }

    public int getMinimumScale() {
        return this.getScale();
    }

    public int getNativeType() {
        return 392;
    }

    public int getPrecision() {
        return this.length_;
    }

    public int getRadix() {
        return 10;
    }

    public int getScale() {
        int n = this.length_ - 20;
        if (n >= 0) {
            return n;
        }
        return 0;
    }

    public int getType() {
        return 93;
    }

    public String getTypeName() {
        return "TIMESTAMP";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return false;
    }

    public int getActualSize() {
        return this.length_;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Date getDate(Calendar calendar) throws SQLException {
        this.truncated_ = 16;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.set(this.year_, this.month_, this.day_, 0, 0, 0);
        calendar.set(14, 0);
        long l = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
        return new Date(l);
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.set(this.year_, this.month_, this.day_, this.hour_, this.minute_, this.second_);
        long l = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
        if (this.picos_ % 1000L == 0L) {
            Timestamp timestamp = new Timestamp(l);
            timestamp.setNanos((int)(this.picos_ / 1000L));
            return timestamp;
        }
        AS400JDBCTimestamp aS400JDBCTimestamp = new AS400JDBCTimestamp(l);
        aS400JDBCTimestamp.setPicos(this.picos_);
        return aS400JDBCTimestamp;
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        Calendar calendar = AS400Calendar.getGMTInstance();
        calendar.set(this.year_, this.month_, this.day_, this.hour_, this.minute_, this.second_);
        long l = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
        if (this.picos_ % 1000L == 0L) {
            Timestamp timestamp = new Timestamp(l);
            timestamp.setNanos((int)(this.picos_ / 1000L));
            return SQLTimestamp.timestampToString(timestamp, calendar, this.hour_, this.length_, this.settings_);
        }
        AS400JDBCTimestamp aS400JDBCTimestamp = new AS400JDBCTimestamp(l);
        aS400JDBCTimestamp.setPicos(this.picos_);
        return SQLTimestamp.timestampToString(aS400JDBCTimestamp, calendar, this.hour_, this.length_, this.settings_);
    }

    public Time getTime(Calendar calendar) throws SQLException {
        this.truncated_ = 18;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.set(0, 0, 0, this.hour_, this.minute_, this.second_);
        long l = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
        return new Time(l);
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.set(this.year_, this.month_, this.day_, this.hour_, this.minute_, this.second_);
        long l = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
        if (this.picos_ % 1000L == 0L) {
            Timestamp timestamp = new Timestamp(l);
            timestamp.setNanos((int)(this.picos_ / 1000L));
            return timestamp;
        }
        AS400JDBCTimestamp aS400JDBCTimestamp = new AS400JDBCTimestamp(l);
        aS400JDBCTimestamp.setPicos(this.picos_);
        return aS400JDBCTimestamp;
    }

    static {
        jdk14 = JVMInfo.isJDK14();
    }
}

