/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;

public class ServiceProgramCall
extends ProgramCall {
    static final long serialVersionUID = 4L;
    public static final int NO_RETURN_VALUE = 0;
    public static final int RETURN_INTEGER = 1;
    static final int RETURN_INTEGER_AND_ERRNO = 3;
    private String procedureName_ = "";
    private byte[] returnValue_ = null;
    private int returnValueFormat_ = 0;
    private int procedureNameCCSID_ = 37;
    private boolean alignOn16Bytes_ = false;

    public ServiceProgramCall() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing ServiceProgramCall object.");
        }
    }

    public ServiceProgramCall(AS400 aS400) {
        super(aS400);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing ServiceProgramCall object.");
        }
    }

    public ServiceProgramCall(AS400 aS400, String string, ProgramParameter[] programParameterArray) {
        super(aS400, string, programParameterArray);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing ServiceProgramCall object.");
        }
    }

    public ServiceProgramCall(AS400 aS400, String string, String string2, ProgramParameter[] programParameterArray) {
        super(aS400, string, programParameterArray);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing ServiceProgramCall object, procedureName: " + string2);
        }
        if (string2 == null) {
            throw new NullPointerException("procedureName");
        }
        this.procedureName_ = string2;
    }

    public ServiceProgramCall(AS400 aS400, String string, String string2, int n, ProgramParameter[] programParameterArray) {
        super(aS400, string, programParameterArray);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing ServiceProgramCall object, procedureName: " + string2 + " return value format:", n);
        }
        if (string2 == null) {
            throw new NullPointerException("procedureName");
        }
        if (n < 0 || n > 1) {
            throw new ExtendedIllegalArgumentException("returnValueFormat (" + n + ")", 2);
        }
        this.procedureName_ = string2;
        this.returnValueFormat_ = n;
    }

    public int getErrno() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting error number.");
        }
        if (this.returnValue_ == null || this.returnValueFormat_ != 1) {
            Trace.log(2, "Attempt to get error number before running service program.");
            throw new ExtendedIllegalStateException("returnValueFormat", 4);
        }
        if (this.returnValue_.length > 7) {
            return BinaryConverter.byteArrayToInt(this.returnValue_, 4);
        }
        return 0;
    }

    public int getIntegerReturnValue() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting integer return value.");
        }
        if (this.returnValue_ == null || this.returnValueFormat_ != 1) {
            Trace.log(2, "Attempt to get integer return value before running service program.");
            throw new ExtendedIllegalStateException("returnValueFormat", 4);
        }
        return BinaryConverter.byteArrayToInt(this.returnValue_, 0);
    }

    public String getProcedureName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting procedure name: " + this.procedureName_);
        }
        return this.procedureName_;
    }

    public byte[] getReturnValue() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting return value:", this.returnValue_);
        }
        return this.returnValue_;
    }

    public int getReturnValueFormat() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting return value format:", this.returnValueFormat_);
        }
        return this.returnValueFormat_;
    }

    public boolean run() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(3, "Running service program: " + this.program_ + " procedure name: " + this.procedureName_);
        }
        if (this.program_.length() == 0) {
            Trace.log(2, "Attempt to run before setting program.");
            throw new ExtendedIllegalStateException("program", 4);
        }
        if (this.procedureName_.length() == 0) {
            Trace.log(2, "Attempt to run before setting procedure name.");
            throw new ExtendedIllegalStateException("procedureName", 4);
        }
        if (this.parameterList_.length > 7) {
            Trace.log(2, "Parameter list length exceeds limit of 7 parameters:", this.parameterList_.length);
            throw new ExtendedIllegalArgumentException("parameterList.length (" + this.parameterList_.length + ")", 2);
        }
        this.chooseImpl();
        int n = this.returnValueFormat_;
        if (n == 1) {
            n = 3;
        }
        this.returnValue_ = this.impl_.runServiceProgram(this.library_, this.name_, this.procedureName_, n, this.parameterList_, this.threadSafetyValue_, this.procedureNameCCSID_, this.messageOption_, this.alignOn16Bytes_);
        this.messageList_ = this.impl_.getMessageList();
        if (this.system_ != null) {
            for (int i = 0; i < this.messageList_.length; ++i) {
                this.messageList_[i].setSystem(this.system_);
            }
        }
        if (this.messageList_.length != 0 && this.messageList_[0].getID().startsWith("MCH3401")) {
            throw new ObjectDoesNotExistException(this.program_, 2);
        }
        if (this.actionCompletedListeners_ != null) {
            this.fireActionCompleted();
        }
        return this.returnValue_ != null;
    }

    public boolean run(String string, ProgramParameter[] programParameterArray) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, PropertyVetoException {
        this.setProgram(string, programParameterArray);
        return this.run();
    }

    public boolean run(AS400 aS400, String string, String string2, int n, ProgramParameter[] programParameterArray) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, PropertyVetoException {
        this.setSystem(aS400);
        this.setProgram(string);
        this.setProcedureName(string2);
        this.setReturnValueFormat(n);
        this.setParameterList(programParameterArray);
        return this.run();
    }

    public void setAlignOn16Bytes(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting alignment: " + bl);
        }
        this.alignOn16Bytes_ = bl;
    }

    public void setProcedureName(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting procedure name: " + string);
        }
        if (string == null) {
            throw new NullPointerException("procedureName");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.procedureName_ = string;
        } else {
            String string2 = this.procedureName_;
            String string3 = string;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("procedureName", string2, string3);
            }
            this.procedureName_ = string;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("procedureName", string2, string3);
            }
        }
    }

    public void setProcedureName(String string, int n) throws PropertyVetoException {
        this.setProcedureName(string);
        this.procedureNameCCSID_ = n;
    }

    public void setProgram(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting service program: " + string);
        }
        if (string == null) {
            throw new NullPointerException("program");
        }
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "SRVPGM");
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.library_ = qSYSObjectPathName.getLibraryName();
            this.name_ = qSYSObjectPathName.getObjectName();
            this.program_ = string;
        } else {
            String string2 = this.program_;
            String string3 = string;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("program", string2, string3);
            }
            this.library_ = qSYSObjectPathName.getLibraryName();
            this.name_ = qSYSObjectPathName.getObjectName();
            this.program_ = string3;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("program", string2, string3);
            }
        }
    }

    public void setReturnValueFormat(int n) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting return value format:", n);
        }
        if (n < 0 || n > 1) {
            throw new ExtendedIllegalArgumentException("returnValueFormat (" + n + ")", 2);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.returnValueFormat_ = n;
        } else {
            Integer n2 = new Integer(this.returnValueFormat_);
            Integer n3 = new Integer(n);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("returnValueFormat", n2, n3);
            }
            this.returnValueFormat_ = n;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("returnValueFormat", n2, n3);
            }
        }
    }
}

