/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IllegalPathNameException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.ValueMap;
import java.io.Serializable;

class QualifiedValueMap
implements ValueMap,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    public static final int FORMAT_20 = 20;
    public static final int FORMAT_CL = 13;
    private int format_ = -1;
    private String type_ = null;

    public QualifiedValueMap(int n, String string) {
        if (n != 20 && n != 13) {
            throw new ExtendedIllegalArgumentException("format", 2);
        }
        if (string == null) {
            throw new NullPointerException("type");
        }
        this.format_ = n;
        this.type_ = string;
    }

    public Object ltop(Object object, AS400 aS400) {
        if (object == null) {
            throw new NullPointerException("logicalValue");
        }
        if (!(object instanceof String)) {
            throw new ExtendedIllegalArgumentException("logicalValue", 2);
        }
        String string = (String)object;
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("logicalValue", 2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.format_) {
            case 20: {
                if (string.length() <= 10) {
                    stringBuffer.append(QualifiedValueMap.normalize(string, 20));
                    break;
                }
                try {
                    QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
                    stringBuffer.append(QualifiedValueMap.normalize(qSYSObjectPathName.getObjectName(), 10));
                    stringBuffer.append(QualifiedValueMap.normalize(qSYSObjectPathName.getLibraryName(), 10));
                    break;
                }
                catch (IllegalPathNameException illegalPathNameException) {
                    if (Trace.isTraceOn()) {
                        Trace.log(2, "Bad path name", (Throwable)illegalPathNameException);
                    }
                    throw new ExtendedIllegalArgumentException("logicalValue", 2);
                }
            }
            case 13: {
                if (string.length() <= 10) {
                    stringBuffer.append(string);
                    break;
                }
                try {
                    QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
                    stringBuffer.append(qSYSObjectPathName.getLibraryName());
                    stringBuffer.append('/');
                    stringBuffer.append(qSYSObjectPathName.getObjectName());
                    break;
                }
                catch (IllegalPathNameException illegalPathNameException) {
                    if (Trace.isTraceOn()) {
                        Trace.log(2, "Bad path name", (Throwable)illegalPathNameException);
                    }
                    throw new ExtendedIllegalArgumentException("logicalValue", 2);
                }
            }
            default: {
                throw new ExtendedIllegalStateException("format", 6);
            }
        }
        return stringBuffer.toString();
    }

    public Object ptol(Object object, AS400 aS400) {
        if (object == null) {
            throw new NullPointerException("physicalValue");
        }
        if (!(object instanceof String)) {
            throw new ExtendedIllegalArgumentException("physicalValue", 2);
        }
        String string = (String)object;
        switch (this.format_) {
            case 20: {
                if (string.length() <= 10) {
                    return string;
                }
                return QSYSObjectPathName.toPath(string.substring(10).trim(), string.substring(0, 10).trim(), this.type_);
            }
            case 13: {
                return QSYSObjectPathName.toPath(string.substring(11, 21).trim(), string.substring(0, 10).trim(), this.type_);
            }
        }
        throw new ExtendedIllegalStateException("format", 6);
    }

    private static String normalize(String string, int n) {
        int n2 = string.length();
        if (n2 < n) {
            StringBuffer stringBuffer = new StringBuffer(string);
            for (int i = n2; i < n; ++i) {
                stringBuffer.append(' ');
            }
            return stringBuffer.toString();
        }
        if (n2 > n) {
            return string.substring(0, n);
        }
        return string;
    }
}

