/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IdentifiedArrayReferenceValue;
import proguard.evaluation.value.InitialValueFactory;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.util.ArrayUtil;

class DetailedArrayReferenceValue
extends IdentifiedArrayReferenceValue {
    private static final int MAXIMUM_STORED_ARRAY_LENGTH = 32;
    private final Value[] values;

    public DetailedArrayReferenceValue(String type, Clazz referencedClass, IntegerValue arrayLength, ValueFactory valuefactory, int id) {
        super(type, referencedClass, arrayLength, valuefactory, id);
        if (arrayLength.isParticular() && arrayLength.value() <= 32) {
            InitialValueFactory initialValueFactory = new InitialValueFactory(valuefactory);
            String elementType = ClassUtil.isInternalArrayType(type) ? type.substring(1) : type;
            this.values = new Value[arrayLength.value()];
            for (int index = 0; index < this.values.length; ++index) {
                this.values[index] = initialValueFactory.createValue(elementType);
            }
        } else {
            this.values = null;
        }
    }

    public IntegerValue integerArrayLoad(IntegerValue indexValue, ValueFactory valueFactory) {
        Value value = this.arrayLoad(indexValue, valueFactory);
        return value != null ? value.integerValue() : super.integerArrayLoad(indexValue, valueFactory);
    }

    public LongValue longArrayLoad(IntegerValue indexValue, ValueFactory valueFactory) {
        Value value = this.arrayLoad(indexValue, valueFactory);
        return value != null ? value.longValue() : super.longArrayLoad(indexValue, valueFactory);
    }

    public FloatValue floatArrayLoad(IntegerValue indexValue, ValueFactory valueFactory) {
        Value value = this.arrayLoad(indexValue, valueFactory);
        return value != null ? value.floatValue() : super.floatArrayLoad(indexValue, valueFactory);
    }

    public DoubleValue doubleArrayLoad(IntegerValue indexValue, ValueFactory valueFactory) {
        Value value = this.arrayLoad(indexValue, valueFactory);
        return value != null ? value.doubleValue() : super.doubleArrayLoad(indexValue, valueFactory);
    }

    public ReferenceValue referenceArrayLoad(IntegerValue indexValue, ValueFactory valueFactory) {
        Value value = this.arrayLoad(indexValue, valueFactory);
        return value != null ? value.referenceValue() : super.referenceArrayLoad(indexValue, valueFactory);
    }

    private Value arrayLoad(IntegerValue indexValue, ValueFactory valueFactory) {
        int index;
        if (this.values != null && indexValue.isParticular() && (index = indexValue.value()) >= 0 && index < this.values.length) {
            return this.values[index];
        }
        return null;
    }

    public void arrayStore(IntegerValue indexValue, Value value) {
        if (this.values != null) {
            if (indexValue.isParticular()) {
                int index = indexValue.value();
                if (index >= 0 && index < this.values.length) {
                    this.values[index] = value;
                }
            } else {
                for (int index = 0; index < this.values.length; ++index) {
                    this.values[index].generalize(value);
                }
            }
        }
    }

    public ReferenceValue generalize(ReferenceValue other) {
        return other.generalize(this);
    }

    public int equal(ReferenceValue other) {
        return other.equal(this);
    }

    public boolean isParticular() {
        if (this.values == null) {
            return false;
        }
        for (int index = 0; index < this.values.length; ++index) {
            if (this.values[index].isParticular()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        return this == object || super.equals(object) && ArrayUtil.equalOrNull(this.values, ((DetailedArrayReferenceValue)object).values);
    }

    public int hashCode() {
        return super.hashCode() ^ ArrayUtil.hashCodeOrNull(this.values);
    }

    public String toString() {
        if (this.values == null) {
            return super.toString();
        }
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append('{');
        for (int index = 0; index < this.values.length; ++index) {
            buffer.append(this.values[index]);
            buffer.append(index < this.values.length - 1 ? (char)',' : '}');
        }
        return buffer.toString();
    }
}

