/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.Objects;
import javax.xml.transform.TransformerException;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.HostLanguage;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XmlProcessingError;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingException;
import net.sf.saxon.tree.util.Navigator;

public class XmlProcessingIncident
implements XmlProcessingError {
    private final String message;
    private String errorCode;
    private Throwable cause;
    private Location locator = null;
    private boolean _isWarning;
    private boolean _isTypeError;
    private String fatalErrorMessage;
    private boolean _hasBeenReported = false;
    private HostLanguage hostLanguage = HostLanguage.UNKNOWN;
    private boolean _isStaticError;

    public XmlProcessingIncident(String message, String errorCode, Location location) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(errorCode);
        Objects.requireNonNull(location);
        this.message = message;
        this.setErrorCodeAsEQName(errorCode);
        this.locator = location;
        this._isWarning = false;
    }

    public XmlProcessingIncident(String message) {
        this.message = message;
    }

    public XmlProcessingIncident(String message, String errorCode) {
        this.message = message;
        this.setErrorCodeAsEQName(errorCode);
    }

    public XmlProcessingIncident(TransformerException err, boolean isWarning) {
        XPathException exception = XPathException.makeXPathException(err);
        this.message = exception.getMessage();
        this.errorCode = exception.getErrorCodeQName().getEQName();
        this.locator = exception.getLocator();
        this._isWarning = isWarning;
    }

    public void setWarning(boolean warning) {
        this._isWarning = warning;
    }

    @Override
    public XmlProcessingIncident asWarning() {
        this._isWarning = true;
        return this;
    }

    @Override
    public void setTerminationMessage(String message) {
        this.fatalErrorMessage = message;
    }

    @Override
    public String getTerminationMessage() {
        return this.fatalErrorMessage;
    }

    @Override
    public boolean isAlreadyReported() {
        return this._hasBeenReported;
    }

    @Override
    public void setAlreadyReported(boolean reported) {
        this._hasBeenReported = reported;
    }

    @Override
    public HostLanguage getHostLanguage() {
        return this.hostLanguage;
    }

    public void setHostLanguage(HostLanguage language) {
        this.hostLanguage = language;
    }

    @Override
    public boolean isTypeError() {
        return this._isTypeError;
    }

    public void setTypeError(boolean isTypeError) {
        this._isTypeError = isTypeError;
    }

    @Override
    public boolean isStaticError() {
        return this._isStaticError;
    }

    public void setStaticError(boolean isStaticError) {
        this._isStaticError = isStaticError;
    }

    @Override
    public QName getErrorCode() {
        if (this.errorCode == null) {
            return null;
        }
        return new QName(StructuredQName.fromEQName(this.errorCode));
    }

    public void setErrorCodeAsEQName(String code) {
        this.errorCode = code.startsWith("Q{") ? code : (NameChecker.isValidNCName(StringTool.codePoints(code)) ? "Q{http://www.w3.org/2005/xqt-errors}" + code : "Q{http://saxon.sf.net/}invalid-error-code");
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getModuleUri() {
        return this.getLocation().getSystemId();
    }

    @Override
    public Location getLocation() {
        return this.locator;
    }

    public void setLocation(Location loc) {
        this.locator = loc;
    }

    public int getColumnNumber() {
        Location locator = this.getLocation();
        if (locator != null) {
            return locator.getColumnNumber();
        }
        return -1;
    }

    public int getLineNumber() {
        Location locator = this.getLocation();
        if (locator != null) {
            return locator.getLineNumber();
        }
        return -1;
    }

    public String getInstructionName() {
        return ((NodeInfo)this.locator).getDisplayName();
    }

    @Override
    public boolean isWarning() {
        return this._isWarning;
    }

    @Override
    public String getPath() {
        if (this.locator instanceof NodeInfo) {
            return Navigator.getPath((NodeInfo)this.locator);
        }
        return null;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public static void maybeSetHostLanguage(XmlProcessingError error, HostLanguage lang) {
        if (error.getHostLanguage() == HostLanguage.UNKNOWN) {
            if (error instanceof XmlProcessingIncident) {
                ((XmlProcessingIncident)error).setHostLanguage(lang);
            } else if (error instanceof XmlProcessingException) {
                ((XmlProcessingException)error).getXPathException().setHostLanguage(lang);
            }
        }
    }

    public static void maybeSetLocation(XmlProcessingError error, Location loc) {
        if (error.getLocation() == null) {
            if (error instanceof XmlProcessingIncident) {
                ((XmlProcessingIncident)error).setLocation(loc);
            } else if (error instanceof XmlProcessingException) {
                ((XmlProcessingException)error).getXPathException().setLocation(loc);
            }
        }
    }
}

