/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Optional;
import java.util.TimeZone;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.number.AbstractNumberer;
import net.sf.saxon.expr.number.Alphanumeric;
import net.sf.saxon.expr.number.NamedTimeZone;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.expr.number.NumericGroupFormatter;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.functions.FormatInteger;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.regex.ARegexIterator;
import net.sf.saxon.regex.ARegularExpression;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.charclass.Categories;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.StringConstants;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntIterator;

public class FormatDate
extends SystemFunction
implements Callable {
    static final String[] knownCalendars = new String[]{"AD", "AH", "AME", "AM", "AP", "AS", "BE", "CB", "CE", "CL", "CS", "EE", "FE", "ISO", "JE", "KE", "KY", "ME", "MS", "NS", "OS", "RS", "SE", "SH", "SS", "TE", "VE", "VS"};
    private static final UnicodeString STR_0 = BMPString.of("0");
    private static final UnicodeString STR_01 = BMPString.of("01");
    private static final UnicodeString STR_1 = BMPString.of("1");
    private static final UnicodeString STR_f = BMPString.of("f");
    private static final UnicodeString STR_F = BMPString.of("F");
    private static final UnicodeString STR_i = BMPString.of("i");
    private static final UnicodeString STR_I = BMPString.of("I");
    private static final UnicodeString STR_J = BMPString.of("J");
    private static final UnicodeString STR_M = BMPString.of("M");
    private static final UnicodeString STR_N = BMPString.of("N");
    private static final UnicodeString STR_Nn = BMPString.of("Nn");
    private static final UnicodeString STR_n = BMPString.of("n");
    private static final UnicodeString STR_P = BMPString.of("P");
    private static final UnicodeString STR_s = BMPString.of("s");
    private static final UnicodeString STR_Y = BMPString.of("Y");
    private static final UnicodeString STR_Z = BMPString.of("Z");
    private static final ARegularExpression componentPattern = ARegularExpression.compile("([YMDdWwFHhmsfZzPCE])\\s*(.*)", "");
    private static final ARegularExpression widthPattern = ARegularExpression.compile(",(\\*|[0-9]+)(\\-(\\*|[0-9]+))?", "");
    private static final ARegularExpression digitsPattern = ARegularExpression.compile("\\p{Nd}+", "");
    private static final ARegularExpression digitsOrOptionalDigitsPattern = ARegularExpression.compile("[#\\p{Nd}]+", "");
    private static final ARegularExpression fractionalDigitsPattern = ARegularExpression.compile("\\p{Nd}+#*", "");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String adjustCalendar(String calendarVal, String result, XPathContext context) throws XPathException {
        StructuredQName cal;
        try {
            cal = StructuredQName.fromLexicalQName(calendarVal, false, true, this.getRetainedStaticContext());
        }
        catch (XPathException e) {
            XPathException err = new XPathException("Invalid calendar name. " + e.getMessage());
            err.setErrorCode("FOFD1340");
            err.setXPathContext(context);
            throw err;
        }
        if (!cal.hasURI(NamespaceUri.NULL)) return "[Calendar: AD]" + result;
        String calLocal = cal.getLocalPart();
        if (calLocal.equals("AD")) return result;
        if (calLocal.equals("ISO")) return result;
        if (Arrays.binarySearch(knownCalendars, calLocal) >= 0) {
            return "[Calendar: AD]" + result;
        }
        XPathException err = new XPathException("Unknown no-namespace calendar: " + calLocal);
        err.setErrorCode("FOFD1340");
        err.setXPathContext(context);
        throw err;
    }

    private static String formatDate(CalendarValue value, String format, String language, String place, XPathContext context) throws XPathException {
        TimeZone tz;
        boolean languageDefaulted;
        Configuration config = context.getConfiguration();
        boolean bl = languageDefaulted = language == null;
        if (language == null) {
            language = config.getDefaultLanguage();
        }
        if (place == null) {
            place = config.getDefaultCountry();
        }
        if (value.hasTimezone() && place.contains("/") && (tz = TimeZone.getTimeZone(place)) != null) {
            BigDecimal seconds = value.toDateTime().secondsSinceEpoch();
            int milliOffset = tz.getOffset(seconds.longValue() * 1000L);
            value = value.adjustTimezone(milliOffset / 60000);
        }
        Numberer numberer = config.makeNumberer(language, place);
        StringBuilder sb = new StringBuilder(64);
        if (!languageDefaulted && numberer.getClass() == Numberer_en.class && !language.startsWith("en")) {
            sb.append("[Language: en]");
        }
        if (numberer.defaultedLocale() != null) {
            sb.append("[Language: " + numberer.defaultedLocale().getLanguage() + "]");
        }
        int i = 0;
        while (true) {
            int close;
            if (i < format.length() && format.charAt(i) != '[') {
                sb.append(format.charAt(i));
                if (format.charAt(i) == ']' && (++i == format.length() || format.charAt(i) != ']')) {
                    XPathException e = new XPathException("Closing ']' in date picture must be written as ']]'");
                    e.setErrorCode("FOFD1340");
                    e.setXPathContext(context);
                    throw e;
                }
                ++i;
                continue;
            }
            if (i == format.length()) break;
            if (++i < format.length() && format.charAt(i) == '[') {
                sb.append('[');
                ++i;
                continue;
            }
            int n = close = i < format.length() ? format.indexOf("]", i) : -1;
            if (close == -1) {
                XPathException e = new XPathException("Date format contains a '[' with no matching ']'");
                e.setErrorCode("FOFD1340");
                e.setXPathContext(context);
                throw e;
            }
            String componentFormat = format.substring(i, close);
            sb.append(FormatDate.formatComponent(value, Whitespace.removeAllWhitespace(componentFormat), numberer, place, context));
            i = close + 1;
        }
        return sb.toString();
    }

    private static UnicodeString formatComponent(CalendarValue value, String specifier, Numberer numberer, String country, XPathContext context) throws XPathException {
        boolean ignoreDate = value instanceof TimeValue;
        boolean ignoreTime = value instanceof DateValue;
        DateTimeValue dtvalue = value.toDateTime();
        UnicodeString uSpecifier = StringView.of(specifier).tidy();
        ARegexIterator matcher = (ARegexIterator)componentPattern.analyze(uSpecifier);
        StringValue firstMatch = matcher.next();
        if (firstMatch == null || firstMatch.getUnicodeStringValue().length32() != uSpecifier.length32() || !matcher.isMatching()) {
            XPathException error = new XPathException("Unrecognized date/time component [" + specifier + ']');
            error.setErrorCode("FOFD1340");
            error.setXPathContext(context);
            throw error;
        }
        UnicodeString component = matcher.getRegexGroup(1);
        UnicodeString format = matcher.getRegexGroup(2);
        boolean defaultFormat = false;
        if (format.isEmpty() || format.codePointAt(0L) == 44) {
            defaultFormat = true;
            switch (component.codePointAt(0L)) {
                case 70: {
                    format = STR_Nn.concat(format);
                    break;
                }
                case 80: {
                    format = STR_n.concat(format);
                    break;
                }
                case 67: 
                case 69: {
                    format = STR_N.concat(format);
                    break;
                }
                case 109: 
                case 115: {
                    format = STR_01.concat(format);
                    break;
                }
                case 90: 
                case 122: {
                    break;
                }
                default: {
                    format = STR_1.concat(format);
                }
            }
        }
        switch (component.codePointAt(0L)) {
            case 89: {
                if (ignoreDate) {
                    XPathException error = new XPathException("In format-time(): an xs:time value does not contain a year component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int year = dtvalue.getYear();
                if (year < 0) {
                    year = -year;
                }
                return FormatDate.formatNumber(component, year, format, defaultFormat, numberer, context);
            }
            case 77: {
                if (ignoreDate) {
                    XPathException error = new XPathException("In format-time(): an xs:time value does not contain a month component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                byte month = dtvalue.getMonth();
                return FormatDate.formatNumber(component, month, format, defaultFormat, numberer, context);
            }
            case 68: {
                if (ignoreDate) {
                    XPathException error = new XPathException("In format-time(): an xs:time value does not contain a day component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                byte day = dtvalue.getDay();
                return FormatDate.formatNumber(component, day, format, defaultFormat, numberer, context);
            }
            case 100: {
                if (ignoreDate) {
                    XPathException error = new XPathException("In format-time(): an xs:time value does not contain a day component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int day = DateValue.getDayWithinYear(dtvalue.getYear(), dtvalue.getMonth(), dtvalue.getDay());
                return FormatDate.formatNumber(component, day, format, defaultFormat, numberer, context);
            }
            case 87: {
                if (ignoreDate) {
                    XPathException error = new XPathException("In format-time(): cannot obtain the week number from an xs:time value");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int week = DateValue.getWeekNumber(dtvalue.getYear(), dtvalue.getMonth(), dtvalue.getDay());
                return FormatDate.formatNumber(component, week, format, defaultFormat, numberer, context);
            }
            case 119: {
                if (ignoreDate) {
                    XPathException error = new XPathException("In format-time(): cannot obtain the week number from an xs:time value");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int week = DateValue.getWeekNumberWithinMonth(dtvalue.getYear(), dtvalue.getMonth(), dtvalue.getDay());
                return FormatDate.formatNumber(component, week, format, defaultFormat, numberer, context);
            }
            case 72: {
                if (ignoreTime) {
                    XPathException error = new XPathException("In format-date(): an xs:date value does not contain an hour component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                Int64Value hour = (Int64Value)value.getComponent(AccessorFn.Component.HOURS);
                assert (hour != null);
                return FormatDate.formatNumber(component, (int)hour.longValue(), format, defaultFormat, numberer, context);
            }
            case 104: {
                if (ignoreTime) {
                    XPathException error = new XPathException("In format-date(): an xs:date value does not contain an hour component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                Int64Value hour = (Int64Value)value.getComponent(AccessorFn.Component.HOURS);
                assert (hour != null);
                int hr = (int)hour.longValue();
                if (hr > 12) {
                    hr -= 12;
                }
                if (hr == 0) {
                    hr = 12;
                }
                return FormatDate.formatNumber(component, hr, format, defaultFormat, numberer, context);
            }
            case 109: {
                if (ignoreTime) {
                    XPathException error = new XPathException("In format-date(): an xs:date value does not contain a minutes component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                Int64Value minutes = (Int64Value)value.getComponent(AccessorFn.Component.MINUTES);
                assert (minutes != null);
                return FormatDate.formatNumber(component, (int)minutes.longValue(), format, defaultFormat, numberer, context);
            }
            case 115: {
                if (ignoreTime) {
                    XPathException error = new XPathException("In format-date(): an xs:date value does not contain a seconds component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                IntegerValue seconds = (IntegerValue)value.getComponent(AccessorFn.Component.WHOLE_SECONDS);
                assert (seconds != null);
                return FormatDate.formatNumber(component, (int)seconds.longValue(), format, defaultFormat, numberer, context);
            }
            case 102: {
                if (ignoreTime) {
                    XPathException error = new XPathException("In format-date(): an xs:date value does not contain a fractional seconds component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                Int64Value micros = (Int64Value)value.getComponent(AccessorFn.Component.MICROSECONDS);
                assert (micros != null);
                return FormatDate.formatNumber(component, (int)micros.longValue(), format, defaultFormat, numberer, context);
            }
            case 90: 
            case 122: {
                DateTimeValue dtv;
                if (value instanceof TimeValue) {
                    int tzoffset;
                    DateTimeValue now = DateTimeValue.getCurrentDateTime(context);
                    int year = now.getYear();
                    DateTimeValue baseDate = new DateTimeValue(year, 1, 1, 0, 0, 0, 0, tzoffset = value.getTimezoneInMinutes(), false);
                    Optional<Boolean> b = NamedTimeZone.inSummerTime(baseDate, country);
                    if (b.isPresent() && b.get().booleanValue()) {
                        baseDate = new DateTimeValue(year, 7, 1, 0, 0, 0, 0, tzoffset, false);
                    }
                    dtv = DateTimeValue.makeDateTimeValue(baseDate.toDateValue(), (TimeValue)value);
                } else {
                    dtv = value.toDateTime();
                }
                return FormatDate.formatTimeZone(dtv, (char)component.codePointAt(0L), format, country);
            }
            case 70: {
                if (ignoreDate) {
                    XPathException error = new XPathException("In format-time(): an xs:time value does not contain day-of-week component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int day = DateValue.getDayOfWeek(dtvalue.getYear(), dtvalue.getMonth(), dtvalue.getDay());
                return FormatDate.formatNumber(component, day, format, defaultFormat, numberer, context);
            }
            case 80: {
                if (ignoreTime) {
                    XPathException error = new XPathException("In format-date(): an xs:date value does not contain an am/pm component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int minuteOfDay = dtvalue.getHour() * 60 + dtvalue.getMinute();
                return FormatDate.formatNumber(component, minuteOfDay, format, defaultFormat, numberer, context);
            }
            case 67: {
                return StringView.of(numberer.getCalendarName("AD")).tidy();
            }
            case 69: {
                if (ignoreDate) {
                    XPathException error = new XPathException("In format-time(): an xs:time value does not contain an AD/BC component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int year = dtvalue.getYear();
                return StringView.of(numberer.getEraName(year)).tidy();
            }
        }
        XPathException e = new XPathException("Unknown format-date/time component specifier '" + format.substring(0L, 1L) + '\'');
        e.setErrorCode("FOFD1340");
        e.setXPathContext(context);
        throw e;
    }

    private static UnicodeString formatNumber(UnicodeString component, int value, UnicodeString format, boolean defaultFormat, Numberer numberer, XPathContext context) throws XPathException {
        int formattedLen;
        NumericGroupFormatter picGroupFormat;
        int primaryLen;
        int comma = (int)StringTool.lastIndexOf(format, 44);
        UnicodeString widths = EmptyUnicodeString.getInstance();
        if (comma >= 0) {
            widths = format.substring(comma);
            format = format.prefix(comma);
        }
        UnicodeString primary = format;
        String letterValue = null;
        String ordinal = null;
        int lastCP = StringTool.lastCodePoint(primary);
        if (lastCP == 116) {
            primary = primary.prefix(primary.length() - 1L);
            letterValue = "traditional";
        } else if (lastCP == 111) {
            primary = primary.prefix(primary.length() - 1L);
            ordinal = numberer.getOrdinalSuffixForDateTime(component.toString());
        }
        int min = 1;
        int max = Integer.MAX_VALUE;
        if (digitsPattern.matches(primary) && (primaryLen = primary.length32()) > 1) {
            min = primaryLen;
            max = primaryLen;
        }
        if (STR_Y.equals(component)) {
            max = 0;
            min = 0;
            if (!widths.isEmpty()) {
                max = FormatDate.getWidths(widths)[1];
            } else if (digitsPattern.containsMatch(primary)) {
                IntIterator primaryIter = primary.codePoints();
                while (primaryIter.hasNext()) {
                    int c = primaryIter.next();
                    if (c == 35) {
                        ++max;
                        continue;
                    }
                    if ((c < 48 || c > 57) && !Categories.ESCAPE_d.test(c)) continue;
                    ++min;
                    ++max;
                }
            }
            if (max <= 1) {
                max = Integer.MAX_VALUE;
            }
            if (max < 4 || max < Integer.MAX_VALUE && value > 9999) {
                value %= (int)Math.pow(10.0, max);
            }
        }
        if (primary.equals(STR_I) || primary.equals(STR_i)) {
            int[] range = FormatDate.getWidths(widths);
            min = range[0];
            String roman = numberer.format(value, primary, null, letterValue, "", ordinal);
            UnicodeBuilder s = new UnicodeBuilder(32);
            s.append(roman);
            for (int len = StringTool.getStringLength(roman); len < min; ++len) {
                s.append(' ');
            }
            return s.toUnicodeString();
        }
        if (!widths.isEmpty()) {
            int[] range = FormatDate.getWidths(widths);
            min = Math.max(min, range[0]);
            max = max == Integer.MAX_VALUE ? range[1] : Math.max(max, range[1]);
            if (defaultFormat && StringTool.lastCodePoint(primary) == 49 && (long)min != primary.length()) {
                UnicodeBuilder sb = new UnicodeBuilder(min + 1);
                for (int i = 1; i < min; ++i) {
                    sb.append('0');
                }
                sb.append('1');
                primary = sb.toUnicodeString();
            }
        }
        if (STR_P.equals(component)) {
            if (!(STR_N.equals(primary) || STR_n.equals(primary) || STR_Nn.equals(primary))) {
                primary = STR_n;
            }
            if (max == Integer.MAX_VALUE) {
                max = 4;
            }
        } else if (STR_Y.equals(component)) {
            if (max < Integer.MAX_VALUE) {
                value %= (int)Math.pow(10.0, max);
            }
        } else if (STR_f.equals(component)) {
            int zeroDigit;
            UnicodeString str;
            if (!digitsPattern.containsMatch(primary)) {
                return FormatDate.formatNumber(component, value, STR_1, defaultFormat, numberer, context);
            }
            if (!digitsOrOptionalDigitsPattern.matches(primary)) {
                UnicodeString reverseFormat = FormatDate.reverse(format);
                UnicodeString reverseValue = FormatDate.reverse(BMPString.of("" + value));
                UnicodeString reverseResult = FormatDate.formatNumber(STR_s, Integer.parseInt(reverseValue.toString()), reverseFormat, false, numberer, context);
                UnicodeString correctedResult = FormatDate.reverse(reverseResult);
                if (correctedResult.length() > (long)max) {
                    correctedResult = correctedResult.prefix(max);
                }
                return correctedResult;
            }
            if (!fractionalDigitsPattern.matches(primary)) {
                throw new XPathException("Invalid picture for fractional seconds: " + primary, "FOFD1340");
            }
            if (value == 0) {
                str = STR_0;
            } else {
                str = BMPString.of((1000000 + value + "").substring(1));
                if (str.length() > (long)max) {
                    str = str.prefix(max);
                }
            }
            while (str.length() < (long)min) {
                str = str.concat(STR_0);
            }
            if (str.length() > (long)min) {
                while (str.length() > (long)min && str.codePointAt(str.length() - 1L) == 48) {
                    str = str.prefix(str.length() - 1L);
                }
            }
            if ((zeroDigit = Alphanumeric.getDigitFamily(format.codePointAt(0L))) >= 0 && zeroDigit != 48) {
                int[] digits = new int[10];
                for (int z = 0; z <= 9; ++z) {
                    digits[z] = zeroDigit + z;
                }
                long n = Long.parseLong(str.toString());
                int requiredLength = str.length32();
                str = StringView.tidy(AbstractNumberer.convertDigitSystem(n, digits, requiredLength));
            }
            return str;
        }
        if (STR_N.equals(primary) || STR_n.equals(primary) || STR_Nn.equals(primary)) {
            String s = "";
            if (STR_M.equals(component)) {
                s = numberer.monthName(value, min, max);
            } else if (STR_F.equals(component)) {
                s = numberer.dayName(value, min, max);
            } else if (STR_P.equals(component)) {
                s = numberer.halfDayName(value, min, max);
            } else {
                primary = STR_1;
            }
            if (STR_N.equals(primary)) {
                return StringView.tidy(s.toUpperCase());
            }
            if (STR_n.equals(primary)) {
                return StringView.tidy(s.toLowerCase());
            }
            return StringView.tidy(s);
        }
        try {
            picGroupFormat = FormatInteger.getPicSeparators(primary);
        }
        catch (XPathException e) {
            if ("FODF1310".equals(e.getErrorCodeLocalPart())) {
                e.setErrorCode("FOFD1340");
            }
            throw e;
        }
        UnicodeString adjustedPicture = picGroupFormat.getAdjustedPicture();
        String formattedStr = numberer.format(value, adjustedPicture, picGroupFormat, letterValue, "", ordinal);
        if (formattedLen < min) {
            int digitZero = Alphanumeric.getDigitFamily(adjustedPicture.codePointAt(0L));
            StringBuilder fsb = new StringBuilder(formattedStr);
            for (formattedLen = StringTool.getStringLength(formattedStr); formattedLen < min; ++formattedLen) {
                StringTool.prependWideChar(fsb, digitZero);
            }
            formattedStr = fsb.toString();
        }
        return StringView.tidy(formattedStr);
    }

    private static UnicodeString reverse(UnicodeString in) {
        UnicodeBuilder builder = new UnicodeBuilder(in.length32());
        for (long i = in.length() - 1L; i >= 0L; --i) {
            builder.append(in.codePointAt(i));
        }
        return builder.toUnicodeString();
    }

    private static int[] getWidths(UnicodeString widths) throws XPathException {
        try {
            int min = -1;
            int max = -1;
            if (!widths.isEmpty()) {
                RegexIterator widthIter = widthPattern.analyze(widths);
                StringValue firstMatch = widthIter.next();
                if (firstMatch != null && firstMatch.length() == widths.length() && widthIter.isMatching()) {
                    UnicodeString smin = widthIter.getRegexGroup(1);
                    min = smin == null || smin.isEmpty() || StringConstants.ASTERISK.equals(smin) ? 1 : Integer.parseInt(smin.toString());
                    UnicodeString smax = widthIter.getRegexGroup(3);
                    max = smax == null || smax.isEmpty() || StringConstants.ASTERISK.equals(smax) ? Integer.MAX_VALUE : Integer.parseInt(smax.toString());
                    if (min < 1) {
                        throw new XPathException("Invalid min value in format picture " + Err.wrap(widths, 4), "FOFD1340");
                    }
                    if (max < 1 || max < min) {
                        throw new XPathException("Invalid max value in format picture " + Err.wrap(widths, 4), "FOFD1340");
                    }
                } else {
                    throw new XPathException("Unrecognized width specifier in format picture " + Err.wrap(widths, 4), "FOFD1340");
                }
            }
            int[] result = new int[]{min, max};
            return result;
        }
        catch (NumberFormatException err) {
            XPathException e = new XPathException("Invalid integer used as width in date/time picture");
            e.setErrorCode("FOFD1340");
            throw e;
        }
    }

    private static UnicodeString formatTimeZone(DateTimeValue value, char component, UnicodeString format, String country) throws XPathException {
        int[] expandedFormat;
        boolean useZforZero;
        int comma = (int)StringTool.lastIndexOf(format, 44);
        UnicodeString widthModifier = EmptyUnicodeString.getInstance();
        if (comma >= 0) {
            widthModifier = format.substring(comma);
            format = format.prefix(comma);
        }
        if (!value.hasTimezone()) {
            if (format.equals(STR_Z)) {
                return STR_J;
            }
            return EmptyUnicodeString.getInstance();
        }
        if (format.isEmpty() && !widthModifier.isEmpty()) {
            int[] widths = FormatDate.getWidths(widthModifier);
            int min = widths[0];
            int max = widths[1];
            format = min <= 1 ? BMPString.of(max >= 4 ? "0:00" : "0") : (min <= 4 ? BMPString.of(max >= 5 ? "00:00" : "00") : BMPString.of("00:00"));
        }
        if (format.isEmpty()) {
            format = BMPString.of("00:00");
        }
        int tz = value.getTimezoneInMinutes();
        boolean bl = useZforZero = StringTool.lastCodePoint(format) == 116;
        if (useZforZero && tz == 0) {
            return STR_Z;
        }
        if (useZforZero) {
            format = format.prefix(format.length() - 1L);
        }
        int digits = 0;
        int separators = 0;
        int separatorChar = 58;
        int zeroDigit = -1;
        for (int ch : expandedFormat = StringTool.expand(format)) {
            if (Character.getType(ch) == 9) {
                ++digits;
                if (zeroDigit >= 0) continue;
                zeroDigit = Alphanumeric.getDigitFamily(ch);
                continue;
            }
            ++separators;
            separatorChar = ch;
        }
        int[] buffer = new int[10];
        int used = 0;
        if (digits > 0) {
            int hourDigits;
            if (component == 'z') {
                buffer[0] = 71;
                buffer[1] = 77;
                buffer[2] = 84;
                used = 3;
            }
            boolean negative = tz < 0;
            tz = Math.abs(tz);
            buffer[used++] = negative ? 45 : 43;
            int hour = tz / 60;
            int minute = tz % 60;
            boolean includeMinutes = minute != 0 || digits >= 3 || separators > 0;
            boolean includeSep = minute != 0 && digits <= 2 || separators > 0 && (minute != 0 || digits >= 3);
            int n = hourDigits = digits <= 2 ? digits : digits - 2;
            if (hour > 9 || hourDigits >= 2) {
                buffer[used++] = zeroDigit + hour / 10;
            }
            buffer[used++] = hour % 10 + zeroDigit;
            if (includeSep) {
                buffer[used++] = separatorChar;
            }
            if (includeMinutes) {
                buffer[used++] = minute / 10 + zeroDigit;
                buffer[used++] = minute % 10 + zeroDigit;
            }
            return StringTool.fromCodePoints(buffer, used);
        }
        if (format.equals(BMPString.of("Z"))) {
            int hour = tz / 60;
            int minute = tz % 60;
            if (hour < -12 || hour > 12 || minute != 0) {
                return FormatDate.formatTimeZone(value, 'Z', BMPString.of("00:00"), country);
            }
            return BMPString.of("" + "YXWVUTSRQPONZABCDEFGHIKLM".charAt(hour + 12));
        }
        if (format.codePointAt(0L) == 78 || format.codePointAt(0L) == 110) {
            return StringView.of(FormatDate.getNamedTimeZone(value, country, format)).tidy();
        }
        return FormatDate.formatTimeZone(value, 'Z', BMPString.of("00:00"), country);
    }

    private static String getNamedTimeZone(DateTimeValue value, String country, UnicodeString format) throws XPathException {
        int min = 1;
        int comma = (int)format.indexOf(44);
        if (comma > 0) {
            UnicodeString widths = format.substring(comma);
            int[] range = FormatDate.getWidths(widths);
            min = range[0];
        }
        if (format.codePointAt(0L) == 78 || format.codePointAt(0L) == 110) {
            if (min <= 5) {
                String tzname = NamedTimeZone.getTimeZoneNameForDate(value, country);
                if (tzname == null) {
                    return FormatDate.formatTimeZone(value, 'Z', BMPString.of("Z00:00t"), country).toString();
                }
                if (format.codePointAt(0L) == 110) {
                    tzname = tzname.toLowerCase();
                }
                return tzname;
            }
            return NamedTimeZone.getOlsonTimeZoneName(value, country);
        }
        UnicodeBuilder sbz = new UnicodeBuilder(16);
        value.appendTimezone(sbz);
        return sbz.toString();
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String place;
        CalendarValue value = (CalendarValue)arguments[0].head();
        if (value == null) {
            return EmptySequence.getInstance();
        }
        String format = arguments[1].head().getStringValue();
        Item calendarVal = null;
        Item countryVal = null;
        StringValue languageVal = null;
        if (this.getArity() > 2) {
            languageVal = (StringValue)arguments[2].head();
            calendarVal = (StringValue)arguments[3].head();
            countryVal = (StringValue)arguments[4].head();
        }
        String calendar = calendarVal == null ? null : calendarVal.getStringValue();
        String language = languageVal == null ? null : languageVal.getStringValue();
        String string = place = countryVal == null ? null : countryVal.getStringValue();
        if (place != null) {
            value = this.adjustTimezoneToPlace(value, place);
        }
        String result = FormatDate.formatDate(value, format, language, place, context);
        if (calendarVal != null) {
            result = this.adjustCalendar(calendar, result, context);
        }
        return new StringValue(result);
    }

    private CalendarValue adjustTimezoneToPlace(CalendarValue value, String place) {
        ZoneId zone;
        if (place.contains("/") && value.hasTimezone() && !(value instanceof TimeValue) && (zone = NamedTimeZone.getNamedTimeZone(place)) != null) {
            int offsetSeconds = zone.getRules().getOffset(value.toDateTime().toJavaInstant()).getTotalSeconds();
            return value.adjustTimezone(offsetSeconds / 60);
        }
        return value;
    }
}

