/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.UserFunctionResolvable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.hof.UnresolvedXQueryFunctionItem;
import net.sf.saxon.functions.hof.UserFunctionReference;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.UnboundFunctionLibrary;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.SequenceType;

public class XQueryFunctionLibrary
implements FunctionLibrary,
XQueryFunctionBinder {
    private Configuration config;
    private HashMap<SymbolicName, XQueryFunction> functions = new HashMap(20);
    private HashMap<StructuredQName, List<XQueryFunction>> functionsByName = new HashMap(20);

    public XQueryFunctionLibrary(Configuration config) {
        this.config = config;
    }

    @Override
    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void declareFunction(XQueryFunction function) throws XPathException {
        SymbolicName keyObj = function.getIdentificationKey();
        StructuredQName functionName = function.getFunctionName();
        List existingFunctions = this.functionsByName.computeIfAbsent(functionName, k -> new ArrayList(2));
        for (XQueryFunction existing : existingFunctions) {
            if (existing == function) {
                return;
            }
            if (!XQueryFunctionLibrary.hasOverlappingArity(function, existing)) continue;
            XPathException err = new XPathException("Conflicting definition of function " + function.getDisplayName() + " (see line " + existing.getLineNumber() + " in " + existing.getSystemId() + ')');
            err.setErrorCode("XQST0034");
            err.setIsStaticError(true);
            err.setLocator(function);
            throw err;
        }
        this.functions.put(keyObj, function);
        existingFunctions.add(function);
    }

    private static boolean hasOverlappingArity(XQueryFunction f1, XQueryFunction f2) {
        return f1.getMinimumArity() <= f2.getNumberOfParameters() && f2.getMinimumArity() <= f1.getNumberOfParameters();
    }

    @Override
    public FunctionItem getFunctionItem(SymbolicName.F functionName, StaticContext staticContext) throws XPathException {
        XQueryFunction fd = this.getDeclaration(functionName.getComponentName(), functionName.getArity());
        if (fd != null) {
            if (fd.isPrivate() && !fd.getSystemId().equals(staticContext.getStaticBaseURI())) {
                throw new XPathException("Cannot call the private function " + functionName.getComponentName().getDisplayName() + " from outside its module", "XPST0017");
            }
            UserFunction fn = fd.getUserFunction();
            if (fn == null) {
                UserFunction uf = new UserFunction();
                uf.setFunctionName(functionName.getComponentName());
                uf.setResultType(fd.getResultType());
                uf.setParameterDefinitions(fd.getParameterDefinitions());
                UserFunctionReference ref = new UserFunctionReference(uf, functionName);
                fd.registerReference(ref);
                return new UnresolvedXQueryFunctionItem(fd, functionName, ref);
            }
            if (functionName.getArity() == fd.getNumberOfParameters()) {
                return fn;
            }
            ReducedArityCallable callable = new ReducedArityCallable(fd, fn);
            SequenceType[] argTypes = new SequenceType[functionName.getArity()];
            for (int i = 0; i < functionName.getArity(); ++i) {
                argTypes[i] = fd.getArgumentTypes()[i];
            }
            SpecificFunctionType functionType = new SpecificFunctionType(argTypes, fd.getResultType());
            return new CallableFunction(functionName, (Callable)callable, (FunctionItemType)functionType);
        }
        return null;
    }

    @Override
    public boolean isAvailable(SymbolicName.F functionName, int languageLevel) {
        return this.functions.get(functionName) != null;
    }

    @Override
    public Expression bind(SymbolicName.F functionName, Expression[] arguments, Map<StructuredQName, Integer> keywords, StaticContext env, List<String> reasons) throws XPathException {
        XQueryFunction fd = this.getDeclaration(functionName.getComponentName(), arguments.length);
        if (fd != null) {
            if (fd.isPrivate() && fd.getStaticContext() != env) {
                reasons.add("Cannot call the private XQuery function " + functionName.getComponentName().getDisplayName() + " from outside its module");
                return null;
            }
            UserFunctionCall ufc = new UserFunctionCall();
            ufc.setFunctionName(fd.getFunctionName());
            int maxArity = fd.getNumberOfParameters();
            if (arguments.length == maxArity && (keywords == null || keywords.isEmpty())) {
                ufc.setArguments(arguments);
            } else {
                Expression[] expandedArgs = UserFunction.makeExpandedArgumentArray(arguments, keywords, fd);
                ufc.setArguments(expandedArgs);
                for (Expression e : expandedArgs) {
                    ufc.adoptChildExpression(e);
                }
            }
            ufc.setStaticType(fd.getResultType());
            UserFunction fn = fd.getUserFunction();
            if (fn == null) {
                fd.registerReference(ufc);
            } else {
                ufc.setFunction(fn);
            }
            return ufc;
        }
        return null;
    }

    @Override
    public XQueryFunction getDeclaration(StructuredQName functionName, int staticArgs) {
        List<XQueryFunction> homonyms = this.functionsByName.get(functionName);
        if (homonyms != null) {
            for (XQueryFunction f : homonyms) {
                if (f.getMinimumArity() > staticArgs || f.getNumberOfParameters() < staticArgs) continue;
                return f;
            }
        }
        return null;
    }

    @Override
    public boolean bindUnboundFunctionCall(UserFunctionCall ufc, List<String> reasons) {
        UnboundFunctionLibrary.UnboundFunctionCallDetails details = ufc.getUnboundCallDetails();
        assert (details != null);
        StructuredQName functionName = details.functionName.getComponentName();
        Expression[] arguments = details.arguments;
        Map<StructuredQName, Integer> keywords = details.keywords;
        XQueryFunction fd = this.getDeclaration(functionName, arguments.length);
        if (fd != null) {
            if (fd.isPrivate() && fd.getStaticContext() != details.env) {
                reasons.add("Cannot call the private XQuery function " + functionName.getDisplayName() + " from outside its module");
                return false;
            }
            ufc.setFunctionName(fd.getFunctionName());
            int maxArity = fd.getNumberOfParameters();
            if (arguments.length == maxArity && (details.keywords == null || details.keywords.isEmpty())) {
                ufc.setArguments(arguments);
            } else {
                Expression[] expandedArgs = Arrays.copyOf(arguments, maxArity);
                if (keywords != null) {
                    int positionalArgs = arguments.length - keywords.size();
                    for (Map.Entry<StructuredQName, Integer> entry : keywords.entrySet()) {
                        StructuredQName key = entry.getKey();
                        int argPos = entry.getValue();
                        int paramPos = fd.getPositionOfParameter(key);
                        if (paramPos < 0) {
                            throw new UncheckedXPathException("Keyword " + key + " does not match the name of any declared parameter", "XPST0142");
                        }
                        if (paramPos < positionalArgs) {
                            throw new UncheckedXPathException("Parameter " + key + " is supplied both by position and by keyword", "XPST0141");
                        }
                        Expression supplied = arguments[paramPos];
                        expandedArgs[argPos] = null;
                        expandedArgs[paramPos] = supplied;
                    }
                }
                for (int a = 0; a < maxArity; ++a) {
                    if (expandedArgs[a] != null) continue;
                    Expression expr = fd.getParameterDefinitions()[a].getDefaultValueExpression();
                    expandedArgs[a] = expr.copy(new RebindingMap());
                }
                ufc.setArguments(expandedArgs);
            }
            ufc.setStaticType(fd.getResultType());
            UserFunction fn = fd.getUserFunction();
            if (fn == null) {
                fd.registerReference(ufc);
            } else {
                ufc.setFunction(fn);
            }
            return true;
        }
        return false;
    }

    public XQueryFunction getDeclarationByKey(SymbolicName functionKey) {
        return this.functions.get(functionKey);
    }

    public Iterable<XQueryFunction> getFunctionDefinitions() {
        return this.functions.values();
    }

    protected void fixupGlobalFunctions(QueryModule env) throws XPathException {
        ExpressionVisitor visitor = ExpressionVisitor.make(env);
        for (XQueryFunction fn : this.functions.values()) {
            fn.compile();
        }
        for (XQueryFunction fn : this.functions.values()) {
            fn.checkReferences(visitor);
        }
    }

    protected void optimizeGlobalFunctions(QueryModule topModule) throws XPathException {
        for (XQueryFunction fn : this.functions.values()) {
            if (((QueryModule)fn.getStaticContext()).getTopLevelModule() != topModule) continue;
            fn.optimize();
        }
    }

    public void explainGlobalFunctions(ExpressionPresenter out) throws XPathException {
        for (XQueryFunction fn : this.functions.values()) {
            fn.explain(out);
        }
    }

    public UserFunction getUserDefinedFunction(NamespaceUri uri, String localName, int arity) {
        SymbolicName.F functionKey = new SymbolicName.F(new StructuredQName("", uri, localName), arity);
        XQueryFunction fd = this.functions.get(functionKey);
        if (fd == null) {
            return null;
        }
        return fd.getUserFunction();
    }

    @Override
    public FunctionLibrary copy() {
        XQueryFunctionLibrary qfl = new XQueryFunctionLibrary(this.config);
        qfl.functions = new HashMap<SymbolicName, XQueryFunction>(this.functions);
        return qfl;
    }

    private static class ReducedArityCallable
    implements Callable {
        private final XQueryFunction declaredFunction;
        private final UserFunction userFunction;

        public ReducedArityCallable(XQueryFunction fd, UserFunction fn) {
            this.declaredFunction = fd;
            this.userFunction = fn;
        }

        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Sequence[] extendedArguments = Arrays.copyOf(arguments, this.userFunction.getArity());
            for (int i = arguments.length; i < this.userFunction.getArity(); ++i) {
                extendedArguments[i] = this.declaredFunction.getParameterDefinitions()[i].getDefaultValueExpression().makeElaborator().eagerly().evaluate(context);
            }
            return this.userFunction.call(context, extendedArguments);
        }
    }

    public static class UnresolvedCallable
    implements UserFunctionResolvable,
    Callable {
        SymbolicName.F symbolicName;
        UserFunction function;

        public UnresolvedCallable(SymbolicName.F symbolicName) {
            this.symbolicName = symbolicName;
        }

        public StructuredQName getFunctionName() {
            return this.symbolicName.getComponentName();
        }

        public int getArity() {
            return this.symbolicName.getArity();
        }

        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            if (this.function == null) {
                throw new XPathException("Forwards reference to XQuery function has not been resolved");
            }
            Sequence[] args = new Sequence[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                args[i] = arguments[i].materialize();
            }
            return this.function.call(context.newCleanContext(), args);
        }

        @Override
        public void setFunction(UserFunction function) {
            this.function = function;
        }

        public UserFunction getFunction() {
            return this.function;
        }
    }
}

