/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceCollection;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.query.InputStreamMarker;
import net.sf.saxon.resource.BinaryResource;
import net.sf.saxon.resource.CatalogCollection;
import net.sf.saxon.resource.EncodingDetector;
import net.sf.saxon.resource.ResourceLoader;
import net.sf.saxon.resource.UnparsedTextResource;
import net.sf.saxon.s9api.XmlProcessingError;
import net.sf.saxon.trans.Maker;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingIncident;
import org.xml.sax.XMLReader;

public abstract class AbstractResourceCollection
implements ResourceCollection {
    protected Configuration config;
    protected String collectionURI;
    protected URIQueryParameters params = null;
    protected boolean noExceptions = false;

    public AbstractResourceCollection(Configuration config) {
        this.config = config;
    }

    public static void checkNotNull(String collectionURI, XPathContext context) throws XPathException {
        if (collectionURI == null) {
            XPathException err = new XPathException("No default collection has been defined");
            err.setErrorCode("FODC0002");
            err.setXPathContext(context);
            throw err;
        }
    }

    @Override
    public String getCollectionURI() {
        return this.collectionURI;
    }

    @Override
    public boolean isStable(XPathContext context) {
        if (this.params == null) {
            return false;
        }
        Optional<Boolean> stable = this.params.getStable();
        if (!stable.isPresent()) {
            return context.getConfiguration().getBooleanProperty(Feature.STABLE_COLLECTION_URI);
        }
        return stable.get();
    }

    public void registerContentType(String contentType, ResourceFactory factory) {
        this.config.registerMediaType(contentType, factory);
    }

    protected ParseOptions optionsFromQueryParameters(URIQueryParameters params, XPathContext context) {
        ParseOptions options = context.getConfiguration().getParseOptions();
        if (params != null) {
            Controller controller;
            Optional<Maker<XMLReader>> p;
            Optional<SpaceStrippingRule> stripSpace;
            Optional<Boolean> xInclude;
            Optional<Integer> v = params.getValidationMode();
            if (v.isPresent()) {
                options = options.withSchemaValidationMode(v.get());
            }
            if ((xInclude = params.getXInclude()).isPresent()) {
                options = options.withXIncludeAware(xInclude.get());
            }
            if ((stripSpace = params.getSpaceStrippingRule()).isPresent()) {
                options = options.withSpaceStrippingRule(stripSpace.get());
            }
            if ((p = params.getXMLReaderMaker()).isPresent()) {
                options = options.withXMLReaderMaker(p.get());
            }
            int onError = 1;
            if (params.getOnError().isPresent()) {
                onError = params.getOnError().get();
            }
            ErrorReporter oldErrorReporter = (controller = context.getController()) == null ? context.getConfiguration().makeErrorReporter() : controller.getErrorReporter();
            options = AbstractResourceCollection.setupErrorHandlingForCollection(options, onError, oldErrorReporter);
        }
        return options;
    }

    public static ParseOptions setupErrorHandlingForCollection(ParseOptions options, int onError, ErrorReporter oldErrorReporter) {
        if (onError == 3) {
            options = options.withErrorReporter(new ErrorSuppressor());
        } else if (onError == 2) {
            options = options.withErrorReporter(new ErrorAsWarningReporter(oldErrorReporter));
        }
        return options;
    }

    protected InputDetails getInputDetails(String resourceURI) throws XPathException {
        InputDetails inputDetails = new InputDetails();
        try {
            inputDetails.resourceUri = resourceURI;
            URI uri = new URI(resourceURI);
            if ("file".equals(uri.getScheme())) {
                inputDetails.contentType = this.params != null && this.params.getContentType().isPresent() ? this.params.getContentType().get() : this.guessContentTypeFromName(resourceURI);
            } else {
                URLConnection connection = ResourceLoader.urlConnection(uri.toURL());
                inputDetails.contentType = connection.getContentType();
                inputDetails.encoding = connection.getContentEncoding();
                for (String param : inputDetails.contentType.replace(" ", "").split(";")) {
                    if (param.startsWith("charset=")) {
                        inputDetails.encoding = param.split("=", 2)[1];
                        continue;
                    }
                    inputDetails.contentType = param;
                }
            }
            if (inputDetails.contentType == null || this.config.getResourceFactoryForMediaType(inputDetails.contentType) == null) {
                InputStream stream;
                if ("file".equals(uri.getScheme())) {
                    File file = new File(uri);
                    stream = new BufferedInputStream(new FileInputStream(file));
                    if (file.length() <= 1024L) {
                        inputDetails.binaryContent = BinaryResource.readBinaryFromStream(stream, resourceURI);
                        stream.close();
                        stream = new ByteArrayInputStream(inputDetails.binaryContent);
                    }
                } else {
                    stream = ResourceLoader.urlStream(uri.toURL());
                }
                inputDetails.contentType = this.guessContentTypeFromContent(stream);
                stream.close();
            }
            if (this.params != null && this.params.getOnError().isPresent()) {
                inputDetails.onError = this.params.getOnError().get();
            }
            return inputDetails;
        }
        catch (IOException | URISyntaxException e) {
            throw new XPathException(e);
        }
    }

    protected String guessContentTypeFromName(String resourceURI) {
        String contentTypeFromName = URLConnection.guessContentTypeFromName(resourceURI);
        String extension = null;
        if (contentTypeFromName == null && (extension = this.getFileExtension(resourceURI)) != null) {
            contentTypeFromName = this.config.getMediaTypeForFileExtension(extension);
        }
        return contentTypeFromName;
    }

    protected String guessContentTypeFromContent(InputStream stream) {
        try {
            stream = InputStreamMarker.ensureMarkSupported(stream);
            return URLConnection.guessContentTypeFromStream(stream);
        }
        catch (IOException err) {
            return null;
        }
    }

    private String getFileExtension(String name) {
        int p;
        int i = name.lastIndexOf(46);
        if (i > (p = Math.max(name.lastIndexOf(47), name.lastIndexOf(92))) && i + 1 < name.length()) {
            return name.substring(i + 1);
        }
        return null;
    }

    public Resource makeResource(XPathContext context, InputDetails details) throws XPathException {
        ResourceFactory factory = null;
        String contentType = details.contentType;
        if (contentType != null) {
            factory = context.getConfiguration().getResourceFactoryForMediaType(contentType);
        }
        if (factory == null) {
            factory = BinaryResource.FACTORY;
        }
        return factory.makeResource(context, details);
    }

    public Resource makeTypedResource(XPathContext context, Resource basicResource) throws XPathException {
        String mediaType = basicResource.getContentType();
        ResourceFactory factory = this.config.getResourceFactoryForMediaType(mediaType);
        if (factory == null) {
            return basicResource;
        }
        if (basicResource instanceof BinaryResource) {
            InputDetails details = new InputDetails();
            details.binaryContent = ((BinaryResource)basicResource).getData();
            details.contentType = mediaType;
            details.resourceUri = basicResource.getResourceURI();
            return factory.makeResource(context, details);
        }
        if (basicResource instanceof UnparsedTextResource) {
            InputDetails details = new InputDetails();
            details.characterContent = ((UnparsedTextResource)basicResource).getContent();
            details.contentType = mediaType;
            details.resourceUri = basicResource.getResourceURI();
            return factory.makeResource(context, details);
        }
        return basicResource;
    }

    public Resource makeResource(XPathContext context, String resourceURI) throws XPathException {
        InputDetails details = this.getInputDetails(resourceURI);
        return this.makeResource(context, details);
    }

    public boolean stripWhitespace(SpaceStrippingRule rules) {
        return false;
    }

    public static class InputDetails {
        public String resourceUri;
        public byte[] binaryContent;
        public String characterContent;
        public String contentType;
        public String encoding;
        public ParseOptions parseOptions;
        public int onError = 1;

        public InputStream getInputStream() throws IOException {
            return ResourceLoader.urlStream(new URL(this.resourceUri));
        }

        public byte[] obtainBinaryContent() throws XPathException {
            byte[] byArray;
            block10: {
                if (this.binaryContent != null) {
                    return this.binaryContent;
                }
                if (this.characterContent != null) {
                    String e = this.encoding != null ? this.encoding : "UTF-8";
                    return BinaryResource.encode(this.characterContent, e);
                }
                InputStream stream = this.getInputStream();
                try {
                    byArray = BinaryResource.readBinaryFromStream(stream, this.resourceUri);
                    if (stream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new XPathException(e);
                    }
                }
                stream.close();
            }
            return byArray;
        }

        public String obtainCharacterContent() throws XPathException {
            if (this.characterContent != null) {
                return this.characterContent;
            }
            if (this.binaryContent != null && this.encoding != null) {
                return BinaryResource.decode(this.binaryContent, this.encoding);
            }
            try {
                InputStream stream = this.getInputStream();
                String enc = this.encoding;
                if (enc == null) {
                    stream = InputStreamMarker.ensureMarkSupported(stream);
                    enc = EncodingDetector.inferStreamEncoding(stream, "UTF-8", null);
                }
                this.characterContent = CatalogCollection.makeStringFromStream(stream, enc);
                return this.characterContent;
            }
            catch (IOException e) {
                if (this.onError == 1) {
                    throw new XPathException(e);
                }
                return null;
            }
        }
    }

    private static class ErrorAsWarningReporter
    implements ErrorReporter {
        private final ErrorReporter originalErrorReporter;

        public ErrorAsWarningReporter(ErrorReporter originalErrorReporter) {
            this.originalErrorReporter = originalErrorReporter;
        }

        @Override
        public void report(XmlProcessingError error) {
            if (error.isWarning()) {
                this.originalErrorReporter.report(error);
            } else {
                this.originalErrorReporter.report(error.asWarning());
                XmlProcessingIncident supp = new XmlProcessingIncident("The document will be excluded from the collection", "SXWN9050").asWarning();
                supp.setLocation(error.getLocation());
                this.originalErrorReporter.report(supp);
            }
        }
    }

    private static class ErrorSuppressor
    implements ErrorReporter {
        private ErrorSuppressor() {
        }

        @Override
        public void report(XmlProcessingError error) {
        }
    }
}

