/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.net.URISyntaxException;
import javax.xml.transform.Source;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.trans.XPathException;

public class ResourceRequest {
    public static final String TEXT_NATURE = "https://www.iana.org/assignments/media-types/text/plain";
    public static final String BINARY_NATURE = "https://www.iana.org/assignments/media-types/application/binary";
    public static final String XQUERY_NATURE = "https://www.iana.org/assignments/media-types/application/xquery";
    public static final String XSLT_NATURE = "http://www.w3.org/1999/XSL/Transform";
    public static final String XSD_NATURE = "http://www.w3.org/2001/XMLSchema";
    public static final String XML_NATURE = "https://www.iana.org/assignments/media-types/application/xml";
    public static final String DTD_NATURE = "https://www.iana.org/assignments/media-types/application/xml-dtd";
    public static final String EXTERNAL_ENTITY_NATURE = "https://www.iana.org/assignments/media-types/application/xml-external-parsed-entity";
    public static final String ANY_PURPOSE = null;
    public static final String SCHEMA_NATURE = "http://www.w3.org/2001/XMLSchema";
    public static final String VALIDATION_PURPOSE = "http://www.rddl.org/purposes#validation";
    public static final String ANY_NATURE = null;
    public String uri;
    public String baseUri;
    public String relativeUri;
    public String publicId;
    public String entityName;
    public String nature;
    public String purpose;
    public boolean uriIsNamespace;
    public boolean streamable;

    public ResourceRequest copy() {
        ResourceRequest rr = new ResourceRequest();
        rr.relativeUri = this.relativeUri;
        rr.baseUri = this.baseUri;
        rr.uri = this.uri;
        rr.uriIsNamespace = this.uriIsNamespace;
        rr.publicId = this.publicId;
        rr.purpose = this.purpose;
        rr.nature = this.nature;
        rr.entityName = this.entityName;
        rr.streamable = this.streamable;
        return rr;
    }

    public Source resolve(ResourceResolver ... resolvers) throws XPathException {
        for (ResourceResolver resolver : resolvers) {
            if (resolver == null) continue;
            Source s = null;
            try {
                s = resolver.resolve(this);
            }
            catch (XPathException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IllegalArgumentException) {
                    IllegalArgumentException iae = (IllegalArgumentException)cause;
                    if (iae.getCause() instanceof URISyntaxException) {
                        throw new XPathException("Invalid URI " + this.uri, iae.getCause());
                    }
                }
                throw e;
            }
            if (s == null) continue;
            return s;
        }
        return null;
    }
}

