/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.HashSet;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.resource.EncodingDetector;
import net.sf.saxon.resource.ParsedContentType;
import net.sf.saxon.resource.TypedStreamSource;

public class ResourceLoader {
    public static int MAX_REDIRECTS = 20;

    public static URLConnection urlConnection(URL url) throws IOException {
        if ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol())) {
            HttpURLConnection conn;
            block4: {
                HashSet<String> visited = new HashSet<String>();
                String cookies = null;
                int count = MAX_REDIRECTS;
                do {
                    int status;
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setInstanceFollowRedirects(false);
                    conn.setRequestProperty("Accept-Encoding", "gzip");
                    if (cookies != null) {
                        conn.setRequestProperty("Cookie", cookies);
                    }
                    if ((status = conn.getResponseCode()) != 301 && status != 302) break block4;
                    String location = conn.getHeaderField("Location");
                    url = new URL(location);
                    cookies = conn.getHeaderField("Set-Cookie");
                    if (visited.contains(location)) {
                        throw new IOException("HTTP redirect loop through " + location);
                    }
                    visited.add(location);
                } while (--count >= 0);
                throw new IOException("HTTP redirects more than " + MAX_REDIRECTS + " times");
            }
            return conn;
        }
        return url.openConnection();
    }

    public static InputStream urlStream(Configuration config, String url) throws IOException {
        if (config != null && url.startsWith("classpath:")) {
            String path = url.length() > 10 && url.charAt(10) == '/' ? url.substring(11) : url.substring(10);
            return config.getDynamicLoader().getResourceAsStream(path);
        }
        URLConnection conn = ResourceLoader.urlConnection(new URL(url));
        InputStream inputStream = conn.getInputStream();
        String contentEncoding = conn.getContentEncoding();
        if ("gzip".equals(contentEncoding)) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public static StreamSource typedStreamSource(Configuration config, String url) throws IOException {
        if (config != null && url.startsWith("classpath:")) {
            return new StreamSource(ResourceLoader.urlStream(config, url), url);
        }
        URLConnection conn = ResourceLoader.urlConnection(new URL(url));
        InputStream inputStream = conn.getInputStream();
        if ("gzip".equals(conn.getContentEncoding())) {
            inputStream = new GZIPInputStream(inputStream);
        }
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        TypedStreamSource tss = new TypedStreamSource();
        tss.setInputStream(inputStream);
        tss.setContentType(conn.getContentType());
        tss.setSystemId(url);
        return tss;
    }

    public static Reader urlReader(Configuration config, String url, String requestedEncoding) throws IOException {
        String contentType;
        String resourceEncoding = null;
        boolean isXmlMediaType = false;
        URLConnection conn = null;
        InputStream inputStream = null;
        if (config != null && url.startsWith("classpath:")) {
            inputStream = ResourceLoader.urlStream(config, url);
        } else {
            conn = ResourceLoader.urlConnection(new URL(url));
            inputStream = conn.getInputStream();
            String contentEncoding = conn.getContentEncoding();
            if ("gzip".equals(contentEncoding)) {
                inputStream = new GZIPInputStream(inputStream);
            }
        }
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (conn != null && !url.startsWith("file:") && (contentType = conn.getContentType()) != null) {
            ParsedContentType parsedContentType = new ParsedContentType(contentType);
            isXmlMediaType = parsedContentType.isXmlMediaType;
            resourceEncoding = parsedContentType.encoding;
        }
        try {
            if (requestedEncoding == null) {
                requestedEncoding = "UTF-8";
            }
            if (resourceEncoding == null || isXmlMediaType) {
                resourceEncoding = EncodingDetector.inferStreamEncoding(inputStream, requestedEncoding, null);
            }
        }
        catch (IOException e) {
            resourceEncoding = "UTF-8";
        }
        assert (resourceEncoding != null);
        return ResourceLoader.getReaderFromStream(inputStream, resourceEncoding);
    }

    public static BufferedReader getReaderFromStream(InputStream inputStream, String resourceEncoding) throws UnsupportedEncodingException {
        try {
            Objects.requireNonNull(inputStream);
            Objects.requireNonNull(resourceEncoding);
            Charset charset2 = Charset.forName(resourceEncoding);
            CharsetDecoder decoder = charset2.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            return new BufferedReader(new InputStreamReader(inputStream, decoder));
        }
        catch (Exception e) {
            throw new UnsupportedEncodingException("Unable to get reader with encoding: " + resourceEncoding);
        }
    }
}

