/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.File;
import java.net.URI;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ConfigurableResourceResolver;
import net.sf.saxon.lib.DirectResourceResolver;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.FeatureData;
import net.sf.saxon.lib.FeatureIndex;
import net.sf.saxon.lib.Initializer;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmEmptySequence;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xmlresolver.ResolverFeature;

public class CommandLineOptions {
    public static final int TYPE_BOOLEAN = 1;
    public static final int TYPE_FILENAME = 2;
    public static final int TYPE_CLASSNAME = 3;
    public static final int TYPE_ENUMERATION = 4;
    public static final int TYPE_INTEGER = 5;
    public static final int TYPE_QNAME = 6;
    public static final int TYPE_FILENAME_LIST = 7;
    public static final int TYPE_DATETIME = 8;
    public static final int TYPE_STRING = 9;
    public static final int TYPE_INTEGER_PAIR = 10;
    public static final int VALUE_REQUIRED = 256;
    public static final int VALUE_PROHIBITED = 512;
    private final HashMap<String, Integer> recognizedOptions = new HashMap();
    private final HashMap<String, String> optionHelp = new HashMap();
    private final Properties namedOptions = new Properties();
    private final Properties configOptions = new Properties();
    private final Map<String, Set<String>> permittedValues = new HashMap<String, Set<String>>();
    private final Map<String, String> defaultValues = new HashMap<String, String>();
    private final List<String> positionalOptions = new ArrayList<String>();
    private final Properties paramValues = new Properties();
    private final Properties paramExpressions = new Properties();
    private final Properties paramFiles = new Properties();
    private final Properties serializationParams = new Properties();

    public static URI getCurrentWorkingDirectory() {
        return new File(System.getProperty("user.dir")).toURI();
    }

    public void addRecognizedOption(String option, int optionProperties, String helpText) {
        this.recognizedOptions.put(option, optionProperties);
        this.optionHelp.put(option, helpText);
        if ((optionProperties & 0xFF) == 1) {
            this.setPermittedValues(option, new String[]{"on", "off"}, "on");
        }
    }

    public void setPermittedValues(String option, String[] values, String defaultValue) {
        HashSet<String> valueSet = new HashSet<String>(Arrays.asList(values));
        this.permittedValues.put(option, valueSet);
        if (defaultValue != null) {
            this.defaultValues.put(option, defaultValue);
        }
    }

    private static String displayPermittedValues(Set<String> permittedValues) {
        StringBuilder sb = new StringBuilder(20);
        for (String val : permittedValues) {
            if ("".equals(val)) {
                sb.append("\"\"");
            } else {
                sb.append(val);
            }
            sb.append('|');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public void setActualOptions(String[] args) throws XPathException {
        for (String arg : args) {
            if ("-".equals(arg)) {
                this.positionalOptions.add(arg);
                continue;
            }
            if (arg.charAt(0) == '-') {
                String msg;
                int prop;
                String option;
                int colon;
                String value = "";
                if (arg.length() > 2 && arg.charAt(1) == '-') {
                    colon = arg.indexOf(58);
                    if (colon > 0 && colon < arg.length() - 1) {
                        option = arg.substring(2, colon);
                        value = arg.substring(colon + 1);
                        this.configOptions.setProperty(option, value);
                        continue;
                    }
                    if (colon > 0 && colon == arg.length() - 1) {
                        option = arg.substring(2, colon);
                        this.configOptions.setProperty(option, "");
                        continue;
                    }
                    option = arg.substring(2);
                    this.configOptions.setProperty(option, "true");
                    continue;
                }
                colon = arg.indexOf(58);
                if (colon > 0 && colon < arg.length() - 1) {
                    option = arg.substring(1, colon);
                    value = arg.substring(colon + 1);
                } else {
                    option = arg.substring(1);
                }
                if (this.recognizedOptions.getOrDefault(option, -1) == -1) {
                    throw new XPathException("Command line option -" + option + " is not recognized. Options available: " + this.displayPermittedOptions());
                }
                if (this.namedOptions.getProperty(option) != null) {
                    throw new XPathException("Command line option -" + option + " appears more than once");
                }
                if ("?".equals(value)) {
                    this.displayOptionHelp(option);
                    throw new XPathException("No processing requested");
                }
                if ("".equals(value)) {
                    prop = this.recognizedOptions.get(option);
                    if ((prop & 0x100) != 0) {
                        msg = "Command line option -" + option + " requires a value";
                        if (this.permittedValues.get(option) != null) {
                            msg = msg + ": permitted values are " + CommandLineOptions.displayPermittedValues(this.permittedValues.get(option));
                        }
                        throw new XPathException(msg);
                    }
                    String defaultValue = this.defaultValues.get(option);
                    if (defaultValue != null) {
                        value = defaultValue;
                    }
                } else {
                    prop = this.recognizedOptions.get(option);
                    if ((prop & 0x200) != 0) {
                        msg = "Command line option -" + option + " does not expect a value";
                        throw new XPathException(msg);
                    }
                }
                Set<String> permitted = this.permittedValues.get(option);
                if (permitted != null && !permitted.contains(value)) {
                    throw new XPathException("Bad option value " + arg + ": permitted values are " + CommandLineOptions.displayPermittedValues(permitted));
                }
                this.namedOptions.setProperty(option, value);
                continue;
            }
            int eq = arg.indexOf(61);
            if (eq >= 1) {
                char ch;
                String keyword = arg.substring(0, eq);
                String value = "";
                if (eq < arg.length() - 1) {
                    value = arg.substring(eq + 1);
                }
                if ((ch = arg.charAt(0)) == '!' && eq >= 2) {
                    this.serializationParams.setProperty(keyword.substring(1), value);
                    continue;
                }
                if (ch == '?' && eq >= 2) {
                    this.paramExpressions.setProperty(keyword.substring(1), value);
                    continue;
                }
                if (ch == '+' && eq >= 2) {
                    this.paramFiles.setProperty(keyword.substring(1), value);
                    continue;
                }
                this.paramValues.setProperty(keyword, value);
                continue;
            }
            this.positionalOptions.add(arg);
        }
    }

    public boolean definesParameterValues() {
        return !this.serializationParams.isEmpty() || !this.paramExpressions.isEmpty() || !this.paramFiles.isEmpty() || !this.paramValues.isEmpty();
    }

    public boolean testIfSchemaAware() {
        return this.getOptionValue("sa") != null || this.getOptionValue("outval") != null || this.getOptionValue("val") != null || this.getOptionValue("vlax") != null || this.getOptionValue("xsd") != null || this.getOptionValue("xsdversion") != null;
    }

    public void applyToConfiguration(Processor processor) throws TransformerException {
        Configuration config = processor.getUnderlyingConfiguration();
        if (this.configOptions.getProperty("?") != null) {
            System.err.println(CommandLineOptions.featureKeys(processor.getSaxonEdition()));
            return;
        }
        for (String name : this.configOptions.stringPropertyNames()) {
            String value = this.configOptions.getProperty(name);
            String fullName = "http://saxon.sf.net/feature/" + name;
            if (!name.startsWith("parserFeature?") && !name.startsWith("parserProperty?")) {
                if (FeatureIndex.exists(fullName)) {
                    FeatureData f = FeatureIndex.getData(fullName);
                    if (f == null) {
                        throw new XPathException("Unknown configuration feature " + name);
                    }
                    if (f.type == Boolean.class) {
                        Configuration.requireBoolean(name, value);
                    } else if (f.type == Integer.class) {
                        Integer.valueOf(value);
                    } else if (f.type != String.class) {
                        throw new XPathException("Property --" + name + " cannot be supplied as a string");
                    }
                } else {
                    throw new XPathException("Unknown configuration property --" + name);
                }
            }
            try {
                processor.getUnderlyingConfiguration().setConfigurationProperty(fullName, value);
            }
            catch (IllegalArgumentException err) {
                throw new XPathException("Incorrect value for --" + name + ": " + err.getMessage());
            }
        }
        Object optionValue = this.getOptionValue("catalog");
        if (optionValue != null) {
            ArrayList<String> catalogs = new ArrayList<String>();
            if (this.getOptionValue("u") != null || CommandLineOptions.isImplicitURI((String)optionValue)) {
                ResourceRequest request = new ResourceRequest();
                request.nature = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
                request.purpose = ResourceRequest.ANY_PURPOSE;
                for (String s : ((String)optionValue).split(";")) {
                    Source sourceInput;
                    try {
                        request.uri = s;
                        sourceInput = new DirectResourceResolver(config).resolve(request);
                    }
                    catch (XPathException e) {
                        throw new XPathException("Catalog file not found: " + s, e);
                    }
                    catalogs.add(sourceInput.getSystemId());
                }
            } else {
                for (String s : ((String)optionValue).split(";")) {
                    File catalogFile = new File(s);
                    if (!catalogFile.exists()) {
                        throw new XPathException("Catalog file not found: " + s);
                    }
                    catalogs.add(catalogFile.toURI().toASCIIString());
                }
            }
            this.setCatalogFiles(config, catalogs);
        }
        if ((optionValue = this.getOptionValue("dtd")) != null) {
            int mode = 0;
            switch (optionValue) {
                case "on": {
                    config.setBooleanProperty(Feature.DTD_VALIDATION, true);
                    mode = 1;
                    break;
                }
                case "off": {
                    config.setBooleanProperty(Feature.DTD_VALIDATION, false);
                    mode = 4;
                    break;
                }
                case "recover": {
                    config.setBooleanProperty(Feature.DTD_VALIDATION, true);
                    config.setBooleanProperty(Feature.DTD_VALIDATION_RECOVERABLE, true);
                    mode = 2;
                }
            }
            config.setParseOptions(config.getParseOptions().withDTDValidationMode(mode));
        }
        if ((optionValue = this.getOptionValue("ea")) != null) {
            boolean on = Configuration.requireBoolean("ea", optionValue);
            config.getDefaultXsltCompilerInfo().setAssertionsEnabled(on);
        }
        if ((optionValue = this.getOptionValue("expand")) != null) {
            boolean on = Configuration.requireBoolean("expand", optionValue);
            config.setParseOptions(config.getParseOptions().withExpandAttributeDefaults(on));
        }
        if ((optionValue = this.getOptionValue("ext")) != null) {
            boolean on = Configuration.requireBoolean("ext", optionValue);
            config.setBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS, on);
        }
        if ((optionValue = this.getOptionValue("l")) != null) {
            boolean on = Configuration.requireBoolean("l", optionValue);
            config.setBooleanProperty(Feature.LINE_NUMBERING, on);
        }
        if ((optionValue = this.getOptionValue("m")) != null) {
            config.setConfigurationProperty(Feature.MESSAGE_EMITTER_CLASS, optionValue);
        }
        if ((optionValue = this.getOptionValue("opt")) != null) {
            config.setConfigurationProperty(Feature.OPTIMIZATION_LEVEL, optionValue);
        }
        if ((optionValue = this.getOptionValue("or")) != null) {
            Object resolver = config.getInstance((String)optionValue);
            if (resolver instanceof OutputURIResolver) {
                config.setConfigurationProperty(Feature.OUTPUT_URI_RESOLVER, (OutputURIResolver)resolver);
            } else {
                throw new XPathException("Class " + (String)optionValue + " is not an OutputURIResolver");
            }
        }
        if ((optionValue = this.getOptionValue("outval")) != null) {
            Boolean isRecover = "recover".equals(optionValue);
            config.setConfigurationProperty(Feature.VALIDATION_WARNINGS, isRecover);
            config.setConfigurationProperty(Feature.VALIDATION_COMMENTS, isRecover);
        }
        if ((optionValue = this.getOptionValue("r")) != null) {
            config.setResourceResolver(config.makeResourceResolver((String)optionValue));
        }
        if ((optionValue = this.getOptionValue("strip")) != null) {
            config.setConfigurationProperty(Feature.STRIP_WHITESPACE, optionValue);
        }
        if ((optionValue = this.getOptionValue("T")) != null) {
            config.setCompileWithTracing(true);
        }
        if ((optionValue = this.getOptionValue("TJ")) != null) {
            boolean on = Configuration.requireBoolean("TJ", optionValue);
            config.setBooleanProperty(Feature.TRACE_EXTERNAL_FUNCTIONS, on);
        }
        if ((optionValue = this.getOptionValue("tree")) != null) {
            switch (optionValue) {
                case "linked": {
                    config.setTreeModel(0);
                    break;
                }
                case "tiny": {
                    config.setTreeModel(1);
                    break;
                }
                case "tinyc": {
                    config.setTreeModel(2);
                }
            }
        }
        if ((optionValue = this.getOptionValue("val")) != null) {
            if ("strict".equals(optionValue)) {
                processor.setConfigurationProperty(Feature.SCHEMA_VALIDATION, 1);
            } else if ("lax".equals(optionValue)) {
                processor.setConfigurationProperty(Feature.SCHEMA_VALIDATION, 2);
            }
        }
        if ((optionValue = this.getOptionValue("x")) != null) {
            processor.setConfigurationProperty(Feature.SOURCE_PARSER_CLASS, optionValue);
        }
        if ((optionValue = this.getOptionValue("xi")) != null) {
            boolean on = Configuration.requireBoolean("xi", optionValue);
            processor.setConfigurationProperty(Feature.XINCLUDE, on);
        }
        if ((optionValue = this.getOptionValue("xmlversion")) != null) {
            processor.setConfigurationProperty(Feature.XML_VERSION, optionValue);
        }
        if ((optionValue = this.getOptionValue("xsdversion")) != null) {
            processor.setConfigurationProperty(Feature.XSD_VERSION, optionValue);
        }
        if ((optionValue = this.getOptionValue("xsiloc")) != null) {
            boolean on = Configuration.requireBoolean("xsiloc", optionValue);
            processor.setConfigurationProperty(Feature.USE_XSI_SCHEMA_LOCATION, on);
        }
        if ((optionValue = this.getOptionValue("y")) != null) {
            processor.setConfigurationProperty(Feature.STYLE_PARSER_CLASS, optionValue);
        }
        if ((optionValue = this.getOptionValue("init")) != null) {
            this.invokeInitializer(processor, (String)optionValue);
        }
    }

    private void invokeInitializer(Processor processor, String initializationClass) throws TransformerException {
        Configuration config = processor.getUnderlyingConfiguration();
        Initializer initializer = (Initializer)config.getInstance(initializationClass);
        initializer.initialize(config);
    }

    private void setCatalogFiles(Configuration config, List<String> catalogs) {
        ResourceResolver rr = config.getResourceResolver();
        if (!(rr instanceof ConfigurableResourceResolver)) {
            throw new IllegalStateException("The resolver in the Configuration is not a ConfigurableResourceResolver");
        }
        CommandLineOptions.setCatalogFiles((ConfigurableResourceResolver)((Object)rr), catalogs);
    }

    public static void setCatalogFiles(ConfigurableResourceResolver crr, List<String> catalogs) {
        crr.setFeature(ResolverFeature.CATALOG_FILES, catalogs);
    }

    public String displayPermittedOptions() {
        String[] options = new String[this.recognizedOptions.size()];
        ArrayList<String> keys = new ArrayList<String>(this.recognizedOptions.keySet());
        options = keys.toArray(options);
        Arrays.sort(options, Collator.getInstance());
        StringBuilder sb = new StringBuilder(100);
        for (String opt : options) {
            sb.append(" -");
            sb.append(opt);
        }
        sb.append(" --?");
        return sb.toString();
    }

    private void displayOptionHelp(String option) {
        System.err.println("Help for -" + option + " option");
        int prop = this.recognizedOptions.get(option);
        if ((prop & 0x200) == 0) {
            switch (prop & 0xFF) {
                case 1: {
                    System.err.println("Value: on|off");
                    break;
                }
                case 5: {
                    System.err.println("Value: integer");
                    break;
                }
                case 2: {
                    System.err.println("Value: file name");
                    break;
                }
                case 7: {
                    System.err.println("Value: list of file names, semicolon-separated");
                    break;
                }
                case 3: {
                    System.err.println("Value: Java fully-qualified class name");
                    break;
                }
                case 6: {
                    System.err.println("Value: QName in Clark notation ({uri}local)");
                    break;
                }
                case 9: {
                    System.err.println("Value: string");
                    break;
                }
                case 10: {
                    System.err.println("Value: int,int");
                    break;
                }
                case 4: {
                    String message = "Value: one of ";
                    message = message + CommandLineOptions.displayPermittedValues(this.permittedValues.get(option));
                    System.err.println(message);
                    break;
                }
            }
        }
        System.err.println("Meaning: " + this.optionHelp.get(option));
    }

    public String getOptionValue(String option) {
        return this.namedOptions.getProperty(option);
    }

    public List<String> getPositionalOptions() {
        return this.positionalOptions;
    }

    public void setParams(Processor processor, ParamSetter paramSetter) throws SaxonApiException {
        String value;
        for (String name : this.paramValues.stringPropertyNames()) {
            value = this.paramValues.getProperty(name);
            paramSetter.setParam(QName.fromClarkName(name), new XdmAtomicValue(value, ItemType.UNTYPED_ATOMIC));
        }
        this.applyFileParameters(processor, paramSetter);
        for (String name : this.paramExpressions.stringPropertyNames()) {
            value = this.paramExpressions.getProperty(name);
            try {
                XPathCompiler xpc = processor.newXPathCompiler();
                XPathExecutable xpe = xpc.compile(value);
                XdmValue val = xpe.load().evaluate();
                paramSetter.setParam(QName.fromClarkName(name), val);
            }
            catch (SaxonApiException e) {
                throw new SaxonApiException("Failure evaluating XPath expression {" + value + "} on command line", e.getCause());
            }
        }
    }

    private void applyFileParameters(Processor processor, ParamSetter paramSetter) throws SaxonApiException {
        boolean useURLs = "on".equals(this.getOptionValue("u"));
        for (String name : this.paramFiles.stringPropertyNames()) {
            String value = this.paramFiles.getProperty(name);
            ArrayList<Source> sourceList = new ArrayList<Source>();
            CommandLineOptions.loadDocuments(value, useURLs, processor, true, sourceList);
            if (!sourceList.isEmpty()) {
                ArrayList<XdmNode> nodeList = new ArrayList<XdmNode>(sourceList.size());
                DocumentBuilder builder = processor.newDocumentBuilder();
                for (Source s : sourceList) {
                    nodeList.add(builder.build(s));
                }
                XdmValue nodes = new XdmValue(nodeList);
                paramSetter.setParam(QName.fromClarkName(name), nodes);
                continue;
            }
            paramSetter.setParam(QName.fromClarkName(name), XdmEmptySequence.getInstance());
        }
    }

    public void setSerializationProperties(Serializer serializer) {
        Iterator<String> iterator = this.serializationParams.stringPropertyNames().iterator();
        while (iterator.hasNext()) {
            String name;
            String key = name = iterator.next();
            String value = this.serializationParams.getProperty(key);
            if (key.startsWith("saxon:")) {
                key = "{http://saxon.sf.net/}" + key.substring(6);
            }
            serializer.setOutputProperty(QName.fromClarkName(key), value);
        }
    }

    public void applyStaticParams(XsltCompiler compiler) throws SaxonApiException {
        String value;
        Processor processor = compiler.getProcessor();
        for (String name : this.paramValues.stringPropertyNames()) {
            value = this.paramValues.getProperty(name);
            compiler.setParameter(QName.fromClarkName(name), new XdmAtomicValue(value, ItemType.UNTYPED_ATOMIC));
        }
        for (String name : this.paramExpressions.stringPropertyNames()) {
            value = this.paramExpressions.getProperty(name);
            try {
                XPathCompiler xpc = processor.newXPathCompiler();
                XPathExecutable xpe = xpc.compile(value);
                XdmValue val = xpe.load().evaluate();
                compiler.setParameter(QName.fromClarkName(name), val);
            }
            catch (SaxonApiException e) {
                throw new SaxonApiException("Failure evaluating XPath expression {" + value + "} on command line", e.getCause());
            }
        }
    }

    public void applyFileParams(Processor processor, Xslt30Transformer transformer) throws SaxonApiException {
        if (!this.paramFiles.isEmpty()) {
            HashMap params = new HashMap();
            this.applyFileParameters(processor, (name, value) -> params.put(name, value));
            transformer.setStylesheetParameters(params);
        }
    }

    public static boolean loadDocuments(String sourceFileName, boolean useURLs, Processor processor, boolean useSAXSource, List<Source> sources) throws SaxonApiException {
        Source sourceInput;
        Configuration config = processor.getUnderlyingConfiguration();
        if (useURLs || CommandLineOptions.isImplicitURI(sourceFileName)) {
            Source sourceInput2;
            try {
                ResourceRequest request = new ResourceRequest();
                request.uri = sourceFileName;
                request.nature = "https://www.iana.org/assignments/media-types/application/xml";
                request.purpose = ResourceRequest.ANY_PURPOSE;
                sourceInput2 = request.resolve(config.getResourceResolver(), new DirectResourceResolver(config));
            }
            catch (XPathException e) {
                throw new SaxonApiException(e);
            }
            sources.add(sourceInput2);
            return false;
        }
        if (sourceFileName.equals("-")) {
            Source sourceInput3 = useSAXSource ? new SAXSource(new InputSource(System.in)) : new StreamSource(System.in);
            sources.add(sourceInput3);
            return false;
        }
        File sourceFile = new File(sourceFileName);
        if (!sourceFile.exists()) {
            throw new SaxonApiException("Source file " + sourceFile + " does not exist");
        }
        if (sourceFile.isDirectory()) {
            XMLReader parser = config.getSourceParser();
            String[] files = sourceFile.list();
            if (files != null) {
                for (String file1 : files) {
                    Source sourceInput4;
                    File file = new File(sourceFile, file1);
                    if (file.isDirectory() || file.isHidden()) continue;
                    if (useSAXSource) {
                        InputSource eis = new InputSource(file.toURI().toString());
                        sourceInput4 = new SAXSource(parser, eis);
                    } else {
                        sourceInput4 = new StreamSource(file.toURI().toString());
                    }
                    sources.add(sourceInput4);
                }
            }
            return true;
        }
        if (useSAXSource) {
            InputSource eis = new InputSource(sourceFile.toURI().toString());
            sourceInput = new SAXSource(eis);
        } else {
            sourceInput = new StreamSource(sourceFile.toURI().toString());
        }
        sources.add(sourceInput);
        return false;
    }

    public static boolean isImplicitURI(String name) {
        return name.startsWith("http:") || name.startsWith("https:") || name.startsWith("file:") || name.startsWith("classpath:") || name.startsWith("jar:");
    }

    public static String coerceImplicitOutputURI(String outputName) {
        if (outputName == null) {
            return null;
        }
        if (outputName.startsWith("file:")) {
            if ((outputName = outputName.substring(5)).startsWith("/")) {
                outputName = outputName.replaceFirst("^/+", "/");
            }
            if (System.getProperty("os.name").startsWith("Windows") && outputName.matches("^/[A-Za-z]:.*$")) {
                outputName = outputName.substring(1);
            }
        }
        return outputName;
    }

    public static void loadAdditionalSchemas(Configuration config, String additionalSchemas) throws SchemaException {
        StringTokenizer st = new StringTokenizer(additionalSchemas, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String schema = st.nextToken();
            File schemaFile = new File(schema);
            if (!schemaFile.exists()) {
                throw new SchemaException("Schema document " + schema + " not found");
            }
            config.addSchemaSource(new StreamSource(schemaFile));
        }
    }

    public static String featureKeys(String edition) {
        int index = "http://saxon.sf.net/feature/".length();
        StringBuilder sb = new StringBuilder();
        for (String name : FeatureIndex.getNames()) {
            if (!FeatureIndex.getData((String)name).editions.contains(edition)) continue;
            sb.append("\n  ").append(name.substring(index));
        }
        return sb.toString();
    }

    public static String getCommandName(Object command) {
        String s = command.getClass().getName();
        if (s.startsWith("cli.Saxon.Cmd.DotNet")) {
            s = s.substring("cli.Saxon.Cmd.DotNet".length());
        }
        return s;
    }

    @FunctionalInterface
    public static interface ParamSetter {
        public void setParam(QName var1, XdmValue var2);
    }
}

