/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GeneralComparison20;
import net.sf.saxon.expr.IntegerRangeTest;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.RangeExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.BooleanElaborator;
import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.expr.sort.UntypedNumericComparer;
import net.sf.saxon.functions.Minimax;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.RangeIterator;
import net.sf.saxon.type.Affinity;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public abstract class GeneralComparison
extends BinaryExpression
implements ComparisonExpression {
    protected int singletonOperator;
    protected AtomicComparer comparer;
    protected boolean runtimeCheckNeeded = true;
    protected ComparisonCardinality comparisonCardinality = ComparisonCardinality.MANY_TO_MANY;
    protected boolean doneWarnings = false;

    public GeneralComparison(Expression p0, int op, Expression p1) {
        super(p0, op, p1);
        this.singletonOperator = GeneralComparison.getCorrespondingSingletonOperator(op);
    }

    public boolean needsRuntimeCheck() {
        return this.runtimeCheckNeeded;
    }

    public void setNeedsRuntimeCheck(boolean needsCheck) {
        this.runtimeCheckNeeded = needsCheck;
    }

    public ComparisonCardinality getComparisonCardinality() {
        return this.comparisonCardinality;
    }

    public void setComparisonCardinality(ComparisonCardinality card) {
        this.comparisonCardinality = card;
    }

    public void setAtomicComparer(AtomicComparer comparer) {
        this.comparer = comparer;
    }

    @Override
    public String getExpressionName() {
        return "GeneralComparison";
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.getRetainedStaticContext();
    }

    @Override
    public AtomicComparer getAtomicComparer() {
        return this.comparer;
    }

    @Override
    public StringCollator getStringCollator() {
        return this.comparer.getCollator();
    }

    @Override
    public int getSingletonOperator() {
        return this.singletonOperator;
    }

    @Override
    public boolean convertsUntypedToOther() {
        return true;
    }

    @Override
    protected int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Configuration config = visitor.getConfiguration();
        Expression oldOp0 = this.getLhsExpression();
        Expression oldOp1 = this.getRhsExpression();
        this.getLhs().typeCheck(visitor, contextInfo);
        this.getRhs().typeCheck(visitor, contextInfo);
        if (Literal.isEmptySequence(this.getLhsExpression()) || Literal.isEmptySequence(this.getRhsExpression())) {
            return Literal.makeLiteral(BooleanValue.FALSE, this);
        }
        this.setLhsExpression(this.getLhsExpression().unordered(false, false));
        this.setRhsExpression(this.getRhsExpression().unordered(false, false));
        SequenceType atomicType = SequenceType.ATOMIC_SEQUENCE;
        TypeChecker tc = config.getTypeChecker(false);
        Supplier<RoleDiagnostic> role0 = () -> new RoleDiagnostic(1, Token.tokens[this.operator], 0);
        this.setLhsExpression(tc.staticTypeCheck(this.getLhsExpression(), atomicType, role0, visitor));
        Supplier<RoleDiagnostic> role1 = () -> new RoleDiagnostic(1, Token.tokens[this.operator], 1);
        this.setRhsExpression(tc.staticTypeCheck(this.getRhsExpression(), atomicType, role1, visitor));
        if (this.getLhsExpression() != oldOp0) {
            this.adoptChildExpression(this.getLhsExpression());
        }
        if (this.getRhsExpression() != oldOp1) {
            this.adoptChildExpression(this.getRhsExpression());
        }
        ItemType t0 = this.getLhsExpression().getItemType();
        ItemType t1 = this.getRhsExpression().getItemType();
        if (t0 instanceof ErrorType || t1 instanceof ErrorType) {
            return Literal.makeLiteral(BooleanValue.FALSE, this);
        }
        if (t0.getUType().union(t1.getUType()).overlaps(UType.EXTENSION)) {
            throw new XPathException("Cannot perform comparisons involving external objects").asTypeError().withErrorCode("XPTY0004").withLocation(this.getLocation());
        }
        BuiltInAtomicType pt0 = (BuiltInAtomicType)t0.getPrimitiveItemType();
        BuiltInAtomicType pt1 = (BuiltInAtomicType)t1.getPrimitiveItemType();
        int c0 = this.getLhsExpression().getCardinality();
        int c1 = this.getRhsExpression().getCardinality();
        if (c0 == 8192 || c1 == 8192) {
            return Literal.makeLiteral(BooleanValue.FALSE, this);
        }
        if (!(t0.equals(BuiltInAtomicType.ANY_ATOMIC) || t0.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || t1.equals(BuiltInAtomicType.ANY_ATOMIC) || t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || Type.isPossiblyComparable(pt0, pt1, Token.isOrderedOperator(this.singletonOperator)))) {
            String message = "In {" + this.toShortString() + "}: cannot compare " + t0 + " to " + t1;
            if (Cardinality.allowsZero(c0) || Cardinality.allowsZero(c1)) {
                if (!this.doneWarnings) {
                    this.doneWarnings = true;
                    String which = "one";
                    if (Cardinality.allowsZero(c0) && !Cardinality.allowsZero(c1)) {
                        which = "the first";
                    } else if (Cardinality.allowsZero(c1) && !Cardinality.allowsZero(c0)) {
                        which = "the second";
                    }
                    visitor.getStaticContext().issueWarning(message + ". The comparison can succeed only if " + which + " operand is empty, and in that case will always be false", "SXWN9025", this.getLocation());
                }
            } else {
                throw new XPathException(message).withErrorCode("XPTY0004").asTypeError().withLocation(this.getLocation());
            }
        }
        boolean bl = this.runtimeCheckNeeded = !Type.isGuaranteedGenerallyComparable(pt0, pt1, Token.isOrderedOperator(this.singletonOperator));
        if (!(Cardinality.allowsMany(c0) || Cardinality.allowsMany(c1) || t0.equals(BuiltInAtomicType.ANY_ATOMIC) || t1.equals(BuiltInAtomicType.ANY_ATOMIC))) {
            Expression e0 = this.getLhsExpression();
            Expression e1 = this.getRhsExpression();
            if (t0.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                if (t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    e0 = new CastExpression(this.getLhsExpression(), BuiltInAtomicType.STRING, Cardinality.allowsZero(c0));
                    this.adoptChildExpression(e0);
                    e1 = new CastExpression(this.getRhsExpression(), BuiltInAtomicType.STRING, Cardinality.allowsZero(c1));
                    this.adoptChildExpression(e1);
                } else {
                    if (NumericType.isNumericType(t1)) {
                        this.setAtomicComparer(new UntypedNumericComparer());
                        return this;
                    }
                    e0 = new CastExpression(this.getLhsExpression(), pt1, Cardinality.allowsZero(c0));
                    this.adoptChildExpression(e0);
                }
            } else if (t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                if (NumericType.isNumericType(t0)) {
                    this.setAtomicComparer(new UntypedNumericComparer());
                    return this;
                }
                e1 = new CastExpression(this.getRhsExpression(), pt0, Cardinality.allowsZero(c1));
                this.adoptChildExpression(e1);
            }
            ValueComparison vc = new ValueComparison(e0, this.singletonOperator, e1);
            vc.setResultWhenEmpty(BooleanValue.FALSE);
            ExpressionTool.copyLocationInfo(this, vc);
            Optimizer.trace(config, "Replaced general comparison by value comparison", vc);
            return vc.typeCheck(visitor, contextInfo);
        }
        StaticContext env = visitor.getStaticContext();
        String defaultCollationName = this.getRetainedStaticContext().getDefaultCollationName();
        StringCollator collation = config.getCollation(defaultCollationName);
        if (collation == null) {
            collation = CodepointCollator.getInstance();
        }
        this.comparer = GenericAtomicComparer.makeAtomicComparer(pt0, pt1, collation, config.getConversionContext());
        if (this.getLhsExpression() instanceof Literal && this.getRhsExpression() instanceof Literal) {
            return Literal.makeLiteral(this.evaluateItem(env.makeEarlyEvaluationContext()), this);
        }
        return this;
    }

    private static Expression makeMinOrMax(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression exp, String function) throws XPathException {
        if (Cardinality.allowsMany(exp.getCardinality())) {
            SystemFunction fn = SystemFunction.makeFunction(function, exp.getRetainedStaticContext(), 1);
            ((Minimax)fn).setIgnoreNaN(true);
            Expression x = fn.makeOptimizedFunctionCall(visitor, contextInfo, exp);
            if (x == null) {
                x = fn.makeFunctionCall(exp);
            }
            return x;
        }
        return exp;
    }

    @Override
    public int getIntrinsicDependencies() {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        if (this.mayInvolveCastToQName(th, this.getLhsExpression(), this.getRhsExpression()) || this.mayInvolveCastToQName(th, this.getRhsExpression(), this.getLhsExpression())) {
            return 2048;
        }
        return 0;
    }

    private boolean mayInvolveCastToQName(TypeHierarchy th, Expression e1, Expression e2) {
        SimpleType s1 = (SimpleType)((Object)e1.getItemType().getAtomizedItemType());
        return (s1 == BuiltInAtomicType.ANY_ATOMIC || s1.isNamespaceSensitive()) && th.relationship(e2.getItemType().getAtomizedItemType(), BuiltInAtomicType.UNTYPED_ATOMIC) != Affinity.DISJOINT && (e2.getSpecialProperties() & 0x4000000) == 0;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof GeneralComparison && super.equals(other) && this.comparer.equals(((GeneralComparison)other).comparer);
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode();
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        StaticContext env = visitor.getStaticContext();
        this.getLhs().optimize(visitor, contextInfo);
        this.getRhs().optimize(visitor, contextInfo);
        if (Literal.isEmptySequence(this.getLhsExpression()) || Literal.isEmptySequence(this.getRhsExpression())) {
            return Literal.makeLiteral(BooleanValue.FALSE, this);
        }
        this.setLhsExpression(this.getLhsExpression().unordered(false, false));
        this.setRhsExpression(this.getRhsExpression().unordered(false, false));
        if (this.getLhsExpression() instanceof Literal && this.getRhsExpression() instanceof Literal) {
            return Literal.makeLiteral(this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext()).materialize(), this);
        }
        ItemType t0 = this.getLhsExpression().getItemType();
        ItemType t1 = this.getRhsExpression().getItemType();
        int c0 = this.getLhsExpression().getCardinality();
        int c1 = this.getRhsExpression().getCardinality();
        boolean many0 = Cardinality.allowsMany(c0);
        boolean many1 = Cardinality.allowsMany(c1);
        if (many0) {
            this.comparisonCardinality = many1 ? ComparisonCardinality.MANY_TO_MANY : ComparisonCardinality.MANY_TO_ONE;
        } else {
            if (many1) {
                GeneralComparison mc = this.getInverseComparison();
                mc.comparisonCardinality = ComparisonCardinality.MANY_TO_ONE;
                ExpressionTool.copyLocationInfo(this, mc);
                mc.comparer = this.comparer;
                mc.runtimeCheckNeeded = this.runtimeCheckNeeded;
                return mc.optimize(visitor, contextInfo);
            }
            this.comparisonCardinality = ComparisonCardinality.ONE_TO_ONE;
        }
        if (this.operator == 6) {
            GroundedValue value1;
            GroundedValue value0;
            if (this.getLhsExpression() instanceof RangeExpression) {
                Expression min = ((RangeExpression)this.getLhsExpression()).getStartExpression();
                Expression max = ((RangeExpression)this.getLhsExpression()).getEndExpression();
                IntegerRangeTest ir = new IntegerRangeTest(this.getRhsExpression(), min, max);
                ExpressionTool.copyLocationInfo(this, ir);
                return ir;
            }
            if (this.getRhsExpression() instanceof RangeExpression) {
                Expression min = ((RangeExpression)this.getRhsExpression()).getStartExpression();
                Expression max = ((RangeExpression)this.getRhsExpression()).getEndExpression();
                IntegerRangeTest ir = new IntegerRangeTest(this.getLhsExpression(), min, max);
                ExpressionTool.copyLocationInfo(this, ir);
                return ir;
            }
            if (this.getLhsExpression() instanceof Literal && (value0 = ((Literal)this.getLhsExpression()).getGroundedValue()) instanceof IntegerRange && ((IntegerRange)value0).getStep() == 1L) {
                long min = ((IntegerRange)value0).getStart();
                long max = ((IntegerRange)value0).getEnd();
                IntegerRangeTest ir = new IntegerRangeTest(this.getRhsExpression(), Literal.makeLiteral(Int64Value.makeIntegerValue(min), this), Literal.makeLiteral(Int64Value.makeIntegerValue(max), this));
                ExpressionTool.copyLocationInfo(this, ir);
                return ir;
            }
            if (this.getRhsExpression() instanceof Literal && (value1 = ((Literal)this.getRhsExpression()).getGroundedValue()) instanceof IntegerRange && ((IntegerRange)value1).getStep() == 1L) {
                long min = ((IntegerRange)value1).getStart();
                long max = ((IntegerRange)value1).getEnd();
                IntegerRangeTest ir = new IntegerRangeTest(this.getLhsExpression(), Literal.makeLiteral(Int64Value.makeIntegerValue(min), this), Literal.makeLiteral(Int64Value.makeIntegerValue(max), this));
                ExpressionTool.copyLocationInfo(this, ir);
                return ir;
            }
        }
        if (this.operator != 6 && this.operator != 22 && (this.comparisonCardinality == ComparisonCardinality.MANY_TO_MANY || this.comparisonCardinality == ComparisonCardinality.MANY_TO_ONE && (this.manyOperandIsLiftable() || this.manyOperandIsRangeExpression())) && (NumericType.isNumericType(t0) || NumericType.isNumericType(t1))) {
            ValueComparison vc;
            switch (this.operator) {
                case 12: 
                case 14: {
                    vc = new ValueComparison(GeneralComparison.makeMinOrMax(visitor, contextInfo, this.getLhsExpression(), "min"), this.singletonOperator, GeneralComparison.makeMinOrMax(visitor, contextInfo, this.getRhsExpression(), "max"));
                    vc.setResultWhenEmpty(BooleanValue.FALSE);
                    break;
                }
                case 11: 
                case 13: {
                    vc = new ValueComparison(GeneralComparison.makeMinOrMax(visitor, contextInfo, this.getLhsExpression(), "max"), this.singletonOperator, GeneralComparison.makeMinOrMax(visitor, contextInfo, this.getRhsExpression(), "min"));
                    vc.setResultWhenEmpty(BooleanValue.FALSE);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown operator " + this.operator);
                }
            }
            ExpressionTool.copyLocationInfo(this, vc);
            vc.setRetainedStaticContext(this.getRetainedStaticContext());
            return vc.typeCheck(visitor, contextInfo);
        }
        if (this.getLhsExpression() instanceof Literal && this.getRhsExpression() instanceof Literal) {
            return Literal.makeLiteral(this.evaluateItem(env.makeEarlyEvaluationContext()), this);
        }
        return visitor.obtainOptimizer().optimizeGeneralComparison(visitor, this, false, contextInfo);
    }

    private boolean manyOperandIsLiftable() {
        if (this.getParentExpression() instanceof ContextSwitchingExpression && ((ContextSwitchingExpression)((Object)this.getParentExpression())).getActionExpression() == this) {
            for (Operand o : this.operands()) {
                if (!Cardinality.allowsMany(o.getChildExpression().getCardinality()) || !ExpressionTool.dependsOnFocus(o.getChildExpression())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean manyOperandIsRangeExpression() {
        for (Operand o : this.operands()) {
            Expression e = o.getChildExpression();
            if (!Cardinality.allowsMany(e.getCardinality())) continue;
            return e instanceof RangeExpression || e instanceof Literal && ((Literal)e).getGroundedValue() instanceof IntegerRange;
        }
        return false;
    }

    @Override
    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.makeElaborator().elaborateForBoolean().eval(context));
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForBoolean().eval(context);
    }

    public static boolean compare(AtomicValue a0, int operator, AtomicValue a1, AtomicComparer comparer, boolean checkTypes, XPathContext context, NamespaceResolver nsResolver) throws XPathException {
        boolean u1;
        boolean u0 = a0.isUntypedAtomic();
        if (u0 != (u1 = a1.isUntypedAtomic())) {
            ConversionRules rules = context.getConfiguration().getConversionRules();
            if (u0) {
                if (a1 instanceof NumericValue) {
                    return UntypedNumericComparer.quickCompare((StringValue)a0, (NumericValue)a1, operator, rules);
                }
                if (!(a1 instanceof StringValue)) {
                    BuiltInAtomicType prim = a1.getPrimitiveType();
                    StringConverter sc = prim.getStringConverter(rules);
                    if (a1 instanceof QualifiedNameValue) {
                        sc = (StringConverter)sc.setNamespaceResolver(nsResolver);
                    }
                    a0 = sc.convertString(a0.getUnicodeStringValue()).asAtomic();
                }
            } else {
                if (a0 instanceof NumericValue) {
                    return UntypedNumericComparer.quickCompare((StringValue)a1, (NumericValue)a0, Token.inverse(operator), rules);
                }
                if (!(a0 instanceof StringValue)) {
                    BuiltInAtomicType prim = a0.getPrimitiveType();
                    StringConverter sc = prim.getStringConverter(rules);
                    if (a0 instanceof QualifiedNameValue) {
                        sc = (StringConverter)sc.setNamespaceResolver(nsResolver);
                    }
                    a1 = sc.convertString(a1.getUnicodeStringValue()).asAtomic();
                }
            }
            checkTypes = false;
        }
        return ValueComparison.compare(a0, operator, a1, comparer, checkTypes);
    }

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        return UType.BOOLEAN;
    }

    public static int getCorrespondingSingletonOperator(int op) {
        switch (op) {
            case 6: {
                return 50;
            }
            case 13: {
                return 54;
            }
            case 22: {
                return 51;
            }
            case 12: {
                return 53;
            }
            case 11: {
                return 52;
            }
            case 14: {
                return 55;
            }
        }
        return op;
    }

    protected GeneralComparison getInverseComparison() {
        GeneralComparison20 gc2 = new GeneralComparison20(this.getRhsExpression(), Token.inverse(this.operator), this.getLhsExpression());
        gc2.setRetainedStaticContext(this.getRetainedStaticContext());
        return gc2;
    }

    @Override
    public String getStreamerName() {
        return "GeneralComparison";
    }

    @Override
    protected String tag() {
        return "gc";
    }

    @Override
    protected void explainExtraAttributes(ExpressionPresenter out) {
        String cc = "";
        switch (this.comparisonCardinality) {
            case ONE_TO_ONE: {
                cc = "1:1";
                break;
            }
            case MANY_TO_ONE: {
                cc = "N:1";
                break;
            }
            case MANY_TO_MANY: {
                cc = "M:N";
            }
        }
        out.emitAttribute("card", cc);
        out.emitAttribute("comp", this.comparer.save());
    }

    @Override
    public Elaborator getElaborator() {
        return new GeneralComparisonElaborator();
    }

    public static class GeneralComparisonElaborator
    extends BooleanElaborator {
        @Override
        public BooleanEvaluator elaborateForBoolean() {
            GeneralComparison exp = (GeneralComparison)this.getExpression();
            ComparisonCardinality cardinality = exp.getComparisonCardinality();
            boolean needsRunTimeCheck = exp.needsRuntimeCheck();
            AtomicComparer comparer = exp.getAtomicComparer();
            RetainedStaticContext staticContext = exp.getRetainedStaticContext();
            int singletonOperator = exp.getSingletonOperator();
            switch (cardinality) {
                case ONE_TO_ONE: {
                    ItemEvaluator p0 = exp.getLhsExpression().makeElaborator().elaborateForItem();
                    ItemEvaluator p1 = exp.getRhsExpression().makeElaborator().elaborateForItem();
                    return context -> {
                        AtomicValue av0 = (AtomicValue)p0.eval(context);
                        if (av0 == null) {
                            return false;
                        }
                        AtomicValue av1 = (AtomicValue)p1.eval(context);
                        if (av1 == null) {
                            return false;
                        }
                        return GeneralComparison.compare(av0, singletonOperator, av1, comparer.provideContext(context), needsRunTimeCheck, context, staticContext);
                    };
                }
                case MANY_TO_ONE: {
                    PullEvaluator p0 = exp.getLhsExpression().makeElaborator().elaborateForPull();
                    ItemEvaluator p1 = exp.getRhsExpression().makeElaborator().elaborateForItem();
                    return context -> this.evaluateManyToOne(p0.iterate(context), (AtomicValue)p1.eval(context), singletonOperator, comparer, needsRunTimeCheck, staticContext, exp.getLocation(), context);
                }
                case MANY_TO_MANY: {
                    PullEvaluator p0 = exp.getLhsExpression().makeElaborator().elaborateForPull();
                    PullEvaluator p1 = exp.getRhsExpression().makeElaborator().elaborateForPull();
                    return context -> this.evaluateManyToMany(p0.iterate(context), p1.iterate(context), singletonOperator, comparer, needsRunTimeCheck, staticContext, exp.getLocation(), context);
                }
            }
            throw new UnsupportedOperationException();
        }

        public boolean evaluateManyToOne(SequenceIterator iter0, AtomicValue value1, int singletonOperator, AtomicComparer comparer, boolean runTimeCheckNeeded, RetainedStaticContext staticContext, Location loc, XPathContext context) throws XPathException {
            try {
                AtomicValue item0;
                if (value1 == null) {
                    return false;
                }
                if (iter0 instanceof RangeIterator) {
                    if (value1.isUntypedAtomic()) {
                        value1 = StringConverter.StringToInteger.INSTANCE.convertString(value1.getUnicodeStringValue()).asAtomic();
                    }
                    RangeIterator ri = (RangeIterator)iter0;
                    switch (singletonOperator) {
                        case 50: {
                            return ri.containsEq((NumericValue)value1);
                        }
                        case 51: {
                            return ri.getFirst().compareTo(ri.getLast()) != 0 || ri.getFirst().compareTo((NumericValue)value1) != 0;
                        }
                        case 55: {
                            return ri.getMin().compareTo((NumericValue)value1) <= 0;
                        }
                        case 53: {
                            return ri.getMin().compareTo((NumericValue)value1) < 0;
                        }
                        case 54: {
                            return ri.getMax().compareTo((NumericValue)value1) >= 0;
                        }
                        case 52: {
                            return ri.getMax().compareTo((NumericValue)value1) > 0;
                        }
                    }
                    throw new AssertionError();
                }
                AtomicComparer boundComparer = comparer.provideContext(context);
                while ((item0 = (AtomicValue)iter0.next()) != null) {
                    if (!GeneralComparison.compare(item0, singletonOperator, value1, boundComparer, runTimeCheckNeeded, context, staticContext)) continue;
                    iter0.close();
                    return true;
                }
                return false;
            }
            catch (XPathException e) {
                throw e.maybeWithLocation(loc).maybeWithContext(context);
            }
        }

        public boolean evaluateManyToMany(SequenceIterator iter0, SequenceIterator iter1, int singletonOperator, AtomicComparer comparer, boolean runTimeCheckNeeded, RetainedStaticContext staticContext, Location loc, XPathContext context) throws XPathException {
            try {
                boolean exhausted0 = false;
                boolean exhausted1 = false;
                ArrayList<AtomicValue> value0 = new ArrayList<AtomicValue>();
                ArrayList<AtomicValue> value1 = new ArrayList<AtomicValue>();
                AtomicComparer boundComparer = comparer.provideContext(context);
                while (true) {
                    if (!exhausted0) {
                        AtomicValue item0 = (AtomicValue)iter0.next();
                        if (item0 == null) {
                            if (exhausted1) {
                                return false;
                            }
                            exhausted0 = true;
                        } else {
                            for (AtomicValue item1 : value1) {
                                if (!GeneralComparison.compare(item0, singletonOperator, item1, boundComparer, runTimeCheckNeeded, context, staticContext)) continue;
                                iter0.close();
                                iter1.close();
                                return true;
                            }
                            if (!exhausted1) {
                                value0.add(item0);
                            }
                        }
                    }
                    if (exhausted1) continue;
                    AtomicValue item1 = (AtomicValue)iter1.next();
                    if (item1 == null) {
                        if (exhausted0) {
                            return false;
                        }
                        exhausted1 = true;
                        continue;
                    }
                    for (AtomicValue item0 : value0) {
                        if (!GeneralComparison.compare(item0, singletonOperator, item1, boundComparer, runTimeCheckNeeded, context, staticContext)) continue;
                        iter0.close();
                        iter1.close();
                        return true;
                    }
                    if (exhausted0) continue;
                    value1.add(item1);
                }
            }
            catch (XPathException e) {
                throw e.maybeWithLocation(loc).maybeWithContext(context);
            }
        }
    }

    public static enum ComparisonCardinality {
        ONE_TO_ONE,
        MANY_TO_ONE,
        MANY_TO_MANY;

    }
}

