/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.HashMap;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.UpdateEvaluator;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.TraceableComponent;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class ComponentTracer
extends Instruction {
    private Operand baseOp;
    private HashMap<String, Object> properties = new HashMap(10);
    private TraceableComponent component;

    public ComponentTracer(TraceableComponent component) {
        this.component = component;
        this.baseOp = new Operand(this, component.getBody(), OperandRole.SAME_FOCUS_ACTION);
        component.gatherProperties((k, v) -> this.properties.put((String)k, v));
    }

    private ComponentTracer() {
    }

    public Expression getChild() {
        return this.baseOp.getChildExpression();
    }

    public Expression getBody() {
        return this.baseOp.getChildExpression();
    }

    @Override
    public Iterable<Operand> operands() {
        return this.baseOp;
    }

    @Override
    public String getExpressionName() {
        return "trace";
    }

    @Override
    public String getStreamerName() {
        return "TraceExpr";
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        ComponentTracer t = new ComponentTracer();
        t.component = this.component;
        t.properties = this.properties;
        Expression newBody = this.getChild().copy(rebindings);
        t.baseOp = new Operand(t, newBody, OperandRole.SAME_FOCUS_ACTION);
        t.adoptChildExpression(newBody);
        t.setLocation(this.getLocation());
        return t;
    }

    @Override
    public boolean isUpdatingExpression() {
        return this.getChild().isUpdatingExpression();
    }

    @Override
    public boolean isVacuousExpression() {
        return this.getChild().isVacuousExpression();
    }

    @Override
    public void checkForUpdatingSubexpressions() throws XPathException {
        this.getChild().checkForUpdatingSubexpressions();
    }

    @Override
    public int getImplementationMethod() {
        return this.getChild().getImplementationMethod();
    }

    @Override
    public ItemType getItemType() {
        return this.getChild().getItemType();
    }

    @Override
    public int getCardinality() {
        return this.getChild().getCardinality();
    }

    @Override
    public int getDependencies() {
        return this.getChild().getDependencies();
    }

    @Override
    public final boolean mayCreateNewNodes() {
        return !this.getChild().hasSpecialProperty(0x800000);
    }

    @Override
    public int getNetCost() {
        return 0;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForItem().eval(context);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForPull().iterate(context);
    }

    @Override
    public int getInstructionNameCode() {
        if (this.getChild() instanceof Instruction) {
            return ((Instruction)this.getChild()).getInstructionNameCode();
        }
        return -1;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        this.getChild().export(out);
    }

    @Override
    public String toShortString() {
        return this.getChild().toShortString();
    }

    @Override
    public Elaborator getElaborator() {
        return new ComponentTracerElaborator();
    }

    private static class ComponentTracerElaborator
    extends PullElaborator {
        private ComponentTracerElaborator() {
        }

        @Override
        public UpdateEvaluator elaborateForUpdate() {
            ComponentTracer expr = (ComponentTracer)this.getExpression();
            UpdateEvaluator baseEval = expr.getBody().makeElaborator().elaborateForUpdate();
            return (context, pul) -> {
                Controller controller = context.getController();
                assert (controller != null);
                if (controller.isTracing()) {
                    TraceListener listener = controller.getTraceListener();
                    listener.enter(expr, expr.properties, context);
                    baseEval.registerUpdates(context, pul);
                    listener.leave(expr);
                } else {
                    baseEval.registerUpdates(context, pul);
                }
            };
        }

        @Override
        public PullEvaluator elaborateForPull() {
            ComponentTracer expr = (ComponentTracer)this.getExpression();
            PullEvaluator baseEval = expr.getBody().makeElaborator().elaborateForPull();
            return context -> {
                Controller controller = context.getController();
                assert (controller != null);
                if (controller.isTracing()) {
                    TraceListener listener = controller.getTraceListener();
                    listener.enter(expr.component, expr.properties, context);
                    SequenceIterator result = baseEval.iterate(context);
                    GroundedValue extent = SequenceTool.toGroundedValue(result);
                    listener.leave(expr.component);
                    return extent.iterate();
                }
                return baseEval.iterate(context);
            };
        }

        @Override
        public PushEvaluator elaborateForPush() {
            ComponentTracer expr = (ComponentTracer)this.getExpression();
            PushEvaluator baseEval = expr.getBody().makeElaborator().elaborateForPush();
            return (output, context) -> {
                Controller controller = context.getController();
                assert (controller != null);
                if (controller.isTracing()) {
                    TraceListener listener = controller.getTraceListener();
                    listener.enter(expr.component, expr.properties, context);
                    TailCall tc = baseEval.processLeavingTail(output, context);
                    Expression.dispatchTailCall(tc);
                    listener.leave(expr.component);
                } else {
                    Expression.dispatchTailCall(baseEval.processLeavingTail(output, context));
                }
                return null;
            };
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            ComponentTracer expr = (ComponentTracer)this.getExpression();
            ItemEvaluator baseEval = expr.getBody().makeElaborator().elaborateForItem();
            return context -> {
                Controller controller = context.getController();
                assert (controller != null);
                if (controller.isTracing()) {
                    TraceListener listener = controller.getTraceListener();
                    listener.enter(expr.component, expr.properties, context);
                    Item result = baseEval.eval(context);
                    listener.leave(expr.component);
                    return result;
                }
                return baseEval.eval(context);
            };
        }
    }
}

