/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Operand
implements Iterable<Operand> {
    private Expression parentExpression;
    private Expression childExpression;
    private OperandRole role;
    private static boolean DEBUG = false;

    public Operand(Expression parentExpression, Expression childExpression, OperandRole role) {
        this.parentExpression = parentExpression;
        this.setChildExpression(childExpression);
        this.role = role;
    }

    public Expression getParentExpression() {
        return this.parentExpression;
    }

    public Expression getChildExpression() {
        return this.childExpression;
    }

    public void setChildExpression(Expression childExpression) {
        if (childExpression != this.childExpression) {
            this.childExpression = childExpression;
            this.parentExpression.adoptChildExpression(childExpression);
            this.parentExpression.resetLocalStaticProperties();
        }
    }

    public void detachChild() {
        if (DEBUG) {
            this.childExpression.setParentExpression(null);
            StringWriter sw = new StringWriter();
            new XPathException("dummy").printStackTrace(new PrintWriter(sw));
            this.childExpression = new ErrorExpression("child expression has been detached: " + sw.toString(), "ZZZ", false);
            ExpressionTool.copyLocationInfo(this.parentExpression, this.childExpression);
        }
    }

    public OperandRole getOperandRole() {
        return this.role;
    }

    public void setOperandRole(OperandRole role) {
        this.role = role;
    }

    public boolean setsNewFocus() {
        return this.role.setsNewFocus();
    }

    public boolean hasSameFocus() {
        return this.role.hasSameFocus();
    }

    public boolean isEvaluatedRepeatedly() {
        return this.role.isEvaluatedRepeatedly();
    }

    public OperandUsage getUsage() {
        return this.role.getUsage();
    }

    public void setUsage(OperandUsage usage) {
        this.role = new OperandRole(this.role.properties, usage, this.role.getRequiredType());
    }

    public SequenceType getRequiredType() {
        return this.role.getRequiredType();
    }

    public boolean isInChoiceGroup() {
        return this.role.isInChoiceGroup();
    }

    @Override
    public Iterator<Operand> iterator() {
        return new MonoIterator<Operand>(this);
    }

    public void typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        try {
            this.setChildExpression(this.getChildExpression().typeCheck(visitor, contextInfo));
        }
        catch (XPathException e) {
            e.maybeSetLocation(this.getChildExpression().getLocation());
            if (!e.isReportableStatically()) {
                visitor.getStaticContext().issueWarning("Evaluation will always throw a dynamic error: " + e.getMessage(), this.getChildExpression().getLocation());
                this.setChildExpression(new ErrorExpression(e));
            }
            throw e;
        }
    }

    public void optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        try {
            this.setChildExpression(this.getChildExpression().optimize(visitor, contextInfo));
        }
        catch (XPathException e) {
            e.maybeSetLocation(this.getChildExpression().getLocation());
            if (!e.isReportableStatically()) {
                visitor.getStaticContext().issueWarning("Evaluation will always throw a dynamic error: " + e.getMessage(), this.getChildExpression().getLocation());
                this.setChildExpression(new ErrorExpression(e));
            }
            throw e;
        }
    }
}

